----------------------------------------------------------
-- UTF-8 .. ѱ 3 Byte ..
--  schema  varchar2(Ǵ ѱ 츸)  3 ϰų
-- varchar2(10 char)   ..
-- ٸ, 2°  altibase ó 
----------------------------------------------------------

CREATE TABLE COMTNTMPLATINFO
(
  TMPLAT_ID            CHAR(20 BYTE)            NOT NULL,
  TMPLAT_NM            VARCHAR2(120 CHAR),
  TMPLAT_COURS         VARCHAR2(2000 BYTE),
  USE_AT               CHAR(1 BYTE)             NOT NULL,
  FRST_REGISTER_ID     VARCHAR2(20 BYTE)        NOT NULL,
  FRST_REGISTER_PNTTM  DATE                     NOT NULL,
  LAST_UPDUSR_ID       VARCHAR2(20 BYTE),
  LAST_UPDUSR_PNTTM    DATE,
  TMPLAT_SE_CODE       CHAR(6 BYTE)
)
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;


CREATE TABLE COMTNNCRDUSER
(
  NCRD_ID         CHAR(20 BYTE)                 NOT NULL,
  EMPLYR_ID       VARCHAR2(20 BYTE)             NOT NULL,
  CREAT_DT        DATE                          NOT NULL,
  REGIST_SE_CODE  CHAR(6 BYTE)                  NOT NULL,
  USE_AT          CHAR(1 BYTE)                  NOT NULL,
  CONSTRAINT COMTNNCRDUSER_PK
 PRIMARY KEY
 (NCRD_ID, EMPLYR_ID)
)
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;


CREATE TABLE IMGTEMP
(
  ORG_CODE   VARCHAR2(7 BYTE)                   NOT NULL,
  ERNCSL_SE  VARCHAR2(2 BYTE)                   NOT NULL,
  IMG_INFO   BLOB                               NOT NULL,
  IMG_TYPE   VARCHAR2(16 BYTE)                  DEFAULT NULL,
  PRIMARY KEY
 (ORG_CODE, ERNCSL_SE)
)
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;


CREATE TABLE COMTNNCRD
(
  NCRD_ID              CHAR(20 BYTE)            NOT NULL,
  NCRD_TRGTER_ID       VARCHAR2(20 BYTE),
  NM                   VARCHAR2(50 CHAR)        NOT NULL,
  TELNO                VARCHAR2(20 BYTE),
  EMAIL_ADRES          VARCHAR2(50 BYTE),
  ADRES                VARCHAR2(100 CHAR),
  OFCPS_NM             VARCHAR2(50 CHAR),
  CLSF_NM              VARCHAR2(50 CHAR),
  CMPNY_NM             VARCHAR2(50 CHAR),
  DEPT_NM              VARCHAR2(50 CHAR),
  FRST_REGISTER_PNTTM  DATE                     NOT NULL,
  FRST_REGISTER_ID     VARCHAR2(20 BYTE),
  LAST_UPDUSR_PNTTM    DATE,
  LAST_UPDUSR_ID       VARCHAR2(20 BYTE),
  REMARK               VARCHAR2(2500 CHAR),
  EXTRL_USER_AT        CHAR(1 BYTE)             NOT NULL,
  MBTLNUM              VARCHAR2(20 BYTE),
  DETAIL_ADRES         VARCHAR2(100 CHAR),
  NATION_NO            VARCHAR2(10 BYTE),
  AREA_NO              VARCHAR2(5 BYTE),
  MIDDLE_TELNO         VARCHAR2(5 BYTE),
  END_TELNO            VARCHAR2(5 BYTE),
  IDNTFC_NO            VARCHAR2(10 BYTE),
  MIDDLE_MBTLNUM       VARCHAR2(10 BYTE),
  END_MBTLNUM          VARCHAR2(10 BYTE),
  OTHBC_AT             CHAR(1 BYTE)             NOT NULL
)
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;


CREATE TABLE COMTSSYSLOGSUMMARY
(
  OCCRRNC_DE  CHAR(8 BYTE)                      NOT NULL,
  SRVC_NM     CHAR(200 BYTE)                    NOT NULL,
  METHOD_NM   VARCHAR2(200 BYTE)                NOT NULL,
  CREAT_CO    NUMBER(10),
  UPDT_CO     NUMBER(10),
  INQIRE_CO   NUMBER(10),
  DELETE_CO   NUMBER(10),
  OUTPT_CO    NUMBER(10),
  ERROR_CO    NUMBER(10),
  CONSTRAINT COMTSSYSLOGSUMMARY_PK
 PRIMARY KEY
 (OCCRRNC_DE, SRVC_NM, METHOD_NM)
)
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;


CREATE TABLE COMTNROLEINFO
(
  ROLE_CODE      VARCHAR2(50 BYTE)              NOT NULL,
  ROLE_DC        VARCHAR2(100 CHAR),
  ROLE_CREAT_DE  DATE                           NOT NULL,
  ROLE_NM        VARCHAR2(50 CHAR)              NOT NULL,
  ROLE_PTN       VARCHAR2(300 CHAR),
  ROLE_TYP       VARCHAR2(50 BYTE),
  ROLE_SORT      INTEGER,
  CONSTRAINT COMTNROLLINFO_PK
 PRIMARY KEY
 (ROLE_CODE)
)
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;


CREATE TABLE COMTNSITELIST
(
  SITE_URL             VARCHAR2(100 CHAR),
  SITE_ID              CHAR(20 BYTE)            NOT NULL,
  SITE_NM              VARCHAR2(100 CHAR),
  SITE_DC              VARCHAR2(1000 CHAR),
  SITE_THEMA_CL_CODE   VARCHAR2(2 BYTE),
  ACTVTY_AT            CHAR(1 BYTE),
  USE_AT               CHAR(1 BYTE),
  FRST_REGISTER_PNTTM  DATE,
  FRST_REGISTER_ID     VARCHAR2(20 BYTE),
  LAST_UPDUSR_PNTTM    DATE,
  LAST_UPDUSR_ID       VARCHAR2(20 BYTE),
  CONSTRAINT COMTNSITELIST_PK
 PRIMARY KEY
 (SITE_ID)
)
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;


CREATE TABLE COMTNSITEMAP
(
  MAPCREAT_ID       VARCHAR2(35 BYTE)           NOT NULL,
  CREAT_OPERTOR_ID  VARCHAR2(20 BYTE)           NOT NULL,
  MAP_FILE_NM       VARCHAR2(50 CHAR)           NOT NULL,
  MAP_FILE_PATH     VARCHAR2(100 BYTE)          NOT NULL,
  CONSTRAINT CONTNSITEMAP_PK
 PRIMARY KEY
 (MAPCREAT_ID)
)
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;


CREATE TABLE COMTNSTPLATINFO
(
  USE_STPLAT_ID        CHAR(20 BYTE)            NOT NULL,
  INFO_PROVD_AGRE_CN   CLOB,
  USE_STPLAT_CN        CLOB,
  FRST_REGISTER_PNTTM  DATE,
  FRST_REGISTER_ID     VARCHAR2(20 BYTE),
  LAST_UPDUSR_PNTTM    DATE,
  LAST_UPDUSR_ID       VARCHAR2(20 BYTE),
  USE_STPLAT_NM        VARCHAR2(100 CHAR),
  CONSTRAINT COMTNSTPLATINFO_PK
 PRIMARY KEY
 (USE_STPLAT_ID)
)
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;


CREATE TABLE COMTNSYSLOG
(
  REQUST_ID        CHAR(20 BYTE)                NOT NULL,
  JOB_SE_CODE      CHAR(3 BYTE),
  OCCRRNC_DE       CHAR(8 BYTE),
  SRVC_NM          VARCHAR2(200 BYTE),
  METHOD_NM        VARCHAR2(200 BYTE),
  PROCESS_SE_CODE  CHAR(3 BYTE),
  PROCESS_CO       NUMBER(10),
  PROCESS_TIME     VARCHAR2(10 BYTE),
  ERROR_SE         CHAR(1 BYTE),
  ERROR_CODE       CHAR(3 BYTE),
  ERROR_CO         NUMBER(10),
  RSPNS_CODE       CHAR(3 BYTE),
  INSTT_CODE       CHAR(7 BYTE),
  TRGET_MENU_NM    VARCHAR2(200 CHAR),
  RQESTER_IP       VARCHAR2(128 BYTE),
  RQESTER_ID       VARCHAR2(20 BYTE),
  CONSTRAINT COMTNSYSLOG_PK
 PRIMARY KEY
 (REQUST_ID)
)
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;


CREATE TABLE COMTNTRSMRCVLOG
(
  REQUST_ID            CHAR(20 BYTE)            NOT NULL,
  OCCRRNC_DE           CHAR(8 BYTE),
  TRSMRCV_SE_CODE      CHAR(3 BYTE),
  INTEG_ID             CHAR(8 BYTE),
  PROVD_INSTT_ID       CHAR(8 BYTE),
  PROVD_SYS_ID         CHAR(8 BYTE),
  PROVD_SVC_ID         CHAR(8 BYTE),
  REQUST_INSTT_ID      CHAR(8 BYTE),
  REQUST_SYS_ID        CHAR(8 BYTE),
  REQUST_TRNSMIT_TM    CHAR(14 BYTE),
  REQUST_RECPTN_TM     CHAR(14 BYTE),
  RSPNS_TRNSMIT_TM     CHAR(14 BYTE),
  RSPNS_RECPTN_TM      CHAR(14 BYTE),
  RESULT_CODE          CHAR(4 BYTE),
  RESULT_MESSAGE       VARCHAR2(4000 BYTE),
  FRST_REGISTER_PNTTM  DATE,
  RQESTER_ID           VARCHAR2(20 BYTE),
  CONSTRAINT COMTNTRSMRCVLOG_PK
 PRIMARY KEY
 (REQUST_ID)
)
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;


CREATE TABLE COMTNUSERLOG
(
  OCCRRNC_DE  CHAR(8 BYTE)                      NOT NULL,
  RQESTER_ID  VARCHAR2(20 BYTE)                 NOT NULL,
  SRVC_NM     VARCHAR2(200 BYTE)                NOT NULL,
  METHOD_NM   VARCHAR2(200 BYTE)                NOT NULL,
  CREAT_CO    NUMBER(10),
  UPDT_CO     NUMBER(10),
  INQIRE_CO   NUMBER(10),
  DELETE_CO   NUMBER(10),
  OUTPT_CO    NUMBER(10),
  ERROR_CO    NUMBER(10),
  CONSTRAINT COMTNUSERLOG_PK
 PRIMARY KEY
 (OCCRRNC_DE, RQESTER_ID, SRVC_NM, METHOD_NM)
)
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;


CREATE TABLE COMTNWEBLOG
(
  REQUST_ID   CHAR(20 BYTE)                     NOT NULL,
  RQESTER_IP  VARCHAR2(128 BYTE),
  RQESTER_ID  VARCHAR2(20 BYTE),
  URL         VARCHAR2(100 BYTE),
  OCCRRNC_DE  CHAR(8 BYTE),
  CONSTRAINT COMTNEWBLOG_PK
 PRIMARY KEY
 (REQUST_ID)
)
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;


CREATE TABLE COMTNWORDDICARYINFO
(
  WORD_NM              VARCHAR2(250 CHAR),
  WORD_ID              CHAR(20 BYTE)            NOT NULL,
  ENG_NM               VARCHAR2(60 CHAR),
  WORD_DC              VARCHAR2(2500 CHAR),
  SYNONM               VARCHAR2(100 CHAR),
  FRST_REGISTER_PNTTM  DATE,
  FRST_REGISTER_ID     VARCHAR2(20 BYTE),
  LAST_UPDUSR_PNTTM    DATE,
  LAST_UPDUSR_ID       VARCHAR2(20 BYTE),
  CONSTRAINT COMTNWORDDICARYINFO_PK
 PRIMARY KEY
 (WORD_ID)
)
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;


CREATE TABLE COMTSBBSSUMMARY
(
  OCCRRNC_DE          CHAR(8 BYTE)              NOT NULL,
  STATS_SE            VARCHAR2(10 BYTE)         NOT NULL,
  STATS_DETAIL_SE     VARCHAR2(10 BYTE)         NOT NULL,
  CREAT_CO            NUMBER(10),
  TOT_INQIRE_CO       NUMBER(10),
  AVRG_INQIRE_CO      VARCHAR2(10 BYTE),
  MXMM_INQIRE_BBS_ID  VARCHAR2(20 BYTE),
  MUMM_INQIRE_BBS_ID  VARCHAR2(20 BYTE),
  TOP_NTCEPERSON_ID   VARCHAR2(20 BYTE),
  CONSTRAINT COMTSBBSSUMMARY_PK
 PRIMARY KEY
 (OCCRRNC_DE, STATS_SE, STATS_DETAIL_SE)
)
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;


CREATE TABLE COMTSTRSMRCVLOGSUMMARY
(
  OCCRRNC_DE       CHAR(8 BYTE)                 NOT NULL,
  TRSMRCV_SE_CODE  CHAR(3 BYTE)                 NOT NULL,
  PROVD_INSTT_ID   CHAR(8 BYTE)                 NOT NULL,
  PROVD_SYS_ID     CHAR(8 BYTE)                 NOT NULL,
  PROVD_SVC_ID     CHAR(8 BYTE)                 NOT NULL,
  REQUST_INSTT_ID  CHAR(8 BYTE)                 NOT NULL,
  REQUST_SYS_ID    CHAR(8 BYTE)                 NOT NULL,
  INQIRE_CO        NUMBER(10),
  ERROR_CO         NUMBER(10),
  CONSTRAINT COMTSTRSMRCVLOGSUMMARY_PK
 PRIMARY KEY
 (OCCRRNC_DE, TRSMRCV_SE_CODE, PROVD_INSTT_ID, PROVD_SYS_ID, PROVD_SVC_ID, REQUST_INSTT_ID, REQUST_SYS_ID)
)
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;


CREATE TABLE COMTSUSERSUMMARY
(
  OCCRRNC_DE       CHAR(8 BYTE)                 NOT NULL,
  STATS_SE         VARCHAR2(10 BYTE)            NOT NULL,
  STATS_DETAIL_SE  VARCHAR2(10 BYTE)            NOT NULL,
  USER_CO          NUMBER(10),
  CONSTRAINT COMTSUSERSUMMARY_PK
 PRIMARY KEY
 (OCCRRNC_DE, STATS_SE, STATS_DETAIL_SE)
)
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;


CREATE TABLE COMTSWEBLOGSUMMARY
(
  OCCRRNC_DE  CHAR(8 BYTE)                      NOT NULL,
  URL         VARCHAR2(100 BYTE)                NOT NULL,
  INQIRE_CO   NUMBER(10),
  CONSTRAINT COMTNEWBLOGSUMMARY_PK
 PRIMARY KEY
 (OCCRRNC_DE, URL)
)
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;


CREATE TABLE COMTCADMINISTCODE
(
  ADMINIST_ZONE_SE          CHAR(1 BYTE)        NOT NULL,
  ADMINIST_ZONE_CODE        VARCHAR2(10 BYTE)   NOT NULL,
  ADMINIST_ZONE_NM          VARCHAR2(60 CHAR),
  UPPER_ADMINIST_ZONE_CODE  VARCHAR2(10 BYTE),
  CREAT_DE                  VARCHAR2(8 BYTE),
  ABL_DE                    VARCHAR2(8 BYTE),
  USE_AT                    CHAR(1 BYTE)        NOT NULL,
  FRST_REGISTER_PNTTM       DATE,
  FRST_REGISTER_ID          VARCHAR2(20 BYTE),
  LAST_UPDUSR_PNTTM         DATE,
  LAST_UPDUSR_ID            VARCHAR2(20 BYTE),
  CONSTRAINT COMTCADMINISTCODE_PK
 PRIMARY KEY
 (ADMINIST_ZONE_SE, ADMINIST_ZONE_CODE)
)
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;


CREATE TABLE COMTCCMMNCLCODE
(
  CL_CODE              CHAR(3 BYTE)             NOT NULL,
  CL_CODE_NM           VARCHAR2(60 CHAR),
  CL_CODE_DC           VARCHAR2(200 CHAR),
  USE_AT               CHAR(1 BYTE),
  FRST_REGISTER_PNTTM  DATE,
  FRST_REGISTER_ID     VARCHAR2(20 BYTE),
  LAST_UPDUSR_PNTTM    DATE,
  LAST_UPDUSR_ID       VARCHAR2(20 BYTE),
  CONSTRAINT COMTCCMMNCLCODE_PK
 PRIMARY KEY
 (CL_CODE)
)
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;


CREATE TABLE COMTCCMMNCODE
(
  CL_CODE              CHAR(3 BYTE),
  CODE_ID              VARCHAR2(6 BYTE)         NOT NULL,
  CODE_ID_NM           VARCHAR2(60 CHAR),
  CODE_ID_DC           VARCHAR2(200 CHAR),
  USE_AT               CHAR(1 BYTE),
  FRST_REGISTER_PNTTM  DATE,
  FRST_REGISTER_ID     VARCHAR2(20 BYTE),
  LAST_UPDUSR_PNTTM    DATE,
  LAST_UPDUSR_ID       VARCHAR2(20 BYTE),
  CONSTRAINT COMTCCMMNCODE_PK
 PRIMARY KEY
 (CODE_ID)
)
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;


CREATE TABLE COMTCCMMNDETAILCODE
(
  CODE_NM              VARCHAR2(60 CHAR),
  CODE_DC              VARCHAR2(200 CHAR),
  USE_AT               CHAR(1 BYTE),
  CODE                 VARCHAR2(15 BYTE)        NOT NULL,
  CODE_ID              VARCHAR2(6 BYTE)         NOT NULL,
  FRST_REGISTER_PNTTM  DATE,
  FRST_REGISTER_ID     VARCHAR2(20 BYTE),
  LAST_UPDUSR_PNTTM    DATE,
  LAST_UPDUSR_ID       VARCHAR2(20 BYTE),
  CONSTRAINT COMTCCMMNDETAILCODE_PK
 PRIMARY KEY
 (CODE_ID, CODE)
)
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;


CREATE TABLE COMTCZIP
(
  ZIP                  CHAR(6 BYTE)             NOT NULL,
  SN                   NUMBER(6)                NOT NULL,
  CTPRVN_NM            VARCHAR2(20 CHAR),
  SIGNGU_NM            VARCHAR2(20 CHAR),
  EMD_NM               VARCHAR2(30 CHAR),
  LI_BULD_NM           VARCHAR2(60 CHAR),
  LNBR_DONG_HO         VARCHAR2(20 CHAR),
  FRST_REGISTER_PNTTM  DATE,
  FRST_REGISTER_ID     VARCHAR2(20 BYTE),
  LAST_UPDUSR_PNTTM    DATE,
  LAST_UPDUSR_ID       VARCHAR2(20 BYTE),
  CONSTRAINT COMTCZIP_PK
 PRIMARY KEY
 (ZIP, SN)
)
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;


CREATE TABLE COMTHCONFMHISTORY
(
  CONFM_NUMBER       NUMBER(8)                  NOT NULL,
  CONFM_RQESTER_ID   VARCHAR2(20 BYTE)          NOT NULL,
  CONFMER_ID         VARCHAR2(20 BYTE),
  CONFM_DE           CHAR(8 BYTE),
  CONFM_TY_CODE      CHAR(4 BYTE)               NOT NULL,
  CONFM_STTUS_CODE   CHAR(4 BYTE)               NOT NULL,
  OPERT_TY_CODE      CHAR(4 BYTE),
  OPERT_ID           VARCHAR2(20 BYTE),
  TRGET_JOB_TY_CODE  CHAR(3 BYTE),
  TRGET_JOB_ID       CHAR(20 BYTE),
  CONSTRAINT COMTHCONFMHISTORY_PK
 PRIMARY KEY
 (CONFM_NUMBER)
)
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;


CREATE TABLE COMTHEMAILDSPTCHMANAGE
(
  EMAIL_CN           CLOB,
  DSPTCHPERSON       VARCHAR2(40 BYTE)          NOT NULL,
  MSSAGE_ID          CHAR(20 BYTE)              NOT NULL,
  RECPTNPERSON       VARCHAR2(40 BYTE)          NOT NULL,
  SJ                 VARCHAR2(50 CHAR)          NOT NULL,
  SNDNG_RESULT_CODE  VARCHAR2(15 BYTE),
  SNDNG_DE           DATE                       NOT NULL,
  ATCH_FILE_ID       CHAR(20 BYTE),
  CONSTRAINT COMTHEMAILDSPTCHMANAGE_PK
 PRIMARY KEY
 (MSSAGE_ID)
)
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;


CREATE TABLE COMTHEMPLYRINFOCHANGEDTLS
(
  GROUP_ID           CHAR(20 BYTE),
  ORGNZT_ID          CHAR(20 BYTE)              NOT NULL,
  EMPLYR_ID          VARCHAR2(20 BYTE)          NOT NULL,
  EMPL_NO            VARCHAR2(20 BYTE)          NOT NULL,
  SEXDSTN_CODE       CHAR(1 BYTE),
  BRTH               CHAR(8 BYTE),
  FXNUM              VARCHAR2(15 BYTE),
  HOMEADRES          VARCHAR2(100 CHAR)         NOT NULL,
  HOMEEND_TELNO      VARCHAR2(5 BYTE),
  AREA_NO            VARCHAR2(5 BYTE),
  DETAIL_ADRES       VARCHAR2(100 BYTE)         NOT NULL,
  ZIP                CHAR(6 BYTE)               NOT NULL,
  OFFM_TELNO         VARCHAR2(15 BYTE),
  MOBLPHON_NO        VARCHAR2(15 BYTE)          NOT NULL,
  EMAIL_ADRES        VARCHAR2(50 BYTE),
  HOMEMIDDLE_TELNO   VARCHAR2(5 BYTE),
  INSTT_CODE         VARCHAR2(15 BYTE),
  EMPLYR_STTUS_CODE  VARCHAR2(15 BYTE)          NOT NULL,
  CHANGE_DE          DATE                       NOT NULL,
  UNIQ_ID            CHAR(20 BYTE),
  CONSTRAINT COMTHEMPLYRINFOCHANGEDTLS_PK
 PRIMARY KEY
 (EMPLYR_ID, CHANGE_DE)
)
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;


CREATE TABLE COMTHPROGRMCHANGEDTLS
(
  PROGRM_FILE_NM      VARCHAR2(50 BYTE)         NOT NULL,
  RQESTER_NO          NUMBER(10)                NOT NULL,
  RQESTER_ID          VARCHAR2(20 BYTE)         NOT NULL,
  CHANGERQESTER_CN    CLOB,
  RQESTER_PROCESS_CN  CLOB,
  OPETR_ID            VARCHAR2(20 BYTE),
  PROCESS_STTUS_CODE  CHAR(3 BYTE)              NOT NULL,
  PROCESS_DE          DATE,
  RQESTER_DE          DATE,
  RQESTER_SJ          VARCHAR2(50 CHAR)         NOT NULL,
  CONSTRAINT COMTHPROGRMCHANGEDTLS_PK
 PRIMARY KEY
 (PROGRM_FILE_NM, RQESTER_NO)
)
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;


CREATE TABLE COMTHSYSHIST
(
  HIST_ID              CHAR(20 BYTE)            NOT NULL,
  FRST_REGISTER_PNTTM  DATE,
  FRST_REGISTER_ID     VARCHAR2(20 BYTE)        NOT NULL,
  LAST_UPDUSR_PNTTM    DATE,
  LAST_UPDUSR_ID       VARCHAR2(20 BYTE),
  HIST_SE_CODE         CHAR(6 BYTE)             NOT NULL,
  HIST_CN              VARCHAR2(2500 CHAR)      NOT NULL,
  SYS_NM               VARCHAR2(200 CHAR)       NOT NULL,
  ATCH_FILE_ID         CHAR(20 BYTE),
  CONSTRAINT COMTHSYSHIST_PK
 PRIMARY KEY
 (HIST_ID)
)
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;


CREATE TABLE COMTNANSWER
(
  NTT_ID               NUMBER(20)               NOT NULL,
  BBS_ID               CHAR(20 BYTE)            NOT NULL,
  WRTER_ID             VARCHAR2(20 BYTE),
  ANSWER_CN            VARCHAR2(1000 CHAR),
  USE_AT               CHAR(1 BYTE)             NOT NULL,
  WRTER_NM             VARCHAR2(20 CHAR),
  FRST_REGISTER_PNTTM  DATE                     NOT NULL,
  FRST_REGISTER_ID     VARCHAR2(20 BYTE)        NOT NULL,
  LAST_UPDUSR_PNTTM    DATE,
  LAST_UPDUSR_ID       VARCHAR2(20 BYTE),
  ANSWER_NO            NUMBER(9)                NOT NULL,
  CONSTRAINT COMTNANSWER_PK
 PRIMARY KEY
 (NTT_ID, BBS_ID, ANSWER_NO)
)
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;


CREATE TABLE COMTNAUTHORGROUPINFO
(
  GROUP_ID        CHAR(20 BYTE)                 NOT NULL,
  GROUP_NM        VARCHAR2(50 CHAR)             NOT NULL,
  GROUP_CREAT_DE  DATE                          NOT NULL,
  GROUP_DC        VARCHAR2(100 CHAR),
  CONSTRAINT COMTNAUTHORGROUPINFO_PK
 PRIMARY KEY
 (GROUP_ID)
)
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;


CREATE TABLE COMTNAUTHORINFO
(
  AUTHOR_CODE      VARCHAR2(30 BYTE)            NOT NULL,
  AUTHOR_NM        VARCHAR2(50 CHAR)            NOT NULL,
  AUTHOR_DC        VARCHAR2(100 CHAR),
  AUTHOR_CREAT_DE  DATE                         NOT NULL,
  CONSTRAINT CONTNAUTHORINFO_PK
 PRIMARY KEY
 (AUTHOR_CODE)
)
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;


CREATE TABLE COMTNAUTHORROLERELATE
(
  CREAT_DT     DATE,
  AUTHOR_CODE  VARCHAR2(30 BYTE)                NOT NULL,
  ROLE_CODE    VARCHAR2(50 BYTE)                NOT NULL,
  CONSTRAINT COMTNAUTHORROLERELATE_PK
 PRIMARY KEY
 (AUTHOR_CODE, ROLE_CODE)
)
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;


CREATE TABLE COMTNBBS
(
  NTT_ID               NUMBER(20)               NOT NULL,
  BBS_ID               CHAR(20 BYTE)            NOT NULL,
  NTCR_ID              VARCHAR2(20 BYTE),
  SORT_ORDR            NUMBER(8),
  NTCR_NM              VARCHAR2(20 CHAR),
  PASSWORD             VARCHAR2(2000 BYTE),
  NTT_SJ               VARCHAR2(2400 CHAR),
  NTT_CN               CLOB,
  INQIRE_CO            NUMBER(9),
  USE_AT               CHAR(1 BYTE)             NOT NULL,
  NTCE_BGNDE           CHAR(8 BYTE),
  NTCE_ENDDE           CHAR(8 BYTE),
  FRST_REGISTER_PNTTM  DATE                     NOT NULL,
  LAST_UPDUSR_PNTTM    DATE,
  FRST_REGISTER_ID     VARCHAR2(20 BYTE)        NOT NULL,
  LAST_UPDUSR_ID       VARCHAR2(20 BYTE),
  REPLY_AT             CHAR(1 BYTE),
  PARNTS               NUMBER(10),
  NTT_NO               NUMBER(10),
  REPLY_LC             NUMBER(8),
  ATCH_FILE_ID         CHAR(20 BYTE),
  CONSTRAINT COMTNBBS_PK
 PRIMARY KEY
 (NTT_ID, BBS_ID)
)
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;


CREATE TABLE COMTNBBSMASTER
(
  BBS_ID                  CHAR(20 BYTE)         NOT NULL,
  BBS_TY_CODE             CHAR(6 BYTE)          NOT NULL,
  LAST_UPDUSR_PNTTM       DATE,
  USE_AT                  CHAR(1 BYTE)          NOT NULL,
  FRST_REGISTER_PNTTM     DATE                  NOT NULL,
  FRST_REGISTER_ID        VARCHAR2(20 BYTE)     NOT NULL,
  LAST_UPDUSR_ID          VARCHAR2(20 BYTE),
  BBS_ATTRB_CODE          CHAR(6 BYTE)          NOT NULL,
  BBS_NM                  VARCHAR2(120 CHAR)    NOT NULL,
  REPLY_POSBL_AT          CHAR(1 BYTE),
  FILE_ATCH_POSBL_AT      CHAR(1 BYTE)          NOT NULL,
  POSBL_ATCH_FILE_NUMBER  NUMBER(2)             NOT NULL,
  POSBL_ATCH_FILE_SIZE    VARCHAR2(8 BYTE),
  BBS_INTRCN              VARCHAR2(2400 CHAR),
  TMPLAT_ID               CHAR(20 BYTE),
  CONSTRAINT COMTNBBSMASTER_PK
 PRIMARY KEY
 (BBS_ID)
)
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;


CREATE TABLE COMTNBBSUSE
(
  FRST_REGISTER_PNTTM  DATE,
  FRST_REGISTER_ID     VARCHAR2(20 BYTE)        NOT NULL,
  LAST_UPDUSR_PNTTM    DATE,
  LAST_UPDUSR_ID       VARCHAR2(20 BYTE),
  USE_AT               CHAR(1 BYTE)             NOT NULL,
  REGIST_SE_CODE       CHAR(6 BYTE),
  BBS_ID               CHAR(20 BYTE)            NOT NULL,
  TRGET_ID             CHAR(20 BYTE)            NOT NULL,
  CONSTRAINT COMTNBBSUSE_PK
 PRIMARY KEY
 (BBS_ID, TRGET_ID)
)
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;


CREATE TABLE COMTNCLUB
(
  CLB_ID               CHAR(20 BYTE)            NOT NULL,
  CLB_NM               VARCHAR2(120 CHAR)       NOT NULL,
  FRST_REGISTER_ID     VARCHAR2(20 BYTE)        NOT NULL,
  USE_AT               CHAR(1 BYTE)             NOT NULL,
  FRST_REGISTER_PNTTM  DATE                     NOT NULL,
  LAST_UPDUSR_PNTTM    DATE,
  LAST_UPDUSR_ID       VARCHAR2(20 BYTE),
  CLB_INTRCN           VARCHAR2(2400 CHAR),
  REGIST_SE_CODE       CHAR(6 BYTE),
  TMPLAT_ID            CHAR(20 BYTE),
  CMMNTY_ID            CHAR(20 BYTE)            NOT NULL,
  CONSTRAINT COMTNCLUB_PK
 PRIMARY KEY
 (CLB_ID, CMMNTY_ID)
)
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;


CREATE TABLE COMTNCLUBUSER
(
  CLB_ID               CHAR(20 BYTE)            NOT NULL,
  SBSCRB_DE            DATE,
  SECSN_DE             CHAR(8 BYTE),
  OPRTR_AT             CHAR(1 BYTE)             NOT NULL,
  FRST_REGISTER_PNTTM  DATE                     NOT NULL,
  USE_AT               CHAR(1 BYTE)             NOT NULL,
  FRST_REGISTER_ID     VARCHAR2(20 BYTE)        NOT NULL,
  LAST_UPDUSR_PNTTM    DATE,
  LAST_UPDUSR_ID       VARCHAR2(20 BYTE),
  CMMNTY_ID            CHAR(20 BYTE)            NOT NULL,
  EMPLYR_ID            VARCHAR2(20 BYTE)        NOT NULL,
  CONSTRAINT COMTNCLUBUSER_PK
 PRIMARY KEY
 (CLB_ID, CMMNTY_ID, EMPLYR_ID)
)
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;


CREATE TABLE COMTNCMMNTY
(
  CMMNTY_ID            CHAR(20 BYTE)            NOT NULL,
  CMMNTY_NM            VARCHAR2(120 CHAR)       NOT NULL,
  USE_AT               CHAR(1 BYTE)             NOT NULL,
  FRST_REGISTER_PNTTM  DATE                     NOT NULL,
  FRST_REGISTER_ID     VARCHAR2(20 BYTE)        NOT NULL,
  LAST_UPDUSR_PNTTM    DATE,
  LAST_UPDUSR_ID       VARCHAR2(20 BYTE),
  CMMNTY_INTRCN        VARCHAR2(2400 CHAR),
  REGIST_SE_CODE       CHAR(6 BYTE),
  TMPLAT_ID            CHAR(20 BYTE),
  CONSTRAINT COMTNCMMNTY_PK
 PRIMARY KEY
 (CMMNTY_ID)
)
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;


CREATE TABLE COMTNCMMNTYUSER
(
  CMMNTY_ID            CHAR(20 BYTE)            NOT NULL,
  SBSCRB_DE            DATE,
  SECSN_DE             CHAR(8 BYTE),
  MNGR_AT              CHAR(1 BYTE)             NOT NULL,
  FRST_REGISTER_PNTTM  DATE                     NOT NULL,
  FRST_REGISTER_ID     VARCHAR2(20 BYTE)        NOT NULL,
  LAST_UPDUSR_PNTTM    DATE,
  LAST_UPDUSR_ID       VARCHAR2(20 BYTE),
  USE_AT               CHAR(1 BYTE),
  EMPLYR_ID            VARCHAR2(20 BYTE)        NOT NULL,
  CONSTRAINT COMTNCMMNTYUSER_PK
 PRIMARY KEY
 (CMMNTY_ID, EMPLYR_ID)
)
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;


CREATE TABLE COMTNCNSLTLIST
(
  OTHBC_AT                CHAR(1 BYTE),
  CNSLT_SJ                VARCHAR2(250 CHAR),
  CNSLT_CN                VARCHAR2(2500 CHAR),
  INQIRE_CO               NUMBER(10),
  MANAGT_CN               VARCHAR2(2500 CHAR),
  MANAGT_DE               DATE,
  ATCH_FILE_ID            CHAR(20 BYTE),
  FRST_REGISTER_PNTTM     DATE,
  FRST_REGISTER_ID        VARCHAR2(20 BYTE),
  LAST_UPDUSR_PNTTM       DATE,
  LAST_UPDUSR_ID          VARCHAR2(20 BYTE),
  CNSLT_ID                CHAR(20 BYTE)         NOT NULL,
  EMAIL_ADRES             VARCHAR2(50 BYTE),
  AREA_NO                 VARCHAR2(5 BYTE),
  FIRST_MOBLPHON_NO       VARCHAR2(10 BYTE),
  WRITNG_DE               DATE,
  WRTER_NM                VARCHAR2(20 CHAR),
  MIDDLE_MBTLNUM          VARCHAR2(10 BYTE),
  END_MBTLNUM             VARCHAR2(10 BYTE),
  MIDDLE_TELNO            VARCHAR2(5 BYTE),
  END_TELNO               VARCHAR2(5 BYTE),
  EMAIL_ANSWER_AT         CHAR(1 BYTE),
  QNA_PROCESS_STTUS_CODE  CHAR(1 BYTE),
  WRITNG_PASSWORD         VARCHAR2(20 BYTE),
  CONSTRAINT COMTNCNSLTLIST_PK
 PRIMARY KEY
 (CNSLT_ID)
)
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;


CREATE TABLE COMTNCPYRHTINFO
(
  CPYRHT_ID              CHAR(20 BYTE)          NOT NULL,
  CPYRHT_PRTC_POLICY_CN  VARCHAR2(2500 CHAR),
  FRST_REGISTER_PNTTM    DATE,
  FRST_REGISTER_ID       VARCHAR2(20 BYTE),
  LAST_UPDUSR_PNTTM      DATE,
  LAST_UPDUSR_ID         VARCHAR2(20 BYTE),
  CONSTRAINT COMTNCPYRHTINFO_PK
 PRIMARY KEY
 (CPYRHT_ID)
)
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;


CREATE TABLE COMTNDIARYINFO
(
  DIARY_ID             CHAR(20 BYTE)            NOT NULL,
  SCHDUL_ID            CHAR(20 BYTE)            NOT NULL,
  DIARY_PROCS_PTE      NUMBER(3),
  DIARY_NM             VARCHAR2(255 CHAR),
  DRCT_MATTER          VARCHAR2(2500 CHAR),
  PARTCLR_MATTER       VARCHAR2(2500 CHAR),
  ATCH_FILE_ID         CHAR(20 BYTE),
  FRST_REGISTER_PNTTM  DATE,
  FRST_REGISTER_ID     VARCHAR2(20 BYTE),
  LAST_UPDUSR_PNTTM    DATE,
  LAST_UPDUSR_ID       VARCHAR2(20 BYTE),
  CONSTRAINT COMTNDIARYINFO_PK
 PRIMARY KEY
 (DIARY_ID, SCHDUL_ID)
)
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;


CREATE TABLE COMTNEMPLYRINFO
(
  EMPLYR_ID          VARCHAR2(20 BYTE)          NOT NULL,
  ORGNZT_ID          CHAR(20 BYTE)              NOT NULL,
  EMPLYR_NM          VARCHAR2(60 CHAR)          NOT NULL,
  PASSWORD           VARCHAR2(100 BYTE)         NOT NULL,
  EMPL_NO            VARCHAR2(20 BYTE)          NOT NULL,
  IHIDNUM            CHAR(13 BYTE),
  SEXDSTN_CODE       CHAR(1 BYTE),
  BRTH               CHAR(8 BYTE),
  FXNUM              VARCHAR2(15 BYTE),
  HOMEADRES          VARCHAR2(100 CHAR)         NOT NULL,
  PASSWORD_HINT      VARCHAR2(100 CHAR),
  PASSWORD_CNSR      VARCHAR2(100 CHAR),
  HOMEEND_TELNO      VARCHAR2(5 BYTE),
  AREA_NO            VARCHAR2(5 BYTE),
  DETAIL_ADRES       VARCHAR2(100 CHAR),
  ZIP                CHAR(6 BYTE)               NOT NULL,
  OFFM_TELNO         VARCHAR2(15 BYTE),
  MOBLPHON_NO        VARCHAR2(15 BYTE)          NOT NULL,
  EMAIL_ADRES        VARCHAR2(50 BYTE),
  OFCPS_NM           VARCHAR2(50 CHAR),
  HOMEMIDDLE_TELNO   VARCHAR2(5 BYTE),
  GROUP_ID           CHAR(20 BYTE),
  INSTT_CODE         VARCHAR2(15 BYTE),
  EMPLYR_STTUS_CODE  VARCHAR2(15 BYTE)          NOT NULL,
  UNIQ_ID            CHAR(20 BYTE),
  SUB_DN             VARCHAR2(150 CHAR),
  SBSCRB_DE          DATE,
  CONSTRAINT COMTNEMPLYRINFO_PK
 PRIMARY KEY
 (EMPLYR_ID)
)
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;


CREATE TABLE COMTNEMPLYRSCRTYESTBS
(
  SCRTY_ESTBSTRGET_ID  VARCHAR2(20 BYTE)        NOT NULL,
  MBER_TY_CODE         VARCHAR2(15 BYTE),
  AUTHOR_CODE          VARCHAR2(30 BYTE)        NOT NULL,
  CONSTRAINT COMTNEMPLYRSCRTYESTBS_PK
 PRIMARY KEY
 (SCRTY_ESTBSTRGET_ID)
)
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;


CREATE TABLE COMTNENTRPRSMBER
(
  ENTRPRSMBER_ID              VARCHAR2(20 BYTE) NOT NULL,
  ENTRPRS_SE_CODE             CHAR(15 BYTE),
  BIZRNO                      CHAR(10 BYTE)     NOT NULL,
  JURIRNO                     CHAR(13 BYTE),
  CMPNY_NM                    VARCHAR2(50 CHAR) NOT NULL,
  CXFC                        VARCHAR2(60 CHAR),
  ZIP                         CHAR(6 BYTE),
  ADRES                       VARCHAR2(100 CHAR) NOT NULL,
  ENTRPRS_MIDDLE_TELNO        VARCHAR2(5 BYTE)  NOT NULL,
  FXNUM                       VARCHAR2(15 BYTE),
  INDUTY_CODE                 CHAR(15 BYTE),
  APPLCNT_NM                  VARCHAR2(60 CHAR) NOT NULL,
  APPLCNT_IHIDNUM             CHAR(13 BYTE),
  SBSCRB_DE                   DATE              NOT NULL,
  ENTRPRS_MBER_STTUS          VARCHAR2(15 BYTE),
  ENTRPRS_MBER_PASSWORD       VARCHAR2(100 BYTE) NOT NULL,
  ENTRPRS_MBER_PASSWORD_HINT  VARCHAR2(100 CHAR),
  ENTRPRS_MBER_PASSWORD_CNSR  VARCHAR2(100 CHAR),
  GROUP_ID                    CHAR(20 BYTE),
  DETAIL_ADRES                VARCHAR2(100 CHAR),
  ENTRPRS_END_TELNO           VARCHAR2(5 BYTE)  NOT NULL,
  AREA_NO                     VARCHAR2(5 BYTE)  NOT NULL,
  APPLCNT_EMAIL_ADRES         VARCHAR2(50 BYTE) NOT NULL,
  UNIQ_ID                     CHAR(20 BYTE),
  CONSTRAINT COMTNENTRPRSMBER_PK
 PRIMARY KEY
 (ENTRPRSMBER_ID)
)
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;


CREATE TABLE COMTNEVENTINFO
(
  EVENT_ID             CHAR(20 BYTE)            NOT NULL,
  BSNS_YEAR            CHAR(4 BYTE),
  BSNS_CODE            VARCHAR2(2 BYTE),
  EVENT_SVC_BEGIN_DE   CHAR(8 BYTE),
  SVC_USE_NMPR_CO      NUMBER(10),
  CHARGER_NM           VARCHAR2(50 CHAR),
  EVENT_CN             VARCHAR2(1000 CHAR),
  FRST_REGISTER_PNTTM  DATE,
  FRST_REGISTER_ID     VARCHAR2(20 BYTE),
  LAST_UPDUSR_PNTTM    DATE,
  LAST_UPDUSR_ID       VARCHAR2(20 BYTE),
  PRPARETG_CN          VARCHAR2(2500 CHAR),
  EVENT_SVC_END_DE     CHAR(18 BYTE),
  EVENT_TY_CODE        CHAR(18 BYTE),
  EVENT_CONFM_AT       CHAR(1 BYTE),
  EVENT_CONFM_DE       CHAR(8 BYTE),
  CONSTRAINT COMTNEVENTINFO_PK
 PRIMARY KEY
 (EVENT_ID)
)
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;


CREATE TABLE COMTNEXTRLHRINFO
(
  SEXDSTN_CODE         CHAR(1 BYTE),
  EXTRL_HR_NM          VARCHAR2(50 CHAR),
  EMAIL_ADRES          VARCHAR2(50 BYTE),
  FRST_REGISTER_PNTTM  DATE,
  FRST_REGISTER_ID     VARCHAR2(20 BYTE),
  LAST_UPDUSR_PNTTM    DATE,
  LAST_UPDUSR_ID       VARCHAR2(20 BYTE),
  OCCP_TY_CODE         VARCHAR2(4 BYTE),
  PSITN_INSTT_NM       VARCHAR2(100 CHAR),
  EXTRL_HR_ID          CHAR(20 BYTE)            NOT NULL,
  EVENT_ID             CHAR(20 BYTE)            NOT NULL,
  BRTH                 CHAR(8 BYTE),
  AREA_NO              VARCHAR2(5 BYTE),
  MIDDLE_TELNO         VARCHAR2(5 BYTE),
  END_TELNO            VARCHAR2(5 BYTE),
  CONSTRAINT COMTNEXTRLHRINFO_PK
 PRIMARY KEY
 (EXTRL_HR_ID, EVENT_ID)
)
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;


CREATE TABLE COMTNFAQINFO
(
  FAQ_ID                  CHAR(20 BYTE)         NOT NULL,
  QESTN_CN                VARCHAR2(2500 CHAR),
  ANSWER_CN               VARCHAR2(2500 CHAR),
  QESTN_SJ                VARCHAR2(250 CHAR),
  INQIRE_CO               NUMBER(10),
  FRST_REGISTER_PNTTM     DATE                  NOT NULL,
  FRST_REGISTER_ID        VARCHAR2(20 BYTE)     NOT NULL,
  LAST_UPDUSR_PNTTM       DATE                  NOT NULL,
  LAST_UPDUSR_ID          VARCHAR2(20 BYTE)     NOT NULL,
  ATCH_FILE_ID            CHAR(20 BYTE),
  QNA_PROCESS_STTUS_CODE  CHAR(1 BYTE),
  CONSTRAINT COMTNFAQINFO_PK
 PRIMARY KEY
 (FAQ_ID)
)
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;


CREATE TABLE COMTNFILE
(
  ATCH_FILE_ID  CHAR(20 BYTE)                   NOT NULL,
  CREAT_DT      DATE                            NOT NULL,
  USE_AT        CHAR(1 BYTE),
  CONSTRAINT COMTNFILE_PK
 PRIMARY KEY
 (ATCH_FILE_ID)
)
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;


CREATE TABLE COMTNFILEDETAIL
(
  ATCH_FILE_ID     CHAR(20 BYTE)                NOT NULL,
  FILE_SN          VARCHAR2(10 BYTE)            NOT NULL,
  FILE_STRE_COURS  VARCHAR2(2000 BYTE)          NOT NULL,
  STRE_FILE_NM     VARCHAR2(255 BYTE)           NOT NULL,
  ORIGNL_FILE_NM   VARCHAR2(255 CHAR),
  FILE_EXTSN       VARCHAR2(20 BYTE)            NOT NULL,
  FILE_MG          NUMBER(8),
  FILE_CN          CLOB,
  CONSTRAINT COMTNFILEDETAIL_PK
 PRIMARY KEY
 (ATCH_FILE_ID, FILE_SN)
)
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;


CREATE TABLE COMTNGNRLMBER
(
  PASSWORD          VARCHAR2(100 BYTE)          NOT NULL,
  PASSWORD_HINT     VARCHAR2(100 CHAR),
  PASSWORD_CNSR     VARCHAR2(100 CHAR),
  IHIDNUM           CHAR(13 BYTE),
  MBER_NM           VARCHAR2(60 CHAR)           NOT NULL,
  ZIP               CHAR(6 BYTE)                NOT NULL,
  ADRES             VARCHAR2(100 CHAR)          NOT NULL,
  AREA_NO           VARCHAR2(5 BYTE),
  MBER_STTUS        VARCHAR2(15 BYTE),
  DETAIL_ADRES      VARCHAR2(100 CHAR),
  END_TELNO         VARCHAR2(5 BYTE),
  MBER_ID           VARCHAR2(20 BYTE)           NOT NULL,
  MOBLPHON_NO       VARCHAR2(15 BYTE)           NOT NULL,
  GROUP_ID          CHAR(20 BYTE),
  MBER_FXNUM        VARCHAR2(15 BYTE),
  MBER_EMAIL_ADRES  VARCHAR2(50 BYTE),
  MIDDLE_TELNO      VARCHAR2(5 BYTE),
  SBSCRB_DE         DATE,
  SEXDSTN_CODE      CHAR(1 BYTE),
  UNIQ_ID           CHAR(20 BYTE)               NOT NULL,
  CONSTRAINT COMTNGNRLMBER_PK
 PRIMARY KEY
 (MBER_ID)
)
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;


CREATE TABLE COMTNHPCMINFO
(
  HPCM_ID              CHAR(20 BYTE)            NOT NULL,
  HPCM_SE_CODE         CHAR(1 BYTE),
  HPCM_DF              VARCHAR2(1000 CHAR),
  HPCM_DC              VARCHAR2(2500 CHAR),
  FRST_REGISTER_PNTTM  DATE,
  FRST_REGISTER_ID     VARCHAR2(20 BYTE),
  LAST_UPDUSR_PNTTM    DATE,
  LAST_UPDUSR_ID       VARCHAR2(20 BYTE),
  CONSTRAINT COMTNHPCMINFO_PK
 PRIMARY KEY
 (HPCM_ID)
)
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;


CREATE TABLE COMTNLOGINLOG
(
  LOG_ID        CHAR(20 BYTE)                   NOT NULL,
  LOGIN_ID      VARCHAR2(20 BYTE),
  LOGIN_IP      VARCHAR2(128 BYTE),
  LOGIN_MTHD    CHAR(4 BYTE),
  ERR_OCCRR_AT  CHAR(1 BYTE),
  ERROR_CODE    CHAR(3 BYTE),
  CREAT_DT      DATE,
  CONSTRAINT COMTNLOGINLOG_PK
 PRIMARY KEY
 (LOG_ID)
)
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;


CREATE TABLE COMTNMENUCREATDTLS
(
  MENU_NO      NUMBER(20)                       NOT NULL,
  MAPCREAT_ID  VARCHAR2(35 BYTE),
  AUTHOR_CODE  VARCHAR2(30 BYTE)                NOT NULL,
  CONSTRAINT COMTNMENUCREATDTLS_PK
 PRIMARY KEY
 (MENU_NO, AUTHOR_CODE)
)
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;


CREATE TABLE COMTNMENUINFO
(
  MENU_NM            VARCHAR2(50 CHAR)          NOT NULL,
  PROGRM_FILE_NM     VARCHAR2(50 BYTE)          NOT NULL,
  MENU_NO            NUMBER(20)                 NOT NULL,
  UPPER_MENU_NO      NUMBER(20),
  MENU_ORDR          NUMBER(20)                 NOT NULL,
  MENU_DC            VARCHAR2(100 CHAR),
  RELATE_IMAGE_PATH  VARCHAR2(100 BYTE),
  RELATE_IMAGE_NM    VARCHAR2(50 BYTE),
  CONSTRAINT COMTNMENUINFO_PK
 PRIMARY KEY
 (MENU_NO)
)
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;


CREATE TABLE COMTNMTGINFO
(
  MTG_ID               CHAR(20 BYTE)            NOT NULL,
  MTG_NM               VARCHAR2(250 CHAR),
  MTG_MTR_CN           VARCHAR2(1000 CHAR),
  MTG_SN               NUMBER(10),
  MTG_CO               NUMBER(5),
  MTG_DE               CHAR(8 BYTE),
  MTG_PLACE            VARCHAR2(250 CHAR),
  MTG_BEGIN_TIME       CHAR(14 BYTE),
  MTG_END_TIME         CHAR(14 BYTE),
  CLSDR_MTG_AT         CHAR(1 BYTE),
  READNG_BEGIN_DE      CHAR(8 BYTE),
  READNG_AT            CHAR(1 BYTE),
  MTG_RESULT_CN        VARCHAR2(1000 BYTE),
  MTG_RESULT_ENNC      CHAR(1 BYTE),
  ETC_MATTER           VARCHAR2(1000 BYTE),
  MNGT_DEPT_ID         VARCHAR2(20 BYTE),
  MNAER_ID             VARCHAR2(20 BYTE),
  MNAER_DEPT_ID        VARCHAR2(20 BYTE),
  MTN_AT               CHAR(1 BYTE),
  NONATDRN_CO          NUMBER(10),
  ATDRN_CO             NUMBER(10),
  FRST_REGISTER_PNTTM  DATE,
  FRST_REGISTER_ID     VARCHAR2(20 BYTE),
  LAST_UPDUSR_PNTTM    DATE,
  LAST_UPDUSR_ID       VARCHAR2(20 BYTE),
  CONSTRAINT COMTNMTGINFO_PK
 PRIMARY KEY
 (MTG_ID)
)
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;


CREATE TABLE COMTNNEWSINFO
(
  NEWS_ID              CHAR(20 BYTE)            NOT NULL,
  NEWS_SJ              VARCHAR2(100 CHAR),
  NEWS_CN              VARCHAR2(2500 CHAR),
  NEWS_ORIGIN          VARCHAR2(250 CHAR),
  NTCE_AT              CHAR(1 BYTE),
  FRST_REGISTER_PNTTM  DATE                     NOT NULL,
  FRST_REGISTER_ID     VARCHAR2(20 BYTE)        NOT NULL,
  LAST_UPDUSR_PNTTM    DATE                     NOT NULL,
  LAST_UPDUSR_ID       VARCHAR2(20 BYTE)        NOT NULL,
  ATCH_FILE_ID         CHAR(20 BYTE),
  NTCE_DE              CHAR(8 BYTE),
  CONSTRAINT COMTNNEWSINFO_PK
 PRIMARY KEY
 (NEWS_ID)
)
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;


CREATE TABLE COMTNNTTSTATS
(
  NTCE_CO             NUMBER(10),
  AVRG_INQIRE_CO      NUMBER(10),
  TOP_INQIRE_CO       NUMBER(10),
  MUMM_INQIRE_CO      NUMBER(10),
  TOP_NTCEPERSON__ID  VARCHAR2(20 BYTE),
  STATS_ID            CHAR(18 BYTE)             NOT NULL,
  CONSTRAINT COMTNNTTSTATS_PK
 PRIMARY KEY
 (STATS_ID)
)
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;


CREATE TABLE COMTNORGNZTINFO
(
  ORGNZT_ID  CHAR(20 BYTE)                      NOT NULL,
  ORGNZT_NM  VARCHAR2(20 CHAR)                  NOT NULL,
  ORGNZT_DC  VARCHAR2(100 CHAR),
  CONSTRAINT COMTNORGNZTINFO_PK
 PRIMARY KEY
 (ORGNZT_ID)
)
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;


CREATE TABLE COMTNPROGRMLIST
(
  PROGRM_FILE_NM    VARCHAR2(50 BYTE)           NOT NULL,
  PROGRM_STRE_PATH  VARCHAR2(100 BYTE)          NOT NULL,
  PROGRM_KOREANNM   VARCHAR2(50 CHAR),
  PROGRM_DC         CLOB,
  URL               VARCHAR2(100 BYTE)          NOT NULL,
  CONSTRAINT COMTNPROGRMLIST_PK
 PRIMARY KEY
 (PROGRM_FILE_NM)
)
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;


CREATE TABLE COMTNQAINFO
(
  QA_ID                   CHAR(20 BYTE)         NOT NULL,
  QESTN_SJ                VARCHAR2(250 CHAR),
  QESTN_ANSWER_CN         VARCHAR2(2500 CHAR),
  WRITNG_DE               DATE,
  INQIRE_CO               NUMBER(10),
  EMAIL_ADRES             VARCHAR2(50 BYTE),
  FRST_REGISTER_PNTTM     DATE,
  FRST_REGISTER_ID        VARCHAR2(20 BYTE),
  LAST_UPDUSR_PNTTM       DATE,
  LAST_UPDUSR_ID          VARCHAR2(20 BYTE),
  PROCESS_STTUS_CODE      CHAR(1 BYTE),
  WRTER_NM                VARCHAR2(20 CHAR),
  ANSWER_CN               VARCHAR2(2500 CHAR),
  WRITNG_PASSWORD         VARCHAR2(20 BYTE),
  ANSWER_DE               DATE,
  EMAIL_ANSWER_AT         CHAR(1 BYTE),
  AREA_NO                 VARCHAR2(5 BYTE),
  MIDDLE_TELNO            VARCHAR2(5 BYTE),
  END_TELNO               VARCHAR2(5 BYTE),
  QNA_PROCESS_STTUS_CODE  CHAR(1 BYTE),
  QESTN_CN                VARCHAR2(2500 CHAR),
  CONSTRAINT COMTNQAINFO_PK
 PRIMARY KEY
 (QA_ID)
)
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;


CREATE TABLE COMTNQESTNRINFO
(
  QESTNR_ID                  CHAR(20 BYTE)      NOT NULL,
  QESTNR_SJ                  VARCHAR2(250 CHAR),
  QESTNR_PURPS               VARCHAR2(1000 CHAR),
  QESTNR_WRITNG_GUIDANCE_CN  VARCHAR2(2000 CHAR),
  QESTNR_BEGIN_DE            CHAR(8 BYTE),
  QESTNR_END_DE              CHAR(8 BYTE),
  FRST_REGISTER_PNTTM        DATE,
  FRST_REGISTER_ID           VARCHAR2(20 BYTE),
  LAST_UPDUSR_PNTTM          DATE,
  LAST_UPDUSR_ID             VARCHAR2(20 BYTE),
  QESTNR_TRGET               VARCHAR2(1000 CHAR),
  QESTNR_TMPLAT_ID           CHAR(20 BYTE)      NOT NULL,
  CONSTRAINT COMTNQESTNRINFO_PK
 PRIMARY KEY
 (QESTNR_ID, QESTNR_TMPLAT_ID)
)
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;


CREATE TABLE COMTNQUSTNRIEM
(
  QESTNR_QESITM_ID     CHAR(20 BYTE)            NOT NULL,
  QESTNR_ID            CHAR(20 BYTE)            NOT NULL,
  IEM_SN               NUMBER(5),
  FRST_REGISTER_PNTTM  DATE,
  FRST_REGISTER_ID     VARCHAR2(20 BYTE),
  LAST_UPDUSR_PNTTM    DATE,
  LAST_UPDUSR_ID       VARCHAR2(20 BYTE),
  QUSTNR_IEM_ID        VARCHAR2(20 BYTE)        NOT NULL,
  IEM_CN               VARCHAR2(1000 CHAR),
  ETC_ANSWER_AT        CHAR(1 BYTE),
  QESTNR_TMPLAT_ID     CHAR(20 BYTE)            NOT NULL,
  CONSTRAINT COMTNQUSTNRIEM_PK
 PRIMARY KEY
 (QESTNR_TMPLAT_ID, QESTNR_ID, QESTNR_QESITM_ID, QUSTNR_IEM_ID)
)
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;


CREATE TABLE COMTNQUSTNRQESITM
(
  QESTNR_QESITM_ID     CHAR(20 BYTE)            NOT NULL,
  QESTNR_ID            CHAR(20 BYTE)            NOT NULL,
  FRST_REGISTER_PNTTM  DATE                     NOT NULL,
  FRST_REGISTER_ID     VARCHAR2(20 BYTE)        NOT NULL,
  LAST_UPDUSR_PNTTM    DATE                     NOT NULL,
  LAST_UPDUSR_ID       VARCHAR2(20 BYTE)        NOT NULL,
  QESTN_SN             NUMBER(10),
  QESTN_TY_CODE        CHAR(1 BYTE),
  QESTN_CN             VARCHAR2(2500 CHAR),
  MXMM_CHOISE_CO       NUMBER(5),
  QESTNR_TMPLAT_ID     CHAR(20 BYTE)            NOT NULL,
  CONSTRAINT COMTNQUSTNRQESITM_PK
 PRIMARY KEY
 (QESTNR_ID, QESTNR_QESITM_ID, QESTNR_TMPLAT_ID)
)
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;


CREATE TABLE COMTNQUSTNRRESPONDINFO
(
  QESTNR_ID            CHAR(20 BYTE)            NOT NULL,
  QESTNR_RESPOND_ID    CHAR(20 BYTE)            NOT NULL,
  SEXDSTN_CODE         CHAR(1 BYTE),
  OCCP_TY_CODE         VARCHAR2(250 BYTE),
  RESPOND_NM           VARCHAR2(50 CHAR),
  FRST_REGISTER_PNTTM  DATE,
  FRST_REGISTER_ID     VARCHAR2(20 BYTE),
  LAST_UPDUSR_PNTTM    DATE,
  LAST_UPDUSR_ID       VARCHAR2(20 BYTE),
  QESTNR_TMPLAT_ID     CHAR(20 BYTE)            NOT NULL,
  BRTH                 CHAR(8 BYTE),
  AREA_NO              VARCHAR2(5 BYTE),
  MIDDLE_TELNO         VARCHAR2(5 BYTE),
  END_TELNO            VARCHAR2(5 BYTE),
  CONSTRAINT COMTNQUSTNRRESPONDINFO_PK
 PRIMARY KEY
 (QESTNR_TMPLAT_ID, QESTNR_ID, QESTNR_RESPOND_ID)
)
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;


CREATE TABLE COMTNQUSTNRRSPNSRESULT
(
  RESPOND_ANSWER_CN    VARCHAR2(1000 CHAR),
  FRST_REGISTER_PNTTM  DATE,
  FRST_REGISTER_ID     VARCHAR2(20 BYTE),
  LAST_UPDUSR_PNTTM    DATE,
  LAST_UPDUSR_ID       VARCHAR2(20 BYTE),
  RESPOND_NM           VARCHAR2(50 BYTE),
  ETC_ANSWER_CN        VARCHAR2(1000 BYTE),
  QESTNR_QESRSPNS_ID   CHAR(20 BYTE)            NOT NULL,
  QESTNR_ID            CHAR(20 BYTE)            NOT NULL,
  QESTNR_QESITM_ID     CHAR(20 BYTE)            NOT NULL,
  QESTNR_TMPLAT_ID     CHAR(20 BYTE)            NOT NULL,
  QUSTNR_IEM_ID        CHAR(20 BYTE),
  CONSTRAINT COMTNQUSTNRRSPNSRESULT_PK
 PRIMARY KEY
 (QESTNR_QESRSPNS_ID, QESTNR_ID, QESTNR_QESITM_ID, QESTNR_TMPLAT_ID)
)
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;


CREATE TABLE COMTNQUSTNRTMPLAT
(
  QESTNR_TMPLAT_ID     CHAR(20 BYTE)            NOT NULL,
  QESTNR_TMPLAT_TY     VARCHAR2(100 BYTE),
  FRST_REGISTER_PNTTM  DATE,
  FRST_REGISTER_ID     VARCHAR2(20 BYTE),
  LAST_UPDUSR_PNTTM    DATE,
  LAST_UPDUSR_ID       VARCHAR2(20 BYTE),
  QESTNR_TMPLAT_CN     VARCHAR2(2000 CHAR),
  QESTNR_TMPLAT_COURS  VARCHAR2(100 BYTE),
  QESTNR_TMPLAT_IMAGE  BLOB,
  CONSTRAINT COMTNQUSTNRTMPLAT_PK
 PRIMARY KEY
 (QESTNR_TMPLAT_ID)
)
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;


CREATE TABLE COMTNRECOMENDSITEINFO
(
  RECOMEND_SITE_URL    VARCHAR2(250 BYTE),
  RECOMEND_SITE_ID     CHAR(20 BYTE)            NOT NULL,
  RECOMEND_SITE_NM     VARCHAR2(100 CHAR),
  RECOMEND_SITE_DC     VARCHAR2(1000 CHAR),
  RECOMEND_RESN_CN     VARCHAR2(1000 CHAR),
  RECOMEND_CONFM_AT    CHAR(1 BYTE),
  CONFM_DE             CHAR(8 BYTE),
  FRST_REGISTER_PNTTM  DATE,
  FRST_REGISTER_ID     VARCHAR2(20 BYTE),
  LAST_UPDUSR_PNTTM    DATE,
  LAST_UPDUSR_ID       VARCHAR2(20 BYTE),
  CONSTRAINT COMTNRECOMENDSITEINFO_PK
 PRIMARY KEY
 (RECOMEND_SITE_ID)
)
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;


CREATE TABLE COMTNRESTDE
(
  RESTDE_NM            VARCHAR2(50 CHAR),
  RESTDE_SE_CODE       VARCHAR2(2 BYTE),
  RESTDE_DC            VARCHAR2(200 CHAR),
  FRST_REGISTER_PNTTM  DATE,
  FRST_REGISTER_ID     VARCHAR2(20 BYTE),
  LAST_UPDUSR_PNTTM    DATE,
  LAST_UPDUSR_ID       VARCHAR2(20 BYTE),
  RESTDE_NO            NUMBER(6)                NOT NULL,
  RESTDE_DE            CHAR(8 BYTE),
  CONSTRAINT COMTNRESTDE_PK
 PRIMARY KEY
 (RESTDE_NO)
)
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;


CREATE TABLE COMTNROLES_HIERARCHY
(
  PARENT_ROLE  VARCHAR2(30 BYTE)                NOT NULL,
  CHILD_ROLE   VARCHAR2(30 BYTE)                NOT NULL,
  CONSTRAINT COMTNROLES_HIERARCHY_PK
 PRIMARY KEY
 (PARENT_ROLE, CHILD_ROLE)
)
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;


CREATE TABLE COMTNSCHDULINFO
(
  SCHDUL_ID            CHAR(20 BYTE)            NOT NULL,
  SCHDUL_SE            CHAR(1 BYTE),
  SCHDUL_DEPT_ID       VARCHAR2(20 BYTE),
  SCHDUL_KIND_CODE     VARCHAR2(20 BYTE),
  SCHDUL_BGNDE         VARCHAR2(14 BYTE),
  SCHDUL_ENDDE         VARCHAR2(14 BYTE),
  SCHDUL_NM            VARCHAR2(255 CHAR),
  SCHDUL_CN            VARCHAR2(2500 CHAR),
  SCHDUL_PLACE         VARCHAR2(255 CHAR),
  SCHDUL_IPCR_CODE     CHAR(1 BYTE),
  SCHDUL_CHARGER_ID    VARCHAR2(20 BYTE),
  ATCH_FILE_ID         CHAR(20 BYTE),
  FRST_REGISTER_PNTTM  DATE,
  FRST_REGISTER_ID     VARCHAR2(20 BYTE),
  LAST_UPDUSR_PNTTM    DATE,
  LAST_UPDUSR_ID       VARCHAR2(20 BYTE),
  REPTIT_SE_CODE       CHAR(1 BYTE),
  CONSTRAINT COMTNSCHDULINFO_PK
 PRIMARY KEY
 (SCHDUL_ID)
)
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;


CREATE TABLE COMTECOPSEQ
(
  TABLE_NAME  VARCHAR2(20 BYTE)                 NOT NULL,
  NEXT_ID     INTEGER                           NOT NULL,
  CONSTRAINT COMTECOPSEQ_PK
 PRIMARY KEY
 (TABLE_NAME)
)
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;



CREATE INDEX COMTCCMMNCODE_FK1 ON COMTCCMMNCODE
(CL_CODE)
LOGGING
NOPARALLEL;




CREATE INDEX COMTCCMMNDETAILCODE_FK1 ON COMTCCMMNDETAILCODE
(CODE_ID)
LOGGING
NOPARALLEL;










CREATE INDEX COMTHEMAILDSPTCHMANAGE_FK1 ON COMTHEMAILDSPTCHMANAGE
(DSPTCHPERSON)
LOGGING
NOPARALLEL;


CREATE INDEX COMTHEMAILDSPTCHMANAGE_FK2 ON COMTHEMAILDSPTCHMANAGE
(ATCH_FILE_ID)
LOGGING
NOPARALLEL;




CREATE INDEX COMTHEMPLYRINFOCHANGEDTLS_FK1 ON COMTHEMPLYRINFOCHANGEDTLS
(EMPLYR_ID)
LOGGING
NOPARALLEL;




CREATE INDEX COMTHPROGRMCHANGEDTLS_FK1 ON COMTHPROGRMCHANGEDTLS
(PROGRM_FILE_NM)
LOGGING
NOPARALLEL;






CREATE INDEX COMTNANSWER_FK1 ON COMTNANSWER
(NTT_ID, BBS_ID)
LOGGING
NOPARALLEL;








CREATE INDEX COMTNAUTHORROLERELATE_FK1 ON COMTNAUTHORROLERELATE
(AUTHOR_CODE)
LOGGING
NOPARALLEL;


CREATE INDEX COMTNAUTHORROLERELATE_FK2 ON COMTNAUTHORROLERELATE
(ROLE_CODE)
LOGGING
NOPARALLEL;




CREATE INDEX COMTNBBS_FK1 ON COMTNBBS
(BBS_ID)
LOGGING
NOPARALLEL;






CREATE INDEX COMTNBBSUSE_FK1 ON COMTNBBSUSE
(BBS_ID)
LOGGING
NOPARALLEL;






CREATE INDEX COMTNCLUBUSER_FK1 ON COMTNCLUBUSER
(CLB_ID, CMMNTY_ID)
LOGGING
NOPARALLEL;


CREATE INDEX COMTNCLUBUSER_FK2 ON COMTNCLUBUSER
(EMPLYR_ID)
LOGGING
NOPARALLEL;






CREATE INDEX COMTNCMMNTYUSER_FK1 ON COMTNCMMNTYUSER
(CMMNTY_ID)
LOGGING
NOPARALLEL;








CREATE INDEX COMTNDIARYINFO_FK1 ON COMTNDIARYINFO
(SCHDUL_ID)
LOGGING
NOPARALLEL;




CREATE INDEX COMTNEMPLYRINFO_FK1 ON COMTNEMPLYRINFO
(ORGNZT_ID)
LOGGING
NOPARALLEL;


CREATE INDEX COMTNEMPLYRINFO_FK2 ON COMTNEMPLYRINFO
(GROUP_ID)
LOGGING
NOPARALLEL;




CREATE INDEX COMTNEMPLYRSCRTYESTBS_FK4 ON COMTNEMPLYRSCRTYESTBS
(AUTHOR_CODE)
LOGGING
NOPARALLEL;




CREATE INDEX COMTNENTRPRSMBER_FK1 ON COMTNENTRPRSMBER
(GROUP_ID)
LOGGING
NOPARALLEL;






CREATE INDEX COMTNEXTRLHRINFO_FK1 ON COMTNEXTRLHRINFO
(EVENT_ID)
LOGGING
NOPARALLEL;




CREATE INDEX COMTNFAQINFO_FK1 ON COMTNFAQINFO
(ATCH_FILE_ID)
LOGGING
NOPARALLEL;






CREATE INDEX COMTNFILEDETAIL_FK1 ON COMTNFILEDETAIL
(ATCH_FILE_ID)
LOGGING
NOPARALLEL;




CREATE INDEX COMTNGNRLMBER_FK1 ON COMTNGNRLMBER
(GROUP_ID)
LOGGING
NOPARALLEL;








CREATE INDEX COMTNMENUCREATSTLS_FK1 ON COMTNMENUCREATDTLS
(AUTHOR_CODE)
LOGGING
NOPARALLEL;


CREATE INDEX COMTNMENUCREATSTLS_FK2 ON COMTNMENUCREATDTLS
(MENU_NO)
LOGGING
NOPARALLEL;


CREATE INDEX COMTNMENUCREATSTLS_FK3 ON COMTNMENUCREATDTLS
(MAPCREAT_ID)
LOGGING
NOPARALLEL;




CREATE INDEX COMTNMENUINFO_FK1 ON COMTNMENUINFO
(PROGRM_FILE_NM)
LOGGING
NOPARALLEL;


CREATE INDEX COMTNMENUINFO_FK2 ON COMTNMENUINFO
(UPPER_MENU_NO)
LOGGING
NOPARALLEL;








CREATE INDEX COMTNNEWSINFO_FK1 ON COMTNNEWSINFO
(ATCH_FILE_ID)
LOGGING
NOPARALLEL;












CREATE INDEX COMTNQESTNRINFO_FK1 ON COMTNQESTNRINFO
(QESTNR_TMPLAT_ID)
LOGGING
NOPARALLEL;




CREATE INDEX COMTNQUSTNRIEM_FK1 ON COMTNQUSTNRIEM
(QESTNR_QESITM_ID, QESTNR_ID, QESTNR_TMPLAT_ID)
LOGGING
NOPARALLEL;




CREATE INDEX COMTNQUSTNRQESITM_FK1 ON COMTNQUSTNRQESITM
(QESTNR_ID, QESTNR_TMPLAT_ID)
LOGGING
NOPARALLEL;




CREATE INDEX COMTNQUSTNRRESPONDINFO_FK1 ON COMTNQUSTNRRESPONDINFO
(QESTNR_ID, QESTNR_TMPLAT_ID)
LOGGING
NOPARALLEL;




CREATE INDEX COMTNQUSTNRRSPNSRESULT_FK1 ON COMTNQUSTNRRSPNSRESULT
(QESTNR_ID, QESTNR_QESITM_ID, QESTNR_TMPLAT_ID)
LOGGING
NOPARALLEL;












CREATE INDEX COMTNROLES_HIERARCHY_FK1 ON COMTNROLES_HIERARCHY
(PARENT_ROLE)
LOGGING
NOPARALLEL;


CREATE INDEX COMTNROLES_HIERARCHY_FK2 ON COMTNROLES_HIERARCHY
(CHILD_ROLE)
LOGGING
NOPARALLEL;



CREATE OR REPLACE FORCE VIEW COMVNUSERMASTER 
	(UNIQ_ID,USER_ID,PASSWORD,USER_NM,USER_ZIP,USER_ADRES,USER_EMAIL,GROUP_ID,USER_SE,ORGNZT_ID) 
AS
SELECT 
	UNIQ_ID,MBER_ID,PASSWORD,MBER_NM,ZIP,ADRES,MBER_EMAIL_ADRES, GROUP_ID,USER_SE,ORGNZT_ID
FROM (
	SELECT 
		UNIQ_ID,MBER_ID,PASSWORD,MBER_NM,ZIP,ADRES,MBER_EMAIL_ADRES,'' GROUP_ID,'GNR' AS USER_SE, '' AS ORGNZT_ID
	FROM COMTNGNRLMBER			
	UNION ALL		
	SELECT 
		UNIQ_ID,EMPLYR_ID,PASSWORD,EMPLYR_NM,ZIP,HOMEADRES,EMAIL_ADRES,GROUP_ID,'USR' AS USER_SE, ORGNZT_ID
	FROM COMTNEMPLYRINFO	
	UNION ALL		
	SELECT UNIQ_ID,ENTRPRSMBER_ID,ENTRPRS_MBER_PASSWORD,CMPNY_NM,ZIP,ADRES,APPLCNT_EMAIL_ADRES,'','ENT' AS USER_SE, '' AS ORGNZT_ID
	FROM COMTNENTRPRSMBER
)
ORDER BY UNIQ_ID;














