CREATE TABLE `COMTCADMINISTCODERECPTNLOG` (
  `OCCRR_DE` char(8) NOT NULL,
  `ADMINIST_ZONE_SE` char(1) NOT NULL,
  `ADMINIST_ZONE_CODE` varchar(10) NOT NULL,
  `OPERT_SN` int(11) NOT NULL,
  `CHANGE_SE_CODE` varchar(2) DEFAULT NULL,
  `PROCESS_SE` varchar(2) DEFAULT NULL,
  `ADMINIST_ZONE_NM` varchar(60) DEFAULT NULL,
  `LOWEST_ADMINIST_ZONE_NM` varchar(60) DEFAULT NULL,
  `CTPRVN_CODE` varchar(2) DEFAULT NULL,
  `SIGNGU_CODE` varchar(3) DEFAULT NULL,
  `EMD_CODE` varchar(3) DEFAULT NULL,
  `LI_CODE` varchar(2) DEFAULT NULL,
  `CREAT_DE` char(8) DEFAULT NULL,
  `ABL_DE` char(8) DEFAULT NULL,
  `ABL_ENNC` char(1) DEFAULT NULL,
  `FRST_REGISTER_ID` varchar(20) DEFAULT NULL,
  `FRST_REGISTER_PNTTM` datetime DEFAULT NULL,
  `LAST_UPDUSR_ID` varchar(20) DEFAULT NULL,
  `LAST_UPDUSR_PNTTM` datetime DEFAULT NULL,
  PRIMARY KEY (`OCCRR_DE`,`ADMINIST_ZONE_SE`,`ADMINIST_ZONE_CODE`,`OPERT_SN`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='행정코드수신로그에 대한 정보';

CREATE TABLE `COMTNADBK` (
  `ADBKUSER_ID` char(20) NOT NULL,
  `ADBK_ID` char(20) DEFAULT NULL,
  `EMPLYR_ID` varchar(20) DEFAULT NULL,
  `NCRD_ID` char(20) DEFAULT NULL,
  `NM` varchar(20) DEFAULT NULL,
  `EMAIL_ADRES` varchar(50) DEFAULT NULL,
  `HOME_TELNO` varchar(20) DEFAULT NULL,
  `MOBLPHON_NO` varchar(20) DEFAULT NULL,
  `OFFM_TELNO` varchar(20) DEFAULT NULL,
  `FXNUM` varchar(20) DEFAULT NULL,
  PRIMARY KEY (`ADBKUSER_ID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

CREATE TABLE `COMTNADBKMANAGE` (
  `ADBK_ID` char(20) NOT NULL,
  `ADBK_NM` varchar(50) NOT NULL,
  `OTHBC_SCOPE` varchar(20) NOT NULL,
  `USE_AT` char(1) NOT NULL,
  `WRTER_ID` varchar(20) DEFAULT NULL,
  `TRGET_ORGNZT_ID` char(20) DEFAULT NULL,
  `FRST_REGISTER_PNTTM` datetime NOT NULL,
  `LAST_UPDUSR_PNTTM` datetime DEFAULT NULL,
  `FRST_REGISTER_ID` varchar(20) NOT NULL,
  `LAST_UPDUSR_ID` varchar(20) DEFAULT NULL,
  PRIMARY KEY (`ADBK_ID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='주소록을 구성하기 위한 주소록명, 공개범위,  등록자ID, 등록자의 부서에 대한 데이터를 저장하고,  사용여';

CREATE TABLE `COMTNADMINISTRATIONWORD` (
  `ADMINIST_WORD_ID` char(20) NOT NULL,
  `ADMINIST_WORD_NM` varchar(255) DEFAULT NULL,
  `ADMINIST_WORD_ENG_NM` varchar(255) DEFAULT NULL,
  `ADMINIST_WORD_ABRV` varchar(255) DEFAULT NULL,
  `THEMA_RELM` varchar(255) DEFAULT NULL,
  `WORD_DOMN` varchar(255) DEFAULT NULL,
  `STD_WORD` varchar(255) DEFAULT NULL,
  `ADMINIST_WORD_DF` varchar(2500) DEFAULT NULL,
  `ADMINIST_WORD_DC` varchar(2500) DEFAULT NULL,
  `FRST_REGISTER_ID` varchar(20) DEFAULT NULL,
  `FRST_REGISTER_PNTTM` datetime DEFAULT NULL,
  `LAST_UPDUSR_ID` varchar(20) DEFAULT NULL,
  `LAST_UPDUSR_PNTTM` datetime DEFAULT NULL,
  PRIMARY KEY (`ADMINIST_WORD_ID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='행정용어사전관리  정보를 조회하는 기능을 제공하기 위한 속성을 관리한다.';

CREATE TABLE `COMTNBBSMASTEROPTN` (
  `BBS_ID` char(20) NOT NULL,
  `COMMENT_AT` char(1) NOT NULL,
  `STSFDG_AT` char(1) NOT NULL,
  `FRST_REGISTER_PNTTM` datetime NOT NULL,
  `LAST_UPDUSR_PNTTM` datetime DEFAULT NULL,
  `FRST_REGISTER_ID` varchar(20) NOT NULL,
  `LAST_UPDUSR_ID` varchar(20) DEFAULT NULL,
  PRIMARY KEY (`BBS_ID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

CREATE TABLE `COMTNBKMKMENUMANAGERESULT` (
  `MENU_ID` decimal(20,0) NOT NULL,
  `EMPLYR_ID` varchar(20) NOT NULL,
  `MENU_NM` varchar(50) NOT NULL,
  `PROGRM_STRE_PATH` varchar(100) NOT NULL,
  PRIMARY KEY (`MENU_ID`,`EMPLYR_ID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='로그인한 사용자가 자주 사용하는 메뉴나 접근의 용의성을 위해 바로 가기 메뉴를 관리한다.';

CREATE TABLE `COMTNCNTCINSTT` (
  `INSTT_ID` varchar(20) NOT NULL,
  `INSTT_NM` varchar(100) DEFAULT NULL,
  `USE_AT` char(1) DEFAULT NULL,
  `FRST_REGISTER_ID` varchar(20) DEFAULT NULL,
  `FRST_REGISTER_PNTTM` datetime DEFAULT NULL,
  `LAST_UPDUSR_ID` varchar(20) DEFAULT NULL,
  `LAST_UPDUSR_PNTTM` datetime DEFAULT NULL,
  PRIMARY KEY (`INSTT_ID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='연계기관에 대한 정보';

CREATE TABLE `COMTNCNTCMESSAGE` (
  `CNTC_MESSAGE_ID` varchar(20) NOT NULL,
  `CNTC_MESSAGE_NM` varchar(100) DEFAULT NULL,
  `UPPER_CNTC_MESSAGE_ID` varchar(20) DEFAULT NULL,
  `USE_AT` char(1) DEFAULT NULL,
  `FRST_REGISTER_ID` varchar(20) DEFAULT NULL,
  `FRST_REGISTER_PNTTM` datetime DEFAULT NULL,
  `LAST_UPDUSR_ID` varchar(20) DEFAULT NULL,
  `LAST_UPDUSR_PNTTM` datetime DEFAULT NULL,
  PRIMARY KEY (`CNTC_MESSAGE_ID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='연계메시지에 대한 정보';

CREATE TABLE `COMTNCNTCMESSAGEITEM` (
  `CNTC_MESSAGE_ID` varchar(20) NOT NULL,
  `ITEM_ID` varchar(20) NOT NULL,
  `ITEM_NM` varchar(100) DEFAULT NULL,
  `ITEM_TYPE` varchar(50) DEFAULT NULL,
  `ITEM_LT` decimal(8,0) DEFAULT NULL,
  `USE_AT` char(1) DEFAULT NULL,
  `FRST_REGISTER_ID` varchar(20) DEFAULT NULL,
  `FRST_REGISTER_PNTTM` datetime DEFAULT NULL,
  `LAST_UPDUSR_ID` varchar(20) DEFAULT NULL,
  `LAST_UPDUSR_PNTTM` datetime DEFAULT NULL,
  PRIMARY KEY (`CNTC_MESSAGE_ID`,`ITEM_ID`),
  CONSTRAINT `COMTNCNTCMESSAGEITEM_FK` FOREIGN KEY (`CNTC_MESSAGE_ID`) REFERENCES `COMTNCNTCMESSAGE` (`CNTC_MESSAGE_ID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='연계항목에 대한 정보';

CREATE TABLE `COMTNCNTCSYSTEM` (
  `INSTT_ID` varchar(20) NOT NULL,
  `SYS_ID` varchar(20) NOT NULL,
  `SYS_NM` varchar(255) DEFAULT NULL,
  `SYS_IP` varchar(23) DEFAULT NULL,
  `USE_AT` char(1) DEFAULT NULL,
  `FRST_REGISTER_ID` varchar(20) DEFAULT NULL,
  `FRST_REGISTER_PNTTM` datetime DEFAULT NULL,
  `LAST_UPDUSR_ID` varchar(20) DEFAULT NULL,
  `LAST_UPDUSR_PNTTM` datetime DEFAULT NULL,
  PRIMARY KEY (`INSTT_ID`,`SYS_ID`),
  CONSTRAINT `COMTNCNTCSYSTEM_FK` FOREIGN KEY (`INSTT_ID`) REFERENCES `COMTNCNTCINSTT` (`INSTT_ID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='연계시스템에 대한 정보';

CREATE TABLE `COMTNCNTCSERVICE` (
  `INSTT_ID` varchar(20) NOT NULL,
  `SYS_ID` varchar(20) NOT NULL,
  `SVC_ID` varchar(20) NOT NULL,
  `SVC_NM` varchar(255) DEFAULT NULL,
  `REQUEST_MESSAGE_ID` varchar(20) DEFAULT NULL,
  `RSPNS_MESSAGE_ID` varchar(20) DEFAULT NULL,
  `USE_AT` char(1) DEFAULT NULL,
  `FRST_REGISTER_ID` varchar(20) DEFAULT NULL,
  `FRST_REGISTER_PNTTM` datetime DEFAULT NULL,
  `LAST_UPDUSR_ID` varchar(20) DEFAULT NULL,
  `LAST_UPDUSR_PNTTM` datetime DEFAULT NULL,
  PRIMARY KEY (`INSTT_ID`,`SYS_ID`,`SVC_ID`),
  CONSTRAINT `COMTNCNTCSERVICE_FK` FOREIGN KEY (`INSTT_ID`, `SYS_ID`) REFERENCES `COMTNCNTCSYSTEM` (`INSTT_ID`, `SYS_ID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='연계서비스에 대한 정보';

CREATE TABLE `COMTNINDVDLPGECNTNTS` (
  `CNTNTS_ID` varchar(20) NOT NULL,
  `CNTNTS_NM` varchar(100) NOT NULL,
  `CNTC_URL` varchar(256) NOT NULL COMMENT '마이페이지에 뿌려질 콘텐츠 URL',
  `CNTNTS_USE_AT` char(1) NOT NULL,
  `CNTNTS_LINK_URL` varchar(256) NOT NULL COMMENT '상세보기URL',
  `CNTNTS_DC` varchar(1000) DEFAULT NULL,
  PRIMARY KEY (`CNTNTS_ID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='사용자들이 마이페이지에 등록 가능한 콘텐츠를 관리한다.';

CREATE TABLE `COMTNINDVDLPGEESTBS` (
  `EMPLYR_ID` varchar(20) NOT NULL,
  `TITLE_BAR_COLOR` char(7) CHARACTER SET latin1 NOT NULL,
  `SORT_MTHD` char(1) CHARACTER SET latin1 NOT NULL DEFAULT 'R',
  `SORT_CNT` int(11) NOT NULL DEFAULT '2',
  PRIMARY KEY (`EMPLYR_ID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='마이페이지 구성을 위한 콘텐츠 타이틀바 색상, 콘텐츠의 배열 방식을 저장하고';

CREATE TABLE `COMTNCNTNTSLIST` (
  `EMPLYR_ID` varchar(20) NOT NULL,
  `CNTNTS_ID` varchar(20) NOT NULL,
  PRIMARY KEY (`EMPLYR_ID`,`CNTNTS_ID`),
  KEY `FK2_INDVDLPGECNTNTS_CNTNTSLIST` (`CNTNTS_ID`),
  CONSTRAINT `FK2_INDVDLPGECNTNTS_CNTNTSLIST` FOREIGN KEY (`CNTNTS_ID`) REFERENCES `COMTNINDVDLPGECNTNTS` (`CNTNTS_ID`),
  CONSTRAINT `FK1_INDVDLPGEESTBS_CNTNTSLIST` FOREIGN KEY (`EMPLYR_ID`) REFERENCES `COMTNINDVDLPGEESTBS` (`EMPLYR_ID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='각텝별로 추가된 콘텐츠 목록';

CREATE TABLE `COMTNCOMMENT` (
  `COMMENT_NO` decimal(20,0) NOT NULL,
  `NTT_ID` decimal(20,0) NOT NULL,
  `BBS_ID` char(20) NOT NULL,
  `WRTER_ID` varchar(20) DEFAULT NULL,
  `WRTER_NM` varchar(20) DEFAULT NULL,
  `PASSWORD` varchar(2000) DEFAULT NULL,
  `COMMENT_CN` varchar(200) NOT NULL,
  `USE_AT` char(1) NOT NULL,
  `FRST_REGISTER_PNTTM` datetime NOT NULL,
  `LAST_UPDUSR_PNTTM` datetime DEFAULT NULL,
  `FRST_REGISTER_ID` varchar(20) NOT NULL,
  `LAST_UPDUSR_ID` varchar(20) DEFAULT NULL,
  PRIMARY KEY (`COMMENT_NO`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

CREATE TABLE `COMTNDTAUSESTATS` (
  `DTA_USE_STATS_ID` char(20) NOT NULL COMMENT '자료이용현황 생성시 기본키',
  `BBS_ID` varchar(20) NOT NULL COMMENT '게시판 ID',
  `NTT_ID` decimal(8,0) NOT NULL COMMENT '게시글 ID',
  `ATCH_FILE_ID` varchar(20) NOT NULL COMMENT '첨부파일ID',
  `FILE_SN` varchar(10) NOT NULL COMMENT '파일연번',
  `FRST_REGISTER_ID` varchar(20) DEFAULT NULL COMMENT '최초등록자ID',
  `FRST_REGISTER_PNTTM` datetime DEFAULT NULL COMMENT '최초등록시점',
  `LAST_UPDUSR_ID` varchar(20) DEFAULT NULL COMMENT '최종수정자ID',
  `LAST_UPDUSR_PNTTM` datetime DEFAULT NULL COMMENT '최종수정시점',
  PRIMARY KEY (`DTA_USE_STATS_ID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='각종 게시판의 자료이용현황에 대한 통계자료를 특정 조건에 맞게 제공하기 위한 속성을 정의한다.';

CREATE TABLE `COMTNINDVDLINFOPOLICY` (
  `INDVDL_INFO_ID` char(20) NOT NULL,
  `INDVDL_INFO_NM` varchar(255) NOT NULL,
  `INDVDL_INFO_DC` varchar(2500) DEFAULT NULL,
  `INDVDL_INFO_YN` char(1) DEFAULT NULL,
  `FRST_REGISTER_ID` varchar(20) DEFAULT NULL,
  `FRST_REGISTER_PNTTM` datetime DEFAULT NULL,
  `LAST_UPDUSR_ID` varchar(20) DEFAULT NULL,
  `LAST_UPDUSR_PNTTM` datetime DEFAULT NULL,
  PRIMARY KEY (`INDVDL_INFO_ID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='개인정보정책확인 정보를 조회하는 기능을 제공하기 위한 속성을 관리한다.';

CREATE TABLE `COMTNINSTTCODE` (
  `INSTT_CODE` char(7) NOT NULL,
  `ALL_INSTT_NM` varchar(255) DEFAULT NULL,
  `LOWEST_INSTT_NM` varchar(100) DEFAULT NULL,
  `INSTT_ABRV_NM` varchar(60) DEFAULT NULL,
  `ODR` char(1) DEFAULT NULL,
  `ORD` char(3) DEFAULT NULL,
  `INSTT_ODR` char(2) DEFAULT NULL,
  `UPPER_INSTT_CODE` char(7) DEFAULT NULL,
  `BEST_INSTT_CODE` char(7) DEFAULT NULL,
  `REPRSNT_INSTT_CODE` char(7) DEFAULT NULL,
  `INSTT_TY_LCLAS` char(2) DEFAULT NULL,
  `INSTT_TY_MCLAS` char(2) DEFAULT NULL,
  `INSTT_TY_SCLAS` char(2) DEFAULT NULL,
  `TELNO` varchar(20) DEFAULT NULL,
  `FXNUM` varchar(20) DEFAULT NULL,
  `CREAT_DE` char(8) DEFAULT NULL,
  `ABL_DE` char(8) DEFAULT NULL,
  `ABL_ENNC` char(1) DEFAULT NULL,
  `CHANGEDE` char(8) DEFAULT NULL,
  `CHANGE_TIME` varchar(6) DEFAULT NULL,
  `BSIS_DE` char(8) DEFAULT NULL,
  `SORT_ORDR` decimal(8,0) DEFAULT NULL,
  `FRST_REGISTER_ID` varchar(20) DEFAULT NULL,
  `FRST_REGISTER_PNTTM` datetime DEFAULT NULL,
  `LAST_UPDUSR_ID` varchar(20) DEFAULT NULL,
  `LAST_UPDUSR_PNTTM` datetime DEFAULT NULL,
  PRIMARY KEY (`INSTT_CODE`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='기관코드에 대한 정보';

CREATE TABLE `COMTNINSTTCODERECPTNLOG` (
  `OCCRR_DE` char(8) NOT NULL,
  `INSTT_CODE` char(7) NOT NULL,
  `OPERT_SN` int(11) NOT NULL,
  `CHANGE_SE_CODE` varchar(2) DEFAULT NULL,
  `PROCESS_SE` varchar(2) DEFAULT NULL,
  `ETC_CODE` char(2) DEFAULT NULL,
  `ALL_INSTT_NM` varchar(255) DEFAULT NULL,
  `LOWEST_INSTT_NM` varchar(100) DEFAULT NULL,
  `INSTT_ABRV_NM` varchar(60) DEFAULT NULL,
  `ODR` char(1) DEFAULT NULL,
  `ORD` char(3) DEFAULT NULL,
  `INSTT_ODR` char(2) DEFAULT NULL,
  `UPPER_INSTT_CODE` char(7) DEFAULT NULL,
  `BEST_INSTT_CODE` char(7) DEFAULT NULL,
  `REPRSNT_INSTT_CODE` char(7) DEFAULT NULL,
  `INSTT_TY_LCLAS` char(2) DEFAULT NULL,
  `INSTT_TY_MCLAS` char(2) DEFAULT NULL,
  `INSTT_TY_SCLAS` char(2) DEFAULT NULL,
  `TELNO` varchar(20) DEFAULT NULL,
  `FXNUM` varchar(20) DEFAULT NULL,
  `CREAT_DE` char(8) DEFAULT NULL,
  `ABL_DE` char(8) DEFAULT NULL,
  `ABL_ENNC` char(1) DEFAULT NULL,
  `CHANGEDE` char(8) DEFAULT NULL,
  `CHANGE_TIME` varchar(6) DEFAULT NULL,
  `BSIS_DE` char(8) DEFAULT NULL,
  `SORT_ORDR` decimal(8,0) DEFAULT NULL,
  `FRST_REGISTER_ID` varchar(20) DEFAULT NULL,
  `FRST_REGISTER_PNTTM` datetime DEFAULT NULL,
  `LAST_UPDUSR_ID` varchar(20) DEFAULT NULL,
  `LAST_UPDUSR_PNTTM` datetime DEFAULT NULL,
  PRIMARY KEY (`OCCRR_DE`,`INSTT_CODE`,`OPERT_SN`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='기관코드수신로그에 대한 정보';

CREATE TABLE `COMTNINTNETSVC` (
  `INTNET_SVC_ID` char(20) NOT NULL COMMENT '등록시 부여되는 일련번호',
  `INTNET_SVC_NM` varchar(20) NOT NULL COMMENT '인터넷서비스정보에 부여된 명칭',
  `INTNET_SVC_DC` text COMMENT '인터넷서비스정보의 부연 설명',
  `REFLCT_AT` char(1) NOT NULL COMMENT '인터넷 서비스 메뉴에 적용 여부',
  `FRST_REGISTER_ID` varchar(20) DEFAULT NULL,
  `FRST_REGISTER_PNTTM` datetime DEFAULT NULL,
  `LAST_UPDUSR_ID` varchar(20) DEFAULT NULL,
  `LAST_UPDUSR_PNTTM` datetime DEFAULT NULL,
  PRIMARY KEY (`INTNET_SVC_ID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='인터넷으로 서비스하는 정보를 등록 관리하여 해당 서비스 안내 정보가 웹페이지에 보여지게 하는 기능을 제공하기';

CREATE TABLE `COMTNLOGINPOLICY` (
  `EMPLYR_ID` varchar(20) NOT NULL COMMENT '사용자ID',
  `IP_INFO` varchar(23) NOT NULL COMMENT '사용자 접속ID 정보',
  `DPLCT_PERM_AT` char(1) NOT NULL COMMENT '중복 허용 여부',
  `LMTT_AT` char(1) NOT NULL COMMENT '제한 여부',
  `FRST_REGISTER_ID` varchar(20) DEFAULT NULL,
  `FRST_REGISTER_PNTTM` datetime DEFAULT NULL,
  `LAST_UPDUSR_ID` varchar(20) DEFAULT NULL,
  `LAST_UPDUSR_PNTTM` datetime DEFAULT NULL,
  PRIMARY KEY (`EMPLYR_ID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='사용자 로그인 정책에 맞게 로그인을 제한하는 기능을 제공한다.(특정 IP에 대한 로그인 제한, 중복로그인 방';

CREATE TABLE `COMTNLOGINSCRINIMAGE` (
  `IMAGE_ID` char(20) NOT NULL COMMENT '등록시 부여되는 일련번호',
  `IMAGE_NM` varchar(20) NOT NULL COMMENT '로그인화면 이미지에 부여된 명칭',
  `IMAGE` varchar(60) NOT NULL COMMENT '로그인화면 이미지 이미지 파일',
  `IMAGE_FILE` varchar(60) DEFAULT NULL COMMENT '로그인화면 업로드 이미지 파일',
  `IMAGE_DC` varchar(200) DEFAULT NULL COMMENT '로그인화면 이미지에 대한 간략한 설명 등록',
  `REFLCT_AT` char(1) NOT NULL COMMENT '로그인화면에 등록 여부',
  `FRST_REGISTER_ID` varchar(20) DEFAULT NULL,
  `FRST_REGISTER_PNTTM` datetime DEFAULT NULL,
  `LAST_UPDUSR_ID` varchar(20) DEFAULT NULL,
  `LAST_UPDUSR_PNTTM` datetime DEFAULT NULL,
  PRIMARY KEY (`IMAGE_ID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='로그인화면에 대한 이미지를 등록하고 등록한 이미지가 로그인 화면에 출력되는 기능을 제공하기 위한 속성정보를 ';

CREATE TABLE `COMTNMAINIMAGE` (
  `IMAGE_ID` char(20) NOT NULL COMMENT '등록시 부여되는 일련번호',
  `IMAGE_NM` varchar(20) NOT NULL COMMENT '메인화면 이미지에 부여된 명칭',
  `IMAGE` varchar(60) NOT NULL COMMENT '메인화면 이미지 이미지 파일',
  `IMAGE_FILE` varchar(60) DEFAULT NULL COMMENT '메인화면 업로드 이미지 파일',
  `IMAGE_DC` varchar(200) DEFAULT NULL COMMENT '메인화면 이미지에 대한 간략한 설명 등록',
  `REFLCT_AT` char(1) NOT NULL COMMENT '메인화면에 등록 여부',
  `FRST_REGISTER_ID` varchar(20) DEFAULT NULL,
  `FRST_REGISTER_PNTTM` datetime DEFAULT NULL,
  `LAST_UPDUSR_ID` varchar(20) DEFAULT NULL,
  `LAST_UPDUSR_PNTTM` datetime DEFAULT NULL,
  PRIMARY KEY (`IMAGE_ID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='메인화면에 보여지는 이미지를 등록하여 메인화면에 출력하는 기능을 제공하기 위한 속성을 관리한다.';

CREATE TABLE `COMTNNTFCINFO` (
  `NTFC_NO` decimal(20,0) NOT NULL,
  `NTFC_SJ` varchar(60) NOT NULL,
  `NTFC_CN` varchar(100) NOT NULL,
  `NTFC_TIME` char(14) NOT NULL,
  `BH_NTFC_INTRVL` varchar(20) NOT NULL,
  `FRST_REGISTER_PNTTM` date NOT NULL,
  `LAST_UPDUSR_PNTTM` date DEFAULT NULL,
  `FRST_REGISTER_ID` varchar(20) NOT NULL,
  `LAST_UPDUSR_ID` varchar(20) DEFAULT NULL,
  PRIMARY KEY (`NTFC_NO`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

CREATE TABLE `COMTNONLINEMANUAL` (
  `ONLINE_MNL_ID` char(20) NOT NULL,
  `ONLINE_MNL_NM` varchar(255) NOT NULL,
  `ONLINE_MNL_SE_CODE` char(3) DEFAULT NULL,
  `ONLINE_MNL_DF` text,
  `ONLINE_MNL_DC` text,
  `FRST_REGISTER_ID` varchar(20) DEFAULT NULL,
  `FRST_REGISTER_PNTTM` datetime DEFAULT NULL,
  `LAST_UPDUSR_ID` varchar(20) DEFAULT NULL,
  `LAST_UPDUSR_PNTTM` datetime DEFAULT NULL,
  PRIMARY KEY (`ONLINE_MNL_ID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

CREATE TABLE `COMTNONLINEPOLLMANAGE` (
  `POLL_ID` char(20) NOT NULL,
  `POLL_NM` varchar(255) NOT NULL,
  `POLL_BEGIN_DE` date NOT NULL,
  `POLL_END_DE` date NOT NULL,
  `POLL_KIND_CODE` char(3) DEFAULT NULL,
  `POLL_DSUSE_YN` char(1) DEFAULT NULL,
  `POLL_AUTO_DSUSE_YN` char(1) DEFAULT NULL,
  `FRST_REGISTER_ID` varchar(20) DEFAULT NULL,
  `FRST_REGISTER_PNTTM` datetime DEFAULT NULL,
  `LAST_UPDUSR_ID` varchar(20) DEFAULT NULL,
  `LAST_UPDUSR_PNTTM` datetime DEFAULT NULL,
  PRIMARY KEY (`POLL_ID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='온라인POLL관리 정보를 조회하는 기능을 제공하기 위한 속성을 관리한다.';

CREATE TABLE `COMTNONLINEPOLLITEM` (
  `POLL_ID` char(20) NOT NULL,
  `POLL_IEM_ID` char(20) NOT NULL,
  `POLL_IEM_NM` varchar(255) NOT NULL,
  `FRST_REGISTER_ID` varchar(20) DEFAULT NULL,
  `FRST_REGISTER_PNTTM` datetime DEFAULT NULL,
  `LAST_UPDUSR_ID` varchar(20) DEFAULT NULL,
  `LAST_UPDUSR_PNTTM` datetime DEFAULT NULL,
  PRIMARY KEY (`POLL_ID`,`POLL_IEM_ID`),
  CONSTRAINT `FK_COMTNONLINEPOLLMANAGE_ITEM` FOREIGN KEY (`POLL_ID`) REFERENCES `COMTNONLINEPOLLMANAGE` (`POLL_ID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='온라인POLL항목 정보를 조회하는 기능을 제공하기 위한 속성을 관리한다.';

CREATE TABLE `COMTNONLINEPOLLRESULT` (
  `POLL_ID` char(20) NOT NULL,
  `POLL_IEM_ID` char(20) NOT NULL,
  `POLL_RESULT_ID` char(20) NOT NULL,
  `FRST_REGISTER_ID` varchar(20) DEFAULT NULL,
  `FRST_REGISTER_PNTTM` datetime DEFAULT NULL,
  `LAST_UPDUSR_ID` varchar(20) DEFAULT NULL,
  `LAST_UPDUSR_PNTTM` datetime DEFAULT NULL,
  PRIMARY KEY (`POLL_ID`,`POLL_IEM_ID`,`POLL_RESULT_ID`),
  CONSTRAINT `FK_COMTNONLINEPOLLITEM_RESULT` FOREIGN KEY (`POLL_ID`, `POLL_IEM_ID`) REFERENCES `COMTNONLINEPOLLITEM` (`POLL_ID`, `POLL_IEM_ID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='온라인POLL결과 정보를 조회하는 기능을 제공하기 위한 속성을 관리한다.';

CREATE TABLE `COMTNPOPUPMANAGE` (
  `POPUP_ID` varchar(20) NOT NULL,
  `POPUP_TITLE_NM` varchar(1024) DEFAULT NULL,
  `FILE_URL` varchar(1024) DEFAULT NULL,
  `POPUP_HLC` varchar(10) DEFAULT NULL,
  `POPUP_WLC` varchar(10) DEFAULT NULL,
  `POPUP_HSIZE` varchar(10) DEFAULT NULL,
  `POPUP_WSIZE` varchar(10) DEFAULT NULL,
  `NTCE_BGNDE` varchar(12) DEFAULT NULL,
  `NTCE_ENDDE` varchar(12) DEFAULT NULL,
  `STOP_VEW_AT` char(1) DEFAULT NULL,
  `NTCE_AT` char(1) DEFAULT NULL,
  `FRST_REGISTER_PNTTM` datetime DEFAULT NULL,
  `FRST_REGISTER_ID` char(20) DEFAULT NULL,
  `LAST_UPDUSR_PNTTM` datetime DEFAULT NULL,
  `LAST_UPDUSR_ID` char(20) DEFAULT NULL,
  PRIMARY KEY (`POPUP_ID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='사이트의 초기화면에 나타날 팝업창을 관리자가 관리하는 기능을 제공한다.';

CREATE TABLE `COMTNRECENTSRCHWRDMANAGE` (
  `SRCHWRD_MANAGE_ID` char(20) NOT NULL,
  `SRCHWRD_MANAGE_NM` varchar(255) NOT NULL,
  `SRCHWRD_MANAGE_URL` varchar(255) NOT NULL,
  `SRCHWRD_MANAGE_USE_YN` char(1) NOT NULL,
  `FRST_REGISTER_ID` varchar(20) DEFAULT NULL,
  `FRST_REGISTER_PNTTM` datetime DEFAULT NULL,
  `LAST_UPDUSR_ID` varchar(20) DEFAULT NULL,
  `LAST_UPDUSR_PNTTM` datetime DEFAULT NULL,
  PRIMARY KEY (`SRCHWRD_MANAGE_ID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='최근검색어관리  정보를 조회하는 기능을 제공하기 위한 속성을 관리한다.';

CREATE TABLE `COMTNRECENTSRCHWRD` (
  `SRCHWRD_MANAGE_ID` char(20) NOT NULL,
  `SRCHWRD_ID` char(20) NOT NULL,
  `SRCHWRD_NM` char(255) NOT NULL,
  `FRST_REGISTER_ID` varchar(20) DEFAULT NULL,
  `FRST_REGISTER_PNTTM` datetime DEFAULT NULL,
  `LAST_UPDUSR_ID` varchar(20) DEFAULT NULL,
  `LAST_UPDUSR_PNTTM` datetime DEFAULT NULL,
  PRIMARY KEY (`SRCHWRD_MANAGE_ID`,`SRCHWRD_ID`),
  CONSTRAINT `FK_COMTNRECENTSRCHWRDMANAGE_COMTNRECENTSRCHWRD` FOREIGN KEY (`SRCHWRD_MANAGE_ID`) REFERENCES `COMTNRECENTSRCHWRDMANAGE` (`SRCHWRD_MANAGE_ID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='최근검색어  정보를 조회하는 기능을 제공하기 위한 속성을 관리한다.';

CREATE TABLE `COMTNREPRTSTATS` (
  `REPRT_ID` char(6) NOT NULL COMMENT '보고서에 부여되는 일련번호',
  `REPRT_NM` varchar(20) NOT NULL COMMENT '보고서에 부여된 명칭',
  `REPRT_TY` char(5) NOT NULL COMMENT '보고서의 종류를 정의한 속성정보',
  `REPRT_STTUS` char(5) NOT NULL COMMENT '보고서의 현황을 정의한 속성정보',
  `FRST_REGISTER_ID` varchar(20) NOT NULL COMMENT '보고서가 생성된 일시',
  `FRST_REGISTER_PNTTM` datetime DEFAULT NULL,
  `LAST_UPDUSR_ID` varchar(20) DEFAULT NULL,
  `LAST_UPDUSR_PNTTM` datetime DEFAULT NULL,
  PRIMARY KEY (`REPRT_ID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='각종 보고서현황에 대한 통계자료를 특정 조건에 맞게 제공하기 위한 속성을 정의한다.';

CREATE TABLE `COMTNSCRAP` (
  `SCRAP_ID` char(20) NOT NULL,
  `NTT_ID` decimal(20,0) NOT NULL,
  `BBS_ID` char(20) NOT NULL,
  `SCRAP_NM` varchar(100) NOT NULL,
  `USE_AT` char(1) NOT NULL,
  `FRST_REGISTER_PNTTM` datetime NOT NULL,
  `LAST_UPDUSR_PNTTM` datetime DEFAULT NULL,
  `FRST_REGISTER_ID` varchar(20) NOT NULL,
  `LAST_UPDUSR_ID` varchar(20) DEFAULT NULL,
  PRIMARY KEY (`SCRAP_ID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

CREATE TABLE `COMTNSMS` (
  `SMS_ID` char(20) NOT NULL,
  `TRNSMIT_TELNO` varchar(12) NOT NULL,
  `TRNSMIT_CN` varchar(100) NOT NULL,
  `FRST_REGISTER_PNTTM` datetime NOT NULL,
  `FRST_REGISTER_ID` varchar(20) NOT NULL,
  PRIMARY KEY (`SMS_ID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

CREATE TABLE `COMTNSMSRECPTN` (
  `SMS_ID` char(20) NOT NULL,
  `RECPTN_TELNO` varchar(12) NOT NULL,
  `RESULT_CODE` varchar(4) DEFAULT NULL,
  `RESULT_MSSAGE` varchar(4000) DEFAULT NULL,
  PRIMARY KEY (`SMS_ID`,`RECPTN_TELNO`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

CREATE TABLE `COMTNSTSFDG` (
  `STSFDG_NO` decimal(20,0) NOT NULL,
  `NTT_ID` decimal(20,0) NOT NULL,
  `BBS_ID` char(20) NOT NULL,
  `WRTER_ID` varchar(20) DEFAULT NULL,
  `WRTER_NM` varchar(20) DEFAULT NULL,
  `PASSWORD` varchar(2000) DEFAULT NULL,
  `STSFDG` decimal(1,0) NOT NULL,
  `STSFDG_CN` varchar(200) DEFAULT NULL,
  `USE_AT` char(1) NOT NULL,
  `FRST_REGISTER_PNTTM` datetime NOT NULL,
  `LAST_UPDUSR_PNTTM` datetime DEFAULT NULL,
  `FRST_REGISTER_ID` varchar(20) NOT NULL,
  `LAST_UPDUSR_ID` varchar(20) DEFAULT NULL,
  PRIMARY KEY (`STSFDG_NO`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

CREATE TABLE `COMTNSYSTEMCNTC` (
  `CNTC_ID` char(8) NOT NULL,
  `CNTC_NM` varchar(100) DEFAULT NULL,
  `CNTC_TYPE` varchar(60) DEFAULT NULL,
  `PROVD_INSTT_ID` char(8) DEFAULT NULL,
  `PROVD_SYS_ID` char(8) DEFAULT NULL,
  `PROVD_SVC_ID` char(8) DEFAULT NULL,
  `REQUST_INSTT_ID` char(8) DEFAULT NULL,
  `REQUST_SYS_ID` char(8) DEFAULT NULL,
  `CONFM_AT` char(1) DEFAULT NULL,
  `USE_AT` char(1) DEFAULT NULL,
  `VALID_BEGIN_DE` char(8) DEFAULT NULL,
  `VALID_END_DE` char(8) DEFAULT NULL,
  `FRST_REGISTER_ID` varchar(20) DEFAULT NULL,
  `FRST_REGISTER_PNTTM` datetime DEFAULT NULL,
  `LAST_UPDUSR_ID` varchar(20) DEFAULT NULL,
  `LAST_UPDUSR_PNTTM` datetime DEFAULT NULL,
  PRIMARY KEY (`CNTC_ID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='시스템연계에 대한 정보';

CREATE TABLE `COMTNUNITYLINK` (
  `UNITY_LINK_ID` char(20) NOT NULL,
  `UNITY_LINK_SE_CODE` char(3) DEFAULT NULL,
  `UNITY_LINK_NM` varchar(255) DEFAULT NULL,
  `UNITY_LINK_URL` varchar(255) DEFAULT NULL,
  `UNITY_LINK_DC` varchar(2500) DEFAULT NULL,
  `FRST_REGISTER_ID` varchar(20) DEFAULT NULL,
  `FRST_REGISTER_PNTTM` datetime DEFAULT NULL,
  `LAST_UPDUSR_ID` varchar(20) DEFAULT NULL,
  `LAST_UPDUSR_PNTTM` datetime DEFAULT NULL,
  PRIMARY KEY (`UNITY_LINK_ID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='통합링크 정보를 조회하는 기능을 제공하기 위한 속성을 관리한다.';

CREATE TABLE `COMTNUSERABSNCE` (
  `EMPLYR_ID` varchar(20) NOT NULL COMMENT '사용자 부재정보를 관리하기 위한 기본ID',
  `USER_ABSNCE_AT` char(1) NOT NULL COMMENT '사용자 부재여부를 관리하기 위한 속성',
  `FRST_REGISTER_ID` varchar(20) DEFAULT NULL COMMENT '해당 사용자의 부재정보를 등록한 일시',
  `FRST_REGISTER_PNTTM` datetime DEFAULT NULL,
  `LAST_UPDUSR_ID` varchar(20) DEFAULT NULL,
  `LAST_UPDUSR_PNTTM` datetime DEFAULT NULL,
  PRIMARY KEY (`EMPLYR_ID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='사용자 부재여부를 등록하여 해당 사용자가 부재중인지 여부를 조회하는 기능을 제공하기 위한 속성을 관리한다.';

CREATE TABLE `COMTNBANNER` (
  `BANNER_ID` char(20) NOT NULL,
  `BANNER_NM` varchar(20) NOT NULL,
  `LINK_URL` varchar(255) NOT NULL,
  `BANNER_IMAGE` varchar(60) NOT NULL,
  `BANNER_IMAGE_FILE` varchar(60) DEFAULT NULL,
  `BANNER_DC` varchar(200) DEFAULT NULL,
  `SORT_ORDR` int(8) NOT NULL,
  `REFLCT_AT` char(1) NOT NULL,
  `FRST_REGISTER_ID` varchar(20) DEFAULT NULL,
  `FRST_REGISTER_PNTTM` datetime DEFAULT NULL,
  `LAST_UPDUSR_ID` varchar(20) DEFAULT NULL,
  `LAST_UPDUSR_PNTTM` datetime DEFAULT NULL,
  PRIMARY KEY (`BANNER_ID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;


