CREATE TABLE `COMTNDEPTJOB` (
  `DEPT_JOB_ID` char(20) NOT NULL,
  `DEPT_JOBBX_ID` char(6) NOT NULL,
  `DEPT_JOB_NM` varchar(255) NOT NULL,
  `DEPT_JOB_CN` varchar(2500) NOT NULL,
  `ATCH_FILE_ID` char(20) DEFAULT NULL,
  `CHARGER_ID` varchar(20) NOT NULL,
  `PRIORT` char(1) NOT NULL,
  `FRST_REGISTER_ID` varchar(20) NOT NULL,
  `FRST_REGISTER_PNTTM` date NOT NULL,
  `LAST_UPDUSR_ID` varchar(20) DEFAULT NULL,
  `LAST_UPDUSR_PNTTM` date DEFAULT NULL,
  PRIMARY KEY (`DEPT_JOB_ID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

CREATE TABLE `COMTNLEADERSCHDUL` (
  `SCHDUL_ID` char(20) NOT NULL,
  `SCHDUL_SE` char(1) DEFAULT NULL,
  `SCHDUL_NM` varchar(255) NOT NULL,
  `SCHDUL_CN` varchar(2500) NOT NULL,
  `SCHDUL_PLACE` varchar(255) DEFAULT NULL,
  `LEADER_ID` varchar(20) NOT NULL,
  `REPTIT_SE_CODE` char(1) DEFAULT NULL,
  `SCHDUL_BGNDE` char(12) NOT NULL,
  `SCHDUL_ENDDE` char(12) NOT NULL,
  `SCHDUL_CHARGER_ID` varchar(20) NOT NULL,
  `FRST_REGISTER_ID` varchar(20) NOT NULL,
  `FRST_REGISTER_PNTTM` date NOT NULL,
  `LAST_UPDUSR_ID` varchar(20) DEFAULT NULL,
  `LAST_UPDUSR_PNTTM` date DEFAULT NULL,
  PRIMARY KEY (`SCHDUL_ID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

CREATE TABLE `COMTNDEPTJOBBX` (
  `DEPT_JOBBX_ID` char(6) NOT NULL,
  `DEPT_JOBBX_NM` varchar(255) NOT NULL,
  `DEPT_ID` varchar(20) NOT NULL,
  `INDICT_ORDR` decimal(6,0) DEFAULT NULL,
  `FRST_REGISTER_ID` varchar(20) NOT NULL,
  `FRST_REGISTER_PNTTM` date NOT NULL,
  `LAST_UPDUSR_ID` varchar(20) DEFAULT NULL,
  `LAST_UPDUSR_PNTTM` date DEFAULT NULL,
  PRIMARY KEY (`DEPT_JOBBX_ID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

CREATE TABLE `COMTNLEADERSCHDULDE` (
  `SCHDUL_ID` char(20) NOT NULL,
  `SCHDUL_DE` char(8) NOT NULL,
  PRIMARY KEY (`SCHDUL_ID`,`SCHDUL_DE`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

CREATE TABLE `COMTNMEMOREPRT` (
  `REPRT_ID` char(6) NOT NULL,
  `REPRT_SJ` varchar(255) NOT NULL,
  `REPRT_DE` char(8) NOT NULL,
  `WRTER_ID` varchar(20) NOT NULL,
  `REPORTR_ID` varchar(20) NOT NULL,
  `REPRT_CN` varchar(2500) NOT NULL,
  `ATCH_FILE_ID` char(20) DEFAULT NULL,
  `DRCT_MATTER` varchar(2500) DEFAULT NULL,
  `DRCT_MATTER_REGIST_DT` varchar(14) DEFAULT NULL,
  `REPORTR_INQIRE_DT` varchar(14) DEFAULT NULL,
  `FRST_REGISTER_ID` varchar(20) NOT NULL,
  `FRST_REGISTER_PNTTM` datetime NOT NULL,
  `LAST_UPDUSR_ID` varchar(20) DEFAULT NULL,
  `LAST_UPDUSR_PNTTM` datetime DEFAULT NULL,
  PRIMARY KEY (`REPRT_ID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

CREATE TABLE `COMTNMEMOTODO` (
  `TODO_ID` char(20) NOT NULL,
  `TODO_NM` varchar(255) NOT NULL,
  `TODO_BEGIN_TIME` varchar(14) NOT NULL,
  `TODO_END_TIME` varchar(14) NOT NULL,
  `WRTER_ID` varchar(20) NOT NULL,
  `TODO_CN` varchar(2500) NOT NULL,
  `FRST_REGISTER_ID` varchar(20) NOT NULL,
  `FRST_REGISTER_PNTTM` date NOT NULL,
  `LAST_UPDUSR_ID` varchar(20) DEFAULT NULL,
  `LAST_UPDUSR_PNTTM` date DEFAULT NULL,
  PRIMARY KEY (`TODO_ID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

CREATE TABLE `COMTNWIKMNTHNGREPRT` (
  `REPRT_ID` char(6) NOT NULL,
  `REPRT_SE` char(1) NOT NULL,
  `REPRT_SJ` varchar(255) NOT NULL,
  `REPRT_DE` char(8) NOT NULL,
  `WRTER_ID` varchar(20) NOT NULL,
  `REPORTR_ID` varchar(20) NOT NULL,
  `REPRT_BGNDE` char(8) NOT NULL,
  `REPRT_ENDDE` char(8) NOT NULL,
  `REPRT_THSWIK_CN` text NOT NULL,
  `REPRT_LESSEE_CN` text NOT NULL,
  `PARTCLR_MATTER` varchar(2500) DEFAULT NULL,
  `ATCH_FILE_ID` char(20) DEFAULT NULL,
  `CONFM_DT` varchar(14) DEFAULT NULL,
  `FRST_REGISTER_ID` varchar(20) NOT NULL,
  `FRST_REGISTER_PNTTM` datetime NOT NULL,
  `LAST_UPDUSR_ID` varchar(20) DEFAULT NULL,
  `LAST_UPDUSR_PNTTM` datetime DEFAULT NULL,
  PRIMARY KEY (`REPRT_ID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

CREATE TABLE `COMTHDBMNTRNGLOGINFO` (
  `LOG_ID` char(20) NOT NULL,
  `DATA_SOURC_NM` varchar(60) NOT NULL,
  `SERVER_NM` varchar(60) DEFAULT NULL,
  `DBMS_KIND` varchar(2) DEFAULT NULL,
  `CECK_SQL` varchar(250) DEFAULT NULL,
  `MNGR_NM` varchar(60) DEFAULT NULL,
  `MNGR_EMAIL_ADDR` varchar(50) DEFAULT NULL,
  `MNTRNG_STTUS` char(2) DEFAULT NULL,
  `LOG_INFO` varchar(2000) DEFAULT NULL,
  `CREAT_DT` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `FRST_REGISTER_ID` varchar(20) DEFAULT NULL,
  `FRST_REGISTER_PNTTM` timestamp NOT NULL DEFAULT '0000-00-00 00:00:00',
  `LAST_UPDUSR_PNTTM` timestamp NOT NULL DEFAULT '0000-00-00 00:00:00',
  `LAST_UPDUSR_ID` varchar(20) DEFAULT NULL,
  PRIMARY KEY (`LOG_ID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

CREATE TABLE `COMTHTRSMRCVMNTRNGLOGINFO` (
  `LOG_ID` char(20) NOT NULL,
  `CNTC_ID` char(8) NOT NULL,
  `TEST_CLASS_NM` varchar(255) DEFAULT NULL,
  `MNGR_NM` varchar(60) DEFAULT NULL,
  `MNGR_EMAIL_ADDR` varchar(50) DEFAULT NULL,
  `MNTRNG_STTUS` char(2) DEFAULT NULL,
  `LOG_INFO` varchar(2000) DEFAULT NULL,
  `CREAT_DT` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `FRST_REGISTER_ID` varchar(20) DEFAULT NULL,
  `FRST_REGISTER_PNTTM` timestamp NOT NULL DEFAULT '0000-00-00 00:00:00',
  `LAST_UPDUSR_ID` varchar(20) DEFAULT NULL,
  `LAST_UPDUSR_PNTTM` timestamp NOT NULL DEFAULT '0000-00-00 00:00:00',
  PRIMARY KEY (`LOG_ID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

CREATE TABLE `COMTNSERVERRESRCELOGINFO` (
  `SERVER_ID` char(20) NOT NULL,
  `SERVER_EQPMN_ID` varchar(20) NOT NULL,
  `LOG_ID` char(20) NOT NULL,
  `CPU_USE_RT` decimal(5,2) DEFAULT NULL,
  `MORY_USE_RT` decimal(5,2) DEFAULT NULL,
  `SVC_STTUS` char(2) DEFAULT NULL,
  `LOG_INFO` varchar(2000) DEFAULT NULL,
  `CREAT_DT` datetime DEFAULT NULL,
  `FRST_REGISTER_ID` varchar(20) DEFAULT NULL,
  `FRST_REGISTER_PNTTM` datetime DEFAULT NULL,
  `LAST_UPDUSR_ID` varchar(20) DEFAULT NULL,
  `LAST_UPDUSR_PNTTM` datetime DEFAULT NULL,
  PRIMARY KEY (`SERVER_ID`,`SERVER_EQPMN_ID`,`LOG_ID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

CREATE TABLE `COMTNFILESYSMNTRNGLOGINFO` (
  `FILE_SYS_ID` char(20) NOT NULL,
  `LOG_ID` char(20) NOT NULL,
  `FILE_SYS_NM` varchar(60) NOT NULL,
  `FILE_SYS_MANAGE_NM` varchar(255) NOT NULL,
  `FILE_SYS_MG` decimal(8,0) NOT NULL,
  `FILE_SYS_THRHLD` decimal(8,0) NOT NULL,
  `FILE_SYS_USGQTY` decimal(8,0) DEFAULT NULL,
  `MNTRNG_STTUS` char(2) DEFAULT NULL,
  `LOG_INFO` varchar(2000) DEFAULT NULL,
  `CREAT_DT` datetime DEFAULT NULL,
  `FRST_REGISTER_ID` varchar(20) DEFAULT NULL,
  `FRST_REGISTER_PNTTM` datetime DEFAULT NULL,
  `LAST_UPDUSR_ID` varchar(20) DEFAULT NULL,
  `LAST_UPDUSR_PNTTM` datetime DEFAULT NULL,
  PRIMARY KEY (`FILE_SYS_ID`,`LOG_ID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

CREATE TABLE `COMTNPROXYINFO` (
  `PROXY_ID` char(20) NOT NULL,
  `PROXY_NM` varchar(60) DEFAULT NULL,
  `PROXY_IP` varchar(23) DEFAULT NULL,
  `PROXY_PORT` varchar(10) DEFAULT NULL,
  `TRGET_SVC_NM` varchar(255) DEFAULT NULL,
  `SVC_DC` varchar(2000) DEFAULT NULL,
  `SVC_IP` varchar(23) DEFAULT NULL,
  `SVC_PORT` varchar(10) DEFAULT NULL,
  `SVC_STTUS` char(2) DEFAULT NULL,
  `FRST_REGISTER_ID` varchar(20) DEFAULT NULL,
  `FRST_REGISTER_PNTTM` datetime DEFAULT NULL,
  `LAST_UPDUSR_ID` varchar(20) DEFAULT NULL,
  `LAST_UPDUSR_PNTTM` datetime DEFAULT NULL,
  PRIMARY KEY (`PROXY_ID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

CREATE TABLE `COMTNPROXYLOGINFO` (
  `PROXY_ID` char(20) NOT NULL,
  `LOG_ID` varchar(20) NOT NULL,
  `CLNT_IP` varchar(23) DEFAULT NULL,
  `CLNT_PORT` varchar(10) DEFAULT NULL,
  `CONECT_TIME` datetime DEFAULT NULL,
  `FRST_REGISTER_ID` varchar(20) DEFAULT NULL,
  `FRST_REGISTER_PNTTM` datetime DEFAULT NULL,
  `LAST_UPDUSR_ID` varchar(20) DEFAULT NULL,
  `LAST_UPDUSR_PNTTM` datetime DEFAULT NULL,
  PRIMARY KEY (`PROXY_ID`,`LOG_ID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

CREATE TABLE `COMTHHTTPMONLOGINFO` (
  `SYS_ID` varchar(20) NOT NULL,
  `LOG_ID` char(20) NOT NULL,
  `SITE_URL` varchar(100) DEFAULT NULL,
  `WEB_KIND` varchar(20) DEFAULT NULL,
  `HTTP_STTUS_CD` varchar(3) DEFAULT NULL,
  `CREAT_DT` datetime DEFAULT NULL,
  `LOG_INFO` varchar(2000) DEFAULT NULL,
  `MNGR_NM` varchar(60) DEFAULT NULL,
  `MNGR_EMAIL_ADDR` varchar(50) DEFAULT NULL,
  `FRST_REGISTER_ID` varchar(20) DEFAULT NULL,
  `FRST_REGISTER_PNTTM` datetime DEFAULT NULL,
  `LAST_UPDUSR_ID` varchar(20) DEFAULT NULL,
  `LAST_UPDUSR_PNTTM` datetime DEFAULT NULL,
  `WEB_KIND_NM` varchar(20) DEFAULT NULL,
  PRIMARY KEY (`SYS_ID`,`LOG_ID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

CREATE TABLE `COMTNNTWRKSVCMNTRNGLOGINFO` (
  `SYS_IP` varchar(23) NOT NULL,
  `SYS_PORT` decimal(5,0) NOT NULL,
  `LOG_ID` char(20) NOT NULL,
  `SYS_NM` varchar(255) NOT NULL,
  `MNTRNG_STTUS` char(2) DEFAULT NULL,
  `LOG_INFO` varchar(2000) DEFAULT NULL,
  `CREAT_DT` datetime DEFAULT NULL,
  `FRST_REGISTER_ID` varchar(20) DEFAULT NULL,
  `FRST_REGISTER_PNTTM` datetime DEFAULT NULL,
  `LAST_UPDUSR_ID` varchar(20) NOT NULL,
  `LAST_UPDUSR_PNTTM` datetime NOT NULL,
  PRIMARY KEY (`SYS_IP`,`SYS_PORT`,`LOG_ID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

CREATE TABLE `COMTNSYNCHRNSERVERINFO` (
  `SERVER_ID` char(20) NOT NULL,
  `SERVER_NM` varchar(60) DEFAULT NULL,
  `SERVER_IP` varchar(23) DEFAULT NULL,
  `SERVER_PORT` varchar(10) DEFAULT NULL,
  `FTP_ID` varchar(20) DEFAULT NULL,
  `FTP_PASSWORD` varchar(20) DEFAULT NULL,
  `SYNCHRN_LC` varchar(255) DEFAULT NULL,
  `REFLCT_AT` char(20) DEFAULT NULL,
  `FRST_REGISTER_ID` varchar(20) DEFAULT NULL,
  `FRST_REGISTER_PNTTM` datetime DEFAULT NULL,
  `LAST_UPDUSR_ID` varchar(20) DEFAULT NULL,
  `LAST_UPDUSR_PNTTM` datetime DEFAULT NULL,
  PRIMARY KEY (`SERVER_ID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

CREATE TABLE `COMTNTRSMRCVMNTRNG` (
  `CNTC_ID` char(8) NOT NULL,
  `TEST_CLASS_NM` varchar(255) DEFAULT NULL,
  `MNGR_NM` varchar(60) DEFAULT NULL,
  `MNGR_EMAIL_ADDR` varchar(50) DEFAULT NULL,
  `MNTRNG_STTUS` char(2) DEFAULT NULL,
  `CREAT_DT` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `FRST_REGISTER_ID` varchar(20) DEFAULT NULL,
  `FRST_REGISTER_PNTTM` timestamp NOT NULL DEFAULT '0000-00-00 00:00:00',
  `LAST_UPDUSR_ID` varchar(20) DEFAULT NULL,
  `LAST_UPDUSR_PNTTM` timestamp NOT NULL DEFAULT '0000-00-00 00:00:00',
  PRIMARY KEY (`CNTC_ID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

CREATE TABLE `COMTNPROCESSMONLOGINFO` (
  `LOG_ID` char(20) NOT NULL,
  `PROCESS_ID` char(20) NOT NULL,
  `PROCESS_NM` varchar(60) DEFAULT NULL,
  `PROCS_STTUS` varchar(3) DEFAULT NULL,
  `CREAT_DT` datetime DEFAULT NULL,
  `LOG_INFO` varchar(2000) DEFAULT NULL,
  `MNGR_NM` varchar(60) DEFAULT NULL,
  `MNGR_EMAIL_ADDR` varchar(50) DEFAULT NULL,
  `FRST_REGISTER_ID` varchar(20) DEFAULT NULL,
  `FRST_REGISTER_PNTTM` datetime DEFAULT NULL,
  `LAST_UPDUSR_ID` varchar(20) DEFAULT NULL,
  `LAST_UPDUSR_PNTTM` datetime DEFAULT NULL,
  PRIMARY KEY (`PROCESS_ID`,`LOG_ID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

CREATE TABLE `COMTNDBMNTRNG` (
  `DATA_SOURC_NM` varchar(60) NOT NULL,
  `SERVER_NM` varchar(60) DEFAULT NULL,
  `DBMS_KIND` varchar(2) DEFAULT NULL,
  `CECK_SQL` varchar(250) DEFAULT NULL,
  `MNGR_NM` varchar(60) DEFAULT NULL,
  `MNGR_EMAIL_ADDR` varchar(50) DEFAULT NULL,
  `MNTRNG_STTUS` char(2) DEFAULT NULL,
  `CREAT_DT` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `FRST_REGISTER_ID` varchar(20) DEFAULT NULL,
  `FRST_REGISTER_PNTTM` timestamp NOT NULL DEFAULT '0000-00-00 00:00:00',
  `LAST_UPDUSR_ID` varchar(20) DEFAULT NULL,
  `LAST_UPDUSR_PNTTM` timestamp NOT NULL DEFAULT '0000-00-00 00:00:00',
  PRIMARY KEY (`DATA_SOURC_NM`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

CREATE TABLE `COMTNNTWRKSVCMNTRNG` (
  `SYS_IP` varchar(23) NOT NULL,
  `SYS_PORT` decimal(5,0) NOT NULL,
  `SYS_NM` varchar(255) NOT NULL,
  `MNGR_NM` varchar(60) DEFAULT NULL,
  `MNGR_EMAIL_ADDR` varchar(50) DEFAULT NULL,
  `MNTRNG_STTUS` char(2) DEFAULT NULL,
  `CREAT_DT` datetime DEFAULT NULL,
  `FRST_REGISTER_ID` varchar(20) DEFAULT NULL,
  `FRST_REGISTER_PNTTM` datetime DEFAULT NULL,
  `LAST_UPDUSR_ID` varchar(20) NOT NULL,
  `LAST_UPDUSR_PNTTM` datetime NOT NULL,
  PRIMARY KEY (`SYS_IP`,`SYS_PORT`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

CREATE TABLE `COMTNFILESYSMNTRNG` (
  `FILE_SYS_ID` char(20) NOT NULL,
  `FILE_SYS_NM` varchar(60) NOT NULL,
  `FILE_SYS_MANAGE_NM` varchar(255) NOT NULL,
  `FILE_SYS_MG` decimal(8,0) NOT NULL,
  `FILE_SYS_THRHLD` decimal(8,0) NOT NULL,
  `FILE_SYS_USGQTY` decimal(8,0) DEFAULT NULL,
  `MNGR_NM` varchar(60) DEFAULT NULL,
  `MNGR_EMAIL_ADDR` varchar(50) DEFAULT NULL,
  `MNTRNG_STTUS` char(2) DEFAULT NULL,
  `CREAT_DT` datetime DEFAULT NULL,
  `FRST_REGISTER_ID` varchar(20) DEFAULT NULL,
  `FRST_REGISTER_PNTTM` datetime DEFAULT NULL,
  `LAST_UPDUSR_ID` varchar(20) DEFAULT NULL,
  `LAST_UPDUSR_PNTTM` datetime DEFAULT NULL,
  PRIMARY KEY (`FILE_SYS_ID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

CREATE TABLE `COMTNHTTPMON` (
  `SYS_ID` varchar(20) NOT NULL,
  `SITE_URL` varchar(100) DEFAULT NULL,
  `WEB_KIND` varchar(20) DEFAULT NULL,
  `HTTP_STTUS_CD` varchar(3) DEFAULT NULL,
  `CREAT_DT` datetime DEFAULT NULL,
  `MNGR_NM` varchar(60) DEFAULT NULL,
  `MNGR_EMAIL_ADDR` varchar(50) DEFAULT NULL,
  `FRST_REGISTER_ID` varchar(20) DEFAULT NULL,
  `FRST_REGISTER_PNTTM` datetime DEFAULT NULL,
  `LAST_UPDUSR_ID` varchar(20) DEFAULT NULL,
  `LAST_UPDUSR_PNTTM` datetime DEFAULT NULL,
  PRIMARY KEY (`SYS_ID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

CREATE TABLE `COMTNPROCESSMON` (
  `PROCESS_ID` char(20) NOT NULL,
  `PROCESS_NM` varchar(60) DEFAULT NULL,
  `PROCS_STTUS` varchar(3) DEFAULT NULL,
  `CREAT_DT` datetime DEFAULT NULL,
  `MNGR_NM` varchar(60) DEFAULT NULL,
  `MNGR_EMAIL_ADDR` varchar(50) DEFAULT NULL,
  `FRST_REGISTER_ID` varchar(20) DEFAULT NULL,
  `FRST_REGISTER_PNTTM` datetime DEFAULT NULL,
  `LAST_UPDUSR_ID` varchar(20) DEFAULT NULL,
  `LAST_UPDUSR_PNTTM` datetime DEFAULT NULL,
  PRIMARY KEY (`PROCESS_ID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

CREATE TABLE `COMTNNOTE` (
  `NOTE_ID` char(20) NOT NULL,
  `NOTE_SJ` varchar(255) DEFAULT NULL,
  `NOTE_CN` varchar(4000) DEFAULT NULL,
  `ATCH_FILE_ID` char(20) DEFAULT NULL,
  `FRST_REGISTER_ID` varchar(20) DEFAULT NULL,
  `FRST_REGISTER_PNTTM` datetime DEFAULT NULL,
  `LAST_UPDUSR_ID` varchar(20) DEFAULT NULL,
  `LAST_UPDUSR_PNTTM` datetime DEFAULT NULL,
  PRIMARY KEY (`NOTE_ID`),
  KEY `COMTNNOTE_FK` (`NOTE_ID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

CREATE TABLE `COMTNBNDTCECKMANAGE` (
  `BNDT_CECK_SE` varchar(2) NOT NULL,
  `BNDT_CECK_CD` varchar(10) NOT NULL,
  `BNDT_CECK_CD_NM` varchar(255) NOT NULL,
  `USE_AT` char(1) NOT NULL,
  `FRST_REGISTER_ID` varchar(20) DEFAULT NULL,
  `FRST_REGISTER_PNTTM` date DEFAULT NULL,
  `LAST_UPDUSR_ID` varchar(20) DEFAULT NULL,
  `LAST_UPDUSR_PNTTM` date DEFAULT NULL,
  PRIMARY KEY (`BNDT_CECK_CD`,`BNDT_CECK_SE`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

CREATE TABLE `COMTNBNDTMANAGE` (
  `BNDT_ID` varchar(20) NOT NULL,
  `BNDT_DE` char(8) NOT NULL,
  `REMARK` varchar(2500) DEFAULT NULL,
  `FRST_REGISTER_ID` varchar(20) DEFAULT NULL,
  `FRST_REGISTER_PNTTM` date DEFAULT NULL,
  `LAST_UPDUSR_ID` varchar(20) DEFAULT NULL,
  `LAST_UPDUSR_PNTTM` date DEFAULT NULL,
  PRIMARY KEY (`BNDT_ID`,`BNDT_DE`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

CREATE TABLE `COMTNBNDTDIARY` (
  `BNDT_ID` varchar(20) NOT NULL,
  `BNDT_DE` char(8) NOT NULL,
  `BNDT_CECK_SE` varchar(2) NOT NULL,
  `BNDT_CECK_CD` varchar(10) NOT NULL,
  `CHCK_STTUS` varchar(1000) DEFAULT NULL,
  `FRST_REGISTER_ID` varchar(20) DEFAULT NULL,
  `FRST_REGISTER_PNTTM` date DEFAULT NULL,
  `LAST_UPDUSR_ID` varchar(20) DEFAULT NULL,
  `LAST_UPDUSR_PNTTM` date DEFAULT NULL,
  PRIMARY KEY (`BNDT_ID`,`BNDT_DE`,`BNDT_CECK_SE`,`BNDT_CECK_CD`),
  CONSTRAINT `FK_COMTNBND_REFERENCE_COMTNBND` FOREIGN KEY (`BNDT_ID`, `BNDT_DE`) REFERENCES `COMTNBNDTMANAGE` (`BNDT_ID`, `BNDT_DE`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

CREATE TABLE `COMTNNOTETRNSMIT` (
  `NOTE_ID` char(20) NOT NULL,
  `NOTE_TRNSMIT_ID` char(20) NOT NULL,
  `TRNSMITER_ID` varchar(20) DEFAULT NULL,
  `DELETE_YN` varchar(1) DEFAULT NULL,
  `FRST_REGISTER_ID` varchar(20) DEFAULT NULL,
  `FRST_REGISTER_PNTTM` datetime DEFAULT NULL,
  `LAST_UPDUSR_ID` varchar(20) DEFAULT NULL,
  `LAST_UPDUSR_PNTTM` datetime DEFAULT NULL,
  PRIMARY KEY (`NOTE_ID`,`NOTE_TRNSMIT_ID`),
  KEY `COMTNNOTETRNSMIT_FK` (`NOTE_ID`),
  CONSTRAINT `COMTNNOTETRNSMIT_IBFK` FOREIGN KEY (`NOTE_ID`) REFERENCES `COMTNNOTE` (`NOTE_ID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

CREATE TABLE `COMTNRSS` (
  `RSS_ID` char(20) NOT NULL,
  `TRGET_SVC_NM` varchar(255) NOT NULL DEFAULT '',
  `TRGET_SVC_TABLE` varchar(255) NOT NULL DEFAULT '',
  `TRGET_SVC_LIST_CO` int(5) NOT NULL DEFAULT '0',
  `HDER_TITLE` varchar(255) NOT NULL,
  `HDER_LINK` varchar(255) NOT NULL,
  `HDER_DESCRIPTION` varchar(3000) NOT NULL,
  `HDER_TAG` varchar(255) DEFAULT NULL,
  `HDER_ETC` varchar(255) DEFAULT NULL,
  `BDT_TITLE` varchar(255) DEFAULT NULL,
  `BDT_LINK` varchar(255) DEFAULT NULL,
  `BDT_DESCRIPTION` varchar(3000) DEFAULT NULL,
  `BDT_TAG` varchar(255) DEFAULT NULL,
  `BDT_ETC` varchar(255) DEFAULT NULL,
  `FRST_REGISTER_ID` varchar(20) DEFAULT NULL,
  `FRST_REGISTER_PNTTM` datetime DEFAULT NULL,
  `LAST_UPDUSR_ID` varchar(20) DEFAULT NULL,
  `LAST_UPDUSR_PNTTM` datetime DEFAULT NULL,
  PRIMARY KEY (`RSS_ID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

CREATE TABLE `COMTNNOTERECPTN` (
  `NOTE_ID` char(20) NOT NULL,
  `NOTE_TRNSMIT_ID` char(20) NOT NULL,
  `NOTE_RECPTN_ID` char(20) NOT NULL,
  `RCVER_ID` varchar(20) DEFAULT NULL,
  `OPEN_YN` char(1) DEFAULT NULL,
  `RECPTN_SE` varchar(2) DEFAULT NULL,
  `FRST_REGISTER_ID` varchar(20) DEFAULT NULL,
  `FRST_REGISTER_PNTTM` datetime DEFAULT NULL,
  `LAST_UPDUSR_ID` varchar(20) DEFAULT NULL,
  `LAST_UPDUSR_PNTTM` datetime DEFAULT NULL,
  PRIMARY KEY (`NOTE_ID`,`NOTE_TRNSMIT_ID`,`NOTE_RECPTN_ID`),
  KEY `COMTNNOTERECPTN_FK` (`NOTE_ID`,`NOTE_TRNSMIT_ID`),
  CONSTRAINT `COMTNNOTERECPTN_IBFK` FOREIGN KEY (`NOTE_ID`, `NOTE_TRNSMIT_ID`) REFERENCES `COMTNNOTETRNSMIT` (`NOTE_ID`, `NOTE_TRNSMIT_ID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

CREATE TABLE `COMTNMTGPLACERESVE` (
  `RESVE_ID` char(20) NOT NULL,
  `MTG_PLACE_ID` char(20) NOT NULL,
  `MTG_SJ` varchar(100) NOT NULL,
  `RESVE_MAN_ID` varchar(20) NOT NULL,
  `RESVE_DE` char(8) NOT NULL,
  `RESVE_BEGIN_TM` varchar(14) NOT NULL,
  `RESVE_END_TM` varchar(14) NOT NULL,
  `ATNDNC_NMPR` decimal(10,0) DEFAULT NULL,
  `MTG_CN` varchar(200) DEFAULT NULL,
  `FRST_REGISTER_ID` varchar(20) DEFAULT NULL,
  `FRST_REGISTER_PNTTM` date DEFAULT NULL,
  `LAST_UPDUSR_ID` varchar(20) DEFAULT NULL,
  `LAST_UPDUSR_PNTTM` date DEFAULT NULL,
  PRIMARY KEY (`RESVE_ID`),
  KEY `COMTNMTGPLACERESVE_FK1` (`MTG_PLACE_ID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

CREATE TABLE `COMTNVCATNMANAGE` (
  `APPLCNT_ID` varchar(20) NOT NULL,
  `VCATN_SE` varchar(2) NOT NULL,
  `BGNDE` char(8) NOT NULL,
  `ENDDE` char(8) NOT NULL,
  `VCATN_RESN` varchar(200) NOT NULL,
  `REQST_DE` char(8) NOT NULL,
  `OCCRRNC_YEAR` char(4) DEFAULT NULL,
  `SANCTNER_ID` varchar(20) DEFAULT NULL,
  `CONFM_AT` char(1) DEFAULT NULL,
  `SANCTN_DT` date DEFAULT NULL,
  `RETURN_RESN` varchar(1000) DEFAULT NULL,
  `INFRML_SANCTN_ID` char(20) DEFAULT NULL,
  `FRST_REGISTER_ID` varchar(20) DEFAULT NULL,
  `FRST_REGISTER_PNTTM` date DEFAULT NULL,
  `LAST_UPDUSR_ID` varchar(20) DEFAULT NULL,
  `LAST_UPDUSR_PNTTM` date DEFAULT NULL,
  `NOON_SE` char(1) DEFAULT NULL,
  PRIMARY KEY (`APPLCNT_ID`,`VCATN_SE`,`BGNDE`,`ENDDE`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

CREATE TABLE `COMTNINDVDLYRYCMANAGE` (
  `OCCRRNC_YEAR` char(4) NOT NULL,
  `USID` varchar(20) NOT NULL,
  `OCCRNC_YRYC_CO` decimal(5,1) DEFAULT NULL,
  `USE_YRYC_CO` decimal(5,1) DEFAULT NULL,
  `REMNDR_YRYC_CO` decimal(5,1) DEFAULT NULL,
  `FRST_REGISTER_ID` varchar(20) DEFAULT NULL,
  `FRST_REGISTER_PNTTM` date DEFAULT NULL,
  `LAST_UPDUSR_ID` varchar(20) DEFAULT NULL,
  `LAST_UPDUSR_PNTTM` date DEFAULT NULL,
  PRIMARY KEY (`OCCRRNC_YEAR`,`USID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

CREATE TABLE `COMTNRWARDMANAGE` (
  `RWARD_ID` char(20) NOT NULL,
  `RWARD_MAN_ID` varchar(20) NOT NULL,
  `RWARD_CD` varchar(2) NOT NULL,
  `RWARD_DE` char(8) NOT NULL,
  `RWARD_NM` varchar(255) NOT NULL,
  `PBLEN_CN` varchar(1000) DEFAULT NULL,
  `SANCTNER_ID` varchar(20) NOT NULL,
  `CONFM_AT` char(1) DEFAULT NULL,
  `SANCTN_DT` date DEFAULT NULL,
  `RETURN_RESN` varchar(1000) DEFAULT NULL,
  `ATCH_FILE_ID` char(20) DEFAULT NULL,
  `INFRML_SANCTN_ID` char(20) DEFAULT NULL,
  `FRST_REGISTER_ID` varchar(20) DEFAULT NULL,
  `FRST_REGISTER_PNTTM` date DEFAULT NULL,
  `LAST_UPDUSR_ID` varchar(20) DEFAULT NULL,
  `LAST_UPDUSR_PNTTM` date DEFAULT NULL,
  PRIMARY KEY (`RWARD_ID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

CREATE TABLE `COMTNCTSNNMANAGE` (
  `CTSNN_ID` char(20) NOT NULL,
  `USID` varchar(20) NOT NULL,
  `CTSNN_CD` varchar(2) NOT NULL,
  `REQST_DE` char(8) NOT NULL,
  `CTSNN_NM` varchar(255) NOT NULL,
  `TRGTER_NM` varchar(20) NOT NULL,
  `BRTH` char(8) NOT NULL,
  `OCCRR_DE` char(8) NOT NULL,
  `RELATE` varchar(2) NOT NULL,
  `REMARK` varchar(2500) DEFAULT NULL,
  `SANCTNER_ID` varchar(20) NOT NULL,
  `CONFM_AT` char(1) DEFAULT NULL,
  `SANCTN_DT` date DEFAULT NULL,
  `RETURN_RESN` varchar(1000) DEFAULT NULL,
  `INFRML_SANCTN_ID` char(20) DEFAULT NULL,
  `FRST_REGISTER_ID` varchar(20) DEFAULT NULL,
  `FRST_REGISTER_PNTTM` date DEFAULT NULL,
  `LAST_UPDUSR_ID` varchar(20) DEFAULT NULL,
  `LAST_UPDUSR_PNTTM` date DEFAULT NULL,
  PRIMARY KEY (`CTSNN_ID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

CREATE TABLE `COMTNFXTRSMANAGE` (
  `FXTRS_CD` varchar(14) NOT NULL,
  `FXTRS_NM` varchar(100) NOT NULL,
  `MAKR_NM` varchar(100) DEFAULT NULL,
  `PRICE` decimal(16,0) DEFAULT NULL,
  PRIMARY KEY (`FXTRS_CD`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

CREATE TABLE `COMTNEVENTMANAGE` (
  `EVENT_ID` char(20) NOT NULL,
  `EVENT_SE` varchar(2) NOT NULL,
  `EVENT_NM` varchar(60) NOT NULL,
  `EVENT_PURPS` varchar(200) NOT NULL,
  `EVENT_BEGIN_DE` char(8) NOT NULL,
  `EVENT_END_DE` char(8) NOT NULL,
  `EVENT_AUSPC_INSTT_NM` varchar(60) DEFAULT NULL,
  `EVENT_MNGT_INSTT_NM` varchar(60) DEFAULT NULL,
  `EVENT_PLACE` varchar(200) NOT NULL,
  `EVENT_CN` varchar(1000) DEFAULT NULL,
  `CT_OCCRRNC_AT` varchar(1) DEFAULT NULL,
  `PARTCPT_CT` decimal(16,0) DEFAULT NULL,
  `GARDEN` decimal(10,0) NOT NULL,
  `REFRN_URL` varchar(1024) DEFAULT NULL,
  `RCEPT_BEGIN_DE` char(8) NOT NULL,
  `RCEPT_END_DE` char(8) NOT NULL,
  `FRST_REGISTER_ID` varchar(20) DEFAULT NULL,
  `FRST_REGISTER_PNTTM` date DEFAULT NULL,
  `LAST_UPDUSR_ID` varchar(20) DEFAULT NULL,
  `LAST_UPDUSR_PNTTM` date DEFAULT NULL,
  PRIMARY KEY (`EVENT_ID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

CREATE TABLE `COMTNMTGPLACEMANAGE` (
  `MTG_PLACE_ID` char(20) NOT NULL,
  `MTG_PLACE_NM` varchar(255) NOT NULL,
  `OPN_BEGIN_TM` varchar(6) NOT NULL,
  `OPN_END_TM` varchar(6) NOT NULL,
  `ACEPTNC_POSBL_NMPR` decimal(10,0) NOT NULL,
  `LC_SE` varchar(5) DEFAULT NULL,
  `LC_DETAIL` varchar(200) DEFAULT NULL,
  `ATCH_FILE_ID` char(20) DEFAULT NULL,
  `FRST_REGISTER_ID` varchar(20) DEFAULT NULL,
  `FRST_REGISTER_PNTTM` date DEFAULT NULL,
  `LAST_UPDUSR_ID` varchar(20) DEFAULT NULL,
  `LAST_UPDUSR_PNTTM` date DEFAULT NULL,
  PRIMARY KEY (`MTG_PLACE_ID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;


CREATE TABLE `COMTNMTGPLACEFXTRS` (
  `MTG_PLACE_ID` char(20) NOT NULL,
  `FXTRS_CD` varchar(14) NOT NULL,
  `QUANTITY` decimal(20,0) NOT NULL,
  `FRST_REGISTER_ID` varchar(20) DEFAULT NULL,
  `FRST_REGISTER_PNTTM` date DEFAULT NULL,
  `LAST_UPDUSR_ID` varchar(20) DEFAULT NULL,
  `LAST_UPDUSR_PNTTM` date DEFAULT NULL,
  PRIMARY KEY (`MTG_PLACE_ID`,`FXTRS_CD`),
  UNIQUE KEY `COMTNMTGPLACEFXTRS_PK` (`MTG_PLACE_ID`,`FXTRS_CD`),
  KEY `COMTNMTGPLACEFXTRS_FK2` (`MTG_PLACE_ID`),
  CONSTRAINT `FK_COMTNMTG_RELATIONS_COMTNMTG` FOREIGN KEY (`MTG_PLACE_ID`) REFERENCES `COMTNMTGPLACEMANAGE` (`MTG_PLACE_ID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

CREATE TABLE `COMTNANNVRSRYMANAGE` (
  `ANN_ID` char(20) NOT NULL,
  `USID` varchar(20) NOT NULL,
  `ANNVRSRY_SE` varchar(2) NOT NULL,
  `ANNVRSRY_NM` varchar(255) NOT NULL,
  `ANNVRSRY_DE` char(8) NOT NULL,
  `CLDR_SE` varchar(2) NOT NULL,
  `ANNVRSRY_SETUP` varchar(1) DEFAULT NULL,
  `ANNVRSRY_BEGIN_DE` char(8) DEFAULT NULL,
  `MEMO` varchar(1000) DEFAULT NULL,
  `FRST_REGISTER_ID` varchar(20) DEFAULT NULL,
  `FRST_REGISTER_PNTTM` date DEFAULT NULL,
  `LAST_UPDUSR_ID` varchar(20) DEFAULT NULL,
  `LAST_UPDUSR_PNTTM` date DEFAULT NULL,
  `REPTIT_SE` char(1) DEFAULT NULL,
  PRIMARY KEY (`ANN_ID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

CREATE TABLE `COMTNEVENTATDRN` (
  `APPLCNT_ID` varchar(20) NOT NULL,
  `EVENT_ID` char(20) NOT NULL,
  `REQST_DE` char(8) NOT NULL,
  `SANCTNER_ID` varchar(20) NOT NULL,
  `CONFM_AT` char(1) DEFAULT NULL,
  `SANCTN_DT` datetime DEFAULT NULL,
  `RETURN_RESN` varchar(1000) DEFAULT NULL,
  `INFRML_SANCTN_ID` char(20) DEFAULT NULL,
  `FRST_REGISTER_ID` varchar(20) DEFAULT NULL,
  `FRST_REGISTER_PNTTM` date DEFAULT NULL,
  `LAST_UPDUSR_ID` varchar(20) DEFAULT NULL,
  `LAST_UPDUSR_PNTTM` date DEFAULT NULL,
  PRIMARY KEY (`APPLCNT_ID`,`EVENT_ID`),
  KEY `FK_COMTNEVE_RELATIONS_COMTNEVE` (`EVENT_ID`),
  CONSTRAINT `FK_COMTNEVE_RELATIONS_COMTNEVE` FOREIGN KEY (`EVENT_ID`) REFERENCES `COMTNEVENTMANAGE` (`EVENT_ID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

CREATE TABLE `COMTNTWITTER` (
  `USID` char(20) NOT NULL,
  `CONSUMER_KEY` varchar(50) NOT NULL,
  `CONSUMER_SECRET` varchar(50) NOT NULL,
  `FRST_REGISTER_ID` varchar(20) DEFAULT NULL,
  `FRST_REGISTER_PNTTM` datetime DEFAULT NULL,
  `LAST_UPDUSR_ID` varchar(20) DEFAULT NULL,
  `LAST_UPDUSR_PNTTM` datetime DEFAULT NULL,
  PRIMARY KEY (`USID`),
  KEY `COMTNTWITTER_FK` (`USID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

CREATE TABLE `COMTNINFRMLSANCTN` (
  `INFRML_SANCTN_ID` char(20) NOT NULL,
  `JOB_SE_CODE` char(3) NOT NULL,
  `APPLCNT_ID` varchar(20) NOT NULL,
  `REQST_DE` char(8) NOT NULL,
  `SANCTNER_ID` varchar(20) NOT NULL,
  `CONFM_AT` char(1) NOT NULL,
  `SANCTN_DT` datetime DEFAULT NULL,
  `RETURN_RESN` varchar(1000) DEFAULT NULL,
  `FRST_REGISTER_ID` varchar(20) DEFAULT NULL,
  `FRST_REGISTER_PNTTM` date DEFAULT NULL,
  `LAST_UPDUSR_ID` varchar(20) DEFAULT NULL,
  `LAST_UPDUSR_PNTTM` date DEFAULT NULL,
  PRIMARY KEY (`INFRML_SANCTN_ID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

CREATE TABLE `COMTNWIKIBKMK` (
  `WIKI_BKMK_ID` char(20) NOT NULL,
  `USID` char(20) NOT NULL,
  `WIKI_BKMK_NM` varchar(1000) NOT NULL,
  `FRST_REGISTER_ID` varchar(20) DEFAULT NULL,
  `FRST_REGISTER_PNTTM` datetime DEFAULT NULL,
  `LAST_UPDUSR_ID` varchar(20) DEFAULT NULL,
  `LAST_UPDUSR_PNTTM` datetime DEFAULT NULL,
  PRIMARY KEY (`WIKI_BKMK_ID`,`USID`),
  KEY `COMTNWIKIBKMK_KEY` (`WIKI_BKMK_ID`,`USID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

CREATE TABLE `COMTNSERVERINFO` (
  `SERVER_ID` char(20) NOT NULL,
  `SERVER_NM` varchar(60) DEFAULT NULL,
  `SERVER_KND` char(2) DEFAULT NULL,
  `REGST_YMD` char(8) DEFAULT NULL,
  `FRST_REGISTER_ID` varchar(20) DEFAULT NULL,
  `FRST_REGISTER_PNTTM` datetime DEFAULT NULL,
  `LAST_UPDUSR_ID` varchar(20) DEFAULT NULL,
  `LAST_UPDUSR_PNTTM` datetime DEFAULT NULL,
  PRIMARY KEY (`SERVER_ID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

CREATE TABLE `COMTNSERVEREQPMNINFO` (
  `SERVER_EQPMN_ID` varchar(20) NOT NULL,
  `SERVER_EQPMN_NM` varchar(60) DEFAULT NULL,
  `SERVER_EQPMN_IP` varchar(23) DEFAULT NULL,
  `SERVER_EQPMN_MNGR` varchar(60) DEFAULT NULL,
  `MNGR_EMAIL_ADDR` varchar(50) DEFAULT NULL,
  `OPERSYSM_INFO` varchar(2000) DEFAULT NULL,
  `CPU_INFO` varchar(2000) DEFAULT NULL,
  `MORY_INFO` varchar(2000) DEFAULT NULL,
  `HDDISK` varchar(2000) DEFAULT NULL,
  `ETC_INFO` varchar(2000) DEFAULT NULL,
  `REGST_YMD` char(8) DEFAULT NULL,
  `FRST_REGISTER_ID` varchar(20) DEFAULT NULL,
  `FRST_REGISTER_PNTTM` datetime DEFAULT NULL,
  `LAST_UPDUSR_ID` varchar(20) DEFAULT NULL,
  `LAST_UPDUSR_PNTTM` datetime DEFAULT NULL,
  PRIMARY KEY (`SERVER_EQPMN_ID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

CREATE TABLE `COMTNBACKUPSCHDULDFK` (
  `BACKUP_OPERT_ID` varchar(20) NOT NULL,
  `EXECUT_SCHDUL_DFK_SE` varchar(1) NOT NULL,
  PRIMARY KEY (`BACKUP_OPERT_ID`,`EXECUT_SCHDUL_DFK_SE`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

CREATE TABLE `COMTNSERVEREQPMNRELATE` (
  `SERVER_ID` char(20) NOT NULL,
  `SERVER_EQPMN_ID` varchar(20) NOT NULL,
  `FRST_REGISTER_ID` varchar(20) DEFAULT NULL,
  `FRST_REGISTER_PNTTM` datetime DEFAULT NULL,
  `LAST_UPDUSR_ID` varchar(20) DEFAULT NULL,
  `LAST_UPDUSR_PNTTM` datetime DEFAULT NULL,
  PRIMARY KEY (`SERVER_ID`,`SERVER_EQPMN_ID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

CREATE TABLE `COMTNBACKUPRESULT` (
  `BACKUP_RESULT_ID` varchar(20) NOT NULL,
  `BACKUP_OPERT_ID` varchar(20) NOT NULL,
  `BACKUP_FILE` varchar(255) DEFAULT NULL,
  `STTUS` varchar(2) DEFAULT NULL,
  `ERROR_INFO` varchar(2000) DEFAULT NULL,
  `EXECUT_BEGIN_TIME` varchar(14) DEFAULT NULL,
  `EXECUT_END_TIME` varchar(14) DEFAULT NULL,
  `FRST_REGISTER_ID` varchar(20) DEFAULT NULL,
  `FRST_REGISTER_PNTTM` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `LAST_UPDUSR_ID` varchar(20) DEFAULT NULL,
  `LAST_UPDUSR_PNTTM` timestamp NOT NULL DEFAULT '0000-00-00 00:00:00',
  PRIMARY KEY (`BACKUP_RESULT_ID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

CREATE TABLE `COMTNBACKUPOPERT` (
  `BACKUP_OPERT_ID` varchar(20) NOT NULL,
  `BACKUP_OPERT_NM` varchar(60) DEFAULT NULL,
  `BACKUP_ORGINL_DRCTRY` varchar(255) DEFAULT NULL,
  `BACKUP_STRE_DRCTRY` varchar(255) DEFAULT NULL,
  `CMPRS_SE` varchar(2) DEFAULT NULL,
  `EXECUT_CYCLE` varchar(2) DEFAULT NULL,
  `EXECUT_SCHDUL_DE` char(8) DEFAULT NULL,
  `EXECUT_SCHDUL_HOUR` char(2) DEFAULT NULL,
  `EXECUT_SCHDUL_MNT` char(2) DEFAULT NULL,
  `EXECUT_SCHDUL_SECND` char(2) DEFAULT NULL,
  `USE_AT` char(1) DEFAULT NULL,
  `FRST_REGISTER_ID` varchar(20) DEFAULT NULL,
  `FRST_REGISTER_PNTTM` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `LAST_UPDUSR_ID` varchar(20) DEFAULT NULL,
  `LAST_UPDUSR_PNTTM` timestamp NOT NULL DEFAULT '0000-00-00 00:00:00',
  PRIMARY KEY (`BACKUP_OPERT_ID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

CREATE TABLE `COMTNBATCHSCHDULDFK` (
  `BATCH_SCHDUL_ID` varchar(20) NOT NULL,
  `EXECUT_SCHDUL_DFK_SE` varchar(1) NOT NULL,
  PRIMARY KEY (`BATCH_SCHDUL_ID`,`EXECUT_SCHDUL_DFK_SE`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

CREATE TABLE `COMTNBATCHOPERT` (
  `BATCH_OPERT_ID` varchar(20) NOT NULL,
  `BATCH_OPERT_NM` varchar(60) DEFAULT NULL,
  `BATCH_PROGRM` varchar(255) DEFAULT NULL,
  `PARAMTR` varchar(250) DEFAULT NULL,
  `USE_AT` char(1) DEFAULT NULL,
  `FRST_REGISTER_ID` varchar(20) DEFAULT NULL,
  `FRST_REGISTER_PNTTM` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `LAST_UPDUSR_ID` varchar(20) DEFAULT NULL,
  `LAST_UPDUSR_PNTTM` timestamp NOT NULL DEFAULT '0000-00-00 00:00:00',
  PRIMARY KEY (`BATCH_OPERT_ID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

CREATE TABLE `COMTNBATCHRESULT` (
  `BATCH_RESULT_ID` varchar(20) NOT NULL,
  `BATCH_SCHDUL_ID` varchar(20) NOT NULL,
  `BATCH_OPERT_ID` varchar(20) NOT NULL,
  `PARAMTR` varchar(250) DEFAULT NULL,
  `STTUS` varchar(2) DEFAULT NULL,
  `ERROR_INFO` varchar(2000) DEFAULT NULL,
  `EXECUT_BEGIN_TIME` varchar(14) DEFAULT NULL,
  `EXECUT_END_TIME` varchar(14) DEFAULT NULL,
  `LAST_UPDUSR_PNTTM` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `LAST_UPDUSR_ID` varchar(20) DEFAULT NULL,
  `FRST_REGISTER_PNTTM` timestamp NOT NULL DEFAULT '0000-00-00 00:00:00',
  `FRST_REGISTER_ID` varchar(20) DEFAULT NULL,
  PRIMARY KEY (`BATCH_RESULT_ID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

CREATE TABLE `COMTNBATCHSCHDUL` (
  `BATCH_SCHDUL_ID` varchar(20) NOT NULL,
  `BATCH_OPERT_ID` varchar(20) NOT NULL,
  `EXECUT_CYCLE` varchar(2) DEFAULT NULL,
  `EXECUT_SCHDUL_DE` char(8) DEFAULT NULL,
  `EXECUT_SCHDUL_HOUR` char(2) DEFAULT NULL,
  `EXECUT_SCHDUL_MNT` char(2) DEFAULT NULL,
  `EXECUT_SCHDUL_SECND` char(2) DEFAULT NULL,
  `FRST_REGISTER_ID` varchar(20) DEFAULT NULL,
  `FRST_REGISTER_PNTTM` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `LAST_UPDUSR_ID` varchar(20) DEFAULT NULL,
  `LAST_UPDUSR_PNTTM` timestamp NOT NULL DEFAULT '0000-00-00 00:00:00',
  PRIMARY KEY (`BATCH_SCHDUL_ID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

CREATE TABLE `COMTNNTWRKINFO` (
  `NTWRK_ID` char(20) NOT NULL,
  `NTWRK_IP` varchar(23) DEFAULT NULL,
  `GTWY` varchar(23) DEFAULT NULL,
  `SUBNET` varchar(23) DEFAULT NULL,
  `DOMN_SERVER` varchar(23) DEFAULT NULL,
  `MANAGE_IEM` varchar(2) DEFAULT NULL,
  `USER_NM` varchar(60) DEFAULT NULL,
  `USE_AT` char(1) DEFAULT NULL,
  `REGST_YMD` char(8) DEFAULT NULL,
  `FRST_REGISTER_ID` varchar(20) DEFAULT NULL,
  `FRST_REGISTER_PNTTM` datetime DEFAULT NULL,
  `LAST_UPDUSR_ID` varchar(20) DEFAULT NULL,
  `LAST_UPDUSR_PNTTM` datetime DEFAULT NULL,
  PRIMARY KEY (`NTWRK_ID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

CREATE TABLE `COMTNTROBLINFO` (
  `TROBL_ID` char(20) NOT NULL,
  `TROBL_NM` varchar(60) DEFAULT NULL,
  `TROBL_KND` char(2) DEFAULT NULL,
  `TROBL_DC` varchar(2000) DEFAULT NULL,
  `TROBL_OCCRRNC_TIME` varchar(14) DEFAULT NULL,
  `TROBL_RQESTER_NM` varchar(60) DEFAULT NULL,
  `TROBL_REQUST_TIME` varchar(14) DEFAULT NULL,
  `TROBL_PROCESS_RESULT` varchar(2000) DEFAULT NULL,
  `TROBL_OPETR_NM` varchar(60) DEFAULT NULL,
  `TROBL_PROCESS_TIME` varchar(14) DEFAULT NULL,
  `PROCESS_STTUS` char(1) DEFAULT NULL,
  `FRST_REGISTER_ID` varchar(20) DEFAULT NULL,
  `FRST_REGISTER_PNTTM` datetime DEFAULT NULL,
  `LAST_UPDUSR_ID` varchar(20) DEFAULT NULL,
  `LAST_UPDUSR_PNTTM` datetime DEFAULT NULL,
  PRIMARY KEY (`TROBL_ID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

CREATE TABLE `COMTNDAMCALRES` (
  `KNO_ID` char(20) NOT NULL,
  `ORGNZT_ID` char(20) DEFAULT NULL,
  `SPE_ID` char(20) DEFAULT NULL,
  `KNO_TYPE_CD` varchar(3) DEFAULT NULL,
  `EMPLYR_ID` char(20) DEFAULT NULL,
  `KNO_NM` varchar(60) DEFAULT NULL,
  `KNO_CN` varchar(2500) DEFAULT NULL,
  `ATCH_FILE_ID` char(20) DEFAULT NULL,
  `ANS_PARENTS` char(20) DEFAULT NULL,
  `ANS_DEPTH` int(10) DEFAULT '0',
  `ANS_SEQ` int(10) DEFAULT '0',
  `ANS_NUMBER` int(10) DEFAULT '0',
  `FRST_REGISTER_ID` varchar(20) DEFAULT NULL,
  `FRST_REGISTER_PNTTM` datetime DEFAULT NULL,
  `LAST_UPDUSR_ID` varchar(20) DEFAULT NULL,
  `LAST_UPDUSR_PNTTM` datetime DEFAULT NULL,
  PRIMARY KEY (`KNO_ID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

CREATE TABLE `COMTNDAMKNOIFM` (
  `KNO_ID` char(20) NOT NULL,
  `KNO_TYPE_CD` varchar(3) DEFAULT NULL,
  `ORGNZT_ID` char(20) DEFAULT NULL,
  `SPE_ID` char(20) DEFAULT NULL,
  `EMPLYR_ID` char(20) DEFAULT NULL,
  `KNO_NM` varchar(60) DEFAULT NULL,
  `KNO_CN` varchar(2500) DEFAULT NULL,
  `KEYWORLD` varchar(100) DEFAULT NULL,
  `OTHBC_AT` char(1) DEFAULT NULL,
  `KNO_APS` char(1) DEFAULT NULL,
  `COL_YMD` char(8) DEFAULT NULL,
  `APP_YMD` char(8) DEFAULT NULL,
  `ATCH_FILE_ID` char(20) DEFAULT NULL,
  `FRST_REGISTER_ID` varchar(20) DEFAULT NULL,
  `FRST_REGISTER_PNTTM` datetime DEFAULT NULL,
  `LAST_UPDUSR_ID` varchar(20) DEFAULT NULL,
  `LAST_UPDUSR_PNTTM` datetime DEFAULT NULL,
  `JUNK_YMD` char(8) DEFAULT NULL,
  PRIMARY KEY (`KNO_ID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

CREATE TABLE `COMTNDAMPRO` (
  `SPE_ID` char(20) NOT NULL,
  `KNO_TYPE_CD` varchar(3) NOT NULL,
  `APP_TYPE_CD` char(1) NOT NULL,
  `SPE_CONFM_DE` char(8) DEFAULT NULL,
  `FRST_REGISTER_ID` varchar(20) DEFAULT NULL,
  `FRST_REGISTER_PNTTM` datetime DEFAULT NULL,
  `LAST_UPDUSR_ID` varchar(20) DEFAULT NULL,
  `LAST_UPDUSR_PNTTM` datetime DEFAULT NULL,
  `SPE_EXP_CN` varchar(100) DEFAULT NULL,
  PRIMARY KEY (`SPE_ID`,`KNO_TYPE_CD`,`APP_TYPE_CD`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

CREATE TABLE `COMTNDAMMAPKNO` (
  `KNO_TYPE_CD` varchar(3) NOT NULL,
  `ORGNZT_ID` char(20) DEFAULT NULL,
  `SPE_ID` char(20) DEFAULT NULL,
  `KNO_TYPE_NM` varchar(100) DEFAULT NULL,
  `CL_YMD` char(8) DEFAULT NULL,
  `KNO_URL` varchar(255) DEFAULT NULL,
  `FRST_REGISTER_ID` varchar(20) DEFAULT NULL,
  `FRST_REGISTER_PNTTM` datetime DEFAULT NULL,
  `LAST_UPDUSR_ID` varchar(20) DEFAULT NULL,
  `LAST_UPDUSR_PNTTM` datetime DEFAULT NULL,
  PRIMARY KEY (`KNO_TYPE_CD`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

CREATE TABLE `COMTNDAMMAPTEAM` (
  `ORGNZT_ID` char(20) NOT NULL,
  `ORGNZT_NM` varchar(20) DEFAULT NULL,
  `CL_YMD` char(8) DEFAULT NULL,
  `KNO_URL` varchar(100) DEFAULT NULL,
  `LAST_UPDUSR_ID` varchar(20) DEFAULT NULL,
  `LAST_UPDUSR_PNTTM` datetime DEFAULT NULL,
  PRIMARY KEY (`ORGNZT_ID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;
