
CREATE TABLE COMTNPROGRMLIST
(
	PROGRM_FILE_NM        VARCHAR(60) NOT NULL,
	PROGRM_STRE_PATH      VARCHAR(100) NOT NULL,
	PROGRM_KOREAN_NM      VARCHAR(60) NULL,
	PROGRM_DC             VARCHAR(200) NULL,
	URL                   VARCHAR(100) NOT NULL,
	 PRIMARY KEY (PROGRM_FILE_NM)
)
;



CREATE UNIQUE INDEX COMTNPROGRMLIST_PK ON COMTNPROGRMLIST
(
	PROGRM_FILE_NM
)
;



CREATE TABLE COMTHPROGRMCHANGEDTLS
(
	PROGRM_FILE_NM        VARCHAR(60) NOT NULL,
	REQUST_NO             NUMERIC(10) NOT NULL,
	RQESTER_ID            VARCHAR(20) NOT NULL,
	CHANGE_REQUST_CN      VARCHAR(1000) NULL,
	REQUST_PROCESS_CN     TEXT NULL,
	OPETR_ID              VARCHAR(20) NULL,
	PROCESS_STTUS_CODE    VARCHAR(15) NOT NULL,
	PROCESS_DE            CHAR(20) NULL,
	RQESTDE               CHAR(20) NULL,
	REQUST_SJ             VARCHAR(60) NOT NULL,
	 PRIMARY KEY (PROGRM_FILE_NM,REQUST_NO),
	FOREIGN KEY (PROGRM_FILE_NM) REFERENCES COMTNPROGRMLIST(PROGRM_FILE_NM)
		ON DELETE CASCADE
)
;



CREATE UNIQUE INDEX COMTHPROGRMCHANGEDTLS_PK ON COMTHPROGRMCHANGEDTLS
(
	PROGRM_FILE_NM,
	REQUST_NO
)
;



CREATE INDEX COMTHPROGRMCHANGEDTLS_i01 ON COMTHPROGRMCHANGEDTLS
(
	PROGRM_FILE_NM
)
;



CREATE TABLE COMTNPOPUPMANAGE
(
	POPUP_ID              VARCHAR(20) NOT NULL,
	POPUP_SJ_NM           VARCHAR(1024) NULL,
	FILE_URL              VARCHAR(1024) NULL,
	POPUP_WIDTH_LC        VARCHAR(20) NULL,
	POPUP_WIDTH_SIZE      NUMERIC NULL,
	NTCE_BGNDE            CHAR(20) NULL,
	NTCE_ENDDE            CHAR(20) NULL,
	STOPVEW_SETUP_AT      CHAR(1) NULL,
	NTCE_AT               CHAR(1) NULL,
	POPUP_VRTICL_LC       VARCHAR(20) NULL,
	POPUP_VRTICL_SIZE     NUMERIC NULL,
	FRST_REGISTER_ID      VARCHAR(20) NULL,
	FRST_REGIST_PNTTM     TIMESTAMP NULL,
	LAST_UPDUSR_ID        VARCHAR(20) NULL,
	LAST_UPDT_PNTTM       TIMESTAMP NULL,
	 PRIMARY KEY (POPUP_ID)
)
;



CREATE UNIQUE INDEX COMTNPOPUPMANAGE_PK ON COMTNPOPUPMANAGE
(
	POPUP_ID
)
;



CREATE TABLE COMTNBANNER
(
	BANNER_ID             CHAR(20) NOT NULL,
	BANNER_NM             VARCHAR(60) NOT NULL,
	LINK_URL              VARCHAR(255) NOT NULL,
	BANNER_IMAGE          VARCHAR(60) NOT NULL,
	BANNER_DC             VARCHAR(200) NULL,
	REFLCT_AT             CHAR(1) NOT NULL,
	FRST_REGISTER_ID      VARCHAR(20) NULL,
	FRST_REGIST_PNTTM     TIMESTAMP NULL,
	LAST_UPDUSR_ID        VARCHAR(20) NULL,
	LAST_UPDT_PNTTM       TIMESTAMP NULL,
	BANNER_IMAGE_FILE     VARCHAR(60) NULL,
	SORT_ORDR             NUMERIC(8) NULL,
	 PRIMARY KEY (BANNER_ID)
)
;



CREATE UNIQUE INDEX COMTNBANNER_PK ON COMTNBANNER
(
	BANNER_ID
)
;



CREATE TABLE COMTNLOGINSCRINIMAGE
(
	IMAGE_ID              CHAR(20) NOT NULL,
	IMAGE_NM              VARCHAR(20) NOT NULL,
	REFLCT_AT             CHAR(1) NOT NULL,
	IMAGE                 VARCHAR(60) NOT NULL,
	IMAGE_DC              VARCHAR(200) NULL,
	FRST_REGISTER_ID      VARCHAR(20) NULL,
	FRST_REGIST_PNTTM     TIMESTAMP NULL,
	LAST_UPDUSR_ID        VARCHAR(20) NULL,
	LAST_UPDT_PNTTM       TIMESTAMP NULL,
	IMAGE_FILE            VARCHAR(60) NULL,
	 PRIMARY KEY (IMAGE_ID)
)
;



CREATE UNIQUE INDEX COMTNLOGINSCRINIMAGE_PK ON COMTNLOGINSCRINIMAGE
(
	IMAGE_ID
)
;



CREATE TABLE COMTNORGNZTINFO
(
	ORGNZT_ID             CHAR(20) NOT NULL,
	ORGNZT_NM             VARCHAR(20) NOT NULL,
	ORGNZT_DC             VARCHAR(100) NULL,
	 PRIMARY KEY (ORGNZT_ID)
)
;



CREATE UNIQUE INDEX COMTNORGNZTINFO_PK ON COMTNORGNZTINFO
(
	ORGNZT_ID
)
;



CREATE TABLE COMTNAUTHORGROUPINFO
(
	GROUP_ID              CHAR(20) NOT NULL,
	GROUP_NM              VARCHAR(60) NOT NULL,
	GROUP_CREAT_DE        TIMESTAMP NOT NULL,
	GROUP_DC              VARCHAR(100) NULL,
	PRIMARY KEY (GROUP_ID)
)
;



CREATE UNIQUE INDEX COMTNAUTHORGROUPINFO_PK ON COMTNAUTHORGROUPINFO
(
	GROUP_ID
)
;



CREATE TABLE COMTNEMPLYRINFO
(
	EMPLYR_ID             VARCHAR(20) NOT NULL,
	ORGNZT_ID             CHAR(20) NULL,
	USER_NM               VARCHAR(60) NOT NULL,
	PASSWORD              VARCHAR(200) NOT NULL,
	EMPL_NO               VARCHAR(20) NULL,
	IHIDNUM               VARCHAR(200) NULL,
	SEXDSTN_CODE          CHAR(1) NULL,
	BRTHDY                CHAR(20) NULL,
	FXNUM                 VARCHAR(20) NULL,
	HOUSE_ADRES           VARCHAR(100) NOT NULL,
	PASSWORD_HINT         VARCHAR(100) NOT NULL,
	PASSWORD_CNSR         VARCHAR(100) NOT NULL,
	HOUSE_END_TELNO       VARCHAR(4) NOT NULL,
	AREA_NO               VARCHAR(4) NOT NULL,
	DETAIL_ADRES          VARCHAR(100) NULL,
	ZIP                   VARCHAR(6) NOT NULL,
	OFFM_TELNO            VARCHAR(20) NULL,
	MBTLNUM               VARCHAR(20) NULL,
	EMAIL_ADRES           VARCHAR(50) NULL,
	OFCPS_NM              VARCHAR(60) NULL,
	HOUSE_MIDDLE_TELNO    VARCHAR(4) NOT NULL,
	GROUP_ID              CHAR(20) NULL,
	PSTINST_CODE          CHAR(8) NULL,
	EMPLYR_STTUS_CODE     CHAR(1) NOT NULL,
	ESNTL_ID              CHAR(20) NOT NULL,
	CRTFC_DN_VALUE        VARCHAR(100) NULL,
	SBSCRB_DE             TIMESTAMP NULL,
	LOCK_AT               CHAR(1) NULL,
	LOCK_CNT              NUMERIC(3,0) NULL,
	LOCK_LAST_PNTTM       TIMESTAMP NULL,
	 PRIMARY KEY (EMPLYR_ID),
	FOREIGN KEY (ORGNZT_ID) REFERENCES COMTNORGNZTINFO(ORGNZT_ID)
		ON DELETE SET NULL,
	FOREIGN KEY (GROUP_ID) REFERENCES COMTNAUTHORGROUPINFO(GROUP_ID)
		ON DELETE SET NULL
)
;



CREATE UNIQUE INDEX COMTNEMPLYRINFO_PK ON COMTNEMPLYRINFO
(
	EMPLYR_ID
)
;



CREATE INDEX COMTNEMPLYRINFO_i01 ON COMTNEMPLYRINFO
(
	ORGNZT_ID
)
;



CREATE INDEX COMTNEMPLYRINFO_i02 ON COMTNEMPLYRINFO
(
	GROUP_ID
)
;



CREATE TABLE COMTNFILE
(
	ATCH_FILE_ID          CHAR(20) NOT NULL,
	CREAT_DT              TIMESTAMP NOT NULL,
	USE_AT                CHAR(1) NULL,
	 PRIMARY KEY (ATCH_FILE_ID)
)
;



CREATE UNIQUE INDEX COMTNFILE_PK ON COMTNFILE
(
	ATCH_FILE_ID
)
;



CREATE TABLE COMTHEMAILDSPTCHMANAGE
(
	MSSAGE_ID             VARCHAR(20) NOT NULL,
	EMAIL_CN              TEXT NULL,
	SNDR                  VARCHAR(50) NOT NULL,
	RCVER                 VARCHAR(50) NOT NULL,
	SJ                    VARCHAR(60) NOT NULL,
	SNDNG_RESULT_CODE     CHAR(1) NULL,
	DSPTCH_DT             CHAR(20) NOT NULL,
	ATCH_FILE_ID          CHAR(20) NULL,
	 PRIMARY KEY (MSSAGE_ID),
	FOREIGN KEY (ATCH_FILE_ID) REFERENCES COMTNFILE(ATCH_FILE_ID)
)
;



CREATE UNIQUE INDEX COMTHEMAILDSPTCHMANAGE_PK ON COMTHEMAILDSPTCHMANAGE
(
	MSSAGE_ID
)
;



CREATE INDEX COMTHEMAILDSPTCHMANAGE_i01 ON COMTHEMAILDSPTCHMANAGE
(
	SNDR
)
;



CREATE INDEX COMTHEMAILDSPTCHMANAGE_i02 ON COMTHEMAILDSPTCHMANAGE
(
	ATCH_FILE_ID
)
;



CREATE TABLE COMTNNTTSTATS
(
	STATS_ID              CHAR(18) NOT NULL,
	NTCE_CO               NUMERIC(10) NULL,
	AVRG_RDCNT            NUMERIC(10) NULL,
	TOP_RDCNT             NUMERIC(10) NULL,
	MUMM_RDCNT            NUMERIC(10) NULL,
	TOP_NTCR_ID           VARCHAR(20) NULL,
	 PRIMARY KEY (STATS_ID)
)
;



CREATE UNIQUE INDEX COMTNNTTSTATS_PK ON COMTNNTTSTATS
(
	STATS_ID
)
;



CREATE TABLE COMTNSITELIST
(
	SITE_ID               CHAR(20) NOT NULL,
	SITE_NM               VARCHAR(100) NULL,
	SITE_URL              VARCHAR(100) NULL,
	SITE_DC               VARCHAR(1000) NULL,
	SITE_THEMA_CL_CODE    VARCHAR(2) NULL,
	ACTVTY_AT             CHAR(1) NULL,
	USE_AT                CHAR(1) NULL,
	FRST_REGIST_PNTTM     TIMESTAMP NULL,
	FRST_REGISTER_ID      VARCHAR(20) NULL,
	LAST_UPDT_PNTTM       TIMESTAMP NULL,
	LAST_UPDUSR_ID        VARCHAR(20) NULL,
	 PRIMARY KEY (SITE_ID)
)
;



CREATE UNIQUE INDEX COMTNSITELIST_PK ON COMTNSITELIST
(
	SITE_ID
)
;



CREATE TABLE COMTNRECENTSRCHWRDMANAGE
(
	SRCHWRD_MANAGE_ID     CHAR(20) NOT NULL,
	SRCHWRD_MANAGE_NM     VARCHAR(255) NULL,
	SRCHWRD_CONECT_URL    VARCHAR(255) NULL,
	USER_SEARCH_AT        CHAR(1) NULL,
	FRST_REGISTER_ID      VARCHAR(20) NULL,
	FRST_REGIST_PNTTM     TIMESTAMP NULL,
	LAST_UPDUSR_ID        VARCHAR(20) NULL,
	LAST_UPDT_PNTTM       TIMESTAMP NULL,
	 PRIMARY KEY (SRCHWRD_MANAGE_ID)
)
;



CREATE UNIQUE INDEX COMTNRECENTSRCHWRDMANAGE_PK ON COMTNRECENTSRCHWRDMANAGE
(
	SRCHWRD_MANAGE_ID
)
;



CREATE TABLE COMTNRECENTSRCHWRD
(
	SRCHWRD_MANAGE_ID     CHAR(20) NOT NULL,
	RECENT_SRCHWRD_ID     CHAR(20) NOT NULL,
	RECENT_SRCHWRD_NM     VARCHAR(255) NULL,
	RECENT_SRCHWRD_CO     NUMERIC(20) NULL,
	FRST_REGISTER_ID      VARCHAR(20) NULL,
	FRST_REGIST_PNTTM     TIMESTAMP NULL,
	LAST_UPDUSR_ID        VARCHAR(20) NULL,
	LAST_UPDT_PNTTM       TIMESTAMP NULL,
	 PRIMARY KEY (RECENT_SRCHWRD_ID),
	FOREIGN KEY (SRCHWRD_MANAGE_ID) REFERENCES COMTNRECENTSRCHWRDMANAGE(SRCHWRD_MANAGE_ID)
)
;



CREATE UNIQUE INDEX COMTNRECENTSRCHWRD_PK ON COMTNRECENTSRCHWRD
(
	RECENT_SRCHWRD_ID
)
;



CREATE TABLE COMTNPROXYINFO
(
	PROXY_ID              CHAR(20) NOT NULL,
	PROXY_NM              VARCHAR(60) NULL,
	PROXY_IP              VARCHAR(23) NULL,
	PROXY_PORT            VARCHAR(10) NULL,
	TRGET_SVC_NM          VARCHAR(255) NULL,
	SVC_DC                VARCHAR(2000) NULL,
	SVC_IP                VARCHAR(23) NULL,
	SVC_PORT              VARCHAR(10) NULL,
	SVC_STTUS             CHAR(2) NULL,
	FRST_REGISTER_ID      VARCHAR(20) NULL,
	FRST_REGIST_PNTTM     TIMESTAMP NULL,
	LAST_UPDUSR_ID        VARCHAR(20) NULL,
	LAST_UPDT_PNTTM       TIMESTAMP NULL,
	 PRIMARY KEY (PROXY_ID)
)
;



CREATE UNIQUE INDEX COMTNPROXYINFO_PK ON COMTNPROXYINFO
(
	PROXY_ID
)
;



CREATE TABLE COMTNPROXYLOGINFO
(
	PROXY_ID              CHAR(20) NOT NULL,
	CLNT_IP               VARCHAR(23) NULL,
	CLNT_PORT             VARCHAR(10) NULL,
	CONECT_TIME           TIMESTAMP NULL,
	FRST_REGISTER_ID      VARCHAR(20) NULL,
	FRST_REGIST_PNTTM     TIMESTAMP NULL,
	LAST_UPDUSR_ID        VARCHAR(20) NULL,
	LAST_UPDT_PNTTM       TIMESTAMP NULL,
	LOG_ID                CHAR(20) NOT NULL,
	 PRIMARY KEY (PROXY_ID,LOG_ID),
	FOREIGN KEY (PROXY_ID) REFERENCES COMTNPROXYINFO(PROXY_ID)
)
;



CREATE UNIQUE INDEX COMTNPROXYLOGINFO_PK ON COMTNPROXYLOGINFO
(
	PROXY_ID,
	LOG_ID
)
;



CREATE TABLE COMTNMAINIMAGE
(
	IMAGE_ID              CHAR(20) NOT NULL,
	IMAGE_NM              VARCHAR(20) NOT NULL,
	IMAGE                 VARCHAR(60) NOT NULL,
	IMAGE_DC              VARCHAR(200) NULL,
	REFLCT_AT             CHAR(1) NOT NULL,
	FRST_REGISTER_ID      VARCHAR(20) NULL,
	FRST_REGIST_PNTTM     TIMESTAMP NULL,
	LAST_UPDUSR_ID        VARCHAR(20) NULL,
	LAST_UPDT_PNTTM       TIMESTAMP NULL,
	IMAGE_FILE            VARCHAR(60) NULL,
	 PRIMARY KEY (IMAGE_ID)
)
;



CREATE UNIQUE INDEX COMTNMAINIMAGE_PK ON COMTNMAINIMAGE
(
	IMAGE_ID
)
;



CREATE TABLE COMTNUNITYLINK
(
	UNITY_LINK_ID         CHAR(20) NOT NULL,
	UNITY_LINK_GROUP      VARCHAR(255) NULL,
	UNITY_LINK_NM         VARCHAR(255) NULL,
	UNITY_LINK_URL        VARCHAR(255) NULL,
	UNITY_LINK_DC         VARCHAR(2500) NULL,
	FRST_REGISTER_ID      VARCHAR(20) NULL,
	FRST_REGIST_PNTTM     TIMESTAMP NULL,
	LAST_UPDUSR_ID        VARCHAR(20) NULL,
	LAST_UPDT_PNTTM       TIMESTAMP NULL,
	UNITY_LINK_SE_CODE    CHAR(3) NULL,
	 PRIMARY KEY (UNITY_LINK_ID)
)
;



CREATE UNIQUE INDEX COMTNUNITYLINK_PK ON COMTNUNITYLINK
(
	UNITY_LINK_ID
)
;



CREATE TABLE COMTNUSERABSNCE
(
	EMPLYR_ID             VARCHAR(20) NOT NULL,
	USER_ABSNCE_AT        CHAR(1) NOT NULL,
	FRST_REGISTER_ID      VARCHAR(20) NULL,
	FRST_REGIST_PNTTM     TIMESTAMP NULL,
	LAST_UPDUSR_ID        VARCHAR(20) NULL,
	LAST_UPDT_PNTTM       TIMESTAMP NULL,
	 PRIMARY KEY (EMPLYR_ID)
)
;



CREATE UNIQUE INDEX COMTNUSERABSNCE_PK ON COMTNUSERABSNCE
(
	EMPLYR_ID
)
;



CREATE TABLE COMTSSYSLOGSUMMARY
(
	OCCRRNC_DE            CHAR(8) NOT NULL,
	SVC_NM                VARCHAR(255) NOT NULL,
	METHOD_NM             VARCHAR(60) NOT NULL,
	CREAT_CO              NUMERIC(10) NULL,
	UPDT_CO               NUMERIC(10) NULL,
	RDCNT                 NUMERIC(10) NULL,
	DELETE_CO             NUMERIC(10) NULL,
	OUTPT_CO              NUMERIC(10) NULL,
	ERROR_CO              NUMERIC(10) NULL,
	 PRIMARY KEY (OCCRRNC_DE,SVC_NM,METHOD_NM)
)
;



CREATE UNIQUE INDEX COMTSSYSLOGSUMMARY_PK ON COMTSSYSLOGSUMMARY
(
	OCCRRNC_DE,
	SVC_NM,
	METHOD_NM
)
;



CREATE TABLE COMTNSYSLOG
(
	REQUST_ID             VARCHAR(20) NOT NULL,
	JOB_SE_CODE           CHAR(3) NULL,
	INSTT_CODE            CHAR(7) NULL,
	OCCRRNC_DE            TIMESTAMP NULL,
	RQESTER_IP            VARCHAR(23) NULL,
	RQESTER_ID            VARCHAR(20) NULL,
	TRGET_MENU_NM         VARCHAR(255) NULL,
	SVC_NM                VARCHAR(255) NULL,
	METHOD_NM             VARCHAR(60) NULL,
	PROCESS_SE_CODE       CHAR(3) NULL,
	PROCESS_CO            NUMERIC(10) NULL,
	PROCESS_TIME          VARCHAR(14) NULL,
	RSPNS_CODE            CHAR(3) NULL,
	ERROR_SE              CHAR(1) NULL,
	ERROR_CO              NUMERIC(10) NULL,
	ERROR_CODE            CHAR(3) NULL,
	 PRIMARY KEY (REQUST_ID)
)
;



CREATE UNIQUE INDEX COMTNSYSLOG_PK ON COMTNSYSLOG
(
	REQUST_ID
)
;



CREATE TABLE COMTNBBSMASTER
(
	BBS_ID                CHAR(20) NOT NULL,
	BBS_NM                VARCHAR(255) NOT NULL,
	BBS_INTRCN            VARCHAR(2400) NULL,
	BBS_TY_CODE           CHAR(6) NOT NULL,
	REPLY_POSBL_AT        CHAR(1) NULL,
	FILE_ATCH_POSBL_AT    CHAR(1) NOT NULL,
	ATCH_POSBL_FILE_NUMBER  NUMERIC(2) NOT NULL,
	ATCH_POSBL_FILE_SIZE  NUMERIC(8) NULL,
	USE_AT                CHAR(1) NOT NULL,
	TMPLAT_ID             CHAR(20) NULL,
	CMMNTY_ID             CHAR(20) NULL,
	FRST_REGISTER_ID      VARCHAR(20) NOT NULL,
	FRST_REGIST_PNTTM     TIMESTAMP NOT NULL,
	LAST_UPDUSR_ID        VARCHAR(20) NULL,
	LAST_UPDT_PNTTM       TIMESTAMP NULL,
	BLOG_ID 					CHAR(20) NULL,
	BLOG_AT 					CHAR(2) NULL,
	PRIMARY KEY (BBS_ID)
)
;



CREATE UNIQUE INDEX COMTNBBSMASTER_PK ON COMTNBBSMASTER
(
	BBS_ID
)
;



CREATE TABLE COMTNBBS
(
	NTT_ID                NUMERIC(20) NOT NULL,
	BBS_ID                CHAR(20) NOT NULL,
	NTT_NO                NUMERIC(20) NULL,
	NTT_SJ                VARCHAR(2000) NULL,
	NTT_CN                TEXT NULL,
	ANSWER_AT             CHAR(1) NULL,
	PARNTSCTT_NO          NUMERIC(10) NULL,
	ANSWER_LC             NUMERIC(8) NULL,
	SORT_ORDR             NUMERIC(8) NULL,
	RDCNT                 NUMERIC(10) NULL,
	USE_AT                CHAR(1) NOT NULL,
	NTCE_BGNDE            CHAR(20) NULL,
	NTCE_ENDDE            CHAR(20) NULL,
	NTCR_ID               VARCHAR(20) NULL,
	NTCR_NM               VARCHAR(20) NULL,
	PASSWORD              VARCHAR(200) NULL,
	ATCH_FILE_ID          CHAR(20) NULL,
	NOTICE_AT             CHAR(1) NULL,
	SJ_BOLD_AT            CHAR(1) NULL,
	SECRET_AT             CHAR(1) NULL,
	FRST_REGIST_PNTTM     TIMESTAMP NOT NULL,
	FRST_REGISTER_ID      VARCHAR(20) NOT NULL,
	LAST_UPDT_PNTTM       TIMESTAMP NULL,
	LAST_UPDUSR_ID        VARCHAR(20) NULL,
	BLOG_ID 					CHAR(20) NULL,
	PRIMARY KEY (NTT_ID,BBS_ID),
	FOREIGN KEY (BBS_ID) REFERENCES COMTNBBSMASTER(BBS_ID)
)
;



CREATE UNIQUE INDEX COMTNBBS_PK ON COMTNBBS
(
	NTT_ID,
	BBS_ID
)
;



CREATE INDEX COMTNBBS_i01 ON COMTNBBS
(
	BBS_ID
)
;



CREATE TABLE COMTNCOMMENT
(
	NTT_ID                NUMERIC(20) NOT NULL,
	BBS_ID                CHAR(20) NOT NULL,
	ANSWER_NO             NUMERIC(20) NOT NULL,
	WRTER_ID              VARCHAR(20) NULL,
	WRTER_NM              VARCHAR(20) NULL,
	ANSWER                VARCHAR(200) NULL,
	USE_AT                CHAR(1) NOT NULL,
	FRST_REGIST_PNTTM     TIMESTAMP NOT NULL,
	FRST_REGISTER_ID      VARCHAR(20) NOT NULL,
	LAST_UPDT_PNTTM       TIMESTAMP NULL,
	LAST_UPDUSR_ID        VARCHAR(20) NULL,
	PASSWORD              VARCHAR(200) NULL,
	 PRIMARY KEY (NTT_ID,BBS_ID,ANSWER_NO),
	FOREIGN KEY (NTT_ID,BBS_ID) REFERENCES COMTNBBS(NTT_ID,BBS_ID)
)
;



CREATE UNIQUE INDEX COMTNCOMMENT_PK ON COMTNCOMMENT
(
	NTT_ID,
	BBS_ID,
	ANSWER_NO
)
;



CREATE INDEX COMTNCOMMENT_i01 ON COMTNCOMMENT
(
	NTT_ID,
	BBS_ID
)
;



CREATE TABLE COMTNRECOMENDSITEINFO
(
	RECOMEND_SITE_ID      CHAR(20) NOT NULL,
	RECOMEND_SITE_NM      VARCHAR(100) NULL,
	RECOMEND_SITE_URL     VARCHAR(255) NULL,
	RECOMEND_SITE_DC      VARCHAR(1000) NULL,
	RECOMEND_RESN_CN      VARCHAR(1000) NULL,
	RECOMEND_CONFM_AT     CHAR(1) NULL,
	CONFM_DE              CHAR(20) NULL,
	FRST_REGIST_PNTTM     TIMESTAMP NULL,
	FRST_REGISTER_ID      VARCHAR(20) NULL,
	LAST_UPDT_PNTTM       TIMESTAMP NULL,
	LAST_UPDUSR_ID        VARCHAR(20) NULL,
	 PRIMARY KEY (RECOMEND_SITE_ID)
)
;



CREATE UNIQUE INDEX COMTNRECOMENDSITEINFO_PK ON COMTNRECOMENDSITEINFO
(
	RECOMEND_SITE_ID
)
;



CREATE TABLE COMTNINTNETSVC
(
	INTNET_SVC_ID         CHAR(20) NOT NULL,
	INTNET_SVC_NM         VARCHAR(20) NOT NULL,
	INTNET_SVC_DC         VARCHAR(200) NULL,
	REFLCT_AT             CHAR(1) NOT NULL,
	FRST_REGISTER_ID      VARCHAR(20) NULL,
	FRST_REGIST_PNTTM     TIMESTAMP NULL,
	LAST_UPDUSR_ID        VARCHAR(20) NULL,
	LAST_UPDT_PNTTM       TIMESTAMP NULL,
	 PRIMARY KEY (INTNET_SVC_ID)
)
;



CREATE UNIQUE INDEX COMTNINTNETSVC_PK ON COMTNINTNETSVC
(
	INTNET_SVC_ID
)
;



CREATE TABLE COMTNCLUB
(
	CLB_ID                CHAR(20) NOT NULL,
	CMMNTY_ID             CHAR(20) NOT NULL,
	CLB_NM                VARCHAR(255) NOT NULL,
	CLB_INTRCN            VARCHAR(2400) NULL,
	USE_AT                CHAR(1) NOT NULL,
	REGIST_SE_CODE        CHAR(6) NULL,
	TMPLAT_ID             CHAR(20) NULL,
	FRST_REGIST_PNTTM     TIMESTAMP NOT NULL,
	FRST_REGISTER_ID      VARCHAR(20) NOT NULL,
	LAST_UPDT_PNTTM       TIMESTAMP NULL,
	LAST_UPDUSR_ID        VARCHAR(20) NULL,
	 PRIMARY KEY (CLB_ID,CMMNTY_ID)
)
;



CREATE UNIQUE INDEX COMTNCLUB_PK ON COMTNCLUB
(
	CLB_ID,
	CMMNTY_ID
)
;



CREATE TABLE COMTNCLUBUSER
(
	CLB_ID                CHAR(20) NOT NULL,
	CMMNTY_ID             CHAR(20) NOT NULL,
	OPRTR_AT              CHAR(1) NOT NULL,
	SBSCRB_DE             TIMESTAMP NULL,
	SECSN_DE              CHAR(20) NULL,
	USE_AT                CHAR(1) NOT NULL,
	FRST_REGIST_PNTTM     TIMESTAMP NOT NULL,
	FRST_REGISTER_ID      VARCHAR(20) NOT NULL,
	LAST_UPDT_PNTTM       TIMESTAMP NULL,
	LAST_UPDUSR_ID        VARCHAR(20) NULL,
	EMPLYR_ID             VARCHAR(20) NOT NULL,
	 PRIMARY KEY (CLB_ID,CMMNTY_ID,EMPLYR_ID),
	FOREIGN KEY (CLB_ID,CMMNTY_ID) REFERENCES COMTNCLUB(CLB_ID,CMMNTY_ID)
)
;



CREATE UNIQUE INDEX COMTNCLUBUSER_PK ON COMTNCLUBUSER
(
	CLB_ID,
	CMMNTY_ID,
	EMPLYR_ID
)
;



CREATE INDEX COMTNCLUBUSER_i01 ON COMTNCLUBUSER
(
	CLB_ID,
	CMMNTY_ID
)
;



CREATE TABLE COMTNBACKUPOPERT
(
	BACKUP_OPERT_ID       VARCHAR(20) NOT NULL,
	BACKUP_OPERT_NM       VARCHAR(60) NULL,
	BACKUP_ORGINL_DRCTRY  VARCHAR(255) NULL,
	BACKUP_STRE_DRCTRY    VARCHAR(255) NULL,
	CMPRS_SE              VARCHAR(2) NULL,
	EXECUT_CYCLE          VARCHAR(2) NULL,
	EXECUT_SCHDUL_DE      CHAR(20) NULL,
	EXECUT_SCHDUL_HOUR    CHAR(2) NULL,
	EXECUT_SCHDUL_MNT     CHAR(2) NULL,
	EXECUT_SCHDUL_SECND   CHAR(2) NULL,
	USE_AT                CHAR(1) NULL,
	FRST_REGISTER_ID      VARCHAR(20) NULL,
	FRST_REGIST_PNTTM     TIMESTAMP NULL,
	LAST_UPDUSR_ID        VARCHAR(20) NULL,
	LAST_UPDT_PNTTM       TIMESTAMP NOT NULL,
	 PRIMARY KEY (BACKUP_OPERT_ID)
)
;



CREATE UNIQUE INDEX COMTNBACKUPOPERT_PK ON COMTNBACKUPOPERT
(
	BACKUP_OPERT_ID
)
;



CREATE TABLE COMTNBACKUPSCHDULDFK
(
	BACKUP_OPERT_ID       VARCHAR(20) NOT NULL,
	EXECUT_SCHDUL_DFK_SE  CHAR(1) NOT NULL,
	 PRIMARY KEY (BACKUP_OPERT_ID,EXECUT_SCHDUL_DFK_SE),
	FOREIGN KEY (BACKUP_OPERT_ID) REFERENCES COMTNBACKUPOPERT(BACKUP_OPERT_ID)
)
;



CREATE UNIQUE INDEX COMTNBACKUPSCHDULDFK_PK ON COMTNBACKUPSCHDULDFK
(
	BACKUP_OPERT_ID,
	EXECUT_SCHDUL_DFK_SE
)
;



CREATE TABLE COMTNCMMNTY
(
	CMMNTY_ID             CHAR(20) NOT NULL,
	CMMNTY_NM             VARCHAR(255) NOT NULL,
	CMMNTY_INTRCN         VARCHAR(2400) NULL,
	USE_AT                CHAR(1) NOT NULL,
	REGIST_SE_CODE        CHAR(6) NULL,
	TMPLAT_ID             CHAR(20) NULL,
	FRST_REGIST_PNTTM     TIMESTAMP NOT NULL,
	FRST_REGISTER_ID      VARCHAR(20) NOT NULL,
	LAST_UPDT_PNTTM       TIMESTAMP NULL,
	LAST_UPDUSR_ID        VARCHAR(20) NULL,
	 PRIMARY KEY (CMMNTY_ID)
)
;



CREATE UNIQUE INDEX COMTNCMMNTY_PK ON COMTNCMMNTY
(
	CMMNTY_ID
)
;



CREATE TABLE COMTNCMMNTYUSER
(
	CMMNTY_ID             CHAR(20) NOT NULL,
	EMPLYR_ID             VARCHAR(20) NOT NULL,
	MNGR_AT               CHAR(1) NOT NULL,
	MBER_STTUS            VARCHAR(15) NULL,
	SBSCRB_DE             TIMESTAMP NULL,
	SECSN_DE              CHAR(20) NULL,
	USE_AT                CHAR(1) NULL,
	FRST_REGIST_PNTTM     TIMESTAMP NOT NULL,
	FRST_REGISTER_ID      VARCHAR(20) NOT NULL,
	LAST_UPDT_PNTTM       TIMESTAMP NULL,
	LAST_UPDUSR_ID        VARCHAR(20) NULL,
	 PRIMARY KEY (CMMNTY_ID,EMPLYR_ID),
	FOREIGN KEY (CMMNTY_ID) REFERENCES COMTNCMMNTY(CMMNTY_ID)
)
;



CREATE UNIQUE INDEX COMTNCMMNTYUSER_PK ON COMTNCMMNTYUSER
(
	CMMNTY_ID,
	EMPLYR_ID
)
;



CREATE INDEX COMTNCMMNTYUSER_i01 ON COMTNCMMNTYUSER
(
	CMMNTY_ID
)
;



CREATE TABLE COMTNFILEDETAIL
(
	ATCH_FILE_ID          CHAR(20) NOT NULL,
	FILE_SN               NUMERIC(10) NOT NULL,
	FILE_STRE_COURS       VARCHAR(2000) NOT NULL,
	STRE_FILE_NM          VARCHAR(255) NOT NULL,
	ORIGNL_FILE_NM        VARCHAR(255) NULL,
	FILE_EXTSN            VARCHAR(20) NOT NULL,
	FILE_CN               TEXT NULL,
	FILE_SIZE             NUMERIC(8) NULL,
	 PRIMARY KEY (ATCH_FILE_ID,FILE_SN),
	FOREIGN KEY (ATCH_FILE_ID) REFERENCES COMTNFILE(ATCH_FILE_ID)
)
;



CREATE UNIQUE INDEX COMTNFILEDETAIL_PK ON COMTNFILEDETAIL
(
	ATCH_FILE_ID,
	FILE_SN
)
;



CREATE INDEX COMTNFILEDETAIL_i01 ON COMTNFILEDETAIL
(
	ATCH_FILE_ID
)
;



CREATE TABLE COMTNLOGINPOLICY
(
	EMPLYR_ID             VARCHAR(20) NOT NULL,
	IP_INFO               VARCHAR(23) NOT NULL,
	DPLCT_PERM_AT         CHAR(1) NOT NULL,
	LMTT_AT               CHAR(1) NOT NULL,
	FRST_REGISTER_ID      VARCHAR(20) NULL,
	FRST_REGIST_PNTTM     TIMESTAMP NULL,
	LAST_UPDUSR_ID        VARCHAR(20) NULL,
	LAST_UPDT_PNTTM       TIMESTAMP NULL,
	 PRIMARY KEY (EMPLYR_ID)
)
;



CREATE UNIQUE INDEX COMTNLOGINPOLICY_PK ON COMTNLOGINPOLICY
(
	EMPLYR_ID
)
;



CREATE TABLE COMTNQUSTNRTMPLAT
(
	QUSTNR_TMPLAT_ID      CHAR(20) NOT NULL,
	QUSTNR_TMPLAT_TY      VARCHAR(100) NULL,
	QUSTNR_TMPLAT_DC      VARCHAR(2000) NULL,
	QUSTNR_TMPLAT_PATH_NM  VARCHAR(100) NULL,
	FRST_REGIST_PNTTM     TIMESTAMP NULL,
	FRST_REGISTER_ID      VARCHAR(20) NULL,
	LAST_UPDT_PNTTM       TIMESTAMP NULL,
	LAST_UPDUSR_ID        VARCHAR(20) NULL,
	QUSTNR_TMPLAT_IMAGE_INFO  BYTEA NULL,
	 PRIMARY KEY (QUSTNR_TMPLAT_ID)
)
;



CREATE UNIQUE INDEX COMTNQUSTNRTMPLAT_PK ON COMTNQUSTNRTMPLAT
(
	QUSTNR_TMPLAT_ID
)
;



CREATE TABLE COMTNQESTNRINFO
(
	QUSTNR_TMPLAT_ID      CHAR(20) NOT NULL,
	QESTNR_ID             CHAR(20) NOT NULL,
	QUSTNR_SJ             VARCHAR(255) NULL,
	QUSTNR_PURPS          VARCHAR(1000) NULL,
	QUSTNR_WRITNG_GUIDANCE_CN  VARCHAR(2000) NULL,
	QUSTNR_TRGET          VARCHAR(1000) NULL,
	QUSTNR_BGNDE          CHAR(20) NULL,
	QUSTNR_ENDDE          CHAR(20) NULL,
	FRST_REGIST_PNTTM     TIMESTAMP NULL,
	FRST_REGISTER_ID      VARCHAR(20) NULL,
	LAST_UPDT_PNTTM       TIMESTAMP NULL,
	LAST_UPDUSR_ID        VARCHAR(20) NULL,
	 PRIMARY KEY (QUSTNR_TMPLAT_ID,QESTNR_ID),
	FOREIGN KEY (QUSTNR_TMPLAT_ID) REFERENCES COMTNQUSTNRTMPLAT(QUSTNR_TMPLAT_ID)
)
;



CREATE UNIQUE INDEX COMTNQESTNRINFO_PK ON COMTNQESTNRINFO
(
	QUSTNR_TMPLAT_ID,
	QESTNR_ID
)
;



CREATE INDEX COMTNQESTNRINFO_i01 ON COMTNQESTNRINFO
(
	QUSTNR_TMPLAT_ID
)
;



CREATE TABLE COMTNQUSTNRRESPONDINFO
(
	QUSTNR_TMPLAT_ID      CHAR(20) NOT NULL,
	QESTNR_ID             CHAR(20) NOT NULL,
	QUSTNR_RESPOND_ID     CHAR(20) NOT NULL,
	SEXDSTN_CODE          CHAR(1) NULL,
	OCCP_TY_CODE          CHAR(1) NULL,
	RESPOND_NM            VARCHAR(50) NULL,
	BRTHDY                CHAR(20) NULL,
	AREA_NO               VARCHAR(4) NULL,
	MIDDLE_TELNO          VARCHAR(4) NULL,
	END_TELNO             VARCHAR(4) NULL,
	FRST_REGIST_PNTTM     TIMESTAMP NULL,
	FRST_REGISTER_ID      VARCHAR(20) NULL,
	LAST_UPDT_PNTTM       TIMESTAMP NULL,
	LAST_UPDUSR_ID        VARCHAR(20) NULL,
	 PRIMARY KEY (QUSTNR_TMPLAT_ID,QESTNR_ID,QUSTNR_RESPOND_ID),
	FOREIGN KEY (QUSTNR_TMPLAT_ID,QESTNR_ID) REFERENCES COMTNQESTNRINFO(QUSTNR_TMPLAT_ID,QESTNR_ID)
)
;



CREATE UNIQUE INDEX COMTNQUSTNRRESPONDINFO_PK ON COMTNQUSTNRRESPONDINFO
(
	QUSTNR_TMPLAT_ID,
	QESTNR_ID,
	QUSTNR_RESPOND_ID
)
;



CREATE INDEX COMTNQUSTNRRESPONDINFO_i01 ON COMTNQUSTNRRESPONDINFO
(
	QESTNR_ID,
	QUSTNR_TMPLAT_ID
)
;



CREATE TABLE COMTCADMINISTCODE
(
	ADMINIST_ZONE_SE      CHAR(1) NOT NULL,
	ADMINIST_ZONE_CODE    VARCHAR(10) NOT NULL,
	USE_AT                CHAR(1) NOT NULL,
	ADMINIST_ZONE_NM      VARCHAR(60) NULL,
	UPPER_ADMINIST_ZONE_CODE  VARCHAR(10) NULL,
	CREAT_DE              CHAR(20) NULL,
	ABL_DE                CHAR(20) NULL,
	FRST_REGIST_PNTTM     TIMESTAMP NULL,
	FRST_REGISTER_ID      VARCHAR(20) NULL,
	LAST_UPDT_PNTTM       TIMESTAMP NULL,
	LAST_UPDUSR_ID        VARCHAR(20) NULL,
	 PRIMARY KEY (ADMINIST_ZONE_SE,ADMINIST_ZONE_CODE)
)
;



CREATE UNIQUE INDEX COMTCADMINISTCODE_PK ON COMTCADMINISTCODE
(
	ADMINIST_ZONE_SE,
	ADMINIST_ZONE_CODE
)
;



CREATE TABLE COMTNUSERLOG
(
	OCCRRNC_DE            CHAR(8) NOT NULL,
	RQESTER_ID            VARCHAR(20) NOT NULL,
	SVC_NM                VARCHAR(255) NOT NULL,
	METHOD_NM             VARCHAR(60) NOT NULL,
	CREAT_CO              NUMERIC(10) NULL,
	UPDT_CO               NUMERIC(10) NULL,
	RDCNT                 NUMERIC(10) NULL,
	DELETE_CO             NUMERIC(10) NULL,
	OUTPT_CO              NUMERIC(10) NULL,
	ERROR_CO              NUMERIC(10) NULL,
	 PRIMARY KEY (OCCRRNC_DE,RQESTER_ID,SVC_NM,METHOD_NM)
)
;



CREATE UNIQUE INDEX COMTNUSERLOG_PK ON COMTNUSERLOG
(
	OCCRRNC_DE,
	RQESTER_ID,
	SVC_NM,
	METHOD_NM
)
;



CREATE TABLE COMTSTRSMRCVLOGSUMMARY
(
	OCCRRNC_DE            CHAR(20) NOT NULL,
	TRSMRCV_SE_CODE       CHAR(3) NOT NULL,
	PROVD_INSTT_ID        CHAR(8) NOT NULL,
	PROVD_SYS_ID          CHAR(8) NOT NULL,
	PROVD_SVC_ID          CHAR(8) NOT NULL,
	REQUST_INSTT_ID       CHAR(8) NOT NULL,
	REQUST_SYS_ID         CHAR(8) NOT NULL,
	RDCNT                 NUMERIC(10) NULL,
	ERROR_CO              NUMERIC(10) NULL,
	 PRIMARY KEY (OCCRRNC_DE,TRSMRCV_SE_CODE,PROVD_INSTT_ID,PROVD_SYS_ID,PROVD_SVC_ID,REQUST_INSTT_ID,REQUST_SYS_ID)
)
;



CREATE UNIQUE INDEX COMTSTRSMRCVLOGSUMMARY_PK ON COMTSTRSMRCVLOGSUMMARY
(
	OCCRRNC_DE,
	TRSMRCV_SE_CODE,
	PROVD_INSTT_ID,
	PROVD_SYS_ID,
	PROVD_SVC_ID,
	REQUST_INSTT_ID,
	REQUST_SYS_ID
)
;



CREATE TABLE COMTCCMMNCLCODE
(
	CL_CODE               CHAR(3) NOT NULL,
	CL_CODE_NM            VARCHAR(60) NULL,
	CL_CODE_DC            VARCHAR(200) NULL,
	USE_AT                CHAR(1) NULL,
	FRST_REGIST_PNTTM     TIMESTAMP NULL,
	FRST_REGISTER_ID      VARCHAR(20) NULL,
	LAST_UPDT_PNTTM       TIMESTAMP NULL,
	LAST_UPDUSR_ID        VARCHAR(20) NULL,
	 PRIMARY KEY (CL_CODE)
)
;



CREATE UNIQUE INDEX COMTCCMMNCLCODE_PK ON COMTCCMMNCLCODE
(
	CL_CODE
)
;



CREATE TABLE COMTCCMMNCODE
(
	CODE_ID               VARCHAR(6) NOT NULL,
	CODE_ID_NM            VARCHAR(60) NULL,
	CODE_ID_DC            VARCHAR(200) NULL,
	USE_AT                CHAR(1) NULL,
	CL_CODE               CHAR(3) NULL,
	FRST_REGIST_PNTTM     TIMESTAMP NULL,
	FRST_REGISTER_ID      VARCHAR(20) NULL,
	LAST_UPDT_PNTTM       TIMESTAMP NULL,
	LAST_UPDUSR_ID        VARCHAR(20) NULL,
	 PRIMARY KEY (CODE_ID),
	FOREIGN KEY (CL_CODE) REFERENCES COMTCCMMNCLCODE(CL_CODE)
)
;



CREATE UNIQUE INDEX COMTCCMMNCODE_PK ON COMTCCMMNCODE
(
	CODE_ID
)
;



CREATE INDEX COMTCCMMNCODE_i01 ON COMTCCMMNCODE
(
	CL_CODE
)
;



CREATE TABLE COMTCCMMNDETAILCODE
(
	CODE_ID               VARCHAR(6) NOT NULL,
	CODE                  VARCHAR(15) NOT NULL,
	CODE_NM               VARCHAR(60) NULL,
	CODE_DC               VARCHAR(200) NULL,
	USE_AT                CHAR(1) NULL,
	FRST_REGIST_PNTTM     TIMESTAMP NULL,
	FRST_REGISTER_ID      VARCHAR(20) NULL,
	LAST_UPDT_PNTTM       TIMESTAMP NULL,
	LAST_UPDUSR_ID        VARCHAR(20) NULL,
	 PRIMARY KEY (CODE_ID,CODE),
	FOREIGN KEY (CODE_ID) REFERENCES COMTCCMMNCODE(CODE_ID)
)
;



CREATE UNIQUE INDEX COMTCCMMNDETAILCODE_PK ON COMTCCMMNDETAILCODE
(
	CODE_ID,
	CODE
)
;



CREATE INDEX COMTCCMMNDETAILCODE_i01 ON COMTCCMMNDETAILCODE
(
	CODE_ID
)
;



CREATE TABLE COMTSBBSSUMMARY
(
	OCCRRNC_DE            CHAR(20) NOT NULL,
	STATS_SE              VARCHAR(10) NOT NULL,
	DETAIL_STATS_SE       VARCHAR(10) NOT NULL,
	CREAT_CO              NUMERIC(10) NULL,
	TOT_RDCNT             NUMERIC(10) NULL,
	AVRG_RDCNT            NUMERIC(10) NULL,
	TOP_INQIRE_BBSCTT_ID  VARCHAR(20) NULL,
	MUMM_INQIRE_BBSCTT_ID  VARCHAR(20) NULL,
	TOP_NTCR_ID           VARCHAR(20) NULL,
	 PRIMARY KEY (OCCRRNC_DE,STATS_SE,DETAIL_STATS_SE)
)
;



CREATE UNIQUE INDEX COMTSBBSSUMMARY_PK ON COMTSBBSSUMMARY
(
	OCCRRNC_DE,
	STATS_SE,
	DETAIL_STATS_SE
)
;



CREATE TABLE COMTCZIP
(
	ZIP                   VARCHAR(6) NOT NULL,
	SN                    NUMERIC(10) NOT NULL,
	CTPRVN_NM             VARCHAR(20) NULL,
	SIGNGU_NM             VARCHAR(20) NULL,
	EMD_NM                VARCHAR(60) NULL,
	LI_BULD_NM            VARCHAR(60) NULL,
	LNBR_DONG_HO          VARCHAR(20) NULL,
	FRST_REGIST_PNTTM     TIMESTAMP NULL,
	FRST_REGISTER_ID      VARCHAR(20) NULL,
	LAST_UPDT_PNTTM       TIMESTAMP NULL,
	LAST_UPDUSR_ID        VARCHAR(20) NULL,
	 PRIMARY KEY (ZIP,SN)
)
;



CREATE UNIQUE INDEX COMTCZIP_PK ON COMTCZIP
(
	ZIP,
	SN
)
;



CREATE TABLE COMTRDNMADRZIP
(
	RDMN_CODE             VARCHAR(12) NOT NULL,
	SN                    NUMERIC(10) NOT NULL,
	CTPRVN_NM             VARCHAR(20) NULL,
	SIGNGU_NM             VARCHAR(20) NULL,
	RDMN                  VARCHAR(60) NULL,
	BDNBR_MNNM            VARCHAR(5) NULL,
	BDNBR_SLNO            VARCHAR(5) NULL,
	BULD_NM               VARCHAR(60) NULL,
	DETAIL_BULD_NM        VARCHAR(60) NULL,
	ZIP                   VARCHAR(6) NOT NULL,
	FRST_REGIST_PNTTM     TIMESTAMP NULL,
	FRST_REGISTER_ID      VARCHAR(20) NULL,
	LAST_UPDT_PNTTM       TIMESTAMP NULL,
	LAST_UPDUSR_ID        VARCHAR(20) NULL,
	 PRIMARY KEY (SN)
)
;



CREATE UNIQUE INDEX COMTRDNMADRZIP_PK ON COMTRDNMADRZIP
(
	RDMN_CODE,
	SN
)
;



CREATE TABLE COMTNNCRD
(
	NCRD_ID               CHAR(20) NOT NULL,
	NCRD_TRGTER_ID        VARCHAR(20) NULL,
	NM                    VARCHAR(50) NOT NULL,
	TELNO                 VARCHAR(20) NULL,
	NATION_NO             VARCHAR(10) NULL,
	AREA_NO               VARCHAR(4) NULL,
	MIDDLE_TELNO          VARCHAR(4) NULL,
	END_TELNO             VARCHAR(4) NULL,
	MBTLNUM               VARCHAR(20) NULL,
	IDNTFC_NO             VARCHAR(10) NULL,
	MIDDLE_MBTLNUM        VARCHAR(4) NULL,
	END_MBTLNUM           VARCHAR(4) NULL,
	EMAIL_ADRES           VARCHAR(50) NULL,
	CMPNY_NM              VARCHAR(60) NULL,
	DEPT_NM               VARCHAR(60) NULL,
	ADRES                 VARCHAR(100) NULL,
	DETAIL_ADRES          VARCHAR(100) NULL,
	OFCPS_NM              VARCHAR(60) NULL,
	CLSF_NM               VARCHAR(60) NULL,
	EXTRL_USER_AT         CHAR(1) NULL,
	OTHBC_AT              CHAR(1) NOT NULL,
	RM                    VARCHAR(2500) NULL,
	FRST_REGIST_PNTTM     TIMESTAMP NOT NULL,
	FRST_REGISTER_ID      VARCHAR(20) NULL,
	LAST_UPDT_PNTTM       TIMESTAMP NULL,
	LAST_UPDUSR_ID        VARCHAR(20) NULL,
	 PRIMARY KEY (NCRD_ID)
)
;



CREATE UNIQUE INDEX COMTNNCRD_PK ON COMTNNCRD
(
	NCRD_ID
)
;



CREATE TABLE COMTNNCRDUSER
(
	NCRD_ID               CHAR(20) NOT NULL,
	REGIST_SE_CODE        CHAR(6) NOT NULL,
	USE_AT                CHAR(1) NOT NULL,
	CREAT_DT              TIMESTAMP NOT NULL,
	EMPLYR_ID             VARCHAR(20) NOT NULL,
	 PRIMARY KEY (NCRD_ID,EMPLYR_ID),
	FOREIGN KEY (NCRD_ID) REFERENCES COMTNNCRD(NCRD_ID)
)
;



CREATE UNIQUE INDEX COMTNNCRDUSER_PK ON COMTNNCRDUSER
(
	NCRD_ID,
	EMPLYR_ID
)
;



CREATE INDEX COMTNNCRDUSER_i03 ON COMTNNCRDUSER
(
	NCRD_ID
)
;



CREATE TABLE COMTNENTRPRSMBER
(
	ENTRPRS_MBER_ID       VARCHAR(20) NOT NULL,
	ENTRPRS_SE_CODE       CHAR(8) NULL,
	BIZRNO                VARCHAR(10) NULL,
	JURIRNO               VARCHAR(13) NULL,
	CMPNY_NM              VARCHAR(60) NOT NULL,
	CXFC                  VARCHAR(50) NULL,
	ZIP                   VARCHAR(6) NOT NULL,
	ADRES                 VARCHAR(100) NOT NULL,
	ENTRPRS_MIDDLE_TELNO  VARCHAR(4) NOT NULL,
	FXNUM                 VARCHAR(20) NULL,
	INDUTY_CODE           CHAR(1) NULL,
	APPLCNT_NM            VARCHAR(50) NOT NULL,
	APPLCNT_IHIDNUM       VARCHAR(200) NULL,
	SBSCRB_DE             TIMESTAMP NULL,
	ENTRPRS_MBER_STTUS    VARCHAR(15) NULL,
	ENTRPRS_MBER_PASSWORD  VARCHAR(200) NULL,
	ENTRPRS_MBER_PASSWORD_HINT  VARCHAR(100) NOT NULL,
	ENTRPRS_MBER_PASSWORD_CNSR  VARCHAR(100) NOT NULL,
	GROUP_ID              CHAR(20) NULL,
	DETAIL_ADRES          VARCHAR(100) NULL,
	ENTRPRS_END_TELNO     VARCHAR(4) NOT NULL,
	AREA_NO               VARCHAR(4) NOT NULL,
	APPLCNT_EMAIL_ADRES   VARCHAR(50) NOT NULL,
	ESNTL_ID              CHAR(20) NOT NULL,
	LOCK_AT               CHAR(1) NULL,
	LOCK_CNT              NUMERIC(3) NULL,
	LOCK_LAST_PNTTM       TIMESTAMP NULL,
	 PRIMARY KEY (ENTRPRS_MBER_ID),
	FOREIGN KEY (GROUP_ID) REFERENCES COMTNAUTHORGROUPINFO(GROUP_ID)
		ON DELETE SET NULL
)
;



CREATE UNIQUE INDEX COMTNENTRPRSMBER_PK ON COMTNENTRPRSMBER
(
	ENTRPRS_MBER_ID
)
;



CREATE INDEX COMTNENTRPRSMBER_i01 ON COMTNENTRPRSMBER
(
	GROUP_ID
)
;



CREATE TABLE COMTNGNRLMBER
(
	MBER_ID               VARCHAR(20) NOT NULL,
	PASSWORD              VARCHAR(200) NOT NULL,
	PASSWORD_HINT         VARCHAR(100) NULL,
	PASSWORD_CNSR         VARCHAR(100) NULL,
	IHIDNUM               VARCHAR(200) NULL,
	MBER_NM               VARCHAR(50) NOT NULL,
	ZIP                   VARCHAR(6) NOT NULL,
	ADRES                 VARCHAR(100) NOT NULL,
	AREA_NO               VARCHAR(4) NOT NULL,
	MBER_STTUS            VARCHAR(15) NULL,
	DETAIL_ADRES          VARCHAR(100) NULL,
	END_TELNO             VARCHAR(4) NOT NULL,
	MBTLNUM               VARCHAR(20) NOT NULL,
	GROUP_ID              CHAR(20) NULL,
	MBER_FXNUM            VARCHAR(20) NULL,
	MBER_EMAIL_ADRES      VARCHAR(50) NULL,
	MIDDLE_TELNO          VARCHAR(4) NOT NULL,
	SBSCRB_DE             TIMESTAMP NULL,
	SEXDSTN_CODE          CHAR(1) NULL,
	ESNTL_ID              CHAR(20) NOT NULL,
	LOCK_AT               CHAR(1) NULL,
	LOCK_CNT              NUMERIC(3) NULL,
	LOCK_LAST_PNTTM       TIMESTAMP NULL,
	 PRIMARY KEY (MBER_ID),
	FOREIGN KEY (GROUP_ID) REFERENCES COMTNAUTHORGROUPINFO(GROUP_ID)
		ON DELETE SET NULL
)
;



CREATE UNIQUE INDEX COMTNGNRLMBER_PK ON COMTNGNRLMBER
(
	MBER_ID
)
;



CREATE INDEX COMTNGNRLMBER_i01 ON COMTNGNRLMBER
(
	GROUP_ID
)
;



CREATE TABLE COMTNAUTHORINFO
(
	AUTHOR_CODE           VARCHAR(30) NOT NULL,
	AUTHOR_NM             VARCHAR(60) NOT NULL,
	AUTHOR_DC             VARCHAR(200) NULL,
	AUTHOR_CREAT_DE       TIMESTAMP NOT NULL,
	 PRIMARY KEY (AUTHOR_CODE)
)
;



CREATE UNIQUE INDEX COMTNAUTHORINFO_PK ON COMTNAUTHORINFO
(
	AUTHOR_CODE
)
;



CREATE TABLE COMTNEMPLYRSCRTYESTBS
(
	SCRTY_DTRMN_TRGET_ID  VARCHAR(20) NOT NULL,
	MBER_TY_CODE          CHAR(5) NULL,
	AUTHOR_CODE           VARCHAR(30) NOT NULL,
	 PRIMARY KEY (SCRTY_DTRMN_TRGET_ID)
)
;



CREATE UNIQUE INDEX COMTNEMPLYRSCRTYESTBS_PK ON COMTNEMPLYRSCRTYESTBS
(
	SCRTY_DTRMN_TRGET_ID
)
;



CREATE INDEX COMTNEMPLYRSCRTYESTBS_i04 ON COMTNEMPLYRSCRTYESTBS
(
	AUTHOR_CODE
)
;



CREATE TABLE COMTNQAINFO
(
	QA_ID                 CHAR(20) NOT NULL,
	QESTN_SJ              VARCHAR(255) NULL,
	QESTN_CN              VARCHAR(2500) NULL,
	WRITNG_DE             CHAR(20) NULL,
	RDCNT                 NUMERIC(10) NULL,
	EMAIL_ADRES           VARCHAR(50) NULL,
	FRST_REGIST_PNTTM     TIMESTAMP NULL,
	FRST_REGISTER_ID      VARCHAR(20) NULL,
	LAST_UPDT_PNTTM       TIMESTAMP NULL,
	LAST_UPDUSR_ID        VARCHAR(20) NULL,
	QNA_PROCESS_STTUS_CODE  CHAR(1) NULL,
	WRTER_NM              VARCHAR(20) NULL,
	ANSWER_CN             VARCHAR(2500) NULL,
	WRITNG_PASSWORD       VARCHAR(20) NULL,
	ANSWER_DE             CHAR(20) NULL,
	EMAIL_ANSWER_AT       CHAR(1) NULL,
	AREA_NO               VARCHAR(4) NULL,
	MIDDLE_TELNO          VARCHAR(4) NULL,
	END_TELNO             VARCHAR(4) NULL,
	 PRIMARY KEY (QA_ID)
)
;



CREATE UNIQUE INDEX COMTNQAINFO_PK ON COMTNQAINFO
(
	QA_ID
)
;



CREATE TABLE COMTSWEBLOGSUMMARY
(
	OCCRRNC_DE            CHAR(8) NOT NULL,
	URL                   VARCHAR(200) NOT NULL,
	RDCNT                 NUMERIC(10) NULL,
	 PRIMARY KEY (OCCRRNC_DE,URL)
)
;



CREATE UNIQUE INDEX COMTSWEBLOGSUMMARY_PK ON COMTSWEBLOGSUMMARY
(
	OCCRRNC_DE,
	URL
)
;



CREATE TABLE COMTNROLES_HIERARCHY
(
	PARNTS_ROLE           VARCHAR(30) NOT NULL,
	CHLDRN_ROLE           VARCHAR(30) NOT NULL,
	 PRIMARY KEY (PARNTS_ROLE,CHLDRN_ROLE),
	FOREIGN KEY (PARNTS_ROLE) REFERENCES COMTNAUTHORINFO(AUTHOR_CODE)
		ON DELETE CASCADE,
	FOREIGN KEY (CHLDRN_ROLE) REFERENCES COMTNAUTHORINFO(AUTHOR_CODE)
		ON DELETE CASCADE
)
;



CREATE UNIQUE INDEX COMTNROLES_HIERARCHY_PK ON COMTNROLES_HIERARCHY
(
	PARNTS_ROLE,
	CHLDRN_ROLE
)
;



CREATE UNIQUE INDEX COMTNROLES_HIERARCHY_i01 ON COMTNROLES_HIERARCHY
(
	PARNTS_ROLE
)
;



CREATE INDEX COMTNROLES_HIERARCHY_i02 ON COMTNROLES_HIERARCHY
(
	CHLDRN_ROLE
)
;



CREATE TABLE COMTNROLEINFO
(
	ROLE_CODE             VARCHAR(50) NOT NULL,
	ROLE_NM               VARCHAR(60) NOT NULL,
	ROLE_PTTRN            VARCHAR(300) NULL,
	ROLE_DC               VARCHAR(200) NULL,
	ROLE_TY               VARCHAR(80) NULL,
	ROLE_SORT             VARCHAR(10) NULL,
	ROLE_CREAT_DE         TIMESTAMP NOT NULL,
	 PRIMARY KEY (ROLE_CODE)
)
;



CREATE UNIQUE INDEX COMTNROLEINFO_PK ON COMTNROLEINFO
(
	ROLE_CODE
)
;



CREATE TABLE COMTNAUTHORROLERELATE
(
	AUTHOR_CODE           VARCHAR(30) NOT NULL,
	ROLE_CODE             VARCHAR(50) NOT NULL,
	CREAT_DT              TIMESTAMP NULL,
	 PRIMARY KEY (AUTHOR_CODE,ROLE_CODE),
	FOREIGN KEY (AUTHOR_CODE) REFERENCES COMTNAUTHORINFO(AUTHOR_CODE)
		ON DELETE CASCADE,
	FOREIGN KEY (ROLE_CODE) REFERENCES COMTNROLEINFO(ROLE_CODE)
		ON DELETE CASCADE
)
;



CREATE UNIQUE INDEX COMTNAUTHORROLERELATE_PK ON COMTNAUTHORROLERELATE
(
	AUTHOR_CODE,
	ROLE_CODE
)
;



CREATE INDEX COMTNAUTHORROLERELATE_i01 ON COMTNAUTHORROLERELATE
(
	AUTHOR_CODE
)
;



CREATE INDEX COMTNAUTHORROLERELATE_i02 ON COMTNAUTHORROLERELATE
(
	ROLE_CODE
)
;



CREATE TABLE COMTNLOGINLOG
(
	LOG_ID                CHAR(20) NOT NULL,
	CONECT_ID             VARCHAR(20) NULL,
	CONECT_IP             VARCHAR(23) NULL,
	CONECT_MTHD           CHAR(4) NULL,
	ERROR_OCCRRNC_AT      CHAR(1) NULL,
	ERROR_CODE            CHAR(3) NULL,
	CREAT_DT              TIMESTAMP NULL,
	 PRIMARY KEY (LOG_ID)
)
;



CREATE UNIQUE INDEX COMTNLOGINLOG_PK ON COMTNLOGINLOG
(
	LOG_ID
)
;



CREATE TABLE COMTNWEBLOG
(
	REQUST_ID             VARCHAR(20) NOT NULL,
	OCCRRNC_DE            TIMESTAMP NULL,
	URL                   VARCHAR(200) NULL,
	RQESTER_ID            VARCHAR(20) NULL,
	RQESTER_IP            VARCHAR(23) NULL,
	 PRIMARY KEY (REQUST_ID)
)
;



CREATE UNIQUE INDEX COMTNWEBLOG_PK ON COMTNWEBLOG
(
	REQUST_ID
)
;



CREATE TABLE COMTNEVENTINFO
(
	EVENT_ID              CHAR(20) NOT NULL,
	BSNS_YEAR             CHAR(4) NULL,
	BSNS_CODE             VARCHAR(2) NULL,
	EVENT_CN              VARCHAR(1000) NULL,
	EVENT_SVC_BGNDE       CHAR(20) NULL,
	SVC_USE_NMPR_CO       NUMERIC(10) NULL,
	CHARGER_NM            VARCHAR(50) NULL,
	PRPARETG_CN           VARCHAR(2500) NULL,
	FRST_REGIST_PNTTM     TIMESTAMP NULL,
	FRST_REGISTER_ID      VARCHAR(20) NULL,
	LAST_UPDT_PNTTM       TIMESTAMP NULL,
	LAST_UPDUSR_ID        VARCHAR(20) NULL,
	EVENT_SVC_ENDDE       CHAR(20) NULL,
	EVENT_TY_CODE         CHAR(1) NULL,
	EVENT_CONFM_AT        CHAR(1) NULL,
	EVENT_CONFM_DE        CHAR(20) NULL,
	 PRIMARY KEY (EVENT_ID)
)
;



CREATE UNIQUE INDEX COMTNEVENTINFO_PK ON COMTNEVENTINFO
(
	EVENT_ID
)
;



CREATE TABLE COMTNEXTRLHRINFO
(
	EVENT_ID              CHAR(20) NOT NULL,
	EXTRL_HR_ID           CHAR(20) NOT NULL,
	SEXDSTN_CODE          CHAR(1) NULL,
	EXTRL_HR_NM           VARCHAR(60) NULL,
	OCCP_TY_CODE          CHAR(1) NULL,
	PSITN_INSTT_NM        VARCHAR(100) NULL,
	BRTHDY                CHAR(20) NULL,
	AREA_NO               VARCHAR(4) NULL,
	MIDDLE_TELNO          VARCHAR(4) NULL,
	END_TELNO             VARCHAR(4) NULL,
	EMAIL_ADRES           VARCHAR(50) NULL,
	FRST_REGIST_PNTTM     TIMESTAMP NULL,
	FRST_REGISTER_ID      VARCHAR(20) NULL,
	LAST_UPDT_PNTTM       TIMESTAMP NULL,
	LAST_UPDUSR_ID        VARCHAR(20) NULL,
	 PRIMARY KEY (EVENT_ID,EXTRL_HR_ID),
	FOREIGN KEY (EVENT_ID) REFERENCES COMTNEVENTINFO(EVENT_ID)
)
;



CREATE UNIQUE INDEX COMTNEXTRLHRINFO_PK ON COMTNEXTRLHRINFO
(
	EVENT_ID,
	EXTRL_HR_ID
)
;



CREATE INDEX COMTNEXTRLHRINFO_i01 ON COMTNEXTRLHRINFO
(
	EVENT_ID
)
;



CREATE TABLE COMTNBBSUSE
(
	BBS_ID                CHAR(20) NOT NULL,
	TRGET_ID              CHAR(20) NOT NULL,
	USE_AT                CHAR(1) NOT NULL,
	REGIST_SE_CODE        CHAR(6) NULL,
	FRST_REGIST_PNTTM     TIMESTAMP NULL,
	FRST_REGISTER_ID      VARCHAR(20) NOT NULL,
	LAST_UPDT_PNTTM       TIMESTAMP NULL,
	LAST_UPDUSR_ID        VARCHAR(20) NULL,
	 PRIMARY KEY (BBS_ID,TRGET_ID),
	FOREIGN KEY (BBS_ID) REFERENCES COMTNBBSMASTER(BBS_ID)
)
;



CREATE UNIQUE INDEX COMTNBBSUSE_PK ON COMTNBBSUSE
(
	BBS_ID,
	TRGET_ID
)
;



CREATE INDEX COMTNBBSUSE_i01 ON COMTNBBSUSE
(
	BBS_ID
)
;



CREATE TABLE COMTNSTPLATINFO
(
	USE_STPLAT_ID         CHAR(20) NOT NULL,
	USE_STPLAT_NM         VARCHAR(100) NULL,
	USE_STPLAT_CN         TEXT NULL,
	INFO_PROVD_AGRE_CN    TEXT NULL,
	FRST_REGIST_PNTTM     TIMESTAMP NULL,
	FRST_REGISTER_ID      VARCHAR(20) NULL,
	LAST_UPDT_PNTTM       TIMESTAMP NULL,
	LAST_UPDUSR_ID        VARCHAR(20) NULL,
	 PRIMARY KEY (USE_STPLAT_ID)
)
;



CREATE UNIQUE INDEX COMTNSTPLATINFO_PK ON COMTNSTPLATINFO
(
	USE_STPLAT_ID
)
;



CREATE TABLE COMTNQUSTNRQESITM
(
	QESTNR_ID             CHAR(20) NOT NULL,
	QUSTNR_QESITM_ID      CHAR(20) NOT NULL,
	QUSTNR_TMPLAT_ID      CHAR(20) NOT NULL,
	QESTN_SN              NUMERIC(10) NULL,
	QESTN_TY_CODE         CHAR(1) NULL,
	QESTN_CN              VARCHAR(2500) NULL,
	MXMM_CHOISE_CO        NUMERIC(5) NULL,
	FRST_REGIST_PNTTM     TIMESTAMP NOT NULL,
	FRST_REGISTER_ID      VARCHAR(20) NOT NULL,
	LAST_UPDT_PNTTM       TIMESTAMP NOT NULL,
	LAST_UPDUSR_ID        VARCHAR(20) NOT NULL,
	 PRIMARY KEY (QESTNR_ID,QUSTNR_QESITM_ID,QUSTNR_TMPLAT_ID),
	FOREIGN KEY (QUSTNR_TMPLAT_ID,QESTNR_ID) REFERENCES COMTNQESTNRINFO(QUSTNR_TMPLAT_ID,QESTNR_ID)
)
;



CREATE UNIQUE INDEX COMTNQUSTNRQESITM_PK ON COMTNQUSTNRQESITM
(
	QESTNR_ID,
	QUSTNR_QESITM_ID,
	QUSTNR_TMPLAT_ID
)
;



CREATE INDEX COMTNQUSTNRQESITM_i02 ON COMTNQUSTNRQESITM
(
	QESTNR_ID,
	QUSTNR_TMPLAT_ID
)
;



CREATE TABLE COMTNQUSTNRRSPNSRESULT
(
	QUSTNR_RSPNS_RESULT_ID  CHAR(20) NOT NULL,
	QESTNR_ID             CHAR(20) NOT NULL,
	QUSTNR_QESITM_ID      CHAR(20) NOT NULL,
	QUSTNR_TMPLAT_ID      CHAR(20) NOT NULL,
	RESPOND_ANSWER_CN     VARCHAR(1000) NULL,
	ETC_ANSWER_CN         VARCHAR(1000) NULL,
	RESPOND_NM            VARCHAR(50) NULL,
	FRST_REGIST_PNTTM     TIMESTAMP NULL,
	FRST_REGISTER_ID      VARCHAR(20) NULL,
	LAST_UPDT_PNTTM       TIMESTAMP NULL,
	LAST_UPDUSR_ID        VARCHAR(20) NULL,
	QUSTNR_IEM_ID         VARCHAR(20) NULL,
	 PRIMARY KEY (QUSTNR_RSPNS_RESULT_ID,QESTNR_ID,QUSTNR_QESITM_ID,QUSTNR_TMPLAT_ID),
	FOREIGN KEY (QESTNR_ID,QUSTNR_QESITM_ID,QUSTNR_TMPLAT_ID) REFERENCES COMTNQUSTNRQESITM(QESTNR_ID,QUSTNR_QESITM_ID,QUSTNR_TMPLAT_ID)
)
;



CREATE UNIQUE INDEX COMTNQUSTNRRSPNSRESULT_PK ON COMTNQUSTNRRSPNSRESULT
(
	QUSTNR_RSPNS_RESULT_ID,
	QESTNR_ID,
	QUSTNR_QESITM_ID,
	QUSTNR_TMPLAT_ID
)
;



CREATE INDEX COMTNQUSTNRRSPNSRESULT_i01 ON COMTNQUSTNRRSPNSRESULT
(
	QESTNR_ID,
	QUSTNR_QESITM_ID,
	QUSTNR_TMPLAT_ID
)
;



CREATE TABLE COMTNADBKMANAGE
(
	ADBK_ID               CHAR(20) NOT NULL,
	ADBK_NM               VARCHAR(50) NOT NULL,
	OTHBC_SCOPE           VARCHAR(20) NOT NULL,
	USE_AT                CHAR(1) NOT NULL,
	WRTER_ID              VARCHAR(20) NULL,
	TRGET_ORGNZT_ID       CHAR(20) NULL,
	FRST_REGIST_PNTTM     TIMESTAMP NOT NULL,
	LAST_UPDT_PNTTM       TIMESTAMP NULL,
	FRST_REGISTER_ID      VARCHAR(20) NOT NULL,
	LAST_UPDUSR_ID        VARCHAR(20) NULL,
	 PRIMARY KEY (ADBK_ID)
)
;



CREATE UNIQUE INDEX COMTNADBKMANAGE_PK ON COMTNADBKMANAGE
(
	ADBK_ID
)
;



CREATE TABLE COMTNADBK
(
	EMPLYR_ID             VARCHAR(20) NULL,
	NCRD_ID               CHAR(20) NULL,
	FRST_REGIST_PNTTM     TIMESTAMP NULL,
	LAST_UPDT_PNTTM       TIMESTAMP NULL,
	FRST_REGISTER_ID      VARCHAR(20) NULL,
	LAST_UPDUSR_ID        VARCHAR(20) NULL,
	ADBK_CONSTNT_ID       CHAR(20) NOT NULL,
	NM                    VARCHAR(50) NULL,
	EMAIL_ADRES           VARCHAR(50) NULL,
	MBTLNUM               VARCHAR(20) NULL,
	FXNUM                 VARCHAR(20) NULL,
	OFFM_TELNO            VARCHAR(20) NULL,
	HOUSE_TELNO           VARCHAR(20) NULL,
	ADBK_ID               CHAR(20) NOT NULL,
	 PRIMARY KEY (ADBK_CONSTNT_ID,ADBK_ID),
	FOREIGN KEY (ADBK_ID) REFERENCES COMTNADBKMANAGE(ADBK_ID)
		ON DELETE CASCADE
)
;



CREATE UNIQUE INDEX COMTNADBK_PK ON COMTNADBK
(
	ADBK_CONSTNT_ID,
	ADBK_ID
)
;



CREATE INDEX COMTNADBK_i01 ON COMTNADBK
(
	ADBK_ID
)
;



CREATE TABLE COMTNQUSTNRIEM
(
	QUSTNR_TMPLAT_ID      CHAR(20) NOT NULL,
	QESTNR_ID             CHAR(20) NOT NULL,
	QUSTNR_QESITM_ID      CHAR(20) NOT NULL,
	QUSTNR_IEM_ID         VARCHAR(20) NOT NULL,
	IEM_SN                NUMERIC(5) NULL,
	IEM_CN                VARCHAR(1000) NULL,
	ETC_ANSWER_AT         CHAR(1) NULL,
	FRST_REGIST_PNTTM     TIMESTAMP NULL,
	FRST_REGISTER_ID      VARCHAR(20) NULL,
	LAST_UPDT_PNTTM       TIMESTAMP NULL,
	LAST_UPDUSR_ID        VARCHAR(20) NULL,
	 PRIMARY KEY (QUSTNR_TMPLAT_ID,QESTNR_ID,QUSTNR_QESITM_ID,QUSTNR_IEM_ID),
	FOREIGN KEY (QESTNR_ID,QUSTNR_QESITM_ID,QUSTNR_TMPLAT_ID) REFERENCES COMTNQUSTNRQESITM(QESTNR_ID,QUSTNR_QESITM_ID,QUSTNR_TMPLAT_ID)
)
;



CREATE UNIQUE INDEX COMTNQUSTNRIEM_PK ON COMTNQUSTNRIEM
(
	QUSTNR_TMPLAT_ID,
	QESTNR_ID,
	QUSTNR_QESITM_ID,
	QUSTNR_IEM_ID
)
;



CREATE INDEX COMTNQUSTNRIEM_i01 ON COMTNQUSTNRIEM
(
	QUSTNR_QESITM_ID,
	QESTNR_ID,
	QUSTNR_TMPLAT_ID
)
;



CREATE TABLE COMTNADMINISTRATIONWORD
(
	ADMINIST_WORD_ID      CHAR(20) NOT NULL,
	ADMINIST_WORD_NM      VARCHAR(255) NULL,
	ADMINIST_WORD_ENG_NM  VARCHAR(255) NULL,
	ADMINIST_WORD_ABRV_NM  VARCHAR(255) NULL,
	THEMA_RELM            VARCHAR(255) NULL,
	WORD_SE               VARCHAR(255) NULL,
	RELATE_STD_WORD       VARCHAR(255) NULL,
	ADMINIST_WORD_DFN     VARCHAR(2500) NULL,
	ADMINIST_WORD_DC      VARCHAR(4000) NULL,
	FRST_REGISTER_ID      VARCHAR(20) NULL,
	FRST_REGIST_PNTTM     TIMESTAMP NULL,
	LAST_UPDUSR_ID        VARCHAR(20) NULL,
	LAST_UPDT_PNTTM       TIMESTAMP NULL,
	 PRIMARY KEY (ADMINIST_WORD_ID)
)
;



CREATE UNIQUE INDEX COMTNADMINISTRATIONWORD_PK ON COMTNADMINISTRATIONWORD
(
	ADMINIST_WORD_ID
)
;



CREATE TABLE COMTNONLINEMANUAL
(
	ONLINE_MNL_ID         CHAR(20) NOT NULL,
	ONLINE_MNL_SE_CODE    CHAR(3) NULL,
	ONLINE_MNL_DFN        TEXT NULL,
	ONLINE_MNL_DC         TEXT NULL,
	FRST_REGISTER_ID      VARCHAR(20) NULL,
	FRST_REGIST_PNTTM     TIMESTAMP NULL,
	LAST_UPDUSR_ID        VARCHAR(20) NULL,
	LAST_UPDT_PNTTM       TIMESTAMP NULL,
	ONLINE_MNL_NM         VARCHAR(255) NULL,
	 PRIMARY KEY (ONLINE_MNL_ID)
)
;



CREATE UNIQUE INDEX COMTNONLINEMANUAL_PK ON COMTNONLINEMANUAL
(
	ONLINE_MNL_ID
)
;



CREATE TABLE COMTSUSERSUMMARY
(
	OCCRRNC_DE            CHAR(20) NOT NULL,
	STATS_SE              VARCHAR(10) NOT NULL,
	DETAIL_STATS_SE       VARCHAR(10) NOT NULL,
	USER_CO               NUMERIC(10) NULL,
	 PRIMARY KEY (OCCRRNC_DE,STATS_SE,DETAIL_STATS_SE)
)
;



CREATE UNIQUE INDEX COMTSUSERSUMMARY_PK ON COMTSUSERSUMMARY
(
	OCCRRNC_DE,
	STATS_SE,
	DETAIL_STATS_SE
)
;



CREATE TABLE COMTNFAQINFO
(
	FAQ_ID                CHAR(20) NOT NULL,
	QESTN_SJ              VARCHAR(255) NULL,
	QESTN_CN              VARCHAR(2500) NULL,
	ANSWER_CN             VARCHAR(2500) NULL,
	RDCNT                 NUMERIC(10) NULL,
	FRST_REGIST_PNTTM     TIMESTAMP NOT NULL,
	FRST_REGISTER_ID      VARCHAR(20) NOT NULL,
	LAST_UPDT_PNTTM       TIMESTAMP NOT NULL,
	LAST_UPDUSR_ID        VARCHAR(20) NOT NULL,
	ATCH_FILE_ID          CHAR(20) NULL,
	QNA_PROCESS_STTUS_CODE  CHAR(1) NULL,
	 PRIMARY KEY (FAQ_ID),
	FOREIGN KEY (ATCH_FILE_ID) REFERENCES COMTNFILE(ATCH_FILE_ID)
)
;



CREATE UNIQUE INDEX COMTNFAQINFO_PK ON COMTNFAQINFO
(
	FAQ_ID
)
;



CREATE INDEX COMTNFAQINFO_i01 ON COMTNFAQINFO
(
	ATCH_FILE_ID
)
;



CREATE TABLE COMTNMTGINFO
(
	MTG_ID                CHAR(20) NOT NULL,
	MTG_NM                VARCHAR(255) NULL,
	MTG_MTR_CN            VARCHAR(1000) NULL,
	MTG_SN                NUMERIC(10) NULL,
	MTG_CO                NUMERIC(5) NULL,
	MTG_DE                CHAR(20) NULL,
	MTG_PLACE             VARCHAR(255) NULL,
	MTG_BEGIN_TM          VARCHAR(14) NULL,
	MTG_END_TM            VARCHAR(14) NULL,
	CLSDR_MTG_AT          CHAR(1) NULL,
	READNG_BGNDE          CHAR(20) NULL,
	READNG_AT             CHAR(1) NULL,
	MTG_RESULT_CN         VARCHAR(1000) NULL,
	MTG_RESULT_ENNC       CHAR(1) NULL,
	ETC_MATTER            VARCHAR(1000) NULL,
	MNGT_DEPT_ID          VARCHAR(20) NULL,
	MNAER_ID              VARCHAR(20) NULL,
	MNAER_DEPT_ID         VARCHAR(20) NULL,
	MTG_AT                CHAR(1) NULL,
	NONATDRN_CO           NUMERIC(10) NULL,
	ATDRN_CO              NUMERIC(10) NULL,
	FRST_REGIST_PNTTM     TIMESTAMP NULL,
	FRST_REGISTER_ID      VARCHAR(20) NULL,
	LAST_UPDT_PNTTM       TIMESTAMP NULL,
	LAST_UPDUSR_ID        VARCHAR(20) NULL,
	 PRIMARY KEY (MTG_ID)
)
;



CREATE UNIQUE INDEX COMTNMTGINFO_PK ON COMTNMTGINFO
(
	MTG_ID
)
;



CREATE TABLE COMTNREPRTSTATS
(
	REPRT_ID              CHAR(6) NOT NULL,
	REPRT_NM              VARCHAR(20) NOT NULL,
	REPRT_STTUS           CHAR(2) NOT NULL,
	FRST_REGISTER_ID      VARCHAR(20) NOT NULL,
	FRST_REGIST_PNTTM     TIMESTAMP NULL,
	LAST_UPDUSR_ID        VARCHAR(20) NULL,
	LAST_UPDT_PNTTM       TIMESTAMP NULL,
	REPRT_TY              CHAR(2) NULL,
	 PRIMARY KEY (REPRT_ID)
)
;



CREATE UNIQUE INDEX COMTNREPRTSTATS_PK ON COMTNREPRTSTATS
(
	REPRT_ID
)
;



CREATE TABLE COMTNSMS
(
	SMS_ID                CHAR(20) NOT NULL,
	TRNSMIS_TELNO         VARCHAR(12) NOT NULL,
	TRNSMIS_CN            VARCHAR(80) NOT NULL,
	FRST_REGIST_PNTTM     TIMESTAMP NOT NULL,
	FRST_REGISTER_ID      VARCHAR(20) NOT NULL,
	 PRIMARY KEY (SMS_ID)
)
;



CREATE UNIQUE INDEX COMTNSMS_PK ON COMTNSMS
(
	SMS_ID
)
;



CREATE TABLE COMTNSMSRECPTN
(
	SMS_ID                CHAR(20) NOT NULL,
	RECPTN_TELNO          VARCHAR(12) NOT NULL,
	RESULT_CODE           VARCHAR(4) NULL,
	RESULT_MSSAGE         VARCHAR(4000) NULL,
	 PRIMARY KEY (SMS_ID,RECPTN_TELNO),
	FOREIGN KEY (SMS_ID) REFERENCES COMTNSMS(SMS_ID)
)
;



CREATE UNIQUE INDEX COMTNSMSRECPTN_PK ON COMTNSMSRECPTN
(
	SMS_ID,
	RECPTN_TELNO
)
;



CREATE INDEX COMTNSMSRECPTN_i01 ON COMTNSMSRECPTN
(
	SMS_ID
)
;



CREATE TABLE COMTNCPYRHTINFO
(
	CPYRHT_ID             CHAR(20) NOT NULL,
	CPYRHT_PRTC_POLICY_CN  VARCHAR(2500) NULL,
	FRST_REGIST_PNTTM     TIMESTAMP NULL,
	FRST_REGISTER_ID      VARCHAR(20) NULL,
	LAST_UPDT_PNTTM       TIMESTAMP NULL,
	LAST_UPDUSR_ID        VARCHAR(20) NULL,
	 PRIMARY KEY (CPYRHT_ID)
)
;



CREATE UNIQUE INDEX COMTNCPYRHTINFO_PK ON COMTNCPYRHTINFO
(
	CPYRHT_ID
)
;



CREATE TABLE COMTNSCHDULINFO
(
	SCHDUL_ID             CHAR(20) NOT NULL,
	SCHDUL_SE             CHAR(1) NULL,
	SCHDUL_DEPT_ID        VARCHAR(20) NULL,
	SCHDUL_KND_CODE       CHAR(1) NULL,
	SCHDUL_BGNDE          CHAR(20) NULL,
	SCHDUL_ENDDE          CHAR(20) NULL,
	SCHDUL_NM             VARCHAR(255) NULL,
	SCHDUL_CN             VARCHAR(2500) NULL,
	SCHDUL_PLACE          VARCHAR(255) NULL,
	SCHDUL_IPCR_CODE      CHAR(1) NULL,
	SCHDUL_CHARGER_ID     VARCHAR(20) NULL,
	ATCH_FILE_ID          CHAR(20) NULL,
	FRST_REGIST_PNTTM     TIMESTAMP NULL,
	FRST_REGISTER_ID      VARCHAR(20) NULL,
	LAST_UPDT_PNTTM       TIMESTAMP NULL,
	LAST_UPDUSR_ID        VARCHAR(20) NULL,
	REPTIT_SE_CODE        CHAR(1) NULL,
	 PRIMARY KEY (SCHDUL_ID)
)
;



CREATE UNIQUE INDEX COMTNSCHDULINFO_PK ON COMTNSCHDULINFO
(
	SCHDUL_ID
)
;



CREATE TABLE COMTNDIARYINFO
(
	SCHDUL_ID             CHAR(20) NOT NULL,
	DIARY_ID              CHAR(20) NOT NULL,
	DIARY_PROGRSRT        NUMERIC(3) NULL,
	DIARY_NM              VARCHAR(255) NULL,
	DRCT_MATTER           VARCHAR(2500) NULL,
	PARTCLR_MATTER        VARCHAR(2500) NULL,
	ATCH_FILE_ID          CHAR(20) NULL,
	FRST_REGIST_PNTTM     TIMESTAMP NULL,
	FRST_REGISTER_ID      VARCHAR(20) NULL,
	LAST_UPDT_PNTTM       TIMESTAMP NULL,
	LAST_UPDUSR_ID        VARCHAR(20) NULL,
	 PRIMARY KEY (SCHDUL_ID,DIARY_ID),
	FOREIGN KEY (SCHDUL_ID) REFERENCES COMTNSCHDULINFO(SCHDUL_ID)
)
;



CREATE UNIQUE INDEX COMTNDIARYINFO_PK ON COMTNDIARYINFO
(
	SCHDUL_ID,
	DIARY_ID
)
;



CREATE INDEX COMTNDIARYINFO_i01 ON COMTNDIARYINFO
(
	SCHDUL_ID
)
;



CREATE TABLE COMTNONLINEPOLLMANAGE
(
	POLL_ID               CHAR(20) NOT NULL,
	POLL_NM               VARCHAR(255) NULL,
	POLL_BGNDE            CHAR(10) NULL,
	POLL_ENDDE            CHAR(10) NULL,
	POLL_KND              CHAR(3) NULL,
	POLL_DSUSE_ENNC       CHAR(1) NULL,
	POLL_ATMC_DSUSE_ENNC  CHAR(1) NULL,
	FRST_REGISTER_ID      VARCHAR(20) NULL,
	FRST_REGIST_PNTTM     TIMESTAMP NULL,
	LAST_UPDUSR_ID        VARCHAR(20) NULL,
	LAST_UPDT_PNTTM       TIMESTAMP NULL,
	 PRIMARY KEY (POLL_ID)
)
;



CREATE UNIQUE INDEX COMTNONLINEPOLLMANAGE_PK ON COMTNONLINEPOLLMANAGE
(
	POLL_ID
)
;



CREATE TABLE COMTNONLINEPOLLIEM
(
	POLL_IEM_NM           VARCHAR(255) NULL,
	FRST_REGISTER_ID      VARCHAR(20) NULL,
	FRST_REGIST_PNTTM     TIMESTAMP NULL,
	LAST_UPDUSR_ID        VARCHAR(20) NULL,
	LAST_UPDT_PNTTM       TIMESTAMP NULL,
	POLL_IEM_ID           CHAR(20) NOT NULL,
	POLL_ID               CHAR(20) NOT NULL,
	 PRIMARY KEY (POLL_ID,POLL_IEM_ID),
	FOREIGN KEY (POLL_ID) REFERENCES COMTNONLINEPOLLMANAGE(POLL_ID)
)
;



CREATE UNIQUE INDEX COMTNONLINEPOLLIEM_PK ON COMTNONLINEPOLLIEM
(
	POLL_ID,
	POLL_IEM_ID
)
;



CREATE INDEX COMTNONLINEPOLLIEM_i01 ON COMTNONLINEPOLLIEM
(
	POLL_ID
)
;



CREATE TABLE COMTNONLINEPOLLRESULT
(
	POLL_RESULT_ID        CHAR(20) NOT NULL,
	FRST_REGISTER_ID      VARCHAR(20) NULL,
	FRST_REGIST_PNTTM     TIMESTAMP NULL,
	LAST_UPDUSR_ID        VARCHAR(20) NULL,
	LAST_UPDT_PNTTM       TIMESTAMP NULL,
	POLL_IEM_ID           CHAR(20) NOT NULL,
	POLL_ID               CHAR(20) NOT NULL,
	 PRIMARY KEY (POLL_RESULT_ID,POLL_IEM_ID,POLL_ID),
	FOREIGN KEY (POLL_ID,POLL_IEM_ID) REFERENCES COMTNONLINEPOLLIEM(POLL_ID,POLL_IEM_ID)
)
;



CREATE UNIQUE INDEX COMTNONLINEPOLLRESULT_PK ON COMTNONLINEPOLLRESULT
(
	POLL_RESULT_ID,
	POLL_IEM_ID,
	POLL_ID
)
;



CREATE INDEX COMTNONLINEPOLLRESULT_i01 ON COMTNONLINEPOLLRESULT
(
	POLL_IEM_ID,
	POLL_ID
)
;



CREATE TABLE COMTNWORDDICARYINFO
(
	WORD_ID               CHAR(20) NOT NULL,
	WORD_NM               VARCHAR(255) NULL,
	ENG_NM                VARCHAR(60) NULL,
	WORD_DC               VARCHAR(4000) NULL,
	SYNONM                VARCHAR(100) NULL,
	FRST_REGIST_PNTTM     TIMESTAMP NULL,
	FRST_REGISTER_ID      VARCHAR(20) NULL,
	LAST_UPDT_PNTTM       TIMESTAMP NULL,
	LAST_UPDUSR_ID        VARCHAR(20) NULL,
	 PRIMARY KEY (WORD_ID)
)
;



CREATE UNIQUE INDEX COMTNWORDDICARYINFO_PK ON COMTNWORDDICARYINFO
(
	WORD_ID
)
;



CREATE TABLE COMTNCNTCSERVICE
(
	INSTT_ID              VARCHAR(20) NOT NULL,
	SYS_ID                VARCHAR(20) NOT NULL,
	SVC_ID                VARCHAR(20) NOT NULL,
	SVC_NM                VARCHAR(255) NULL,
	REQUST_MSSAGE_ID      VARCHAR(20) NULL,
	RSPNS_MSSAGE_ID       VARCHAR(20) NULL,
	FRST_REGISTER_ID      VARCHAR(20) NULL,
	FRST_REGIST_PNTTM     TIMESTAMP NULL,
	LAST_UPDUSR_ID        VARCHAR(20) NULL,
	LAST_UPDT_PNTTM       TIMESTAMP NULL,
	USE_AT                CHAR(1) NULL,
	 PRIMARY KEY (INSTT_ID,SYS_ID,SVC_ID)
)
;



CREATE UNIQUE INDEX COMTNCNTCSERVICE_PK ON COMTNCNTCSERVICE
(
	INSTT_ID,
	SYS_ID,
	SVC_ID
)
;



CREATE TABLE COMTNHPCMINFO
(
	HPCM_ID               CHAR(20) NOT NULL,
	HPCM_SE_CODE          CHAR(1) NULL,
	HPCM_DFN              VARCHAR(1000) NULL,
	HPCM_DC               VARCHAR(2500) NULL,
	FRST_REGIST_PNTTM     TIMESTAMP NULL,
	FRST_REGISTER_ID      VARCHAR(20) NULL,
	LAST_UPDT_PNTTM       TIMESTAMP NULL,
	LAST_UPDUSR_ID        VARCHAR(20) NULL,
	 PRIMARY KEY (HPCM_ID)
)
;



CREATE UNIQUE INDEX COMTNHPCMINFO_PK ON COMTNHPCMINFO
(
	HPCM_ID
)
;



CREATE TABLE COMTNNEWSINFO
(
	NEWS_ID               CHAR(20) NOT NULL,
	NEWS_SJ               VARCHAR(100) NULL,
	NEWS_CN               VARCHAR(2500) NULL,
	NEWS_ORIGIN           VARCHAR(250) NULL,
	NTCE_AT               CHAR(1) NULL,
	FRST_REGIST_PNTTM     TIMESTAMP NOT NULL,
	FRST_REGISTER_ID      VARCHAR(20) NOT NULL,
	LAST_UPDT_PNTTM       TIMESTAMP NOT NULL,
	LAST_UPDUSR_ID        VARCHAR(20) NOT NULL,
	NTCE_DE               CHAR(20) NULL,
	ATCH_FILE_ID          CHAR(20) NULL,
	 PRIMARY KEY (NEWS_ID),
	FOREIGN KEY (ATCH_FILE_ID) REFERENCES COMTNFILE(ATCH_FILE_ID)
		ON DELETE SET NULL
)
;



CREATE UNIQUE INDEX COMTNNEWSINFO_PK ON COMTNNEWSINFO
(
	NEWS_ID
)
;



CREATE INDEX COMTNNEWSINFO_i01 ON COMTNNEWSINFO
(
	ATCH_FILE_ID
)
;



CREATE TABLE COMTNCNSLTLIST
(
	CNSLT_ID              CHAR(20) NOT NULL,
	CNSLT_SJ              VARCHAR(255) NULL,
	OTHBC_AT              CHAR(1) NULL,
	EMAIL_ADRES           VARCHAR(50) NULL,
	CNSLT_CN              VARCHAR(2500) NULL,
	MANAGT_CN             VARCHAR(2500) NULL,
	MANAGT_DE             CHAR(20) NULL,
	RDCNT                 NUMERIC(10) NULL,
	ATCH_FILE_ID          CHAR(20) NULL,
	FRST_REGIST_PNTTM     TIMESTAMP NULL,
	FRST_REGISTER_ID      VARCHAR(20) NULL,
	LAST_UPDT_PNTTM       TIMESTAMP NULL,
	LAST_UPDUSR_ID        VARCHAR(20) NULL,
	AREA_NO               VARCHAR(4) NULL,
	MIDDLE_TELNO          VARCHAR(4) NULL,
	END_TELNO             VARCHAR(4) NULL,
	FRST_MBTLNUM          VARCHAR(4) NULL,
	MIDDLE_MBTLNUM        VARCHAR(4) NULL,
	END_MBTLNUM           VARCHAR(4) NULL,
	WRITNG_DE             CHAR(20) NULL,
	WRTER_NM              VARCHAR(20) NULL,
	EMAIL_ANSWER_AT       CHAR(1) NULL,
	QNA_PROCESS_STTUS_CODE  CHAR(1) NULL,
	WRITNG_PASSWORD       VARCHAR(20) NULL,
	 PRIMARY KEY (CNSLT_ID)
)
;



CREATE UNIQUE INDEX COMTNCNSLTLIST_PK ON COMTNCNSLTLIST
(
	CNSLT_ID
)
;



CREATE TABLE COMTNMENUINFO
(
	MENU_NM               VARCHAR(60) NOT NULL,
	PROGRM_FILE_NM        VARCHAR(60) NOT NULL,
	MENU_NO               NUMERIC(20) NOT NULL,
	UPPER_MENU_NO         NUMERIC(20) NULL,
	MENU_ORDR             NUMERIC(5) NOT NULL,
	MENU_DC               VARCHAR(250) NULL,
	RELATE_IMAGE_PATH     VARCHAR(100) NULL,
	RELATE_IMAGE_NM       VARCHAR(60) NULL,
	 PRIMARY KEY (MENU_NO),
	FOREIGN KEY (PROGRM_FILE_NM) REFERENCES COMTNPROGRMLIST(PROGRM_FILE_NM)
		ON DELETE CASCADE,
	FOREIGN KEY (UPPER_MENU_NO) REFERENCES COMTNMENUINFO(MENU_NO)
		ON DELETE CASCADE
)
;



CREATE UNIQUE INDEX COMTNMENUINFO_PK ON COMTNMENUINFO
(
	MENU_NO
)
;






CREATE INDEX COMTNMENUINFO_i02 ON COMTNMENUINFO
(
	UPPER_MENU_NO
)
;



CREATE TABLE COMTNSITEMAP
(
	MAPNG_CREAT_ID        VARCHAR(30) NOT NULL,
	CREATR_ID             VARCHAR(20) NOT NULL,
	MAPNG_FILE_NM         VARCHAR(60) NOT NULL,
	MAPNG_FILE_PATH       VARCHAR(100) NOT NULL,
	 PRIMARY KEY (MAPNG_CREAT_ID)
)
;



CREATE UNIQUE INDEX COMTNSITEMAP_PK ON COMTNSITEMAP
(
	MAPNG_CREAT_ID
)
;



CREATE TABLE COMTNMENUCREATDTLS
(
	MENU_NO               NUMERIC(20) NOT NULL,
	AUTHOR_CODE           VARCHAR(30) NOT NULL,
	MAPNG_CREAT_ID        VARCHAR(30) NULL,
	 PRIMARY KEY (MENU_NO,AUTHOR_CODE),
	FOREIGN KEY (MENU_NO) REFERENCES COMTNMENUINFO(MENU_NO)
		ON DELETE CASCADE,
	FOREIGN KEY (MAPNG_CREAT_ID) REFERENCES COMTNSITEMAP(MAPNG_CREAT_ID)
		ON DELETE CASCADE,
	FOREIGN KEY (AUTHOR_CODE) REFERENCES COMTNAUTHORINFO(AUTHOR_CODE)
)
;



CREATE UNIQUE INDEX COMTNMENUCREATDTLS_PK ON COMTNMENUCREATDTLS
(
	MENU_NO,
	AUTHOR_CODE
)
;



CREATE INDEX COMTNMENUCREATDTLS_i02 ON COMTNMENUCREATDTLS
(
	MENU_NO
)
;



CREATE INDEX COMTNMENUCREATDTLS_i03 ON COMTNMENUCREATDTLS
(
	MAPNG_CREAT_ID
)
;



CREATE INDEX COMTNMENUCREATDTLS_i04 ON COMTNMENUCREATDTLS
(
	AUTHOR_CODE
)
;



CREATE TABLE COMTHEMPLYRINFOCHANGEDTLS
(
	EMPLYR_ID             VARCHAR(20) NOT NULL,
	CHANGE_DE             CHAR(20) NOT NULL,
	ORGNZT_ID             CHAR(20) NULL,
	GROUP_ID              CHAR(20) NULL,
	EMPL_NO               VARCHAR(20) NULL,
	SEXDSTN_CODE          CHAR(1) NULL,
	BRTHDY                CHAR(20) NULL,
	FXNUM                 VARCHAR(20) NULL,
	HOUSE_ADRES           VARCHAR(100) NULL,
	HOUSE_END_TELNO       VARCHAR(4) NULL,
	AREA_NO               VARCHAR(4) NULL,
	DETAIL_ADRES          VARCHAR(100) NULL,
	ZIP                   VARCHAR(6) NULL,
	OFFM_TELNO            VARCHAR(20) NULL,
	MBTLNUM               VARCHAR(20) NULL,
	EMAIL_ADRES           VARCHAR(50) NULL,
	HOUSE_MIDDLE_TELNO    VARCHAR(4) NULL,
	PSTINST_CODE          CHAR(8) NULL,
	EMPLYR_STTUS_CODE     CHAR(1) NULL,
	ESNTL_ID              CHAR(20) NULL,
	 PRIMARY KEY (EMPLYR_ID,CHANGE_DE),
	FOREIGN KEY (EMPLYR_ID) REFERENCES COMTNEMPLYRINFO(EMPLYR_ID)
)
;



CREATE UNIQUE INDEX COMTHEMPLYRINFOCHANGEDTLS_PK ON COMTHEMPLYRINFOCHANGEDTLS
(
	EMPLYR_ID,
	CHANGE_DE
)
;



CREATE INDEX COMTHEMPLYRINFOCHANGEDTLS_i01 ON COMTHEMPLYRINFOCHANGEDTLS
(
	EMPLYR_ID
)
;



CREATE TABLE COMTNNTFCINFO
(
	NTCN_NO               NUMERIC(20) NOT NULL,
	NTCN_SJ               VARCHAR(60) NOT NULL,
	NTCN_CN               VARCHAR(100) NOT NULL,
	NTCN_TM               VARCHAR(14) NOT NULL,
	BH_NTCN_INTRVL        VARCHAR(20) NOT NULL,
	FRST_REGIST_PNTTM     TIMESTAMP NOT NULL,
	LAST_UPDT_PNTTM       TIMESTAMP NULL,
	FRST_REGISTER_ID      VARCHAR(20) NOT NULL,
	LAST_UPDUSR_ID        VARCHAR(20) NULL,
	 PRIMARY KEY (NTCN_NO)
)
;



CREATE UNIQUE INDEX COMTNNTFCINFO_PK ON COMTNNTFCINFO
(
	NTCN_NO
)
;



CREATE TABLE COMTNCNTCSYSTEM
(
	INSTT_ID              VARCHAR(20) NOT NULL,
	SYS_ID                VARCHAR(20) NOT NULL,
	SYS_NM                VARCHAR(255) NULL,
	SYS_IP                VARCHAR(23) NULL,
	FRST_REGISTER_ID      VARCHAR(20) NULL,
	FRST_REGIST_PNTTM     TIMESTAMP NULL,
	LAST_UPDUSR_ID        VARCHAR(20) NULL,
	LAST_UPDT_PNTTM       TIMESTAMP NULL,
	USE_AT                CHAR(1) NULL,
	 PRIMARY KEY (INSTT_ID,SYS_ID)
)
;



CREATE UNIQUE INDEX COMTNCNTCSYSTEM_PK ON COMTNCNTCSYSTEM
(
	INSTT_ID,
	SYS_ID
)
;



CREATE TABLE COMTNBBSMASTEROPTN
(
	BBS_ID                CHAR(20) NOT NULL,
	ANSWER_AT             CHAR(1) NOT NULL,
	STSFDG_AT             CHAR(1) NOT NULL,
	FRST_REGIST_PNTTM     TIMESTAMP NOT NULL,
	LAST_UPDT_PNTTM       TIMESTAMP NULL,
	FRST_REGISTER_ID      VARCHAR(20) NOT NULL,
	LAST_UPDUSR_ID        VARCHAR(20) NULL,
	 PRIMARY KEY (BBS_ID)
)
;



CREATE UNIQUE INDEX COMTNBBSMASTEROPTN_PK ON COMTNBBSMASTEROPTN
(
	BBS_ID
)
;



CREATE TABLE COMTNANSWER
(
	NTT_ID                NUMERIC(20) NOT NULL,
	BBS_ID                CHAR(20) NOT NULL,
	WRTER_ID              VARCHAR(20) NULL,
	ANSWER                VARCHAR(200) NULL,
	USE_AT                CHAR(1) NOT NULL,
	WRTER_NM              VARCHAR(20) NULL,
	FRST_REGIST_PNTTM     TIMESTAMP NOT NULL,
	FRST_REGISTER_ID      VARCHAR(20) NOT NULL,
	LAST_UPDT_PNTTM       TIMESTAMP NULL,
	LAST_UPDUSR_ID        VARCHAR(20) NULL,
	ANSWER_NO             NUMERIC(20) NOT NULL,
	 PRIMARY KEY (NTT_ID,BBS_ID,ANSWER_NO),
	FOREIGN KEY (BBS_ID) REFERENCES COMTNBBSMASTEROPTN(BBS_ID)
)
;



CREATE UNIQUE INDEX COMTNANSWER_PK ON COMTNANSWER
(
	NTT_ID,
	BBS_ID,
	ANSWER_NO
)
;



CREATE TABLE COMTNTRSMRCVLOG
(
	REQUST_ID             VARCHAR(20) NOT NULL,
	OCCRRNC_DE            CHAR(20) NULL,
	TRSMRCV_SE_CODE       CHAR(3) NULL,
	CNTC_ID               CHAR(8) NULL,
	PROVD_INSTT_ID        CHAR(8) NULL,
	PROVD_SYS_ID          CHAR(8) NULL,
	PROVD_SVC_ID          CHAR(8) NULL,
	REQUST_INSTT_ID       CHAR(8) NULL,
	REQUST_SYS_ID         CHAR(8) NULL,
	REQUST_TRNSMIT_TM     VARCHAR(14) NULL,
	REQUST_RECPTN_TM      VARCHAR(14) NULL,
	RSPNS_TRNSMIT_TM      VARCHAR(14) NULL,
	RSPNS_RECPTN_TM       VARCHAR(14) NULL,
	RESULT_CODE           VARCHAR(4) NULL,
	RESULT_MSSAGE         VARCHAR(4000) NULL,
	FRST_REGIST_PNTTM     TIMESTAMP NULL,
	RQESTER_ID            VARCHAR(20) NULL,
	 PRIMARY KEY (REQUST_ID)
)
;



CREATE UNIQUE INDEX COMTNTRSMRCVLOG_PK ON COMTNTRSMRCVLOG
(
	REQUST_ID
)
;



CREATE TABLE COMTNDAMCALRES
(
	ORGNZT_ID             CHAR(20) NULL,
	EXPERT_ID             CHAR(20) NULL,
	KNWLDG_TY_CODE        VARCHAR(3) NULL,
	EMPLYR_ID             VARCHAR(20) NULL,
	KNWLDG_NM             VARCHAR(60) NULL,
	KNWLDG_CN             VARCHAR(2500) NULL,
	ATCH_FILE_ID          CHAR(20) NULL,
	PARNTS_KNWLDG_ID      CHAR(20) NULL,
	ANSWER_DP             NUMERIC(20) NULL,
	ANSWER_ORDR           NUMERIC(20) NULL,
	ANSWER_GROUP_NO       NUMERIC(20) NULL,
	FRST_REGISTER_ID      VARCHAR(20) NULL,
	FRST_REGIST_PNTTM     TIMESTAMP NULL,
	LAST_UPDUSR_ID        VARCHAR(20) NULL,
	LAST_UPDT_PNTTM       TIMESTAMP NULL,
	KNWLDG_ID             CHAR(20) NOT NULL,
	 PRIMARY KEY (KNWLDG_ID)
)
;



CREATE UNIQUE INDEX COMTNDAMCALRES_PK ON COMTNDAMCALRES
(
	KNWLDG_ID
)
;



CREATE TABLE COMTNBACKUPRESULT
(
	BACKUP_RESULT_ID      VARCHAR(20) NOT NULL,
	BACKUP_OPERT_ID       VARCHAR(20) NOT NULL,
	BACKUP_FILE           VARCHAR(255) NULL,
	STTUS                 VARCHAR(2) NULL,
	ERROR_INFO            VARCHAR(2000) NULL,
	EXECUT_BEGIN_TM       VARCHAR(14) NULL,
	EXECUT_END_TM         VARCHAR(14) NULL,
	FRST_REGISTER_ID      VARCHAR(20) NULL,
	FRST_REGIST_PNTTM     TIMESTAMP NULL,
	LAST_UPDUSR_ID        VARCHAR(20) NULL,
	LAST_UPDT_PNTTM       TIMESTAMP NOT NULL,
	 PRIMARY KEY (BACKUP_RESULT_ID)
)
;



CREATE UNIQUE INDEX COMTNBACKUPRESULT_PK ON COMTNBACKUPRESULT
(
	BACKUP_RESULT_ID
)
;



CREATE TABLE COMTHTRSMRCVMNTRNGLOGINFO
(
	LOG_ID                CHAR(20) NOT NULL,
	CNTC_ID               CHAR(8) NOT NULL,
	TEST_CLASS_NM         VARCHAR(255) NULL,
	MNGR_NM               VARCHAR(60) NULL,
	MNGR_EMAIL_ADRES      VARCHAR(50) NULL,
	MNTRNG_STTUS          CHAR(2) NULL,
	LOG_INFO              VARCHAR(2000) NULL,
	CREAT_DT              TIMESTAMP NULL,
	FRST_REGISTER_ID      VARCHAR(20) NULL,
	FRST_REGIST_PNTTM     TIMESTAMP NOT NULL,
	LAST_UPDUSR_ID        VARCHAR(20) NULL,
	LAST_UPDT_PNTTM       TIMESTAMP NOT NULL,
	 PRIMARY KEY (LOG_ID)
)
;



CREATE UNIQUE INDEX COMTHTRSMRCVMNTRNGLOGINFO_PK ON COMTHTRSMRCVMNTRNGLOGINFO
(
	LOG_ID
)
;



CREATE TABLE COMTNSCRAP
(
	SCRAP_ID              CHAR(20) NOT NULL,
	NTT_ID                NUMERIC(20) NOT NULL,
	BBS_ID                CHAR(20) NOT NULL,
	SCRAP_NM              VARCHAR(100) NOT NULL,
	USE_AT                CHAR(1) NOT NULL,
	FRST_REGIST_PNTTM     TIMESTAMP NOT NULL,
	LAST_UPDT_PNTTM       TIMESTAMP NULL,
	FRST_REGISTER_ID      VARCHAR(20) NOT NULL,
	LAST_UPDUSR_ID        VARCHAR(20) NULL,
	 PRIMARY KEY (SCRAP_ID)
)
;



CREATE UNIQUE INDEX COMTNSCRAP_PK ON COMTNSCRAP
(
	SCRAP_ID
)
;



CREATE TABLE COMTNCNTCINSTT
(
	INSTT_ID              VARCHAR(20) NOT NULL,
	INSTT_NM              VARCHAR(100) NULL,
	FRST_REGISTER_ID      VARCHAR(20) NULL,
	LAST_UPDUSR_ID        VARCHAR(20) NULL,
	FRST_REGIST_PNTTM     TIMESTAMP NULL,
	LAST_UPDT_PNTTM       TIMESTAMP NULL,
	USE_AT                CHAR(1) NULL,
	 PRIMARY KEY (INSTT_ID)
)
;



CREATE UNIQUE INDEX COMTNCNTCINSTT_PK ON COMTNCNTCINSTT
(
	INSTT_ID
)
;



CREATE TABLE COMTHSYSHIST
(
	HIST_ID               CHAR(20) NOT NULL,
	FRST_REGIST_PNTTM     TIMESTAMP NULL,
	FRST_REGISTER_ID      VARCHAR(20) NOT NULL,
	LAST_UPDT_PNTTM       TIMESTAMP NULL,
	LAST_UPDUSR_ID        VARCHAR(20) NULL,
	HIST_SE_CODE          CHAR(6) NOT NULL,
	HIST_CN               VARCHAR(2500) NOT NULL,
	SYS_NM                VARCHAR(255) NOT NULL,
	ATCH_FILE_ID          CHAR(20) NULL,
	 PRIMARY KEY (HIST_ID)
)
;



CREATE UNIQUE INDEX COMTHSYSHIST_PK ON COMTHSYSHIST
(
	HIST_ID
)
;



CREATE TABLE COMTNHTTPMON
(
	SYS_ID                VARCHAR(20) NOT NULL,
	SITE_URL              VARCHAR(100) NULL,
	WEBSVC_KND            VARCHAR(10) NULL,
	HTTP_STTUS_CODE       VARCHAR(3) NULL,
	CREAT_DT              TIMESTAMP NULL,
	MNGR_NM               VARCHAR(60) NULL,
	MNGR_EMAIL_ADRES      VARCHAR(50) NULL,
	FRST_REGISTER_ID      VARCHAR(20) NULL,
	FRST_REGIST_PNTTM     TIMESTAMP NULL,
	LAST_UPDUSR_ID        VARCHAR(20) NULL,
	LAST_UPDT_PNTTM       TIMESTAMP NULL,
	 PRIMARY KEY (SYS_ID)
)
;



CREATE UNIQUE INDEX COMTNHTTPMON_PK ON COMTNHTTPMON
(
	SYS_ID
)
;



CREATE TABLE COMTHHTTPMONLOGINFO
(
	SYS_ID                VARCHAR(20) NOT NULL,
	SITE_URL              VARCHAR(100) NULL,
	WEBSVC_KND            VARCHAR(10) NULL,
	HTTP_STTUS_CODE       VARCHAR(3) NULL,
	CREAT_DT              TIMESTAMP NULL,
	LOG_INFO              VARCHAR(2000) NULL,
	MNGR_NM               VARCHAR(60) NULL,
	MNGR_EMAIL_ADRES      VARCHAR(50) NULL,
	FRST_REGISTER_ID      VARCHAR(20) NULL,
	FRST_REGIST_PNTTM     TIMESTAMP NULL,
	LAST_UPDUSR_ID        VARCHAR(20) NULL,
	LAST_UPDT_PNTTM       TIMESTAMP NULL,
	LOG_ID                CHAR(20) NOT NULL,
	 PRIMARY KEY (SYS_ID,LOG_ID),
	FOREIGN KEY (SYS_ID) REFERENCES COMTNHTTPMON(SYS_ID)
)
;



CREATE UNIQUE INDEX COMTHHTTPMONLOGINFO_PK ON COMTHHTTPMONLOGINFO
(
	SYS_ID,
	LOG_ID
)
;



CREATE TABLE COMTHDBMNTRNGLOGINFO
(
	DATA_SOURC_NM         VARCHAR(60) NOT NULL,
	SERVER_NM             VARCHAR(60) NULL,
	DBMS_KND              VARCHAR(2) NULL,
	CECK_SQL              VARCHAR(250) NULL,
	MNGR_NM               VARCHAR(60) NULL,
	MNGR_EMAIL_ADRES      VARCHAR(50) NULL,
	MNTRNG_STTUS          CHAR(2) NULL,
	LOG_INFO              VARCHAR(2000) NULL,
	CREAT_DT              TIMESTAMP NULL,
	FRST_REGISTER_ID      VARCHAR(20) NULL,
	FRST_REGIST_PNTTM     TIMESTAMP NOT NULL,
	LAST_UPDT_PNTTM       TIMESTAMP NOT NULL,
	LAST_UPDUSR_ID        VARCHAR(20) NULL,
	LOG_ID                CHAR(20) NOT NULL,
	 PRIMARY KEY (LOG_ID)
)
;



CREATE UNIQUE INDEX COMTHDBMNTRNGLOGINFO_PK ON COMTHDBMNTRNGLOGINFO
(
	LOG_ID
)
;



CREATE TABLE COMTHCONFMHISTORY
(
	CONFM_NO              NUMERIC(8) NOT NULL,
	CONFM_RQESTER_ID      VARCHAR(20) NOT NULL,
	CONFMER_ID            VARCHAR(20) NULL,
	CONFM_DE              CHAR(20) NULL,
	CONFM_TY_CODE         CHAR(4) NOT NULL,
	CONFM_STTUS_CODE      CHAR(4) NOT NULL,
	OPERT_TY_CODE         CHAR(4) NULL,
	OPERT_ID              VARCHAR(20) NULL,
	TRGET_JOB_TY_CODE     CHAR(3) NULL,
	TRGET_JOB_ID          CHAR(20) NULL,
	 PRIMARY KEY (CONFM_NO)
)
;



CREATE UNIQUE INDEX COMTHCONFMHISTORY_PK ON COMTHCONFMHISTORY
(
	CONFM_NO
)
;



CREATE TABLE COMTNDAMMAPTEAM
(
	ORGNZT_ID             CHAR(20) NOT NULL,
	ORGNZT_NM             VARCHAR(20) NULL,
	CL_DE                 CHAR(20) NULL,
	KNWLDG_URL            VARCHAR(255) NULL,
	LAST_UPDUSR_ID        VARCHAR(20) NULL,
	LAST_UPDT_PNTTM       TIMESTAMP NULL,
	 PRIMARY KEY (ORGNZT_ID)
)
;



CREATE UNIQUE INDEX COMTNDAMMAPTEAM_PK ON COMTNDAMMAPTEAM
(
	ORGNZT_ID
)
;



CREATE TABLE COMTNTMPLATINFO
(
	TMPLAT_ID             CHAR(20) NOT NULL,
	TMPLAT_NM             VARCHAR(255) NULL,
	TMPLAT_COURS          VARCHAR(2000) NULL,
	USE_AT                CHAR(1) NULL,
	TMPLAT_SE_CODE        CHAR(6) NULL,
	FRST_REGISTER_ID      VARCHAR(20) NULL,
	FRST_REGIST_PNTTM     TIMESTAMP NULL,
	LAST_UPDUSR_ID        VARCHAR(20) NULL,
	LAST_UPDT_PNTTM       TIMESTAMP NULL,
	 PRIMARY KEY (TMPLAT_ID)
)
;



CREATE UNIQUE INDEX COMTNTMPLATINFO_PK ON COMTNTMPLATINFO
(
	TMPLAT_ID
)
;



CREATE TABLE COMTNINDVDLPGECNTNTS
(
	CNTNTS_ID             VARCHAR(20) NOT NULL,
	CNTNTS_NM             VARCHAR(100) NOT NULL,
	CNTC_URL              VARCHAR(255) NOT NULL,
	CNTNTS_USE_AT         CHAR(1) NOT NULL,
	CNTNTS_LINK_URL       VARCHAR(1000) NULL,
	CNTNTS_DC             VARCHAR(250) NULL,
	 PRIMARY KEY (CNTNTS_ID)
)
;



CREATE UNIQUE INDEX COMTNINDVDLPGECNTNTS_PK ON COMTNINDVDLPGECNTNTS
(
	CNTNTS_ID
)
;



CREATE TABLE COMTNINDVDLPGEESTBS
(
	EMPLYR_ID             VARCHAR(20) NOT NULL,
	UPEND_IMAGE           VARCHAR(1024) NULL,
	TITLEBAR_COLOR        CHAR(7) NULL,
	ALGN_MTHD             CHAR(1) NULL,
	ALGN_CO               NUMERIC(10) NULL,
	 PRIMARY KEY (EMPLYR_ID)
)
;



CREATE UNIQUE INDEX COMTNINDVDLPGEESTBS_PK ON COMTNINDVDLPGEESTBS
(
	EMPLYR_ID
)
;



CREATE TABLE COMTNCNTNTSLIST
(
	CNTNTS_ID             VARCHAR(20) NOT NULL,
	EMPLYR_ID             VARCHAR(20) NOT NULL,
	 PRIMARY KEY (CNTNTS_ID,EMPLYR_ID),
	FOREIGN KEY (CNTNTS_ID) REFERENCES COMTNINDVDLPGECNTNTS(CNTNTS_ID),
	FOREIGN KEY (EMPLYR_ID) REFERENCES COMTNINDVDLPGEESTBS(EMPLYR_ID)
)
;



CREATE UNIQUE INDEX COMTNCNTNTSLIST_PK ON COMTNCNTNTSLIST
(
	CNTNTS_ID,
	EMPLYR_ID
)
;



CREATE INDEX COMTNCNTNTSLIST_i01 ON COMTNCNTNTSLIST
(
	CNTNTS_ID
)
;



CREATE INDEX COMTNCNTNTSLIST_i02 ON COMTNCNTNTSLIST
(
	EMPLYR_ID
)
;



CREATE TABLE COMTNCNTCMESSAGE
(
	CNTC_MSSAGE_ID        VARCHAR(20) NOT NULL,
	CNTC_MSSAGE_NM        VARCHAR(100) NULL,
	UPPER_CNTC_MSSAGE_ID  VARCHAR(20) NULL,
	FRST_REGISTER_ID      VARCHAR(20) NULL,
	FRST_REGIST_PNTTM     TIMESTAMP NULL,
	LAST_UPDUSR_ID        VARCHAR(20) NULL,
	LAST_UPDT_PNTTM       TIMESTAMP NULL,
	USE_AT                CHAR(1) NULL,
	 PRIMARY KEY (CNTC_MSSAGE_ID)
)
;



CREATE UNIQUE INDEX COMTNCNTCMESSAGE_PK ON COMTNCNTCMESSAGE
(
	CNTC_MSSAGE_ID
)
;



CREATE TABLE COMTNCNTCMESSAGEITEM
(
	CNTC_MSSAGE_ID        VARCHAR(20) NOT NULL,
	IEM_ID                VARCHAR(20) NOT NULL,
	IEM_NM                VARCHAR(100) NULL,
	IEM_TY                VARCHAR(50) NULL,
	IEM_LT                NUMERIC(8) NULL,
	USE_AT                CHAR(1) NULL,
	FRST_REGISTER_ID      VARCHAR(20) NULL,
	FRST_REGIST_PNTTM     TIMESTAMP NULL,
	LAST_UPDUSR_ID        VARCHAR(20) NULL,
	LAST_UPDT_PNTTM       TIMESTAMP NULL,
	 PRIMARY KEY (CNTC_MSSAGE_ID,IEM_ID),
	FOREIGN KEY (CNTC_MSSAGE_ID) REFERENCES COMTNCNTCMESSAGE(CNTC_MSSAGE_ID)
)
;



CREATE UNIQUE INDEX COMTNCNTCMESSAGEITEM_PK ON COMTNCNTCMESSAGEITEM
(
	CNTC_MSSAGE_ID,
	IEM_ID
)
;



CREATE INDEX COMTNCNTCMESSAGEITEM_i01 ON COMTNCNTCMESSAGEITEM
(
	CNTC_MSSAGE_ID
)
;



CREATE TABLE COMTNBKMKMENUMANAGERESULT
(
	MENU_ID               NUMERIC(20) NOT NULL,
	EMPLYR_ID             VARCHAR(20) NOT NULL,
	MENU_NM               VARCHAR(60) NOT NULL,
	PROGRM_STRE_PATH      VARCHAR(100) NOT NULL,
	 PRIMARY KEY (MENU_ID,EMPLYR_ID)
)
;



CREATE UNIQUE INDEX COMTNBKMKMENUMANAGERESULT_PK ON COMTNBKMKMENUMANAGERESULT
(
	MENU_ID,
	EMPLYR_ID
)
;



CREATE TABLE COMTNSYSTEMCNTC
(
	CNTC_ID               CHAR(8) NOT NULL,
	CNTC_NM               VARCHAR(100) NULL,
	PROVD_INSTT_ID        CHAR(8) NULL,
	PROVD_SYS_ID          CHAR(8) NULL,
	PROVD_SVC_ID          CHAR(8) NULL,
	REQUST_INSTT_ID       CHAR(8) NULL,
	REQUST_SYS_ID         CHAR(8) NULL,
	CONFM_AT              CHAR(1) NULL,
	USE_AT                CHAR(1) NULL,
	VALID_BGNDE           CHAR(20) NULL,
	VALID_ENDDE           CHAR(20) NULL,
	FRST_REGISTER_ID      VARCHAR(20) NULL,
	FRST_REGIST_PNTTM     TIMESTAMP NULL,
	LAST_UPDUSR_ID        VARCHAR(20) NULL,
	LAST_UPDT_PNTTM       TIMESTAMP NULL,
	CNTC_TY               VARCHAR(60) NULL,
	 PRIMARY KEY (CNTC_ID)
)
;



CREATE UNIQUE INDEX COMTNSYSTEMCNTC_PK ON COMTNSYSTEMCNTC
(
	CNTC_ID
)
;



CREATE TABLE COMTNINDVDLINFOPOLICY
(
	INDVDL_INFO_POLICY_ID  CHAR(20) NOT NULL,
	INDVDL_INFO_POLICY_CN  VARCHAR(2500) NULL,
	INDVDL_INFO_POLICY_AGRE_AT  CHAR(1) NULL,
	FRST_REGISTER_ID      VARCHAR(20) NULL,
	FRST_REGIST_PNTTM     TIMESTAMP NULL,
	LAST_UPDUSR_ID        VARCHAR(20) NULL,
	LAST_UPDT_PNTTM       TIMESTAMP NULL,
	INDVDL_INFO_POLICY_NM  VARCHAR(255) NULL,
	 PRIMARY KEY (INDVDL_INFO_POLICY_ID)
)
;



CREATE UNIQUE INDEX COMTNINDVDLINFOPOLICY_PK ON COMTNINDVDLINFOPOLICY
(
	INDVDL_INFO_POLICY_ID
)
;



CREATE TABLE COMTNBNDTMANAGE
(
	BNDT_ID               VARCHAR(20) NOT NULL,
	BNDT_DE               CHAR(8) NOT NULL,
	RM                    VARCHAR(2500) NULL,
	FRST_REGISTER_ID      VARCHAR(20) NULL,
	FRST_REGIST_PNTTM     TIMESTAMP NULL,
	LAST_UPDUSR_ID        VARCHAR(20) NULL,
	LAST_UPDT_PNTTM       TIMESTAMP NULL,
	 PRIMARY KEY (BNDT_ID,BNDT_DE)
)
;



CREATE UNIQUE INDEX COMTNBNDTMANAGE_PK ON COMTNBNDTMANAGE
(
	BNDT_ID,
	BNDT_DE
)
;



CREATE TABLE COMTNBNDTCECKMANAGE
(
	BNDT_CECK_SE          CHAR(2) NOT NULL,
	BNDT_CECK_CODE        VARCHAR(10) NOT NULL,
	BNDT_CECK_CODE_NM     VARCHAR(255) NOT NULL,
	USE_AT                CHAR(1) NOT NULL,
	FRST_REGISTER_ID      VARCHAR(20) NULL,
	FRST_REGIST_PNTTM     TIMESTAMP NULL,
	LAST_UPDUSR_ID        VARCHAR(20) NULL,
	LAST_UPDT_PNTTM       TIMESTAMP NULL,
	 PRIMARY KEY (BNDT_CECK_CODE,BNDT_CECK_SE)
)
;



CREATE UNIQUE INDEX COMTNBNDTCECKMANAGE_PK ON COMTNBNDTCECKMANAGE
(
	BNDT_CECK_CODE,
	BNDT_CECK_SE
)
;



CREATE TABLE COMTNBNDTDIARY
(
	BNDT_ID               VARCHAR(20) NOT NULL,
	BNDT_DE               CHAR(8) NOT NULL,
	BNDT_CECK_SE          CHAR(2) NOT NULL,
	BNDT_CECK_CODE        VARCHAR(10) NOT NULL,
	CHCK_STTUS            VARCHAR(1000) NULL,
	FRST_REGISTER_ID      VARCHAR(20) NULL,
	FRST_REGIST_PNTTM     TIMESTAMP NULL,
	LAST_UPDUSR_ID        VARCHAR(20) NULL,
	LAST_UPDT_PNTTM       TIMESTAMP NULL,
	 PRIMARY KEY (BNDT_ID,BNDT_DE,BNDT_CECK_SE,BNDT_CECK_CODE),
	FOREIGN KEY (BNDT_ID,BNDT_DE) REFERENCES COMTNBNDTMANAGE(BNDT_ID,BNDT_DE),
	FOREIGN KEY (BNDT_CECK_CODE,BNDT_CECK_SE) REFERENCES COMTNBNDTCECKMANAGE(BNDT_CECK_CODE,BNDT_CECK_SE)
)
;



CREATE UNIQUE INDEX COMTNBNDTDIARY_PK ON COMTNBNDTDIARY
(
	BNDT_ID,
	BNDT_DE,
	BNDT_CECK_SE,
	BNDT_CECK_CODE
)
;



CREATE TABLE COMTNBATCHRESULT
(
	BATCH_RESULT_ID       VARCHAR(20) NOT NULL,
	BATCH_SCHDUL_ID       VARCHAR(20) NOT NULL,
	BATCH_OPERT_ID        VARCHAR(20) NOT NULL,
	PARAMTR               VARCHAR(250) NULL,
	STTUS                 VARCHAR(2) NULL,
	ERROR_INFO            VARCHAR(2000) NULL,
	EXECUT_BEGIN_TM       VARCHAR(14) NULL,
	EXECUT_END_TM         VARCHAR(14) NULL,
	LAST_UPDT_PNTTM       TIMESTAMP NULL,
	LAST_UPDUSR_ID        VARCHAR(20) NULL,
	FRST_REGIST_PNTTM     TIMESTAMP NOT NULL,
	FRST_REGISTER_ID      VARCHAR(20) NULL,
	 PRIMARY KEY (BATCH_RESULT_ID)
)
;



CREATE UNIQUE INDEX COMTNBATCHRESULT_PK ON COMTNBATCHRESULT
(
	BATCH_RESULT_ID
)
;



CREATE TABLE COMTNSTSFDG
(
	STSFDG_NO             NUMERIC(20) NOT NULL,
	NTT_ID                NUMERIC(20) NOT NULL,
	BBS_ID                CHAR(20) NOT NULL,
	WRTER_ID              VARCHAR(20) NULL,
	WRTER_NM              VARCHAR(20) NULL,
	PASSWORD              VARCHAR(200) NULL,
	STSFDG                NUMERIC(1) NOT NULL,
	STSFDG_CN             VARCHAR(200) NULL,
	USE_AT                CHAR(1) NOT NULL,
	FRST_REGIST_PNTTM     TIMESTAMP NOT NULL,
	LAST_UPDT_PNTTM       TIMESTAMP NULL,
	FRST_REGISTER_ID      VARCHAR(20) NOT NULL,
	LAST_UPDUSR_ID        VARCHAR(20) NULL,
	 PRIMARY KEY (STSFDG_NO)
)
;



CREATE UNIQUE INDEX COMTNSTSFDG_PK ON COMTNSTSFDG
(
	STSFDG_NO
)
;



CREATE TABLE COMTNBATCHOPERT
(
	BATCH_OPERT_ID        VARCHAR(20) NOT NULL,
	BATCH_OPERT_NM        VARCHAR(60) NULL,
	BATCH_PROGRM          VARCHAR(255) NULL,
	PARAMTR               VARCHAR(250) NULL,
	USE_AT                CHAR(1) NULL,
	FRST_REGISTER_ID      VARCHAR(20) NULL,
	FRST_REGIST_PNTTM     TIMESTAMP NULL,
	LAST_UPDUSR_ID        VARCHAR(20) NULL,
	LAST_UPDT_PNTTM       TIMESTAMP NOT NULL,
	 PRIMARY KEY (BATCH_OPERT_ID)
)
;



CREATE UNIQUE INDEX COMTNBATCHOPERT_PK ON COMTNBATCHOPERT
(
	BATCH_OPERT_ID
)
;



CREATE TABLE COMTNFILESYSMNTRNG
(
	FILE_SYS_ID           CHAR(20) NOT NULL,
	FILE_SYS_NM           VARCHAR(60) NOT NULL,
	FILE_SYS_MANAGE_NM    VARCHAR(255) NOT NULL,
	FILE_SYS_SIZE         NUMERIC(8) NOT NULL,
	FILE_SYS_THRHLD       NUMERIC(8) NOT NULL,
	FILE_SYS_USGQTY       NUMERIC(8) NULL,
	MNGR_NM               VARCHAR(60) NULL,
	MNGR_EMAIL_ADRES      VARCHAR(50) NULL,
	MNTRNG_STTUS          CHAR(2) NULL,
	CREAT_DT              TIMESTAMP NULL,
	FRST_REGISTER_ID      VARCHAR(20) NULL,
	FRST_REGIST_PNTTM     TIMESTAMP NULL,
	LAST_UPDUSR_ID        VARCHAR(20) NULL,
	LAST_UPDT_PNTTM       TIMESTAMP NULL,
	 PRIMARY KEY (FILE_SYS_ID)
)
;



CREATE UNIQUE INDEX COMTNFILESYSMNTRNG_PK ON COMTNFILESYSMNTRNG
(
	FILE_SYS_ID
)
;



CREATE TABLE COMTNFILESYSMNTRNGLOGINFO
(
	FILE_SYS_ID           CHAR(20) NOT NULL,
	FILE_SYS_NM           VARCHAR(60) NOT NULL,
	FILE_SYS_MANAGE_NM    VARCHAR(255) NOT NULL,
	FILE_SYS_SIZE         NUMERIC(8) NOT NULL,
	FILE_SYS_THRHLD       NUMERIC(8) NOT NULL,
	FILE_SYS_USGQTY       NUMERIC(8) NULL,
	MNTRNG_STTUS          CHAR(2) NULL,
	LOG_INFO              VARCHAR(2000) NULL,
	CREAT_DT              TIMESTAMP NULL,
	FRST_REGISTER_ID      VARCHAR(20) NULL,
	FRST_REGIST_PNTTM     TIMESTAMP NULL,
	LAST_UPDUSR_ID        VARCHAR(20) NULL,
	LAST_UPDT_PNTTM       TIMESTAMP NULL,
	LOG_ID                CHAR(20) NOT NULL,
	 PRIMARY KEY (FILE_SYS_ID,LOG_ID),
	FOREIGN KEY (FILE_SYS_ID) REFERENCES COMTNFILESYSMNTRNG(FILE_SYS_ID)
)
;



CREATE UNIQUE INDEX COMTNFILESYSMNTRNGLOGINFO_PK ON COMTNFILESYSMNTRNGLOGINFO
(
	FILE_SYS_ID,
	LOG_ID
)
;



CREATE TABLE COMTNBATCHSCHDUL
(
	BATCH_SCHDUL_ID       VARCHAR(20) NOT NULL,
	BATCH_OPERT_ID        VARCHAR(20) NOT NULL,
	EXECUT_CYCLE          VARCHAR(2) NULL,
	EXECUT_SCHDUL_DE      CHAR(20) NULL,
	EXECUT_SCHDUL_HOUR    CHAR(2) NULL,
	EXECUT_SCHDUL_MNT     CHAR(2) NULL,
	EXECUT_SCHDUL_SECND   CHAR(2) NULL,
	FRST_REGISTER_ID      VARCHAR(20) NULL,
	FRST_REGIST_PNTTM     TIMESTAMP NULL,
	LAST_UPDUSR_ID        VARCHAR(20) NULL,
	LAST_UPDT_PNTTM       TIMESTAMP NOT NULL,
	 PRIMARY KEY (BATCH_SCHDUL_ID)
)
;



CREATE UNIQUE INDEX COMTNBATCHSCHDUL_PK ON COMTNBATCHSCHDUL
(
	BATCH_SCHDUL_ID
)
;



CREATE TABLE COMTNBATCHSCHDULDFK
(
	BATCH_SCHDUL_ID       VARCHAR(20) NOT NULL,
	EXECUT_SCHDUL_DFK_SE  CHAR(1) NOT NULL,
	 PRIMARY KEY (BATCH_SCHDUL_ID,EXECUT_SCHDUL_DFK_SE),
	FOREIGN KEY (BATCH_SCHDUL_ID) REFERENCES COMTNBATCHSCHDUL(BATCH_SCHDUL_ID)
)
;



CREATE UNIQUE INDEX COMTNBATCHSCHDULDFK_PK ON COMTNBATCHSCHDULDFK
(
	BATCH_SCHDUL_ID,
	EXECUT_SCHDUL_DFK_SE
)
;



CREATE TABLE COMTNCTSNNMANAGE
(
	CTSNN_ID              VARCHAR(20) NOT NULL,
	USER_ID               VARCHAR(20) NOT NULL,
	CTSNN_CODE            CHAR(2) NOT NULL,
	REQST_DE              CHAR(20) NOT NULL,
	CTSNN_NM              VARCHAR(255) NOT NULL,
	TRGTER_NM             VARCHAR(20) NOT NULL,
	BRTHDY                CHAR(20) NOT NULL,
	OCCRRNC_DE            CHAR(20) NOT NULL,
	RELATE                CHAR(2) NOT NULL,
	RM                    VARCHAR(2500) NULL,
	SANCTNER_ID           VARCHAR(20) NOT NULL,
	CONFM_AT              CHAR(1) NULL,
	SANCTN_DT             TIMESTAMP NULL,
	RETURN_RESN           VARCHAR(1000) NULL,
	INFRML_SANCTN_ID      CHAR(20) NULL,
	FRST_REGISTER_ID      VARCHAR(20) NULL,
	FRST_REGIST_PNTTM     TIMESTAMP NULL,
	LAST_UPDUSR_ID        VARCHAR(20) NULL,
	LAST_UPDT_PNTTM       TIMESTAMP NULL,
	 PRIMARY KEY (CTSNN_ID)
)
;



CREATE UNIQUE INDEX COMTNCTSNNMANAGE_PK ON COMTNCTSNNMANAGE
(
	CTSNN_ID
)
;



CREATE TABLE COMTCADMINISTCODERECPTNLOG
(
	OCCRRNC_DE            CHAR(20) NOT NULL,
	ADMINIST_ZONE_SE      CHAR(1) NOT NULL,
	ADMINIST_ZONE_CODE    VARCHAR(10) NOT NULL,
	OPERT_SN              NUMERIC(10) NOT NULL,
	CHANGE_SE_CODE        VARCHAR(2) NULL,
	PROCESS_SE            VARCHAR(2) NULL,
	ADMINIST_ZONE_NM      VARCHAR(60) NULL,
	LOWEST_ADMINIST_ZONE_NM  VARCHAR(60) NULL,
	CTPRVN_CODE           VARCHAR(2) NULL,
	SIGNGU_CODE           VARCHAR(3) NULL,
	EMD_CODE              VARCHAR(3) NULL,
	LI_CODE               VARCHAR(2) NULL,
	CREAT_DE              CHAR(20) NULL,
	ABL_DE                CHAR(20) NULL,
	ABL_ENNC              CHAR(1) NULL,
	FRST_REGISTER_ID      VARCHAR(20) NULL,
	FRST_REGIST_PNTTM     TIMESTAMP NULL,
	LAST_UPDUSR_ID        VARCHAR(20) NULL,
	LAST_UPDT_PNTTM       TIMESTAMP NULL,
	 PRIMARY KEY (OCCRRNC_DE,ADMINIST_ZONE_SE,ADMINIST_ZONE_CODE,OPERT_SN)
)
;



CREATE UNIQUE INDEX COMTCADMINISTCODERECPTNLOG_PK ON COMTCADMINISTCODERECPTNLOG
(
	OCCRRNC_DE,
	ADMINIST_ZONE_SE,
	ADMINIST_ZONE_CODE,
	OPERT_SN
)
;



CREATE TABLE COMTNTROBLINFO
(
	TROBL_ID              CHAR(20) NOT NULL,
	TROBL_NM              VARCHAR(60) NULL,
	TROBL_KND             CHAR(2) NULL,
	TROBL_DC              VARCHAR(2000) NULL,
	TROBL_OCCRRNC_TIME    VARCHAR(14) NULL,
	TROBL_RQESTER_NM      VARCHAR(60) NULL,
	TROBL_REQUST_TIME     VARCHAR(14) NULL,
	TROBL_PROCESS_RESULT  VARCHAR(2000) NULL,
	TROBL_OPETR_NM        VARCHAR(60) NULL,
	TROBL_PROCESS_TIME    VARCHAR(14) NULL,
	PROCESS_STTUS         CHAR(1) NULL,
	FRST_REGISTER_ID      VARCHAR(20) NULL,
	FRST_REGIST_PNTTM     TIMESTAMP NULL,
	LAST_UPDUSR_ID        VARCHAR(20) NULL,
	LAST_UPDT_PNTTM       TIMESTAMP NULL,
	 PRIMARY KEY (TROBL_ID)
)
;



CREATE UNIQUE INDEX COMTNTROBLINFO_PK ON COMTNTROBLINFO
(
	TROBL_ID
)
;



CREATE TABLE COMTNDAMKNOIFM
(
	KNWLDG_ID             CHAR(20) NOT NULL,
	KNWLDG_TY_CODE        VARCHAR(3) NULL,
	ORGNZT_ID             CHAR(20) NULL,
	EXPERT_ID             CHAR(20) NULL,
	EMPLYR_ID             VARCHAR(20) NULL,
	KNWLDG_NM             VARCHAR(60) NULL,
	KNWLDG_CN             VARCHAR(2500) NULL,
	KWRD                  VARCHAR(100) NULL,
	OTHBC_AT              CHAR(1) NULL,
	KNWLDG_EVL            CHAR(1) NULL,
	COLCT_DE              CHAR(20) NULL,
	EVL_DE                CHAR(20) NULL,
	ATCH_FILE_ID          CHAR(20) NULL,
	FRST_REGISTER_ID      VARCHAR(20) NULL,
	FRST_REGIST_PNTTM     TIMESTAMP NULL,
	LAST_UPDUSR_ID        VARCHAR(20) NULL,
	LAST_UPDT_PNTTM       TIMESTAMP NULL,
	DSUSE_DE              CHAR(20) NULL,
	 PRIMARY KEY (KNWLDG_ID)
)
;



CREATE UNIQUE INDEX COMTNDAMKNOIFM_PK ON COMTNDAMKNOIFM
(
	KNWLDG_ID
)
;



CREATE TABLE COMTNDAMMAPKNO
(
	KNWLDG_TY_CODE        VARCHAR(3) NOT NULL,
	ORGNZT_ID             CHAR(20) NULL,
	EXPERT_ID             CHAR(20) NULL,
	KNWLDG_TY_NM          VARCHAR(60) NULL,
	CL_DE                 CHAR(20) NULL,
	KNWLDG_URL            VARCHAR(255) NULL,
	FRST_REGISTER_ID      VARCHAR(20) NULL,
	FRST_REGIST_PNTTM     TIMESTAMP NULL,
	LAST_UPDUSR_ID        VARCHAR(20) NULL,
	LAST_UPDT_PNTTM       TIMESTAMP NULL,
	 PRIMARY KEY (KNWLDG_TY_CODE)
)
;



CREATE UNIQUE INDEX COMTNDAMMAPKNO_PK ON COMTNDAMMAPKNO
(
	KNWLDG_TY_CODE
)
;



CREATE TABLE COMTNDAMPRO
(
	EXPERT_ID             CHAR(20) NOT NULL,
	KNWLDG_TY_CODE        VARCHAR(3) NOT NULL,
	EXPERT_GRAD           CHAR(1) NOT NULL,
	EXPERT_CONFM_DE       CHAR(20) NULL,
	FRST_REGISTER_ID      VARCHAR(20) NULL,
	FRST_REGIST_PNTTM     TIMESTAMP NULL,
	LAST_UPDUSR_ID        VARCHAR(20) NULL,
	LAST_UPDT_PNTTM       TIMESTAMP NULL,
	EXPERT_DC             VARCHAR(2000) NULL,
	 PRIMARY KEY (EXPERT_ID,KNWLDG_TY_CODE,EXPERT_GRAD),
	FOREIGN KEY (KNWLDG_TY_CODE) REFERENCES COMTNDAMMAPKNO(KNWLDG_TY_CODE)
)
;



CREATE UNIQUE INDEX COMTNDAMPRO_PK ON COMTNDAMPRO
(
	EXPERT_ID,
	KNWLDG_TY_CODE,
	EXPERT_GRAD
)
;



CREATE TABLE COMTNINFRMLSANCTN
(
	INFRML_SANCTN_ID      CHAR(20) NOT NULL,
	JOB_SE_CODE           CHAR(3) NOT NULL,
	APPLCNT_ID            VARCHAR(20) NOT NULL,
	REQST_DE              CHAR(20) NOT NULL,
	SANCTNER_ID           VARCHAR(20) NOT NULL,
	CONFM_AT              CHAR(1) NOT NULL,
	SANCTN_DT             TIMESTAMP NULL,
	RETURN_RESN           VARCHAR(1000) NULL,
	FRST_REGISTER_ID      VARCHAR(20) NULL,
	FRST_REGIST_PNTTM     TIMESTAMP NULL,
	LAST_UPDUSR_ID        VARCHAR(20) NULL,
	LAST_UPDT_PNTTM       TIMESTAMP NULL,
	 PRIMARY KEY (INFRML_SANCTN_ID)
)
;



CREATE UNIQUE INDEX COMTNINFRMLSANCTN_PK ON COMTNINFRMLSANCTN
(
	INFRML_SANCTN_ID
)
;



CREATE TABLE COMTNDBMNTRNG
(
	DATA_SOURC_NM         VARCHAR(60) NOT NULL,
	SERVER_NM             VARCHAR(60) NULL,
	DBMS_KND              VARCHAR(2) NULL,
	CECK_SQL              VARCHAR(250) NULL,
	MNGR_NM               VARCHAR(60) NULL,
	MNGR_EMAIL_ADRES      VARCHAR(50) NULL,
	MNTRNG_STTUS          CHAR(2) NULL,
	CREAT_DT              TIMESTAMP NULL,
	FRST_REGISTER_ID      VARCHAR(20) NULL,
	FRST_REGIST_PNTTM     TIMESTAMP NOT NULL,
	LAST_UPDUSR_ID        VARCHAR(20) NULL,
	LAST_UPDT_PNTTM       TIMESTAMP NOT NULL,
	 PRIMARY KEY (DATA_SOURC_NM)
)
;



CREATE UNIQUE INDEX COMTNDBMNTRNG_PK ON COMTNDBMNTRNG
(
	DATA_SOURC_NM
)
;



CREATE TABLE COMTNTRSMRCVMNTRNG
(
	CNTC_ID               CHAR(8) NOT NULL,
	TEST_CLASS_NM         VARCHAR(255) NULL,
	MNGR_NM               VARCHAR(60) NULL,
	MNGR_EMAIL_ADRES      VARCHAR(50) NULL,
	MNTRNG_STTUS          CHAR(2) NULL,
	CREAT_DT              TIMESTAMP NULL,
	FRST_REGISTER_ID      VARCHAR(20) NULL,
	FRST_REGIST_PNTTM     TIMESTAMP NOT NULL,
	LAST_UPDUSR_ID        VARCHAR(20) NULL,
	LAST_UPDT_PNTTM       TIMESTAMP NOT NULL,
	 PRIMARY KEY (CNTC_ID)
)
;



CREATE UNIQUE INDEX COMTNTRSMRCVMNTRNG_PK ON COMTNTRSMRCVMNTRNG
(
	CNTC_ID
)
;



CREATE TABLE COMTNDEPTJOB
(
	DEPT_JOB_ID           CHAR(20) NOT NULL,
	DEPT_JOBBX_ID         CHAR(6) NOT NULL,
	DEPT_JOB_NM           VARCHAR(255) NOT NULL,
	DEPT_JOB_CN           VARCHAR(2500) NOT NULL,
	ATCH_FILE_ID          CHAR(20) NULL,
	CHARGER_ID            VARCHAR(20) NOT NULL,
	PRIORT                CHAR(1) NOT NULL,
	FRST_REGISTER_ID      VARCHAR(20) NOT NULL,
	FRST_REGIST_PNTTM     TIMESTAMP NOT NULL,
	LAST_UPDUSR_ID        VARCHAR(20) NULL,
	LAST_UPDT_PNTTM       TIMESTAMP NULL,
	 PRIMARY KEY (DEPT_JOB_ID)
)
;



CREATE UNIQUE INDEX COMTNDEPTJOB_PK ON COMTNDEPTJOB
(
	DEPT_JOB_ID
)
;



CREATE TABLE COMTNLEADERSCHDUL
(
	SCHDUL_ID             CHAR(20) NOT NULL,
	SCHDUL_SE             CHAR(1) NULL,
	SCHDUL_NM             VARCHAR(255) NOT NULL,
	SCHDUL_CN             VARCHAR(2500) NOT NULL,
	SCHDUL_PLACE          VARCHAR(255) NULL,
	LEADER_ID             VARCHAR(20) NOT NULL,
	REPTIT_SE_CODE        CHAR(1) NULL,
	SCHDUL_BGNDE          CHAR(20) NULL,
	SCHDUL_ENDDE          CHAR(20) NULL,
	SCHDUL_CHARGER_ID     VARCHAR(20) NOT NULL,
	FRST_REGISTER_ID      VARCHAR(20) NOT NULL,
	FRST_REGIST_PNTTM     TIMESTAMP NOT NULL,
	LAST_UPDUSR_ID        VARCHAR(20) NULL,
	LAST_UPDT_PNTTM       TIMESTAMP NULL,
	 PRIMARY KEY (SCHDUL_ID)
)
;



CREATE UNIQUE INDEX COMTNLEADERSCHDUL_PK ON COMTNLEADERSCHDUL
(
	SCHDUL_ID
)
;



CREATE TABLE COMTNLEADERSCHDULDE
(
	SCHDUL_ID             CHAR(20) NOT NULL,
	SCHDUL_DE             CHAR(8) NOT NULL,
	 PRIMARY KEY (SCHDUL_ID,SCHDUL_DE),
	FOREIGN KEY (SCHDUL_ID) REFERENCES COMTNLEADERSCHDUL(SCHDUL_ID)
)
;



CREATE UNIQUE INDEX COMTNLEADERSCHDULDE_PK ON COMTNLEADERSCHDULDE
(
	SCHDUL_ID,
	SCHDUL_DE
)
;

CREATE TABLE COMTNLEADERSTTUS
(
	LEADER_ID             VARCHAR(20)  NOT NULL ,
	LEADER_STTUS          CHAR(1)  NOT NULL ,
	FRST_REGIST_PNTTM     TIMESTAMP  NULL ,
	FRST_REGISTER_ID      VARCHAR(20)  NULL ,
	LAST_UPDT_PNTTM       TIMESTAMP  NULL ,
	LAST_UPDUSR_ID        VARCHAR(20)  NULL ,
	 PRIMARY KEY (LEADER_ID)
);


CREATE TABLE COMTNDEPTJOBBX
(
	DEPT_JOBBX_ID         CHAR(6) NOT NULL,
	DEPT_JOBBX_NM         VARCHAR(255) NOT NULL,
	DEPT_ID               VARCHAR(20) NOT NULL,
	INDICT_ORDR           NUMERIC(6) NULL,
	FRST_REGISTER_ID      VARCHAR(20) NOT NULL,
	FRST_REGIST_PNTTM     TIMESTAMP NOT NULL,
	LAST_UPDUSR_ID        VARCHAR(20) NULL,
	LAST_UPDT_PNTTM       TIMESTAMP NULL,
	 PRIMARY KEY (DEPT_JOBBX_ID)
)
;



CREATE UNIQUE INDEX COMTNDEPTJOBBX_PK ON COMTNDEPTJOBBX
(
	DEPT_JOBBX_ID
)
;



CREATE TABLE COMTNDTAUSESTATS
(
	DTA_USE_STATS_ID      CHAR(20) NOT NULL,
	BBS_ID                CHAR(20) NOT NULL,
	NTT_ID                NUMERIC(20) NOT NULL,
	ATCH_FILE_ID          CHAR(20) NOT NULL,
	FILE_SN               NUMERIC(10) NOT NULL,
	FRST_REGISTER_ID      VARCHAR(20) NULL,
	FRST_REGIST_PNTTM     TIMESTAMP NULL,
	LAST_UPDUSR_ID        VARCHAR(20) NULL,
	LAST_UPDT_PNTTM       TIMESTAMP NULL,
	 PRIMARY KEY (DTA_USE_STATS_ID)
)
;



CREATE UNIQUE INDEX COMTNDTAUSESTATS_PK ON COMTNDTAUSESTATS
(
	DTA_USE_STATS_ID
)
;



CREATE TABLE COMTNINSTTCODE
(
	INSTT_CODE            CHAR(7) NOT NULL,
	ALL_INSTT_NM          VARCHAR(255) NULL,
	LOWEST_INSTT_NM       VARCHAR(100) NULL,
	INSTT_ABRV_NM         VARCHAR(50) NULL,
	ODR                   CHAR(1) NULL,
	ORD                   CHAR(3) NULL,
	INSTT_ODR             CHAR(2) NULL,
	UPPER_INSTT_CODE      CHAR(7) NULL,
	BEST_INSTT_CODE       CHAR(7) NULL,
	REPRSNT_INSTT_CODE    CHAR(7) NULL,
	INSTT_TY_LCLAS        CHAR(2) NULL,
	INSTT_TY_MLSFC        CHAR(2) NULL,
	INSTT_TY_SCLAS        CHAR(2) NULL,
	TELNO                 VARCHAR(20) NULL,
	FXNUM                 VARCHAR(20) NULL,
	CREAT_DE              CHAR(20) NULL,
	ABL_DE                CHAR(20) NULL,
	ABL_ENNC              CHAR(1) NULL,
	CHANGE_DE             CHAR(20) NULL,
	CHANGE_TIME           VARCHAR(6) NULL,
	BSIS_DE               CHAR(20) NULL,
	SORT_ORDR             NUMERIC(8) NULL,
	FRST_REGISTER_ID      VARCHAR(20) NULL,
	FRST_REGIST_PNTTM     TIMESTAMP NULL,
	LAST_UPDUSR_ID        VARCHAR(20) NULL,
	LAST_UPDT_PNTTM       TIMESTAMP NULL,
	 PRIMARY KEY (INSTT_CODE)
)
;



CREATE UNIQUE INDEX COMTNINSTTCODE_PK ON COMTNINSTTCODE
(
	INSTT_CODE
)
;



CREATE TABLE COMTNINSTTCODERECPTNLOG
(
	OCCRRNC_DE            CHAR(20) NOT NULL,
	INSTT_CODE            CHAR(7) NOT NULL,
	OPERT_SN              NUMERIC(10) NOT NULL,
	CHANGE_SE_CODE        VARCHAR(2) NULL,
	PROCESS_SE            VARCHAR(2) NULL,
	ETC_CODE              CHAR(2) NULL,
	ALL_INSTT_NM          VARCHAR(255) NULL,
	LOWEST_INSTT_NM       VARCHAR(100) NULL,
	INSTT_ABRV_NM         VARCHAR(50) NULL,
	ODR                   CHAR(1) NULL,
	ORD                   CHAR(3) NULL,
	INSTT_ODR             CHAR(2) NULL,
	UPPER_INSTT_CODE      CHAR(7) NULL,
	BEST_INSTT_CODE       CHAR(7) NULL,
	REPRSNT_INSTT_CODE    CHAR(7) NULL,
	INSTT_TY_LCLAS        CHAR(2) NULL,
	INSTT_TY_MLSFC        CHAR(2) NULL,
	INSTT_TY_SCLAS        CHAR(2) NULL,
	TELNO                 VARCHAR(20) NULL,
	FXNUM                 VARCHAR(20) NULL,
	CREAT_DE              CHAR(20) NULL,
	ABL_DE                CHAR(20) NULL,
	ABL_ENNC              CHAR(1) NULL,
	CHANGE_DE             CHAR(20) NULL,
	CHANGE_TIME           VARCHAR(6) NULL,
	BSIS_DE               CHAR(20) NULL,
	SORT_ORDR             NUMERIC(8) NULL,
	FRST_REGISTER_ID      VARCHAR(20) NULL,
	FRST_REGIST_PNTTM     TIMESTAMP NULL,
	LAST_UPDUSR_ID        VARCHAR(20) NULL,
	LAST_UPDT_PNTTM       TIMESTAMP NULL,
	 PRIMARY KEY (OCCRRNC_DE,INSTT_CODE,OPERT_SN)
)
;



CREATE UNIQUE INDEX COMTNINSTTCODERECPTNLOG_PK ON COMTNINSTTCODERECPTNLOG
(
	OCCRRNC_DE,
	INSTT_CODE,
	OPERT_SN
)
;



CREATE TABLE COMTNINDVDLYRYCMANAGE
(
	OCCRRNC_YEAR          CHAR(4) NOT NULL,
	YRYC_OCCRRNC_CO       NUMERIC(5,1) NULL,
	USE_YRYC_CO           NUMERIC(5,1) NULL,
	REMNDR_YRYC_CO        NUMERIC(5,1) NULL,
	FRST_REGISTER_ID      VARCHAR(20) NULL,
	FRST_REGIST_PNTTM     TIMESTAMP NULL,
	LAST_UPDUSR_ID        VARCHAR(20) NULL,
	LAST_UPDT_PNTTM       TIMESTAMP NULL,
	USER_ID               VARCHAR(20) NOT NULL,
	 PRIMARY KEY (OCCRRNC_YEAR,USER_ID)
)
;



CREATE UNIQUE INDEX COMTNINDVDLYRYCMANAGE_PK ON COMTNINDVDLYRYCMANAGE
(
	OCCRRNC_YEAR,
	USER_ID
)
;



CREATE TABLE COMTNNTWRKSVCMNTRNG
(
	SYS_IP                VARCHAR(23) NOT NULL,
	SYS_PORT              NUMERIC(5) NOT NULL,
	SYS_NM                VARCHAR(255) NOT NULL,
	MNGR_NM               VARCHAR(60) NULL,
	MNGR_EMAIL_ADRES      VARCHAR(50) NULL,
	MNTRNG_STTUS          CHAR(2) NULL,
	CREAT_DT              TIMESTAMP NULL,
	FRST_REGISTER_ID      VARCHAR(20) NULL,
	FRST_REGIST_PNTTM     TIMESTAMP NULL,
	LAST_UPDUSR_ID        VARCHAR(20) NOT NULL,
	LAST_UPDT_PNTTM       TIMESTAMP NOT NULL,
	 PRIMARY KEY (SYS_IP,SYS_PORT)
)
;



CREATE UNIQUE INDEX COMTNNTWRKSVCMNTRNG_PK ON COMTNNTWRKSVCMNTRNG
(
	SYS_IP,
	SYS_PORT
)
;



CREATE TABLE COMTNNTWRKSVCMNTRNGLOGINFO
(
	SYS_IP                VARCHAR(23) NOT NULL,
	SYS_PORT              NUMERIC(5) NOT NULL,
	SYS_NM                VARCHAR(255) NOT NULL,
	MNTRNG_STTUS          CHAR(2) NULL,
	LOG_INFO              VARCHAR(2000) NULL,
	CREAT_DT              TIMESTAMP NULL,
	FRST_REGISTER_ID      VARCHAR(20) NULL,
	FRST_REGIST_PNTTM     TIMESTAMP NULL,
	LAST_UPDUSR_ID        VARCHAR(20) NOT NULL,
	LAST_UPDT_PNTTM       TIMESTAMP NOT NULL,
	LOG_ID                CHAR(20) NOT NULL,
	 PRIMARY KEY (SYS_IP,SYS_PORT,LOG_ID),
	FOREIGN KEY (SYS_IP,SYS_PORT) REFERENCES COMTNNTWRKSVCMNTRNG(SYS_IP,SYS_PORT)
)
;



CREATE UNIQUE INDEX COMTNNTWRKSVCMNTRNGLOGINFO_PK ON COMTNNTWRKSVCMNTRNGLOGINFO
(
	SYS_IP,
	SYS_PORT,
	LOG_ID
)
;



CREATE TABLE COMTNSERVEREQPMNINFO
(
	SERVER_EQPMN_ID       VARCHAR(20) NOT NULL,
	SERVER_EQPMN_NM       VARCHAR(60) NULL,
	SERVER_EQPMN_IP       VARCHAR(23) NULL,
	SERVER_EQPMN_MNGR     VARCHAR(60) NULL,
	MNGR_EMAIL_ADRES      VARCHAR(50) NULL,
	OPERSYSM_INFO         VARCHAR(2000) NULL,
	CPU_INFO              VARCHAR(2000) NULL,
	MORY_INFO             VARCHAR(2000) NULL,
	HDDISK                CHAR(18) NULL,
	ETC_INFO              VARCHAR(250) NULL,
	RGSDE                 TIMESTAMP NULL,
	FRST_REGISTER_ID      VARCHAR(20) NULL,
	FRST_REGIST_PNTTM     TIMESTAMP NULL,
	LAST_UPDUSR_ID        VARCHAR(20) NULL,
	LAST_UPDT_PNTTM       TIMESTAMP NULL,
	 PRIMARY KEY (SERVER_EQPMN_ID)
)
;



CREATE UNIQUE INDEX COMTNSERVEREQPMNINFO_PK ON COMTNSERVEREQPMNINFO
(
	SERVER_EQPMN_ID
)
;



CREATE TABLE COMTNSYNCHRNSERVERINFO
(
	SERVER_ID             CHAR(20) NOT NULL,
	SERVER_NM             VARCHAR(60) NULL,
	SERVER_IP             VARCHAR(23) NULL,
	SERVER_PORT           VARCHAR(10) NULL,
	FTP_ID                VARCHAR(20) NULL,
	FTP_PASSWORD          VARCHAR(20) NULL,
	SYNCHRN_LC            VARCHAR(255) NULL,
	REFLCT_AT             CHAR(1) NULL,
	FRST_REGISTER_ID      VARCHAR(20) NULL,
	FRST_REGIST_PNTTM     TIMESTAMP NULL,
	LAST_UPDUSR_ID        VARCHAR(20) NULL,
	LAST_UPDT_PNTTM       TIMESTAMP NULL,
	 PRIMARY KEY (SERVER_ID)
)
;



CREATE UNIQUE INDEX COMTNSYNCHRNSERVERINFO_PK ON COMTNSYNCHRNSERVERINFO
(
	SERVER_ID
)
;



CREATE TABLE COMTNSERVERINFO
(
	SERVER_ID             CHAR(20) NOT NULL,
	SERVER_NM             VARCHAR(60) NULL,
	SERVER_KND            CHAR(2) NULL,
	RGSDE                 TIMESTAMP NULL,
	FRST_REGISTER_ID      VARCHAR(20) NULL,
	FRST_REGIST_PNTTM     TIMESTAMP NULL,
	LAST_UPDUSR_ID        VARCHAR(20) NULL,
	LAST_UPDT_PNTTM       TIMESTAMP NULL,
	 PRIMARY KEY (SERVER_ID)
)
;



CREATE UNIQUE INDEX COMTNSERVERINFO_PK ON COMTNSERVERINFO
(
	SERVER_ID
)
;



CREATE TABLE COMTNSERVEREQPMNRELATE
(
	SERVER_EQPMN_ID       VARCHAR(20) NOT NULL,
	FRST_REGISTER_ID      VARCHAR(20) NULL,
	FRST_REGIST_PNTTM     TIMESTAMP NULL,
	LAST_UPDUSR_ID        VARCHAR(20) NULL,
	LAST_UPDT_PNTTM       TIMESTAMP NULL,
	SERVER_ID             CHAR(20) NOT NULL,
	 PRIMARY KEY (SERVER_EQPMN_ID,SERVER_ID),
	FOREIGN KEY (SERVER_EQPMN_ID) REFERENCES COMTNSERVEREQPMNINFO(SERVER_EQPMN_ID),
	FOREIGN KEY (SERVER_ID) REFERENCES COMTNSERVERINFO(SERVER_ID)
)
;



CREATE UNIQUE INDEX COMTNSERVEREQPMNRELATE_PK ON COMTNSERVEREQPMNRELATE
(
	SERVER_EQPMN_ID,
	SERVER_ID
)
;



CREATE TABLE COMTNSERVERRESRCELOGINFO
(
	SERVER_EQPMN_ID       VARCHAR(20) NOT NULL,
	CPU_USE_RT            NUMERIC(3) NULL,
	MORY_USE_RT           NUMERIC(3) NULL,
	SVC_STTUS             CHAR(2) NULL,
	LOG_INFO              VARCHAR(2000) NULL,
	CREAT_DT              TIMESTAMP NULL,
	FRST_REGISTER_ID      VARCHAR(20) NULL,
	FRST_REGIST_PNTTM     TIMESTAMP NULL,
	LAST_UPDUSR_ID        VARCHAR(20) NULL,
	SERVER_ID             CHAR(20) NOT NULL,
	LAST_UPDT_PNTTM       TIMESTAMP NULL,
	LOG_ID                CHAR(20) NOT NULL,
	 PRIMARY KEY (SERVER_EQPMN_ID,SERVER_ID,LOG_ID),
	FOREIGN KEY (SERVER_EQPMN_ID,SERVER_ID) REFERENCES COMTNSERVEREQPMNRELATE(SERVER_EQPMN_ID,SERVER_ID)
)
;



CREATE UNIQUE INDEX COMTNSERVERRESRCELOGINFO_PK ON COMTNSERVERRESRCELOGINFO
(
	SERVER_EQPMN_ID,
	SERVER_ID,
	LOG_ID
)
;



CREATE TABLE COMTNVCATNMANAGE
(
	APPLCNT_ID            VARCHAR(20) NOT NULL,
	VCATN_SE              CHAR(2) NOT NULL,
	BGNDE                 CHAR(8) NOT NULL,
	ENDDE                 CHAR(8) NOT NULL,
	VCATN_RESN            VARCHAR(200) NOT NULL,
	REQST_DE              CHAR(20) NOT NULL,
	OCCRRNC_YEAR          CHAR(4) NULL,
	SANCTNER_ID           VARCHAR(20) NULL,
	CONFM_AT              CHAR(1) NULL,
	SANCTN_DT             TIMESTAMP NULL,
	RETURN_RESN           VARCHAR(1000) NULL,
	INFRML_SANCTN_ID      CHAR(20) NULL,
	FRST_REGISTER_ID      VARCHAR(20) NULL,
	FRST_REGIST_PNTTM     TIMESTAMP NULL,
	LAST_UPDUSR_ID        VARCHAR(20) NULL,
	LAST_UPDT_PNTTM       TIMESTAMP NULL,
	NOON_SE               CHAR(1) NULL,
	 PRIMARY KEY (APPLCNT_ID,VCATN_SE,BGNDE,ENDDE)
)
;



CREATE UNIQUE INDEX COMTNVCATNMANAGE_PK ON COMTNVCATNMANAGE
(
	APPLCNT_ID,
	VCATN_SE,
	BGNDE,
	ENDDE
)
;



CREATE TABLE COMTNMEMOTODO
(
	TODO_ID               CHAR(20) NOT NULL,
	TODO_SJ               VARCHAR(255) NOT NULL,
	TODO_BEGIN_TIME       VARCHAR(14) NOT NULL,
	TODO_END_TIME         VARCHAR(14) NOT NULL,
	WRTER_ID              VARCHAR(20) NOT NULL,
	TODO_CN               VARCHAR(2500) NOT NULL,
	FRST_REGISTER_ID      VARCHAR(20) NOT NULL,
	FRST_REGIST_PNTTM     TIMESTAMP NOT NULL,
	LAST_UPDUSR_ID        VARCHAR(20) NULL,
	LAST_UPDT_PNTTM       TIMESTAMP NULL,
	 PRIMARY KEY (TODO_ID)
)
;



CREATE UNIQUE INDEX COMTNMEMOTODO_PK ON COMTNMEMOTODO
(
	TODO_ID
)
;



CREATE TABLE COMTNNOTE
(
	NOTE_ID               CHAR(20) NOT NULL,
	NOTE_SJ               VARCHAR(255) NULL,
	NOTE_CN               VARCHAR(4000) NULL,
	ATCH_FILE_ID          CHAR(20) NULL,
	FRST_REGISTER_ID      VARCHAR(20) NULL,
	FRST_REGIST_PNTTM     TIMESTAMP NULL,
	LAST_UPDUSR_ID        VARCHAR(20) NULL,
	LAST_UPDT_PNTTM       TIMESTAMP NULL,
	 PRIMARY KEY (NOTE_ID)
)
;



CREATE UNIQUE INDEX COMTNNOTE_PK ON COMTNNOTE
(
	NOTE_ID
)
;



CREATE TABLE COMTNNOTETRNSMIT
(
	NOTE_ID               CHAR(20) NOT NULL,
	NOTE_TRNSMIT_ID       CHAR(20) NOT NULL,
	TRNSMITER_ID          CHAR(20) NULL,
	DELETE_AT             CHAR(8) NULL,
	FRST_REGISTER_ID      VARCHAR(20) NULL,
	FRST_REGIST_PNTTM     TIMESTAMP NULL,
	LAST_UPDUSR_ID        VARCHAR(20) NULL,
	LAST_UPDT_PNTTM       TIMESTAMP NULL,
	 PRIMARY KEY (NOTE_ID,NOTE_TRNSMIT_ID),
	FOREIGN KEY (NOTE_ID) REFERENCES COMTNNOTE(NOTE_ID)
)
;



CREATE UNIQUE INDEX COMTNNOTETRNSMIT_PK ON COMTNNOTETRNSMIT
(
	NOTE_ID,
	NOTE_TRNSMIT_ID
)
;



CREATE INDEX COMTNNOTETRNSMIT_i01 ON COMTNNOTETRNSMIT
(
	NOTE_ID
)
;



CREATE TABLE COMTNNOTERECPTN
(
	NOTE_ID               CHAR(20) NOT NULL,
	NOTE_TRNSMIT_ID       CHAR(20) NOT NULL,
	NOTE_RECPTN_ID        CHAR(20) NOT NULL,
	RCVER_ID              CHAR(20) NULL,
	OPEN_YN               CHAR(1) NULL,
	RECPTN_SE             CHAR(1) NULL,
	FRST_REGISTER_ID      VARCHAR(20) NULL,
	FRST_REGIST_PNTTM     TIMESTAMP NULL,
	LAST_UPDUSR_ID        VARCHAR(20) NULL,
	LAST_UPDT_PNTTM       TIMESTAMP NULL,
	 PRIMARY KEY (NOTE_ID,NOTE_TRNSMIT_ID,NOTE_RECPTN_ID),
	FOREIGN KEY (NOTE_ID,NOTE_TRNSMIT_ID) REFERENCES COMTNNOTETRNSMIT(NOTE_ID,NOTE_TRNSMIT_ID)
)
;



CREATE UNIQUE INDEX COMTNNOTERECPTN_PK ON COMTNNOTERECPTN
(
	NOTE_ID,
	NOTE_TRNSMIT_ID,
	NOTE_RECPTN_ID
)
;



CREATE INDEX COMTNNOTERECPTN_i01 ON COMTNNOTERECPTN
(
	NOTE_ID,
	NOTE_TRNSMIT_ID
)
;



CREATE TABLE COMTNEVENTMANAGE
(
	EVENT_ID              CHAR(20) NOT NULL,
	EVENT_SE              VARCHAR(2) NOT NULL,
	EVENT_NM              VARCHAR(60) NOT NULL,
	EVENT_PURPS           VARCHAR(200) NOT NULL,
	EVENT_BGNDE           CHAR(20) NOT NULL,
	EVENT_ENDDE           CHAR(20) NOT NULL,
	EVENT_AUSPC_INSTT_NM  VARCHAR(60) NULL,
	EVENT_MNGT_INSTT_NM   VARCHAR(60) NULL,
	EVENT_PLACE           VARCHAR(200) NOT NULL,
	EVENT_CN              VARCHAR(1000) NULL,
	CT_OCCRRNC_AT         CHAR(1) NULL,
	PARTCPT_CT            NUMERIC(16) NULL,
	PSNCPA                NUMERIC(10) NOT NULL,
	REFRN_URL             VARCHAR(1024) NULL,
	RCEPT_BGNDE           CHAR(20) NOT NULL,
	RCEPT_ENDDE           CHAR(20) NOT NULL,
	FRST_REGISTER_ID      VARCHAR(20) NULL,
	FRST_REGIST_PNTTM     TIMESTAMP NULL,
	LAST_UPDUSR_ID        VARCHAR(20) NULL,
	LAST_UPDT_PNTTM       TIMESTAMP NULL,
	 PRIMARY KEY (EVENT_ID)
)
;



CREATE UNIQUE INDEX COMTNEVENTMANAGE_PK ON COMTNEVENTMANAGE
(
	EVENT_ID
)
;



CREATE TABLE COMTNEVENTATDRN
(
	APPLCNT_ID            VARCHAR(20) NOT NULL,
	EVENT_ID              CHAR(20) NOT NULL,
	REQST_DE              CHAR(20) NOT NULL,
	SANCTNER_ID           VARCHAR(20) NOT NULL,
	CONFM_AT              CHAR(1) NULL,
	SANCTN_DT             TIMESTAMP NULL,
	RETURN_RESN           VARCHAR(1000) NULL,
	INFRML_SANCTN_ID      CHAR(20) NULL,
	FRST_REGISTER_ID      VARCHAR(20) NULL,
	FRST_REGIST_PNTTM     TIMESTAMP NULL,
	LAST_UPDUSR_ID        VARCHAR(20) NULL,
	LAST_UPDT_PNTTM       TIMESTAMP NULL,
	 PRIMARY KEY (APPLCNT_ID,EVENT_ID),
	FOREIGN KEY (EVENT_ID) REFERENCES COMTNEVENTMANAGE(EVENT_ID)
)
;



CREATE UNIQUE INDEX COMTNEVENTATDRN_PK ON COMTNEVENTATDRN
(
	APPLCNT_ID,
	EVENT_ID
)
;



CREATE INDEX COMTNEVENTATDRN_i01 ON COMTNEVENTATDRN
(
	EVENT_ID
)
;



CREATE TABLE IMGTEMP
(
	ORGNZT_CODE           VARCHAR(10) NOT NULL,
	ERNCSL_SE             VARCHAR(2) NOT NULL,
	IMAGE_INFO            BYTEA NOT NULL,
	IMAGE_TY              VARCHAR(20) NULL,
	 PRIMARY KEY (ORGNZT_CODE,ERNCSL_SE)
)
;



CREATE UNIQUE INDEX IMGTEMP_PK ON IMGTEMP
(
	ORGNZT_CODE,
	ERNCSL_SE
)
;



CREATE TABLE IDS
(
	IDGEN_TABLE_NM        VARCHAR(20) NOT NULL,
	IDGEN_NEXT_ID         NUMERIC(30) NOT NULL,
	 PRIMARY KEY (IDGEN_TABLE_NM)
)
;



CREATE UNIQUE INDEX IDS_PK ON IDS
(
	IDGEN_TABLE_NM
)
;



CREATE TABLE COMTNWIKMNTHNGREPRT
(
	REPRT_ID              CHAR(6) NOT NULL,
	REPRT_SE              CHAR(1) NOT NULL,
	REPRT_SJ              VARCHAR(255) NOT NULL,
	REPORT_DE             CHAR(20) NOT NULL,
	WRTER_ID              VARCHAR(20) NOT NULL,
	REPORTR_ID            VARCHAR(20) NOT NULL,
	REPORT_BGNDE          CHAR(20) NOT NULL,
	REPORT_ENDDE          CHAR(20) NOT NULL,
	THSWIK_REPORT_CN      TEXT NOT NULL,
	NEXTWIK_REPORT_CN     TEXT NOT NULL,
	PARTCLR_MATTER        VARCHAR(2500) NULL,
	ATCH_FILE_ID          CHAR(20) NULL,
	CONFM_DT              VARCHAR(14) NULL,
	FRST_REGISTER_ID      VARCHAR(20) NOT NULL,
	FRST_REGIST_PNTTM     TIMESTAMP NOT NULL,
	LAST_UPDUSR_ID        VARCHAR(20) NULL,
	LAST_UPDT_PNTTM       TIMESTAMP NULL,
	 PRIMARY KEY (REPRT_ID)
)
;



CREATE UNIQUE INDEX COMTNWIKMNTHNGREPRT_PK ON COMTNWIKMNTHNGREPRT
(
	REPRT_ID
)
;



CREATE TABLE COMTNTWITTER
(
	USER_ID               VARCHAR(20) NOT NULL,
	CNSMR_KEY             VARCHAR(50) NOT NULL,
	CNSMR_SECRET          VARCHAR(50) NOT NULL,
	FRST_REGISTER_ID      VARCHAR(20) NULL,
	FRST_REGIST_PNTTM     TIMESTAMP NULL,
	LAST_UPDUSR_ID        VARCHAR(20) NULL,
	LAST_UPDT_PNTTM       TIMESTAMP NULL,
	 PRIMARY KEY (USER_ID)
)
;



CREATE UNIQUE INDEX COMTNTWITTER_PK ON COMTNTWITTER
(
	USER_ID
)
;



CREATE TABLE COMTNWIKIBKMK
(
	WIKI_BKMK_ID          CHAR(20) NOT NULL,
	USER_ID               VARCHAR(20) NOT NULL,
	WIKI_BKMK_NM          VARCHAR(1000) NOT NULL,
	FRST_REGISTER_ID      VARCHAR(20) NULL,
	FRST_REGIST_PNTTM     TIMESTAMP NULL,
	LAST_UPDUSR_ID        VARCHAR(20) NULL,
	LAST_UPDT_PNTTM       TIMESTAMP NULL,
	 PRIMARY KEY (WIKI_BKMK_ID,USER_ID)
)
;



CREATE UNIQUE INDEX COMTNWIKIBKMK_PK ON COMTNWIKIBKMK
(
	WIKI_BKMK_ID,
	USER_ID
)
;



CREATE TABLE COMTNRWARDMANAGE
(
	RWARD_ID              CHAR(20) NOT NULL,
	RWARDWNR_ID           VARCHAR(20) NOT NULL,
	RWARD_CODE            CHAR(2) NOT NULL,
	RWARD_DE              CHAR(20) NOT NULL,
	RWARD_NM              VARCHAR(255) NOT NULL,
	PBLEN_CN              VARCHAR(1000) NULL,
	SANCTNER_ID           VARCHAR(20) NOT NULL,
	CONFM_AT              CHAR(1) NULL,
	SANCTN_DT             TIMESTAMP NULL,
	RETURN_RESN           VARCHAR(1000) NULL,
	ATCH_FILE_ID          CHAR(20) NULL,
	INFRML_SANCTN_ID      CHAR(20) NULL,
	FRST_REGISTER_ID      VARCHAR(20) NULL,
	FRST_REGIST_PNTTM     TIMESTAMP NULL,
	LAST_UPDUSR_ID        VARCHAR(20) NULL,
	LAST_UPDT_PNTTM       TIMESTAMP NULL,
	 PRIMARY KEY (RWARD_ID)
)
;



CREATE UNIQUE INDEX COMTNRWARDMANAGE_PK ON COMTNRWARDMANAGE
(
	RWARD_ID
)
;



CREATE TABLE COMTNRSS
(
	RSS_ID                CHAR(20) NOT NULL,
	TRGET_SVC_NM          VARCHAR(255) NOT NULL,
	TRGET_SVC_TABLE       VARCHAR(255) NOT NULL,
	TRGET_SVC_LIST_CO     NUMERIC(5) NOT NULL,
	HDER_TITLE            VARCHAR(255) NOT NULL,
	HDER_LINK             VARCHAR(255) NOT NULL,
	HDER_DC               VARCHAR(4000) NOT NULL,
	HDER_TAG              VARCHAR(255) NULL,
	HDER_ETC              VARCHAR(250) NULL,
	BDT_TITLE             VARCHAR(255) NULL,
	BDT_LINK              VARCHAR(255) NULL,
	BDT_DC                VARCHAR(4000) NULL,
	BDT_TAG               VARCHAR(255) NULL,
	BDT_ETC_TAG           VARCHAR(255) NULL,
	FRST_REGISTER_ID      VARCHAR(20) NULL,
	FRST_REGIST_PNTTM     TIMESTAMP NULL,
	LAST_UPDUSR_ID        VARCHAR(20) NULL,
	LAST_UPDT_PNTTM       TIMESTAMP NULL,
	 PRIMARY KEY (RSS_ID)
)
;



CREATE UNIQUE INDEX COMTNRSS_PK ON COMTNRSS
(
	RSS_ID
)
;



CREATE TABLE COMTNRESTDE
(
	RESTDE_NO             NUMERIC(6) NOT NULL,
	RESTDE                CHAR(8) NULL,
	RESTDE_NM             VARCHAR(60) NULL,
	RESTDE_DC             VARCHAR(200) NULL,
	RESTDE_SE_CODE        VARCHAR(2) NULL,
	FRST_REGIST_PNTTM     TIMESTAMP NULL,
	FRST_REGISTER_ID      VARCHAR(20) NULL,
	LAST_UPDT_PNTTM       TIMESTAMP NULL,
	LAST_UPDUSR_ID        VARCHAR(20) NULL,
	 PRIMARY KEY (RESTDE_NO)
)
;



CREATE UNIQUE INDEX COMTNRESTDE_PK ON COMTNRESTDE
(
	RESTDE_NO
)
;



CREATE TABLE COMTNPROCESSMON
(
	PROCS_ID              CHAR(20) NOT NULL,
	PROCS_NM              VARCHAR(60) NULL,
	PROCS_STTUS           VARCHAR(3) NULL,
	CREAT_DT              TIMESTAMP NULL,
	MNGR_NM               VARCHAR(60) NULL,
	MNGR_EMAIL_ADRES      VARCHAR(50) NULL,
	FRST_REGISTER_ID      VARCHAR(20) NULL,
	FRST_REGIST_PNTTM     TIMESTAMP NULL,
	LAST_UPDUSR_ID        VARCHAR(20) NULL,
	LAST_UPDT_PNTTM       TIMESTAMP NULL,
	 PRIMARY KEY (PROCS_ID)
)
;



CREATE UNIQUE INDEX COMTNPROCESSMON_PK ON COMTNPROCESSMON
(
	PROCS_ID
)
;



CREATE TABLE COMTNPROCESSMONLOGINFO
(
	PROCS_ID              CHAR(20) NOT NULL,
	PROCS_NM              VARCHAR(60) NULL,
	PROCS_STTUS           VARCHAR(3) NULL,
	CREAT_DT              TIMESTAMP NULL,
	LOG_INFO              VARCHAR(2000) NULL,
	MNGR_NM               VARCHAR(60) NULL,
	MNGR_EMAIL_ADRES      VARCHAR(50) NULL,
	FRST_REGISTER_ID      VARCHAR(20) NULL,
	FRST_REGIST_PNTTM     TIMESTAMP NULL,
	LAST_UPDUSR_ID        VARCHAR(20) NULL,
	LAST_UPDT_PNTTM       TIMESTAMP NULL,
	LOG_ID                CHAR(20) NOT NULL,
	 PRIMARY KEY (PROCS_ID,LOG_ID),
	FOREIGN KEY (PROCS_ID) REFERENCES COMTNPROCESSMON(PROCS_ID)
)
;



CREATE UNIQUE INDEX COMTNPROCESSMONLOGINFO_PK ON COMTNPROCESSMONLOGINFO
(
	PROCS_ID,
	LOG_ID
)
;



CREATE TABLE COMTNNTWRKINFO
(
	NTWRK_ID              CHAR(20) NOT NULL,
	NTWRK_IP              VARCHAR(23) NULL,
	GTWY                  VARCHAR(23) NULL,
	SUBNET                VARCHAR(23) NULL,
	DOMN_NM_SERVER        VARCHAR(23) NULL,
	MANAGE_IEM            CHAR(2) NULL,
	USER_NM               VARCHAR(60) NULL,
	USE_AT                CHAR(1) NULL,
	RGSDE                 TIMESTAMP NULL,
	FRST_REGISTER_ID      VARCHAR(20) NULL,
	FRST_REGIST_PNTTM     TIMESTAMP NULL,
	LAST_UPDUSR_ID        VARCHAR(20) NULL,
	LAST_UPDT_PNTTM       TIMESTAMP NULL,
	 PRIMARY KEY (NTWRK_ID)
)
;



CREATE UNIQUE INDEX COMTNNTWRKINFO_PK ON COMTNNTWRKINFO
(
	NTWRK_ID
)
;



CREATE  VIEW COMVNUSERMASTER ( ESNTL_ID,USER_ID,PASSWORD,USER_NM,USER_ZIP,USER_ADRES,USER_EMAIL,GROUP_ID, USER_SE, ORGNZT_ID ) 
AS  
		SELECT ESNTL_ID, MBER_ID,PASSWORD,MBER_NM,ZIP,ADRES,MBER_EMAIL_ADRES,' ','GNR' AS USER_SE, ' ' ORGNZT_ID
		FROM COMTNGNRLMBER
		
	UNION ALL
		SELECT ESNTL_ID,EMPLYR_ID,PASSWORD,USER_NM,ZIP,HOUSE_ADRES,EMAIL_ADRES,GROUP_ID ,'USR' AS USER_SE, ORGNZT_ID
		FROM COMTNEMPLYRINFO
	UNION ALL
		SELECT ESNTL_ID,ENTRPRS_MBER_ID,ENTRPRS_MBER_PASSWORD,CMPNY_NM,ZIP,ADRES,APPLCNT_EMAIL_ADRES,' ' ,'ENT' AS USER_SE, ' ' ORGNZT_ID
		FROM COMTNENTRPRSMBER 
ORDER BY ESNTL_ID;



CREATE TABLE COMTNMEMOREPRT
(
	REPRT_SJ              VARCHAR(255) NOT NULL,
	REPORT_DE             CHAR(20) NOT NULL,
	WRTER_ID              VARCHAR(20) NOT NULL,
	REPORTR_ID            VARCHAR(20) NOT NULL,
	REPORT_CN             VARCHAR(2500) NOT NULL,
	ATCH_FILE_ID          CHAR(20) NULL,
	DRCT_MATTER           VARCHAR(2500) NULL,
	DRCT_MATTER_REGIST_DT  VARCHAR(14) NULL,
	REPORTR_INQIRE_DT     VARCHAR(14) NULL,
	FRST_REGISTER_ID      VARCHAR(20) NOT NULL,
	FRST_REGIST_PNTTM     TIMESTAMP NOT NULL,
	LAST_UPDUSR_ID        VARCHAR(20) NULL,
	LAST_UPDT_PNTTM       TIMESTAMP NULL,
	REPRT_ID              CHAR(6) NOT NULL,
	 PRIMARY KEY (REPRT_ID)
)
;



CREATE UNIQUE INDEX COMTNMEMOREPRT_PK ON COMTNMEMOREPRT
(
	REPRT_ID
)
;



CREATE TABLE COMTNMTGPLACEMANAGE
(
	MTGRUM_ID             CHAR(20) NOT NULL,
	MTGRUM_NM             VARCHAR(255) NOT NULL,
	OPN_BEGIN_TM          VARCHAR(6) NOT NULL,
	OPN_END_TM            VARCHAR(6) NOT NULL,
	ACEPTNC_POSBL_NMPR    NUMERIC(10) NOT NULL,
	LC_SE                 CHAR(5) NULL,
	LC_DETAIL             VARCHAR(200) NULL,
	ATCH_FILE_ID          CHAR(20) NULL,
	FRST_REGISTER_ID      VARCHAR(20) NULL,
	FRST_REGIST_PNTTM     TIMESTAMP NULL,
	LAST_UPDUSR_ID        VARCHAR(20) NULL,
	LAST_UPDT_PNTTM       TIMESTAMP NULL,
	 PRIMARY KEY (MTGRUM_ID)
)
;



CREATE UNIQUE INDEX COMTNMTGPLACEMANAGE_PK ON COMTNMTGPLACEMANAGE
(
	MTGRUM_ID
)
;



CREATE TABLE COMTNMTGPLACERESVE
(
	RESVE_ID              CHAR(20) NOT NULL,
	MTGRUM_ID             CHAR(20) NOT NULL,
	MTG_SJ                VARCHAR(100) NOT NULL,
	RSVCTM_ID             VARCHAR(20) NOT NULL,
	RESVE_DE              CHAR(8) NOT NULL,
	RESVE_BEGIN_TM        VARCHAR(14) NOT NULL,
	RESVE_END_TM          VARCHAR(14) NOT NULL,
	ATNDNC_NMPR           NUMERIC(10) NULL,
	MTG_CN                VARCHAR(2500) NULL,
	FRST_REGISTER_ID      VARCHAR(20) NULL,
	FRST_REGIST_PNTTM     TIMESTAMP NULL,
	LAST_UPDUSR_ID        VARCHAR(20) NULL,
	LAST_UPDT_PNTTM       TIMESTAMP NULL,
	 PRIMARY KEY (RESVE_ID),
	FOREIGN KEY (MTGRUM_ID) REFERENCES COMTNMTGPLACEMANAGE(MTGRUM_ID)
)
;



CREATE UNIQUE INDEX COMTNMTGPLACERESVE_PK ON COMTNMTGPLACERESVE
(
	RESVE_ID
)
;



CREATE INDEX COMTNMTGPLACERESVE_i01 ON COMTNMTGPLACERESVE
(
	MTGRUM_ID
)
;



CREATE TABLE COMTNFXTRSMANAGE
(
	FXTRS_CODE            CHAR(14) NOT NULL,
	FXTRS_NM              VARCHAR(100) NOT NULL,
	MAKR_NM               VARCHAR(100) NULL,
	PRICE                 NUMERIC(16) NULL,
	 PRIMARY KEY (FXTRS_CODE)
)
;



CREATE UNIQUE INDEX COMTNFXTRSMANAGE_PK ON COMTNFXTRSMANAGE
(
	FXTRS_CODE
)
;



CREATE TABLE COMTNMTGPLACEFXTRS
(
	MTGRUM_ID             CHAR(20) NOT NULL,
	FXTRS_CODE            CHAR(14) NOT NULL,
	QY                    NUMERIC(20) NOT NULL,
	FRST_REGISTER_ID      VARCHAR(20) NULL,
	FRST_REGIST_PNTTM     TIMESTAMP NULL,
	LAST_UPDUSR_ID        VARCHAR(20) NULL,
	LAST_UPDT_PNTTM       TIMESTAMP NULL,
	 PRIMARY KEY (MTGRUM_ID,FXTRS_CODE),
	FOREIGN KEY (MTGRUM_ID) REFERENCES COMTNMTGPLACEMANAGE(MTGRUM_ID),
	FOREIGN KEY (FXTRS_CODE) REFERENCES COMTNFXTRSMANAGE(FXTRS_CODE)
)
;



CREATE UNIQUE INDEX COMTNMTGPLACEFXTRS_PK ON COMTNMTGPLACEFXTRS
(
	MTGRUM_ID,
	FXTRS_CODE
)
;



CREATE INDEX COMTNMTGPLACEFXTRS_i01 ON COMTNMTGPLACEFXTRS
(
	MTGRUM_ID
)
;



CREATE TABLE COMTECOPSEQ
(
	TABLE_NAME            VARCHAR(20) NOT NULL,
	NEXT_ID               NUMERIC(30) NULL,
	 PRIMARY KEY (TABLE_NAME)
)
;



CREATE UNIQUE INDEX COMTECOPSEQ_PK ON COMTECOPSEQ
(
	TABLE_NAME
)
;



CREATE TABLE COMTNANNVRSRYMANAGE
(
	ANNVRSRY_ID           VARCHAR(20) NOT NULL,
	USER_ID               VARCHAR(20) NOT NULL,
	ANNVRSRY_SE           VARCHAR(2) NOT NULL,
	ANNVRSRY_NM           VARCHAR(255) NOT NULL,
	ANNVRSRY              CHAR(20) NOT NULL,
	CLDR_SE               CHAR(1) NOT NULL,
	ANNVRSRY_NTCN_SETUP   CHAR(1) NULL,
	ANNVRSRY_NTCN_BGNDE   CHAR(20) NULL,
	MEMO                  VARCHAR(1000) NULL,
	FRST_REGISTER_ID      VARCHAR(20) NULL,
	FRST_REGIST_PNTTM     TIMESTAMP NULL,
	LAST_UPDUSR_ID        VARCHAR(20) NULL,
	LAST_UPDT_PNTTM       TIMESTAMP NULL,
	REPTIT_AT             CHAR(1) NULL,
	 PRIMARY KEY (ANNVRSRY_ID)
)
;



CREATE UNIQUE INDEX COMTNANNVRSRYMANAGE_PK ON COMTNANNVRSRYMANAGE
(
	ANNVRSRY_ID
)
;

CREATE TABLE J_ATTACHFILE 
(
	FILE_ID VARCHAR(13) NOT NULL,
	FILE_SEQ INT NOT NULL,
	FILE_NAME VARCHAR(100) NOT NULL,
	FILE_SIZE INT,
	FILE_MASK VARCHAR(100),
	DOWNLOAD_COUNT INT,
	DOWNLOAD_EXPIRE_DATE VARCHAR(8),
	DOWNLOAD_LIMIT_COUNT INT,
	REG_DATE TIMESTAMP,
	DELETE_YN VARCHAR(1),
PRIMARY KEY (FILE_ID, FILE_SEQ)
)
;

CREATE UNIQUE INDEX J_ATTACHFILE_PK ON J_ATTACHFILE
(
	FILE_ID, FILE_SEQ
)
;

CREATE TABLE COMTNROUGHMAP (
    ROUGHMAP_ID       VARCHAR(75)   NOT NULL,
    ROUGHMAPSJ        VARCHAR(75)   NOT NULL,
    ROUGHMAPADDRESS   VARCHAR(200)  NULL,
    LA                VARCHAR(48)   NULL,
    LO                VARCHAR(48)   NULL,
    MARKERLA          VARCHAR(48)   NULL,
    MARKERLO          VARCHAR(48)   NULL,
    INFOWINDOW        VARCHAR(20)   NULL,
    ZOOMLEVEL         VARCHAR(10)   NULL,
    FRST_REGIST_PNTTM TIMESTAMP     NULL,
    FRST_REGISTER_ID  VARCHAR(20)   NULL,
    LAST_UPDT_PNTTM   TIMESTAMP     NULL,
    LAST_UPDUSR_ID    VARCHAR(20)   NULL
 );

CREATE TABLE COMTNPRIVACYLOG
(
	REQUST_ID            VARCHAR(20) NOT NULL,
	INQIRE_DT            TIMESTAMP NOT NULL,
	SRVC_NM              VARCHAR(500) NULL,
	INQIRE_INFO          VARCHAR(100) NULL,
	RQESTER_ID           VARCHAR(20) NULL,
	RQESTER_IP           VARCHAR(23) NULL,
	PRIMARY KEY (REQUST_ID)
)
;

CREATE UNIQUE INDEX COMTNPRIVACYLOG_PK ON COMTNPRIVACYLOG
(
	REQUST_ID
)
;

 CREATE TABLE COMTNCOMMUTE (
     WRKTM_ID           CHAR(20) NOT NULL,
     EMPLYR_ID          VARCHAR(20) NOT NULL,
     ORGNZT_ID          VARCHAR(20) NULL,
     WRKT_DT            VARCHAR(10) NOT NULL, 
     WRK_START_TIME     VARCHAR(14) NULL, 
     WRK_END_TIME       VARCHAR(14) NULL, 
     WRK_HOURS          CHAR(2) NULL, 
     OVTMWRK_HOURS      CHAR(2) NULL,
     WRK_START_STATUS   VARCHAR(10) NULL, 
     WRK_END_STATUS     VARCHAR(10) NULL, 
     RM                 VARCHAR(100) NULL,
     FRST_REGISTER_ID   VARCHAR(20) NULL,
     FRST_REGIST_PNTTM  TIMESTAMP NULL,
     LAST_UPDUSR_ID     VARCHAR(20) NULL,
     LAST_UPDT_PNTTM    TIMESTAMP NULL,
 PRIMARY KEY (EMPLYR_ID, WRKT_DT)
);

CREATE TABLE COMTNBLOG
(
	BLOG_ID             CHAR(20)  NOT NULL ,
	BLOG_NM             VARCHAR(255)  NOT NULL ,
	BLOG_INTRCN         VARCHAR(2400)  NULL ,
	USE_AT              CHAR(1)  NOT NULL ,
	REGIST_SE_CODE      CHAR(6)  NULL ,
	TMPLAT_ID           CHAR(20)  NULL ,
	FRST_REGIST_PNTTM   TIMESTAMP  NOT NULL ,
	FRST_REGISTER_ID    VARCHAR(20)  NOT NULL ,
	LAST_UPDT_PNTTM     TIMESTAMP  NULL ,
	LAST_UPDUSR_ID      VARCHAR(20)  NULL ,
	BBS_ID 			CHAR(20) DEFAULT NULL,
  	BLOG_AT 			CHAR(2) DEFAULT NULL,
	PRIMARY KEY (BLOG_ID)
);

CREATE TABLE COMTNBLOGUSER
(
	BLOG_ID               CHAR(20) NOT NULL,
	EMPLYR_ID             VARCHAR(20) NOT NULL,
	MNGR_AT               CHAR(1) NOT NULL,
	MBER_STTUS            VARCHAR(15) NULL,
	SBSCRB_DE             TIMESTAMP NULL,
	SECSN_DE              CHAR(20) NULL,
	USE_AT                CHAR(1) NULL,
	FRST_REGIST_PNTTM     TIMESTAMP NOT NULL,
	FRST_REGISTER_ID      VARCHAR(20) NOT NULL,
	LAST_UPDT_PNTTM       TIMESTAMP NULL,
	LAST_UPDUSR_ID        VARCHAR(20) NULL,
	PRIMARY KEY (BLOG_ID,EMPLYR_ID),
	FOREIGN KEY (BLOG_ID) REFERENCES COMTNBLOG(BLOG_ID)
);
