/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.rules;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.TreeMap;
import net.sourceforge.pmd.AbstractRule;
import net.sourceforge.pmd.ast.ASTArguments;
import net.sourceforge.pmd.ast.ASTClassOrInterfaceDeclaration;
import net.sourceforge.pmd.ast.ASTCompilationUnit;
import net.sourceforge.pmd.ast.ASTConstructorDeclaration;
import net.sourceforge.pmd.ast.ASTEnumDeclaration;
import net.sourceforge.pmd.ast.ASTExplicitConstructorInvocation;
import net.sourceforge.pmd.ast.ASTLiteral;
import net.sourceforge.pmd.ast.ASTMethodDeclaration;
import net.sourceforge.pmd.ast.ASTMethodDeclarator;
import net.sourceforge.pmd.ast.ASTName;
import net.sourceforge.pmd.ast.ASTPrimaryExpression;
import net.sourceforge.pmd.ast.ASTPrimaryPrefix;
import net.sourceforge.pmd.ast.ASTPrimarySuffix;
import net.sourceforge.pmd.ast.AccessNode;
import net.sourceforge.pmd.ast.Node;
import net.sourceforge.pmd.ast.SimpleJavaNode;
import net.sourceforge.pmd.ast.SimpleNode;
import net.sourceforge.retroweaver.runtime.java.util.Collections_;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ConstructorCallsOverridableMethod
extends AbstractRule {
    private static final NullEvalPackage nullEvalPackage = new NullEvalPackage();
    private final List<EvalPackage> evalPackages = new ArrayList<EvalPackage>();
    private static final /* synthetic */ Class class$net$sourceforge$pmd$ast$ASTPrimaryExpression;
    private static final /* synthetic */ Class class$net$sourceforge$pmd$ast$ASTMethodDeclaration;

    private static final int compareNodes(SimpleNode n1, SimpleNode n2) {
        int l2;
        int l1 = n1.getBeginLine();
        if (l1 == (l2 = n2.getBeginLine())) {
            return n1.getBeginColumn() - n2.getBeginColumn();
        }
        return l1 - l2;
    }

    private EvalPackage getCurrentEvalPackage() {
        return this.evalPackages.get(this.evalPackages.size() - 1);
    }

    private void putEvalPackage(EvalPackage ep) {
        this.evalPackages.add(ep);
    }

    private void removeCurrentEvalPackage() {
        this.evalPackages.remove(this.evalPackages.size() - 1);
    }

    private void clearEvalPackages() {
        this.evalPackages.clear();
    }

    private Object visitClassDec(ASTClassOrInterfaceDeclaration node, Object data) {
        String className = node.getImage();
        if (!node.isFinal()) {
            this.putEvalPackage(new EvalPackage(className));
        } else {
            this.putEvalPackage(nullEvalPackage);
        }
        super.visit(node, data);
        if (!(this.getCurrentEvalPackage() instanceof NullEvalPackage)) {
            while (this.evaluateDangerOfMethods(this.getCurrentEvalPackage().allMethodsOfClass)) {
            }
            this.evaluateDangerOfConstructors1(this.getCurrentEvalPackage().allPrivateConstructorsOfClass, this.getCurrentEvalPackage().allMethodsOfClass.keySet());
            while (this.evaluateDangerOfConstructors2(this.getCurrentEvalPackage().allPrivateConstructorsOfClass)) {
            }
            for (MethodInvocation meth : this.getCurrentEvalPackage().calledMethods) {
                for (MethodHolder h : this.getCurrentEvalPackage().allMethodsOfClass.keySet()) {
                    if (!h.isDangerous()) continue;
                    String methName = h.getASTMethodDeclarator().getImage();
                    int count = h.getASTMethodDeclarator().getParameterCount();
                    if (!methName.equals(meth.getName()) || meth.getArgumentCount() != count) continue;
                    this.addViolation(data, meth.getASTPrimaryExpression(), new StringBuffer().append("method '").append(h.getCalled()).append("'").toString());
                }
            }
            for (ConstructorHolder ch : this.getCurrentEvalPackage().allPrivateConstructorsOfClass.keySet()) {
                if (!ch.isDangerous()) continue;
                int paramCount = ch.getASTConstructorDeclaration().getParameterCount();
                for (ConstructorInvocation ci : this.getCurrentEvalPackage().calledConstructors) {
                    if (ci.getArgumentCount() != paramCount) continue;
                    this.addViolation(data, ci.getASTExplicitConstructorInvocation(), "constructor");
                }
            }
        }
        this.removeCurrentEvalPackage();
        return data;
    }

    private boolean evaluateDangerOfMethods(Map<MethodHolder, List<MethodInvocation>> classMethodMap) {
        boolean found = false;
        for (Map.Entry<MethodHolder, List<MethodInvocation>> entry : classMethodMap.entrySet()) {
            MethodHolder h = entry.getKey();
            List<MethodInvocation> calledMeths = entry.getValue();
            Iterator<MethodInvocation> calledMethsIter = calledMeths.iterator();
            block1: while (calledMethsIter.hasNext() && !h.isDangerous()) {
                MethodInvocation meth = calledMethsIter.next();
                for (MethodHolder h3 : classMethodMap.keySet()) {
                    if (!h3.isDangerous()) continue;
                    String matchMethodName = h3.getASTMethodDeclarator().getImage();
                    int matchMethodParamCount = h3.getASTMethodDeclarator().getParameterCount();
                    if (!matchMethodName.equals(meth.getName()) || matchMethodParamCount != meth.getArgumentCount()) continue;
                    h.setDangerous();
                    h.setCalledMethod(matchMethodName);
                    found = true;
                    continue block1;
                }
            }
        }
        return found;
    }

    private void evaluateDangerOfConstructors1(Map<ConstructorHolder, List<MethodInvocation>> classConstructorMap, Set<MethodHolder> evaluatedMethods) {
        for (Map.Entry<ConstructorHolder, List<MethodInvocation>> entry : classConstructorMap.entrySet()) {
            ConstructorHolder ch = entry.getKey();
            if (ch.isDangerous()) continue;
            List<MethodInvocation> calledMeths = entry.getValue();
            Iterator<MethodInvocation> calledMethsIter = calledMeths.iterator();
            block1: while (calledMethsIter.hasNext() && !ch.isDangerous()) {
                MethodInvocation meth = calledMethsIter.next();
                String methName = meth.getName();
                int methArgCount = meth.getArgumentCount();
                for (MethodHolder h : evaluatedMethods) {
                    if (!h.isDangerous()) continue;
                    String matchName = h.getASTMethodDeclarator().getImage();
                    int matchParamCount = h.getASTMethodDeclarator().getParameterCount();
                    if (!methName.equals(matchName) || methArgCount != matchParamCount) continue;
                    ch.setDangerous(true);
                    continue block1;
                }
            }
        }
    }

    private boolean evaluateDangerOfConstructors2(Map<ConstructorHolder, List<MethodInvocation>> classConstructorMap) {
        boolean found = false;
        for (ConstructorHolder ch : classConstructorMap.keySet()) {
            ConstructorInvocation calledC = ch.getCalledConstructor();
            if (calledC == null || ch.isDangerous()) continue;
            int cCount = calledC.getArgumentCount();
            Iterator<ConstructorHolder> innerConstIter = classConstructorMap.keySet().iterator();
            while (innerConstIter.hasNext() && !ch.isDangerous()) {
                int matchConstArgCount;
                ConstructorHolder h2 = innerConstIter.next();
                if (!h2.isDangerous() || (matchConstArgCount = h2.getASTConstructorDeclaration().getParameterCount()) != cCount) continue;
                ch.setDangerous(true);
                found = true;
            }
        }
        return found;
    }

    @Override
    public Object visit(ASTCompilationUnit node, Object data) {
        this.clearEvalPackages();
        return super.visit(node, data);
    }

    @Override
    public Object visit(ASTEnumDeclaration node, Object data) {
        return data;
    }

    @Override
    public Object visit(ASTClassOrInterfaceDeclaration node, Object data) {
        if (!node.isInterface()) {
            return this.visitClassDec(node, data);
        }
        this.putEvalPackage(nullEvalPackage);
        Object o = super.visit(node, data);
        this.removeCurrentEvalPackage();
        return o;
    }

    @Override
    public Object visit(ASTConstructorDeclaration node, Object data) {
        if (!(this.getCurrentEvalPackage() instanceof NullEvalPackage)) {
            ArrayList<MethodInvocation> calledMethodsOfConstructor = new ArrayList<MethodInvocation>();
            ConstructorHolder ch = new ConstructorHolder(node);
            ConstructorCallsOverridableMethod.addCalledMethodsOfNode(node, calledMethodsOfConstructor, this.getCurrentEvalPackage().m_ClassName);
            if (!node.isPrivate()) {
                this.getCurrentEvalPackage().calledMethods.addAll(calledMethodsOfConstructor);
                ASTExplicitConstructorInvocation eci = ch.getASTExplicitConstructorInvocation();
                if (eci != null && eci.isThis()) {
                    this.getCurrentEvalPackage().calledConstructors.add(ch.getCalledConstructor());
                }
            } else {
                this.getCurrentEvalPackage().allPrivateConstructorsOfClass.put(ch, calledMethodsOfConstructor);
            }
        }
        return super.visit(node, data);
    }

    @Override
    public Object visit(ASTMethodDeclarator node, Object data) {
        if (!(this.getCurrentEvalPackage() instanceof NullEvalPackage)) {
            AccessNode parent = (AccessNode)node.jjtGetParent();
            MethodHolder h = new MethodHolder(node);
            if (!(parent.isAbstract() || parent.isPrivate() || parent.isStatic() || parent.isFinal())) {
                h.setDangerous();
                Class<?> clazz = class$net$sourceforge$pmd$ast$ASTMethodDeclaration;
                if (clazz == null) {
                    clazz = class$net$sourceforge$pmd$ast$ASTMethodDeclaration = new ASTMethodDeclaration[0].getClass().getComponentType();
                }
                ASTMethodDeclaration decl = (ASTMethodDeclaration)node.getFirstParentOfType(clazz);
                h.setCalledMethod(decl.getMethodName());
            }
            ArrayList<MethodInvocation> l = new ArrayList<MethodInvocation>();
            ConstructorCallsOverridableMethod.addCalledMethodsOfNode((SimpleNode)parent, l, this.getCurrentEvalPackage().m_ClassName);
            this.getCurrentEvalPackage().allMethodsOfClass.put(h, l);
        }
        return super.visit(node, data);
    }

    private static void addCalledMethodsOfNode(AccessNode node, List<MethodInvocation> calledMethods, String className) {
        ArrayList<ASTPrimaryExpression> expressions = new ArrayList<ASTPrimaryExpression>();
        Class<?> clazz = class$net$sourceforge$pmd$ast$ASTPrimaryExpression;
        if (clazz == null) {
            clazz = class$net$sourceforge$pmd$ast$ASTPrimaryExpression = new ASTPrimaryExpression[0].getClass().getComponentType();
        }
        node.findChildrenOfType(clazz, expressions, false);
        ConstructorCallsOverridableMethod.addCalledMethodsOfNodeImpl(expressions, calledMethods, className);
    }

    private static void addCalledMethodsOfNode(SimpleNode node, List<MethodInvocation> calledMethods, String className) {
        ArrayList<ASTPrimaryExpression> expressions = new ArrayList<ASTPrimaryExpression>();
        Class<?> clazz = class$net$sourceforge$pmd$ast$ASTPrimaryExpression;
        if (clazz == null) {
            clazz = class$net$sourceforge$pmd$ast$ASTPrimaryExpression = new ASTPrimaryExpression[0].getClass().getComponentType();
        }
        node.findChildrenOfType(clazz, expressions);
        ConstructorCallsOverridableMethod.addCalledMethodsOfNodeImpl(expressions, calledMethods, className);
    }

    private static void addCalledMethodsOfNodeImpl(List<ASTPrimaryExpression> expressions, List<MethodInvocation> calledMethods, String className) {
        for (ASTPrimaryExpression ape : expressions) {
            MethodInvocation meth = ConstructorCallsOverridableMethod.findMethod(ape, className);
            if (meth == null) continue;
            calledMethods.add(meth);
        }
    }

    private static MethodInvocation findMethod(ASTPrimaryExpression node, String className) {
        if (node.jjtGetNumChildren() > 0 && node.jjtGetChild(0).jjtGetNumChildren() > 0 && node.jjtGetChild(0).jjtGetChild(0) instanceof ASTLiteral) {
            return null;
        }
        MethodInvocation meth = MethodInvocation.getMethod(node);
        boolean found = false;
        if (meth != null && meth.getReferenceNames().size() == 0 && !meth.isSuper()) {
            List<String> packClass = meth.getQualifierNames();
            if (!packClass.isEmpty()) {
                for (String name : packClass) {
                    if (!name.equals(className)) continue;
                    found = true;
                    break;
                }
            } else {
                found = true;
            }
        }
        return found ? meth : null;
    }

    private static String getNameFromPrefix(ASTPrimaryPrefix node) {
        Node nnode;
        String name = null;
        if (node.jjtGetNumChildren() == 1 && (nnode = node.jjtGetChild(0)) instanceof ASTName) {
            name = ((ASTName)nnode).getImage();
        }
        return name;
    }

    private static final class NullEvalPackage
    extends EvalPackage {
        public NullEvalPackage() {
            this.m_ClassName = "";
            this.calledMethods = Collections_.emptyList();
            this.allMethodsOfClass = Collections_.emptyMap();
            this.calledConstructors = Collections_.emptyList();
            this.allPrivateConstructorsOfClass = Collections_.emptyMap();
        }
    }

    private static class EvalPackage {
        public String m_ClassName;
        public List<MethodInvocation> calledMethods;
        public Map<MethodHolder, List<MethodInvocation>> allMethodsOfClass;
        public List<ConstructorInvocation> calledConstructors;
        public Map<ConstructorHolder, List<MethodInvocation>> allPrivateConstructorsOfClass;

        public EvalPackage() {
        }

        public EvalPackage(String className) {
            this.m_ClassName = className;
            this.calledMethods = new ArrayList<MethodInvocation>();
            this.allMethodsOfClass = new TreeMap<MethodHolder, List<MethodInvocation>>(new MethodHolderComparator());
            this.calledConstructors = new ArrayList<ConstructorInvocation>();
            this.allPrivateConstructorsOfClass = new TreeMap<ConstructorHolder, List<MethodInvocation>>(new ConstructorHolderComparator());
        }
    }

    /*
     * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ConstructorHolderComparator
    implements Comparator<ConstructorHolder> {
        private ConstructorHolderComparator() {
        }

        @Override
        public int compare(ConstructorHolder o1, ConstructorHolder o2) {
            return ConstructorCallsOverridableMethod.compareNodes(o1.getASTConstructorDeclaration(), o2.getASTConstructorDeclaration());
        }
    }

    /*
     * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class MethodHolderComparator
    implements Comparator<MethodHolder> {
        private MethodHolderComparator() {
        }

        @Override
        public int compare(MethodHolder o1, MethodHolder o2) {
            return ConstructorCallsOverridableMethod.compareNodes(o1.getASTMethodDeclarator(), o2.getASTMethodDeclarator());
        }
    }

    private final class ConstructorHolder {
        private ASTConstructorDeclaration m_Cd;
        private boolean m_Dangerous;
        private ConstructorInvocation m_Ci;
        private boolean m_CiInitialized;
        private static final /* synthetic */ Class class$net$sourceforge$pmd$ast$ASTExplicitConstructorInvocation;

        public ConstructorHolder(ASTConstructorDeclaration cd) {
            this.m_Cd = cd;
        }

        public ASTConstructorDeclaration getASTConstructorDeclaration() {
            return this.m_Cd;
        }

        public ConstructorInvocation getCalledConstructor() {
            if (!this.m_CiInitialized) {
                this.initCI();
            }
            return this.m_Ci;
        }

        public ASTExplicitConstructorInvocation getASTExplicitConstructorInvocation() {
            ASTExplicitConstructorInvocation eci = null;
            if (!this.m_CiInitialized) {
                this.initCI();
            }
            if (this.m_Ci != null) {
                eci = this.m_Ci.getASTExplicitConstructorInvocation();
            }
            return eci;
        }

        private void initCI() {
            ArrayList expressions = new ArrayList();
            Class<?> clazz = class$net$sourceforge$pmd$ast$ASTExplicitConstructorInvocation;
            if (clazz == null) {
                clazz = class$net$sourceforge$pmd$ast$ASTExplicitConstructorInvocation = new ASTExplicitConstructorInvocation[0].getClass().getComponentType();
            }
            this.m_Cd.findChildrenOfType(clazz, expressions);
            if (!expressions.isEmpty()) {
                ASTExplicitConstructorInvocation eci = (ASTExplicitConstructorInvocation)expressions.get(0);
                this.m_Ci = new ConstructorInvocation(eci);
            }
            this.m_CiInitialized = true;
        }

        public boolean isDangerous() {
            return this.m_Dangerous;
        }

        public void setDangerous(boolean dangerous) {
            this.m_Dangerous = dangerous;
        }
    }

    private static final class MethodHolder {
        private ASTMethodDeclarator amd;
        private boolean dangerous;
        private String called;

        public MethodHolder(ASTMethodDeclarator amd) {
            this.amd = amd;
        }

        public void setCalledMethod(String name) {
            this.called = name;
        }

        public String getCalled() {
            return this.called;
        }

        public ASTMethodDeclarator getASTMethodDeclarator() {
            return this.amd;
        }

        public boolean isDangerous() {
            return this.dangerous;
        }

        public void setDangerous() {
            this.dangerous = true;
        }
    }

    private static final class ConstructorInvocation {
        private ASTExplicitConstructorInvocation m_Eci;
        private String name;
        private int count = 0;
        private static final /* synthetic */ Class class$net$sourceforge$pmd$ast$ASTArguments;

        public ConstructorInvocation(ASTExplicitConstructorInvocation eci) {
            this.m_Eci = eci;
            ArrayList l = new ArrayList();
            Class<?> clazz = class$net$sourceforge$pmd$ast$ASTArguments;
            if (clazz == null) {
                clazz = class$net$sourceforge$pmd$ast$ASTArguments = new ASTArguments[0].getClass().getComponentType();
            }
            eci.findChildrenOfType(clazz, l);
            if (!l.isEmpty()) {
                ASTArguments aa = (ASTArguments)l.get(0);
                this.count = aa.getArgumentCount();
            }
            this.name = eci.getImage();
        }

        public ASTExplicitConstructorInvocation getASTExplicitConstructorInvocation() {
            return this.m_Eci;
        }

        public int getArgumentCount() {
            return this.count;
        }

        public String getName() {
            return this.name;
        }
    }

    /*
     * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class MethodInvocation {
        private String m_Name;
        private ASTPrimaryExpression m_Ape;
        private List<String> m_ReferenceNames;
        private List<String> m_QualifierNames;
        private int m_ArgumentSize;
        private boolean m_Super;

        private MethodInvocation(ASTPrimaryExpression ape, List<String> qualifierNames, List<String> referenceNames, String name, int argumentSize, boolean superCall) {
            this.m_Ape = ape;
            this.m_QualifierNames = qualifierNames;
            this.m_ReferenceNames = referenceNames;
            this.m_Name = name;
            this.m_ArgumentSize = argumentSize;
            this.m_Super = superCall;
        }

        public boolean isSuper() {
            return this.m_Super;
        }

        public String getName() {
            return this.m_Name;
        }

        public int getArgumentCount() {
            return this.m_ArgumentSize;
        }

        public List<String> getReferenceNames() {
            return this.m_ReferenceNames;
        }

        public List<String> getQualifierNames() {
            return this.m_QualifierNames;
        }

        public ASTPrimaryExpression getASTPrimaryExpression() {
            return this.m_Ape;
        }

        public static MethodInvocation getMethod(ASTPrimaryExpression node) {
            Node lastNode;
            MethodInvocation meth = null;
            int i = node.jjtGetNumChildren();
            if (i > 1 && (lastNode = node.jjtGetChild(i - 1)).jjtGetNumChildren() == 1 && lastNode.jjtGetChild(0) instanceof ASTArguments) {
                String name;
                StringTokenizer st;
                String toParse;
                Node child;
                int x;
                ArrayList<String> varNames = new ArrayList<String>();
                ArrayList<String> packagesAndClasses = new ArrayList<String>();
                String methodName = null;
                ASTArguments args = (ASTArguments)lastNode.jjtGetChild(0);
                int numOfArguments = args.getArgumentCount();
                boolean superFirst = false;
                int thisIndex = -1;
                for (x = 0; x < i - 1; ++x) {
                    SimpleJavaNode child2;
                    child = node.jjtGetChild(x);
                    if (child instanceof ASTPrimarySuffix) {
                        child2 = (ASTPrimarySuffix)child;
                        if (child2.getImage() != null || child2.jjtGetNumChildren() != 0) continue;
                        thisIndex = x;
                        break;
                    }
                    if (!(child instanceof ASTPrimaryPrefix) || ConstructorCallsOverridableMethod.getNameFromPrefix((ASTPrimaryPrefix)(child2 = (ASTPrimaryPrefix)child)) != null) continue;
                    if (child2.getImage() == null) {
                        thisIndex = x;
                        break;
                    }
                    superFirst = true;
                    thisIndex = x;
                    break;
                }
                if (thisIndex != -1) {
                    if (superFirst) {
                        ASTPrimaryPrefix child2 = (ASTPrimaryPrefix)node.jjtGetChild(0);
                        String name2 = child2.getImage();
                        if (i == 2) {
                            methodName = name2;
                        } else {
                            varNames.add(name2);
                        }
                        for (int x2 = 1; x2 < i - 1; ++x2) {
                            child = node.jjtGetChild(x2);
                            ASTPrimarySuffix ps = (ASTPrimarySuffix)child;
                            if (ps.isArguments()) continue;
                            String name3 = ((ASTPrimarySuffix)child).getImage();
                            if (x2 == i - 2) {
                                methodName = name3;
                                continue;
                            }
                            varNames.add(name3);
                        }
                    } else {
                        if (thisIndex == 1) {
                            ASTPrimaryPrefix child3 = (ASTPrimaryPrefix)node.jjtGetChild(0);
                            toParse = ConstructorCallsOverridableMethod.getNameFromPrefix(child3);
                            st = new StringTokenizer(toParse, ".");
                            while (st.hasMoreTokens()) {
                                packagesAndClasses.add(st.nextToken());
                            }
                        }
                        for (x = thisIndex + 1; x < i - 1; ++x) {
                            child = (ASTPrimarySuffix)node.jjtGetChild(x);
                            if (((ASTPrimarySuffix)child).isArguments()) continue;
                            name = ((SimpleNode)child).getImage();
                            if (x == i - 2) {
                                methodName = name;
                                continue;
                            }
                            varNames.add(name);
                        }
                    }
                } else {
                    ASTPrimaryPrefix child4 = (ASTPrimaryPrefix)node.jjtGetChild(0);
                    toParse = ConstructorCallsOverridableMethod.getNameFromPrefix(child4);
                    st = new StringTokenizer(toParse, ".");
                    while (st.hasMoreTokens()) {
                        String value = st.nextToken();
                        if (!st.hasMoreTokens()) {
                            if (i == 2) {
                                methodName = value;
                                continue;
                            }
                            varNames.add(value);
                            continue;
                        }
                        varNames.add(value);
                    }
                    for (int x3 = 1; x3 < i - 1; ++x3) {
                        child = (ASTPrimarySuffix)node.jjtGetChild(x3);
                        if (((ASTPrimarySuffix)child).isArguments()) continue;
                        name = ((SimpleNode)child).getImage();
                        if (x3 == i - 2) {
                            methodName = name;
                            continue;
                        }
                        varNames.add(name);
                    }
                }
                meth = new MethodInvocation(node, packagesAndClasses, varNames, methodName, numOfArguments, superFirst);
            }
            return meth;
        }

        public void show() {
            System.out.println("<MethodInvocation>");
            System.out.println("  <Qualifiers>");
            for (String name : this.getQualifierNames()) {
                System.out.println(new StringBuffer().append("    ").append(name).toString());
            }
            System.out.println("  </Qualifiers>");
            System.out.println(new StringBuffer().append("  <Super>").append(this.isSuper()).append("</Super>").toString());
            System.out.println("  <References>");
            for (String name : this.getReferenceNames()) {
                System.out.println(new StringBuffer().append("    ").append(name).toString());
            }
            System.out.println("  </References>");
            System.out.println(new StringBuffer().append("  <Name>").append(this.getName()).append("</Name>").toString());
            System.out.println("</MethodInvocation>");
        }
    }
}

