/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.symboltable;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.sourceforge.pmd.ast.ASTConstructorDeclaration;
import net.sourceforge.pmd.ast.ASTName;
import net.sourceforge.pmd.ast.SimpleNode;
import net.sourceforge.pmd.symboltable.AbstractScope;
import net.sourceforge.pmd.symboltable.ImageFinderFunction;
import net.sourceforge.pmd.symboltable.NameDeclaration;
import net.sourceforge.pmd.symboltable.NameOccurrence;
import net.sourceforge.pmd.symboltable.VariableNameDeclaration;
import net.sourceforge.pmd.symboltable.VariableUsageFinderFunction;
import net.sourceforge.pmd.util.Applier;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MethodScope
extends AbstractScope {
    protected Map<VariableNameDeclaration, List<NameOccurrence>> variableNames = new HashMap<VariableNameDeclaration, List<NameOccurrence>>();
    private SimpleNode node;

    public MethodScope(SimpleNode node) {
        this.node = node;
    }

    @Override
    public MethodScope getEnclosingMethodScope() {
        return this;
    }

    @Override
    public Map<VariableNameDeclaration, List<NameOccurrence>> getVariableDeclarations() {
        VariableUsageFinderFunction f = new VariableUsageFinderFunction(this.variableNames);
        Applier.apply(f, this.variableNames.keySet().iterator());
        return f.getUsed();
    }

    @Override
    public NameDeclaration addVariableNameOccurrence(NameOccurrence occurrence) {
        NameDeclaration decl = this.findVariableHere(occurrence);
        if (decl != null && !occurrence.isThisOrSuper()) {
            this.variableNames.get(decl).add(occurrence);
            SimpleNode n = occurrence.getLocation();
            if (n instanceof ASTName) {
                ((ASTName)n).setNameDeclaration(decl);
            }
        }
        return decl;
    }

    @Override
    public void addDeclaration(VariableNameDeclaration variableDecl) {
        if (this.variableNames.containsKey(variableDecl)) {
            throw new RuntimeException(new StringBuffer().append("Variable ").append(variableDecl).append(" is already in the symbol table").toString());
        }
        this.variableNames.put(variableDecl, new ArrayList());
    }

    @Override
    public NameDeclaration findVariableHere(NameOccurrence occurrence) {
        if (occurrence.isThisOrSuper() || occurrence.isMethodOrConstructorInvocation()) {
            return null;
        }
        ImageFinderFunction finder = new ImageFinderFunction(occurrence.getImage());
        Applier.apply(finder, this.variableNames.keySet().iterator());
        return finder.getDecl();
    }

    public String getName() {
        if (this.node instanceof ASTConstructorDeclaration) {
            return this.getEnclosingClassScope().getClassName();
        }
        return ((SimpleNode)this.node.jjtGetChild(1)).getImage();
    }

    public String toString() {
        return new StringBuffer().append("MethodScope:").append(this.glomNames(this.variableNames.keySet())).toString();
    }
}

