/*
 * Decompiled with CFR 0.152.
 */
package org.apache.log4j;

import java.io.IOException;
import org.apache.log4j.Appender;
import org.apache.log4j.Layout;
import org.apache.log4j.helpers.OnlyOnceErrorHandler;
import org.apache.log4j.helpers.OptionConverter;
import org.apache.log4j.rolling.FixedWindowRollingPolicy;
import org.apache.log4j.rolling.SizeBasedTriggeringPolicy;
import org.apache.log4j.spi.ErrorHandler;
import org.apache.log4j.spi.Filter;
import org.apache.log4j.spi.LoggerRepository;
import org.apache.log4j.spi.LoggingEvent;
import org.apache.log4j.spi.OptionHandler;

public class RollingFileAppender
implements Appender,
OptionHandler {
    private final ErrorHandler errorHandler = new OnlyOnceErrorHandler();
    private long maxFileSize = 0xA00000L;
    private int maxBackupIndex = 1;
    private final org.apache.log4j.rolling.RollingFileAppender rfa = new org.apache.log4j.rolling.RollingFileAppender();

    public RollingFileAppender() {
    }

    public RollingFileAppender(Layout layout, String filename, boolean append) throws IOException {
        this.rfa.setLayout(layout);
        this.rfa.setFile(filename);
        this.rfa.setAppend(append);
        this.activateOptions();
    }

    public RollingFileAppender(Layout layout, String filename) throws IOException {
        this.rfa.setLayout(layout);
        this.rfa.setFile(filename);
        this.activateOptions();
    }

    public int getMaxBackupIndex() {
        return this.maxBackupIndex;
    }

    public long getMaximumFileSize() {
        return this.maxFileSize;
    }

    public void setMaxBackupIndex(int maxBackups) {
        this.maxBackupIndex = maxBackups;
    }

    public void setMaximumFileSize(long maxFileSize) {
        this.maxFileSize = maxFileSize;
    }

    public void setMaxFileSize(String value) {
        this.maxFileSize = OptionConverter.toFileSize(value, this.maxFileSize + 1L);
    }

    public void activateOptions() {
        SizeBasedTriggeringPolicy trigger = new SizeBasedTriggeringPolicy();
        trigger.setMaxFileSize(this.maxFileSize);
        trigger.activateOptions();
        this.rfa.setTriggeringPolicy(trigger);
        FixedWindowRollingPolicy rolling = new FixedWindowRollingPolicy();
        rolling.setMinIndex(1);
        rolling.setMaxIndex(this.maxBackupIndex);
        this.rfa.setFile(this.rfa.getFile());
        rolling.setFileNamePattern(this.rfa.getFile() + ".%i");
        rolling.activateOptions();
        this.rfa.setRollingPolicy(rolling);
        this.rfa.activateOptions();
    }

    public void addFilter(Filter newFilter) {
        this.rfa.addFilter(newFilter);
    }

    public Filter getFilter() {
        return this.rfa.getFilter();
    }

    public void clearFilters() {
        this.rfa.clearFilters();
    }

    public void close() {
        this.rfa.close();
    }

    public boolean isClosed() {
        return this.rfa.isClosed();
    }

    public boolean isActive() {
        return this.rfa.isActive();
    }

    public void doAppend(LoggingEvent event) {
        this.rfa.doAppend(event);
    }

    public String getName() {
        return this.rfa.getName();
    }

    public void setLayout(Layout layout) {
        this.rfa.setLayout(layout);
    }

    public Layout getLayout() {
        return this.rfa.getLayout();
    }

    public void setName(String name) {
        this.rfa.setName(name);
    }

    public void setLoggerRepository(LoggerRepository repository) throws IllegalStateException {
        this.rfa.setLoggerRepository(repository);
    }

    public void setFile(String file) {
        this.rfa.setFile(file);
    }

    public boolean getAppend() {
        return this.rfa.getAppend();
    }

    public String getFile() {
        return this.rfa.getFile();
    }

    public boolean getBufferedIO() {
        return this.rfa.getBufferedIO();
    }

    public int getBufferSize() {
        return this.rfa.getBufferSize();
    }

    public void setAppend(boolean flag) {
        this.rfa.setAppend(flag);
    }

    public void setBufferedIO(boolean bufferedIO) {
        this.rfa.setBufferedIO(bufferedIO);
    }

    public void setBufferSize(int bufferSize) {
        this.rfa.setBufferSize(bufferSize);
    }

    public void rollOver() {
        this.rfa.rollover();
    }

    public final ErrorHandler getErrorHandler() {
        return this.errorHandler;
    }

    public final void setErrorHandler(ErrorHandler eh) {
    }

    public boolean requiresLayout() {
        return false;
    }
}

