/*
 * Decompiled with CFR 0.152.
 */
package com.tmax.tibero.jdbc.data;

import com.tmax.tibero.jdbc.data.Column;
import com.tmax.tibero.jdbc.data.Row;
import com.tmax.tibero.jdbc.data.StreamBuffer;

public class RowChunkMgr {
    protected static final int CHUNK_HDR_SIZE = 4;
    protected static final int RP_HDR_SIZE = 3;
    private StreamBuffer chunkBuffer = new StreamBuffer(4096);

    public StreamBuffer getChunkBuffer() {
        return this.chunkBuffer;
    }

    public void makeRowData(Row[] rows, int rowCnt, Column[] cols) {
        byte[] rawBytes = this.chunkBuffer.getRawBytes();
        int bufOffset = 1;
        for (int i = 0; i < rowCnt; ++i) {
            bufOffset += rows[i].buildRowData(this, rawBytes, bufOffset, cols);
        }
    }

    public void makeRowData(Row[] rows, int rowCnt, int columnCnt, boolean useRowId) {
        int bufOffset = 0;
        for (int i = 0; i < rowCnt; ++i) {
            bufOffset += rows[i].buildRowMetaData(this.chunkBuffer.getRawBytes(), bufOffset, columnCnt, useRowId);
        }
    }

    public void prepare(int byteSize) {
        this.chunkBuffer.init(byteSize + 4);
    }

    public void reset() {
        this.chunkBuffer = null;
    }
}

