/*
 * Decompiled with CFR 0.152.
 */
package com.tmax.tibero.jdbc.msg;

import com.tmax.tibero.jdbc.comm.TbStreamDataReader;
import com.tmax.tibero.jdbc.comm.TbStreamDataWriter;
import com.tmax.tibero.jdbc.msg.TbAffectedCnt;
import com.tmax.tibero.jdbc.msg.common.TbMsgError;
import java.sql.SQLException;

public class TbMsgBatchUpdateReply
extends TbMsgError {
    public int executedCnt;
    public int affectedCntArrayCnt;
    public TbAffectedCnt[] affectedCnt;
    public byte[] errorStack;
    public int errorStackLen;

    public TbMsgBatchUpdateReply(int autoCommit) {
        this.msgType = 32;
        this.msgBodySize = 0;
        this.autoCommit = autoCommit;
    }

    public void set(int executedCnt, int affectedCntArrayCnt, TbAffectedCnt[] affectedCnt, byte[] errorStack, int errorStackLen) {
        this.executedCnt = executedCnt;
        this.affectedCntArrayCnt = affectedCntArrayCnt;
        this.affectedCnt = affectedCnt;
        this.errorStack = errorStack;
        this.errorStackLen = errorStackLen;
    }

    public void serialize(TbStreamDataWriter writer) throws SQLException {
        writer.writeInt(this.msgType, 4);
        writer.writeInt(this.msgBodySize, 4);
        writer.writeInt(this.autoCommit, 8);
        writer.writeLong(this.tsn, 8);
        writer.writeInt(this.executedCnt, 4);
        writer.writeInt(this.affectedCntArrayCnt, 4);
        if (this.affectedCnt != null) {
            for (int i = 0; i < this.affectedCntArrayCnt; ++i) {
                this.affectedCnt[i].serialize(writer);
            }
        }
        if (this.errorStackLen != 0) {
            writer.writeInt(this.errorStackLen, 4);
            writer.writePadBytes(this.errorStack, 0, this.errorStackLen);
        } else {
            writer.writeInt(0, 4);
            writer.writeInt(0, 4);
        }
        writer.reWriteInt(4, writer.getBufferedDataSize() - 24, 4);
    }

    public void deserialize(TbStreamDataReader reader) throws SQLException {
        this.executedCnt = reader.readInt32();
        int affectedCntLen = reader.readInt32();
        if (affectedCntLen > 0) {
            this.affectedCnt = new TbAffectedCnt[affectedCntLen];
            for (int i = 0; i < affectedCntLen; ++i) {
                this.affectedCnt[i] = new TbAffectedCnt();
                this.affectedCnt[i].deserialize(reader);
            }
        } else {
            this.affectedCnt = null;
        }
        this.readErrorStackInfo(reader);
    }

    public boolean equals(Object obj) {
        int i;
        if (obj == null) {
            return false;
        }
        TbMsgBatchUpdateReply msg = (TbMsgBatchUpdateReply)obj;
        if (this.executedCnt != msg.executedCnt) {
            return false;
        }
        if (this.affectedCnt == null && msg.affectedCnt != null || this.affectedCnt != null && msg.affectedCnt == null) {
            return false;
        }
        if (this.affectedCnt != null && msg.affectedCnt != null) {
            if (this.affectedCnt.length != msg.affectedCnt.length) {
                return false;
            }
            for (i = 0; i < msg.affectedCnt.length; ++i) {
                if (this.affectedCnt[i].equals(msg.affectedCnt[i])) continue;
                return false;
            }
        }
        if (this.errorStack == null && msg.errorStack != null || this.errorStack != null && msg.errorStack == null) {
            return false;
        }
        if (this.errorStack != null && msg.errorStack != null) {
            if (this.errorStack.length != msg.errorStack.length) {
                return false;
            }
            for (i = 0; i < msg.errorStack.length; ++i) {
                if (this.errorStack[i] == msg.errorStack[i]) continue;
                return false;
            }
        }
        return true;
    }

    public String toString() {
        int i;
        StringBuffer str = new StringBuffer("[TbMsgBatchUpdateReply]/");
        str.append("executedCnt=");
        str.append(this.executedCnt);
        str.append("/");
        str.append("affectedCnt={\n");
        if (this.affectedCnt != null) {
            for (i = 0; i < this.affectedCnt.length; ++i) {
                str.append("  affectedCnt[" + i + "]=" + this.affectedCnt[i]);
            }
        } else {
            str.append("=null");
        }
        str.append("}/");
        str.append("errorStack=");
        if (this.errorStack != null) {
            for (i = 0; i < this.errorStack.length; ++i) {
                str.append(this.errorStack[i] + "/");
            }
        } else {
            str.append("null/");
        }
        return str.append("\n").toString();
    }
}

