/*
 * Decompiled with CFR 0.152.
 */
package com.tmax.tibero.jdbc.msg;

import com.tmax.tibero.jdbc.comm.TbStreamDataReader;
import com.tmax.tibero.jdbc.comm.TbStreamDataWriter;
import com.tmax.tibero.jdbc.msg.common.TbMsg;
import java.sql.SQLException;

public class TbMsgLobInlob
extends TbMsg {
    public int offsetHigh;
    public int offsetLow;
    public byte[] lobLoc;
    public int lobLocLen;
    public byte[] ptnLobLoc;
    public int ptnLobLocLen;

    public TbMsgLobInlob(int autoCommit) {
        this.msgType = 46;
        this.msgBodySize = 0;
        this.autoCommit = autoCommit;
    }

    public void set(int offsetHigh, int offsetLow, byte[] lobLoc, int lobLocLen, byte[] ptnLobLoc, int ptnLobLocLen) {
        this.offsetHigh = offsetHigh;
        this.offsetLow = offsetLow;
        this.lobLoc = lobLoc;
        this.lobLocLen = lobLocLen;
        this.ptnLobLoc = ptnLobLoc;
        this.ptnLobLocLen = ptnLobLocLen;
    }

    public void serialize(TbStreamDataWriter writer) throws SQLException {
        writer.writeInt(this.msgType, 4);
        writer.writeInt(this.msgBodySize, 4);
        writer.writeInt(this.autoCommit, 8);
        writer.writeLong(this.tsn, 8);
        writer.writeInt(this.offsetHigh, 4);
        writer.writeInt(this.offsetLow, 4);
        if (this.lobLocLen != 0) {
            writer.writeInt(this.lobLocLen, 4);
            writer.writePadBytes(this.lobLoc, 0, this.lobLocLen);
        } else {
            writer.writeInt(0, 4);
            writer.writeInt(0, 4);
        }
        if (this.ptnLobLocLen != 0) {
            writer.writeInt(this.ptnLobLocLen, 4);
            writer.writePadBytes(this.ptnLobLoc, 0, this.ptnLobLocLen);
        } else {
            writer.writeInt(0, 4);
            writer.writeInt(0, 4);
        }
        writer.reWriteInt(4, writer.getBufferedDataSize() - 24, 4);
    }

    public void deserialize(TbStreamDataReader reader) throws SQLException {
        this.offsetHigh = reader.readInt32();
        this.offsetLow = reader.readInt32();
        int lobLocLen = reader.readInt32();
        if (lobLocLen != 0) {
            this.lobLoc = new byte[lobLocLen];
            reader.readPadBytes(this.lobLoc, 0, lobLocLen);
        } else {
            reader.moveReadOffset(4);
            this.lobLoc = new byte[0];
        }
        int ptnLobLocLen = reader.readInt32();
        if (ptnLobLocLen != 0) {
            this.ptnLobLoc = new byte[ptnLobLocLen];
            reader.readPadBytes(this.ptnLobLoc, 0, ptnLobLocLen);
        } else {
            reader.moveReadOffset(4);
            this.ptnLobLoc = new byte[0];
        }
    }

    public boolean equals(Object obj) {
        int i;
        if (obj == null) {
            return false;
        }
        TbMsgLobInlob msg = (TbMsgLobInlob)obj;
        if (this.offsetHigh != msg.offsetHigh) {
            return false;
        }
        if (this.offsetLow != msg.offsetLow) {
            return false;
        }
        if (this.lobLoc == null && msg.lobLoc != null || this.lobLoc != null && msg.lobLoc == null) {
            return false;
        }
        if (this.lobLoc != null && msg.lobLoc != null) {
            if (this.lobLoc.length != msg.lobLoc.length) {
                return false;
            }
            for (i = 0; i < msg.lobLoc.length; ++i) {
                if (this.lobLoc[i] == msg.lobLoc[i]) continue;
                return false;
            }
        }
        if (this.ptnLobLoc == null && msg.ptnLobLoc != null || this.ptnLobLoc != null && msg.ptnLobLoc == null) {
            return false;
        }
        if (this.ptnLobLoc != null && msg.ptnLobLoc != null) {
            if (this.ptnLobLoc.length != msg.ptnLobLoc.length) {
                return false;
            }
            for (i = 0; i < msg.ptnLobLoc.length; ++i) {
                if (this.ptnLobLoc[i] == msg.ptnLobLoc[i]) continue;
                return false;
            }
        }
        return true;
    }

    public String toString() {
        int i;
        StringBuffer str = new StringBuffer("[TbMsgLobInlob]/");
        str.append("offsetHigh=");
        str.append(this.offsetHigh);
        str.append("/");
        str.append("offsetLow=");
        str.append(this.offsetLow);
        str.append("/");
        str.append("lobLoc=");
        if (this.lobLoc != null) {
            for (i = 0; i < this.lobLoc.length; ++i) {
                str.append(this.lobLoc[i] + "/");
            }
        } else {
            str.append("null/");
        }
        str.append("ptnLobLoc=");
        if (this.ptnLobLoc != null) {
            for (i = 0; i < this.ptnLobLoc.length; ++i) {
                str.append(this.ptnLobLoc[i] + "/");
            }
        } else {
            str.append("null/");
        }
        return str.append("\n").toString();
    }
}

