/*
 * Decompiled with CFR 0.152.
 */
package com.tmax.tibero.jdbc.msg;

import com.tmax.tibero.jdbc.comm.TbStreamDataReader;
import com.tmax.tibero.jdbc.comm.TbStreamDataWriter;
import com.tmax.tibero.jdbc.msg.common.TbMsg;
import java.sql.SQLException;

public class TbMsgPrepare
extends TbMsg {
    public String sql;

    public TbMsgPrepare(int autoCommit) {
        this.msgType = 3;
        this.msgBodySize = 0;
        this.autoCommit = autoCommit;
    }

    public void set(String sql) {
        this.sql = sql;
    }

    public void serialize(TbStreamDataWriter writer) throws SQLException {
        writer.writeInt(this.msgType, 4);
        writer.writeInt(this.msgBodySize, 4);
        writer.writeInt(this.autoCommit, 8);
        writer.writeLong(this.tsn, 8);
        if (this.sql != null) {
            writer.writeLenAndDBEncodedPadString(this.sql);
        } else {
            writer.writeInt(0, 4);
        }
        writer.reWriteInt(4, writer.getBufferedDataSize() - 24, 4);
    }

    public void deserialize(TbStreamDataReader reader) throws SQLException {
        int sqlLen = reader.readInt32();
        this.sql = reader.readDBDecodedPadString(sqlLen);
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        TbMsgPrepare msg = (TbMsgPrepare)obj;
        if (this.sql == null && msg.sql != null || this.sql != null && msg.sql == null) {
            return false;
        }
        return this.sql == null || msg.sql == null || this.sql.equals(msg.sql);
    }

    public String toString() {
        StringBuffer str = new StringBuffer("[TbMsgPrepare]/");
        str.append("sql=");
        str.append(this.sql);
        str.append("/");
        return str.append("\n").toString();
    }
}

