/*
 * Decompiled with CFR 0.152.
 */
package com.tmax.tibero.jdbc.util;

import com.tmax.tibero.jdbc.data.BindItem;
import com.tmax.tibero.jdbc.util.TbCommon;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.EOFException;
import java.io.IOException;

public class TbStatementLogBindData {
    private int bindType;
    private int bindDataLen;
    private byte[] bindData;

    public TbStatementLogBindData(int bindType, int bindDataLen, byte[] bindData) {
        this.bindType = bindType;
        this.bindDataLen = bindDataLen;
        this.bindData = bindData;
    }

    public static void serializeData(BufferedOutputStream logOutStream, BindItem item) throws IOException {
        byte[] intBytes = new byte[4];
        logOutStream.write(intBytes);
        TbCommon.int2bytes(item.getRawData().getLength(), intBytes, 0, 4);
        logOutStream.write(intBytes);
        if (item.getRawData().getLength() > 0) {
            // empty if block
        }
        intBytes = null;
    }

    public static TbStatementLogBindData deserializeData(BufferedInputStream logInStream) throws IOException {
        byte[] intBytes = new byte[4];
        int bindType = 0;
        int bindDataLen = 0;
        byte[] bindData = null;
        if (logInStream.read(intBytes) <= 0) {
            throw new EOFException();
        }
        bindType = TbCommon.byte2int(intBytes, 0, 4);
        if (logInStream.read(intBytes) <= 0) {
            throw new EOFException();
        }
        bindDataLen = TbCommon.byte2int(intBytes, 0, 4);
        bindData = new byte[bindDataLen];
        if (bindDataLen > 0 && logInStream.read(bindData) <= 0) {
            throw new EOFException();
        }
        intBytes = null;
        return new TbStatementLogBindData(bindType, bindDataLen, bindData);
    }

    public void close() {
        this.bindData = null;
    }

    public int getDataType() {
        return this.bindType;
    }

    public int getDataLength() {
        return this.bindDataLen;
    }

    public byte[] getData() {
        return this.bindData;
    }
}

