/*
 * Decompiled with CFR 0.152.
 */
package com.tmax.tibero.jdbc;

import com.tmax.tibero.jdbc.TbClob;
import com.tmax.tibero.jdbc.TbLob;
import com.tmax.tibero.jdbc.TbSQLException;
import com.tmax.tibero.jdbc.util.TbError;
import java.io.IOException;
import java.io.Writer;
import java.sql.SQLException;

public class TbClobWriter
extends Writer {
    private TbClob clob = null;
    private int bufOffset = 0;
    private long lobOffset = 0L;
    private boolean opened = false;
    private char[] charBuf = null;

    public TbClobWriter(TbClob clob) throws SQLException {
        this(clob, 1L);
    }

    public TbClobWriter(TbClob clob, long pos) throws SQLException {
        if (clob == null || pos < 1L) {
            throw new TbSQLException(-590713);
        }
        this.clob = clob;
        this.lobOffset = pos;
        this.bufOffset = 0;
        this.opened = true;
        this.charBuf = new char[TbLob.MAX_CHUNK_SIZE];
    }

    private void assertOpen() throws IOException {
        if (!this.opened) {
            throw new IOException(TbError.getMsg(-90900));
        }
    }

    private int getRemainedInBuffer() {
        return TbLob.MAX_CHUNK_SIZE - this.bufOffset;
    }

    private void flushBuffer() throws SQLException {
        if (this.bufOffset > 0) {
            int writeNum = this.clob.putChars(this.lobOffset, this.charBuf, 0L, this.bufOffset);
            this.lobOffset += (long)writeNum;
            this.bufOffset = 0;
        }
    }

    public void write(char[] cbuf, int off, int len) throws IOException {
        if (cbuf == null) {
            throw new NullPointerException();
        }
        if (off < 0 || off > cbuf.length || len < 0 || off + len > cbuf.length || off + len < 0) {
            throw new IndexOutOfBoundsException();
        }
        if (len == 0) {
            return;
        }
        this.assertOpen();
        if (this.getRemainedInBuffer() >= len) {
            System.arraycopy(cbuf, off, this.charBuf, this.bufOffset, len);
            this.bufOffset += len;
            if (this.getRemainedInBuffer() == 0) {
                try {
                    this.flushBuffer();
                }
                catch (SQLException e) {
                    throw new IOException(e.getMessage());
                }
            }
        } else {
            int writeLen = 0;
            while (len > writeLen) {
                int splitLen = this.getRemainedInBuffer();
                if (splitLen > len - writeLen) {
                    splitLen = len - writeLen;
                }
                if (splitLen > 0) {
                    System.arraycopy(cbuf, off + writeLen, this.charBuf, this.bufOffset, splitLen);
                    writeLen += splitLen;
                    this.bufOffset += splitLen;
                }
                try {
                    this.flushBuffer();
                }
                catch (SQLException e) {
                    throw new IOException(e.getMessage());
                }
            }
        }
    }

    public void flush() throws IOException {
        this.assertOpen();
        try {
            this.flushBuffer();
        }
        catch (SQLException e) {
            throw new IOException(e.getMessage());
        }
    }

    public void close() throws IOException {
        this.assertOpen();
        this.flush();
        this.opened = false;
    }
}

