/*
 * Decompiled with CFR 0.152.
 */
package com.tmax.tibero.jdbc;

import com.tmax.tibero.jdbc.TbStatement;
import com.tmax.tibero.jdbc.msg.TbPivotInfo;
import java.util.HashMap;
import java.util.Vector;

public class TbPivotMeta {
    TbPivotInfo[] pivotInfo;
    Vector pivotData;
    int[] startChunkIdx;
    int[] offset;
    int[] curChunkPos;
    HashMap colIdxMap;

    public TbPivotMeta(TbStatement tbStmt) {
        this.pivotInfo = tbStmt.getPivotInfo();
        this.pivotData = tbStmt.getPivotData();
        if (this.pivotInfo == null) {
            return;
        }
        this.startChunkIdx = new int[this.pivotInfo.length];
        this.offset = new int[this.pivotInfo.length];
        this.curChunkPos = new int[this.pivotInfo.length];
        this.colIdxMap = new HashMap();
        int curChunkIdx = 0;
        for (int i = 0; i < this.pivotInfo.length; ++i) {
            this.colIdxMap.put(new Integer(this.pivotInfo[i].colIdx), new Integer(i));
            this.startChunkIdx[i] = curChunkIdx;
            this.curChunkPos[i] = curChunkIdx;
            this.offset[i] = 0;
            curChunkIdx += this.pivotInfo[i].chunkCnt;
        }
    }

    private int getPivotIdx(int colIdx) throws Exception {
        Integer intObj = (Integer)this.colIdxMap.get(new Integer(colIdx));
        if (intObj != null) {
            return intObj;
        }
        throw new Exception("invalid index for pivot column");
    }

    public String getNextColName(int colIdx) throws Exception {
        if (this.pivotInfo == null) {
            return null;
        }
        int pivotIdx = this.getPivotIdx(colIdx);
        if (this.curChunkPos[pivotIdx] == this.startChunkIdx[pivotIdx] + this.pivotInfo[pivotIdx].chunkCnt) {
            return null;
        }
        byte[] chunk = (byte[])this.pivotData.elementAt(this.curChunkPos[pivotIdx]);
        int pos = this.offset[pivotIdx];
        int colLen = 0;
        if (chunk[pos] <= 250) {
            colLen = chunk[pos];
            ++pos;
            int n = pivotIdx;
            this.offset[n] = this.offset[n] + (1 + colLen);
        } else if (chunk[pos] == 254) {
            colLen = 0xFF & chunk[pos + 1] << 8;
            colLen &= 0xFF & chunk[pos + 2];
            pos += 3;
            int n = pivotIdx;
            this.offset[n] = this.offset[n] + (3 + colLen);
        } else {
            throw new Exception("rpcol length field curruption");
        }
        if (this.offset[pivotIdx] == chunk.length) {
            int n = pivotIdx;
            this.curChunkPos[n] = this.curChunkPos[n] + 1;
            this.offset[pivotIdx] = 0;
        }
        if (colLen == 0) {
            return "";
        }
        return new String(chunk, pos, colLen);
    }

    public int getValType(int colIdx, int valPos) throws Exception {
        TbPivotInfo pi = this.pivotInfo[this.getPivotIdx(colIdx)];
        int cnt = pi.valType.length;
        return pi.valType[valPos % cnt].type;
    }
}

