/*
 * Decompiled with CFR 0.152.
 */
package com.tmax.tibero.jdbc;

import com.tmax.tibero.jdbc.TbBlob;
import com.tmax.tibero.jdbc.TbClob;
import com.tmax.tibero.jdbc.TbPreparedStatement;
import com.tmax.tibero.jdbc.TbRSSensitive;
import com.tmax.tibero.jdbc.TbResultSet;
import com.tmax.tibero.jdbc.TbResultSetBase;
import com.tmax.tibero.jdbc.TbResultSetMetaData;
import com.tmax.tibero.jdbc.TbSQLException;
import com.tmax.tibero.jdbc.data.Column;
import com.tmax.tibero.jdbc.data.DataType;
import com.tmax.tibero.jdbc.data.RawData;
import com.tmax.tibero.jdbc.data.Row;
import com.tmax.tibero.jdbc.data.RsetBuilder;
import com.tmax.tibero.jdbc.data.RsetType;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.Ref;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Map;

public class TbRSUpdatable
extends TbResultSet {
    private TbResultSetBase rset = null;
    private boolean onInserting = false;
    private boolean onUpdating = false;
    private RawData[] buffer = null;
    private boolean[] hasChanged = null;
    protected TbPreparedStatement deleteStmt = null;
    private int colCnt = 0;
    private int beginColumnIndex = 0;
    private boolean lastColumnWasNull = false;

    public void reset() {
        super.reset();
        this.rset = null;
        this.deleteStmt = null;
        this.buffer = null;
        this.hasChanged = null;
        this.lastColumnWasNull = false;
    }

    public String ToString() {
        StringBuffer buf = new StringBuffer(128);
        buf.append(this.toString());
        buf.append(" columnCnt[").append(this.colCnt).append("]");
        buf.append(" onInserting[").append(this.onInserting).append("]");
        buf.append(" onUpdating[").append(this.onUpdating).append("]");
        buf.append(" buffer[").append(this.buffer).append("]");
        buf.append(" hasChanged[").append(this.hasChanged).append("]");
        buf.append(" deleteStmt[").append(this.deleteStmt).append("]");
        buf.append(" rset[").append(this.rset).append("]");
        buf.append(" lastColumnWasNull[").append(this.lastColumnWasNull).append("]");
        buf.append(super.ToString());
        return buf.toString();
    }

    protected TbRSUpdatable(TbResultSetBase rset, RsetType rsetType) throws SQLException {
        super(RsetBuilder.RSET, rsetType, -1L);
        if (rset == null) {
            throw new TbSQLException(-90607);
        }
        this.rset = rset;
        this.beginColumnIndex = rset.getBeginColumnIndex();
        this.colCnt = rset.getColumnCount() + this.beginColumnIndex;
        this.rsetBuilder = rset.getRsetBuilder();
        this.rsetType = rsetType;
    }

    public Column[] getCols() {
        return this.rset.getCols();
    }

    public int getColumnCount() {
        return this.rset.getColumnCount();
    }

    protected Row getCurrentRow() throws SQLException {
        return this.rset.getCurrentRow();
    }

    public int addRows(Row[] rows) throws SQLException {
        return this.rset.addRows(rows);
    }

    public synchronized void setFetchCompleted(int fetchResultBitmap) {
        this.rset.setFetchCompleted(fetchResultBitmap);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void close() throws SQLException {
        try {
            if (this.deleteStmt != null) {
                try {
                    this.deleteStmt.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (this.rset != null) {
                this.rset.close();
            }
        }
        finally {
            this.reset();
        }
    }

    private void setLastColumnWasNull(int columnIndex) throws SQLException {
        this.lastColumnWasNull = this.getCurrentRow().isNull(columnIndex + this.beginColumnIndex);
    }

    protected void cancelChanges() throws SQLException {
        if (this.onInserting) {
            this.cancelRowInserts();
        }
        if (this.onUpdating) {
            this.cancelRowUpdates();
        }
    }

    protected void resetBuffer() {
        if (this.buffer != null) {
            int len = this.buffer.length;
            for (int i = 0; i < len; ++i) {
                this.buffer[i] = null;
                this.hasChanged[i] = false;
            }
        }
    }

    protected void checkUpdateCursorPosition() throws SQLException {
        if (this.isBeforeFirst() || this.isAfterLast()) {
            throw new TbSQLException(-90624);
        }
        this.onUpdating = true;
    }

    private void checkColumnIndex(int columnIndex) throws SQLException {
        if (columnIndex <= 0 || columnIndex > this.colCnt) {
            throw new TbSQLException(-90609);
        }
    }

    protected void setBuffer(int columnIndex, RawData rawData) throws SQLException {
        if (this.buffer == null) {
            this.buffer = new RawData[this.colCnt];
        }
        if (this.hasChanged == null) {
            this.hasChanged = new boolean[this.colCnt];
        }
        int revisedColumnIndex = columnIndex + this.beginColumnIndex - 1;
        this.checkColumnIndex(revisedColumnIndex);
        this.hasChanged[revisedColumnIndex] = true;
        this.buffer[revisedColumnIndex] = rawData;
    }

    protected boolean hasBufferChanged(int columnIndex) throws SQLException {
        int revisedColumnIndex = columnIndex + this.beginColumnIndex - 1;
        this.checkColumnIndex(revisedColumnIndex);
        return (this.onInserting || this.onUpdating) && this.hasChanged[revisedColumnIndex];
    }

    public synchronized void setFetchDirection(int direction) throws SQLException {
        this.rset.setFetchDirection(direction);
    }

    public synchronized int getFetchDirection() throws SQLException {
        return this.rset.getFetchDirection();
    }

    public synchronized int getRow() throws SQLException {
        return this.rset.getRow();
    }

    public synchronized void setFetchSize(int rows) throws SQLException {
        this.rset.setFetchSize(rows);
    }

    public synchronized int getFetchSize() throws SQLException {
        return this.rset.getFetchSize();
    }

    public Statement getStatement() throws SQLException {
        return this.rset.getStatement();
    }

    public ResultSetMetaData getMetaData() throws SQLException {
        return new TbResultSetMetaData(this);
    }

    public synchronized boolean next() throws SQLException {
        this.cancelChanges();
        return this.rset.next();
    }

    public synchronized boolean isBeforeFirst() throws SQLException {
        if (this.onInserting) {
            return false;
        }
        return this.rset.isBeforeFirst();
    }

    public synchronized boolean isAfterLast() throws SQLException {
        if (this.onInserting) {
            return false;
        }
        return this.rset.isAfterLast();
    }

    public synchronized boolean isFirst() throws SQLException {
        if (this.onInserting) {
            return false;
        }
        return this.rset.isFirst();
    }

    public synchronized boolean isLast() throws SQLException {
        if (this.onInserting) {
            return false;
        }
        return this.rset.isLast();
    }

    public synchronized void beforeFirst() throws SQLException {
        this.cancelChanges();
        this.rset.beforeFirst();
    }

    public synchronized void afterLast() throws SQLException {
        this.cancelChanges();
        this.rset.afterLast();
    }

    public synchronized boolean first() throws SQLException {
        this.cancelChanges();
        return this.rset.first();
    }

    public synchronized boolean last() throws SQLException {
        this.cancelChanges();
        return this.rset.last();
    }

    public synchronized boolean absolute(int i) throws SQLException {
        this.cancelChanges();
        return this.rset.absolute(i);
    }

    public synchronized boolean relative(int i) throws SQLException {
        this.cancelChanges();
        return this.rset.relative(i);
    }

    public synchronized boolean previous() throws SQLException {
        this.cancelChanges();
        return this.rset.previous();
    }

    private RawData getBuffer(int columnIndex) throws SQLException {
        int revisedColumnIndex = columnIndex + this.beginColumnIndex - 1;
        this.checkColumnIndex(revisedColumnIndex);
        return this.buffer[revisedColumnIndex];
    }

    public synchronized boolean wasNull() throws SQLException {
        return this.lastColumnWasNull;
    }

    public synchronized String getString(int columnIndex) throws SQLException {
        this.setLastColumnWasNull(columnIndex);
        if (this.lastColumnWasNull) {
            return null;
        }
        if (this.hasBufferChanged(columnIndex)) {
            RawData rawData = this.getBuffer(columnIndex);
            Object data = rawData.getData();
            if (data instanceof TbClob) {
                long clobLength = ((TbClob)data).length();
                return ((TbClob)data).getSubString(1L, (int)clobLength);
            }
            return this.rset.typeConverter.toString(this.getColumnDataType(columnIndex), rawData);
        }
        return this.rset.getString(columnIndex);
    }

    public synchronized boolean getBoolean(int columnIndex) throws SQLException {
        boolean b = false;
        this.setLastColumnWasNull(columnIndex);
        if (this.lastColumnWasNull) {
            return false;
        }
        if (this.hasBufferChanged(columnIndex)) {
            return this.rset.typeConverter.toBoolean(this.getColumnDataType(columnIndex), this.getBuffer(columnIndex));
        }
        b = this.rset.getBoolean(columnIndex);
        return b;
    }

    public synchronized byte getByte(int columnIndex) throws SQLException {
        this.setLastColumnWasNull(columnIndex);
        if (this.lastColumnWasNull) {
            return 0;
        }
        if (this.hasBufferChanged(columnIndex)) {
            return this.rset.typeConverter.toByte(this.getColumnDataType(columnIndex), this.getBuffer(columnIndex));
        }
        return this.rset.getByte(columnIndex);
    }

    public synchronized short getShort(int columnIndex) throws SQLException {
        this.setLastColumnWasNull(columnIndex);
        if (this.lastColumnWasNull) {
            return 0;
        }
        if (this.hasBufferChanged(columnIndex)) {
            return this.rset.typeConverter.toShort(this.getColumnDataType(columnIndex), this.getBuffer(columnIndex));
        }
        return this.rset.getShort(columnIndex);
    }

    public synchronized int getInt(int columnIndex) throws SQLException {
        this.setLastColumnWasNull(columnIndex);
        if (this.lastColumnWasNull) {
            return 0;
        }
        if (this.hasBufferChanged(columnIndex)) {
            return this.rset.typeConverter.toInt(this.getColumnDataType(columnIndex), this.getBuffer(columnIndex));
        }
        return this.rset.getInt(columnIndex);
    }

    public synchronized long getLong(int columnIndex) throws SQLException {
        this.setLastColumnWasNull(columnIndex);
        if (this.lastColumnWasNull) {
            return 0L;
        }
        if (this.hasBufferChanged(columnIndex)) {
            return this.rset.typeConverter.toLong(this.getColumnDataType(columnIndex), this.getBuffer(columnIndex));
        }
        return this.rset.getLong(columnIndex);
    }

    public synchronized float getFloat(int columnIndex) throws SQLException {
        this.setLastColumnWasNull(columnIndex);
        if (this.lastColumnWasNull) {
            return 0.0f;
        }
        if (this.hasBufferChanged(columnIndex)) {
            return this.rset.typeConverter.toFloat(this.getColumnDataType(columnIndex), this.getBuffer(columnIndex));
        }
        return this.rset.getFloat(columnIndex);
    }

    public synchronized double getDouble(int columnIndex) throws SQLException {
        this.setLastColumnWasNull(columnIndex);
        if (this.lastColumnWasNull) {
            return 0.0;
        }
        if (this.hasBufferChanged(columnIndex)) {
            return this.rset.typeConverter.toDouble(this.getColumnDataType(columnIndex), this.getBuffer(columnIndex));
        }
        return this.rset.getDouble(columnIndex);
    }

    public BigDecimal getBigDecimal(int columnIndex) throws SQLException {
        return this.getBigDecimal(columnIndex, 0);
    }

    public synchronized BigDecimal getBigDecimal(int columnIndex, int scale) throws SQLException {
        this.setLastColumnWasNull(columnIndex);
        if (this.lastColumnWasNull) {
            return null;
        }
        if (this.hasBufferChanged(columnIndex)) {
            return this.rset.typeConverter.toBigDecimal(this.getColumnDataType(columnIndex), this.getBuffer(columnIndex));
        }
        return this.rset.getBigDecimal(columnIndex);
    }

    public synchronized byte[] getBytes(int columnIndex) throws SQLException {
        this.setLastColumnWasNull(columnIndex);
        if (this.lastColumnWasNull) {
            return null;
        }
        if (this.hasBufferChanged(columnIndex)) {
            return this.rset.typeConverter.toBytes(this.getColumnDataType(columnIndex), this.getBuffer(columnIndex));
        }
        return this.rset.getBytes(columnIndex);
    }

    public synchronized Date getDate(int columnIndex) throws SQLException {
        this.setLastColumnWasNull(columnIndex);
        if (this.lastColumnWasNull) {
            return null;
        }
        if (this.hasBufferChanged(columnIndex)) {
            return this.rset.typeConverter.toDate(this.getColumnDataType(columnIndex), this.getBuffer(columnIndex));
        }
        return this.rset.getDate(columnIndex);
    }

    public synchronized Time getTime(int columnIndex) throws SQLException {
        this.setLastColumnWasNull(columnIndex);
        if (this.lastColumnWasNull) {
            return null;
        }
        if (this.hasBufferChanged(columnIndex)) {
            return this.rset.typeConverter.toTime(this.getColumnDataType(columnIndex), this.getBuffer(columnIndex));
        }
        return this.rset.getTime(columnIndex);
    }

    public synchronized Timestamp getTimestamp(int columnIndex) throws SQLException {
        this.setLastColumnWasNull(columnIndex);
        if (this.lastColumnWasNull) {
            return null;
        }
        if (this.hasBufferChanged(columnIndex)) {
            return this.rset.typeConverter.toTimestamp(this.getColumnDataType(columnIndex), this.getBuffer(columnIndex));
        }
        return this.rset.getTimestamp(columnIndex);
    }

    public synchronized InputStream getAsciiStream(int columnIndex) throws SQLException {
        return this.getBinaryStream(columnIndex);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public synchronized InputStream getUnicodeStream(int columnIndex) throws SQLException {
        InputStream stream = null;
        this.setLastColumnWasNull(columnIndex);
        if (this.lastColumnWasNull) {
            return null;
        }
        if (!this.hasBufferChanged(columnIndex)) return this.rset.getAsciiStream(columnIndex);
        RawData rawData = this.getBuffer(columnIndex);
        Object data = rawData.getData();
        if (data instanceof InputStream) {
            return (InputStream)data;
        }
        if (!(data instanceof byte[])) throw new TbSQLException(-590705);
        if (rawData.getLength() != 0) return new ByteArrayInputStream(new String((byte[])data).getBytes());
        return null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public synchronized InputStream getBinaryStream(int columnIndex) throws SQLException {
        InputStream stream = null;
        this.setLastColumnWasNull(columnIndex);
        if (this.lastColumnWasNull) {
            return null;
        }
        if (!this.hasBufferChanged(columnIndex)) return this.rset.getBinaryStream(columnIndex);
        RawData rawData = this.getBuffer(columnIndex);
        Object data = rawData.getData();
        if (data instanceof InputStream) {
            return (InputStream)data;
        }
        if (!(data instanceof Blob)) throw new TbSQLException(-590705);
        return ((TbBlob)data).getBinaryStream();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public synchronized Reader getCharacterStream(int columnIndex) throws SQLException {
        this.setLastColumnWasNull(columnIndex);
        if (this.lastColumnWasNull) {
            return null;
        }
        Reader reader = null;
        if (!this.hasBufferChanged(columnIndex)) return this.rset.getCharacterStream(columnIndex);
        RawData rawData = this.getBuffer(columnIndex);
        Object data = rawData.getData();
        if (data instanceof Reader) {
            return (Reader)data;
        }
        if (!(data instanceof Clob)) throw new TbSQLException(-590705);
        return ((TbClob)data).getCharacterStream();
    }

    public synchronized Object getObject(int columnIndex) throws SQLException {
        this.setLastColumnWasNull(columnIndex);
        if (this.lastColumnWasNull) {
            return null;
        }
        Object obj = null;
        if (this.hasBufferChanged(columnIndex)) {
            RawData rawData = this.getBuffer(columnIndex);
            Object data = rawData.getData();
            if (data instanceof byte[]) {
                if (rawData.getLength() == 0) {
                    return null;
                }
                int dataType = this.getColumnDataType(columnIndex);
                obj = this.rset.typeConverter.toObject(dataType, DataType.getSqlType(dataType), rawData);
            } else {
                obj = data;
            }
        } else {
            obj = this.rset.getObject(columnIndex);
        }
        return obj;
    }

    public synchronized int findColumn(String columnName) throws SQLException {
        return this.rset.findColumn(columnName);
    }

    public Object getObject(int i, Map map) throws SQLException {
        throw new TbSQLException(-90201, "getObject");
    }

    public Ref getRef(int i) throws SQLException {
        throw new TbSQLException(-90201, "getRef");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Blob getBlob(int columnIndex) throws SQLException {
        this.setLastColumnWasNull(columnIndex);
        if (this.lastColumnWasNull) {
            return null;
        }
        Blob blob = null;
        if (!this.hasBufferChanged(columnIndex)) return this.rset.getBlob(columnIndex);
        RawData rawData = this.getBuffer(columnIndex);
        Object data = rawData.getData();
        if (!(data instanceof Blob)) throw new TbSQLException(-590705, " not a Blob type");
        return (Blob)data;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Clob getClob(int columnIndex) throws SQLException {
        this.setLastColumnWasNull(columnIndex);
        if (this.lastColumnWasNull) {
            return null;
        }
        Clob clob = null;
        if (!this.hasBufferChanged(columnIndex)) return this.rset.getClob(columnIndex);
        RawData rawData = this.getBuffer(columnIndex);
        Object data = rawData.getData();
        if (!(data instanceof Clob)) throw new TbSQLException(-590705, " not a Clob type");
        return (Clob)data;
    }

    public Array getArray(int i) throws SQLException {
        throw new TbSQLException(-90201, "getArray");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void insertRow() throws SQLException {
        if (!this.onInserting) {
            throw new TbSQLException(-90624, " called insertRow() not on insert row ");
        }
        TbPreparedStatement insertStmt = null;
        try {
            insertStmt = this.getInsertRowStatement();
            this.bindInsertingData(insertStmt);
            int retCnt = insertStmt.executeUpdate();
            if (retCnt <= 0) {
                throw new TbSQLException(-90500, " no record were inserted ");
            }
            if (retCnt > 1) {
                throw new TbSQLException(-90500, " " + retCnt + " records were inserted ");
            }
            this.cancelRowInserts();
        }
        finally {
            if (insertStmt != null) {
                try {
                    insertStmt.close();
                }
                catch (Exception exception) {}
            }
        }
    }

    private TbPreparedStatement getInsertRowStatement() throws SQLException {
        StringBuffer sqlBuf = new StringBuffer();
        sqlBuf.append("INSERT INTO ( ");
        sqlBuf.append(this.rset.stmt.getOriginalSql());
        sqlBuf.append(" ) VALUES ( ");
        int paramCnt = this.hasChanged.length;
        int first = 0;
        for (int i = this.beginColumnIndex; i < paramCnt; ++i) {
            if (first != 0) {
                sqlBuf.append(" , ");
            }
            sqlBuf.append("?");
            ++first;
        }
        sqlBuf.append(" ) ");
        return new TbPreparedStatement(this.rset.stmt.conn, sqlBuf.toString());
    }

    private void bindAllBufferedData(TbPreparedStatement stmt) throws SQLException {
        int paramCnt = this.hasChanged.length;
        int i = 1;
        for (int colIndex = this.beginColumnIndex; colIndex < paramCnt; ++colIndex) {
            if (!this.hasChanged[colIndex]) continue;
            Object data = this.buffer[colIndex].getData();
            if (data instanceof Clob) {
                stmt.setClob(i, (Clob)data);
            } else if (data instanceof Blob) {
                stmt.setBlob(i, (Blob)data);
            } else if (data instanceof Reader) {
                stmt.setCharacterStream(i, (Reader)data, this.buffer[colIndex].getLength());
            } else if (data instanceof InputStream) {
                stmt.setBinaryStream(i, (InputStream)data, this.buffer[colIndex].getLength());
            } else if (data instanceof byte[]) {
                if (this.buffer[colIndex].getLength() == 0) {
                    stmt.setNullInternal(i, this.rset.getColumnDataType(colIndex - this.beginColumnIndex + 1));
                } else {
                    stmt.setBytes(i, this.rset.getColumnDataType(colIndex - this.beginColumnIndex + 1), (byte[])data);
                }
            }
            ++i;
        }
        stmt.setBytes(i, 15, this.rset.getColumnRawData(0));
    }

    private void bindInsertingData(TbPreparedStatement stmt) throws SQLException {
        int paramCnt = this.hasChanged.length;
        int i = 1;
        for (int colIndex = this.beginColumnIndex; colIndex < paramCnt; ++colIndex) {
            if (this.hasChanged[colIndex]) {
                Object data = this.buffer[colIndex].getData();
                if (data instanceof Clob) {
                    stmt.setClob(i, (Clob)data);
                } else if (data instanceof Blob) {
                    stmt.setBlob(i, (Blob)data);
                } else if (data instanceof Reader) {
                    stmt.setCharacterStream(i, (Reader)data, this.buffer[colIndex].getLength());
                } else if (data instanceof InputStream) {
                    stmt.setBinaryStream(i, (InputStream)data, this.buffer[colIndex].getLength());
                } else if (data instanceof byte[]) {
                    if (this.buffer[colIndex].getLength() == 0) {
                        stmt.setNullInternal(i, this.rset.getColumnDataType(i));
                    } else {
                        stmt.setBytes(i, this.rset.getColumnDataType(i), (byte[])data);
                    }
                }
            } else {
                stmt.setNullInternal(i, this.rset.getColumnDataType(i));
            }
            ++i;
        }
    }

    private void storeUpdatedRowChunk() throws SQLException {
        int paramCnt = this.hasChanged.length;
        Row row = this.rset.getCurrentRow();
        for (int i = 0; i < paramCnt; ++i) {
            if (!this.hasChanged[i]) continue;
            row.setRawData(i + 1, this.buffer[i]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void updateRow() throws SQLException {
        if (this.onInserting) {
            throw new TbSQLException(-90624, " called updateRow() on insert row ");
        }
        TbPreparedStatement updateStmt = null;
        try {
            updateStmt = this.getUpdateRowStatement();
            this.bindAllBufferedData(updateStmt);
            int retCnt = updateStmt.executeUpdate();
            if (retCnt <= 0) {
                throw new TbSQLException(-90500, " no record were updated");
            }
            if (retCnt > 1) {
                throw new TbSQLException(-90500, " " + retCnt + " records were updated ");
            }
            if (this.rset instanceof TbRSSensitive) {
                ((TbRSSensitive)this.rset).refreshRowForced(1);
            }
            this.storeUpdatedRowChunk();
            this.cancelRowUpdates();
        }
        finally {
            if (updateStmt != null) {
                try {
                    updateStmt.close();
                }
                catch (Exception exception) {}
            }
        }
    }

    private TbPreparedStatement getUpdateRowStatement() throws SQLException {
        StringBuffer sqlBuf = new StringBuffer();
        sqlBuf.append("UPDATE ( ");
        sqlBuf.append(this.rset.stmt.getOriginalSql());
        sqlBuf.append(" ) SET ");
        int colCnt = this.hasChanged.length;
        int i = 1;
        int colIndex = this.beginColumnIndex;
        int first = 0;
        while (colIndex < colCnt) {
            if (this.hasChanged[colIndex]) {
                if (first != 0) {
                    sqlBuf.append(" , ");
                }
                sqlBuf.append(this.rset.getColumnName(i)).append(" = ? ");
                ++first;
            }
            ++colIndex;
            ++i;
        }
        sqlBuf.append(" WHERE ROWID = ? ");
        return new TbPreparedStatement(this.rset.stmt.conn, sqlBuf.toString());
    }

    public synchronized void deleteRow() throws SQLException {
        if (this.onInserting) {
            throw new TbSQLException(-90624, " called deleteRow() on insert row ");
        }
        if (this.deleteStmt == null) {
            this.deleteStmt = this.getDeleteRowStatement();
        }
        this.deleteStmt.setBytes(1, 15, this.rset.getColumnRawData(0));
        int retCnt = this.deleteStmt.executeUpdate();
        if (retCnt <= 0) {
            throw new TbSQLException(-90500, " no record were found to delete");
        }
        if (retCnt > 1) {
            throw new TbSQLException(-90500, " " + retCnt + " records were deleted ");
        }
        this.rset.removeCurrentRow();
    }

    private TbPreparedStatement getDeleteRowStatement() throws SQLException {
        StringBuffer sqlBuf = new StringBuffer();
        sqlBuf.append("DELETE FROM ( ");
        sqlBuf.append(this.rset.stmt.getOriginalSql());
        sqlBuf.append(" ) WHERE ROWID = ? ");
        return new TbPreparedStatement(this.rset.stmt.conn, sqlBuf.toString());
    }

    public synchronized void refreshRow() throws SQLException {
        if (this.onInserting) {
            throw new TbSQLException(-90624, " called refreshRow() on insert row ");
        }
        this.rset.refreshRow();
    }

    public synchronized void cancelRowUpdates() throws SQLException {
        this.onUpdating = false;
        this.resetBuffer();
    }

    protected void cancelRowInserts() throws SQLException {
        this.onInserting = false;
        this.resetBuffer();
    }

    public synchronized void moveToInsertRow() throws SQLException {
        if (this.onInserting) {
            return;
        }
        this.onInserting = true;
        if (this.buffer == null) {
            this.buffer = new RawData[this.colCnt];
            this.hasChanged = new boolean[this.colCnt];
        } else {
            this.resetBuffer();
        }
    }

    public synchronized void moveToCurrentRow() throws SQLException {
        this.cancelRowInserts();
    }

    public boolean rowUpdated() throws SQLException {
        return false;
    }

    public boolean rowInserted() throws SQLException {
        return false;
    }

    public boolean rowDeleted() throws SQLException {
        return false;
    }

    public synchronized void updateNull(int columnIndex) throws SQLException {
        this.updateObject(columnIndex, null);
    }

    public synchronized void updateBoolean(int columnIndex, boolean data) throws SQLException {
        this.updateObject(columnIndex, (Object)new Boolean(data));
    }

    public synchronized void updateByte(int columnIndex, byte data) throws SQLException {
        this.updateObject(columnIndex, (Object)new Byte(data));
    }

    public synchronized void updateShort(int columnIndex, short data) throws SQLException {
        this.updateObject(columnIndex, (Object)new Short(data));
    }

    public synchronized void updateInt(int columnIndex, int data) throws SQLException {
        this.updateObject(columnIndex, (Object)new Integer(data));
    }

    public synchronized void updateLong(int columnIndex, long data) throws SQLException {
        this.updateObject(columnIndex, (Object)new Long(data));
    }

    public synchronized void updateFloat(int columnIndex, float data) throws SQLException {
        this.updateObject(columnIndex, (Object)new Float(data));
    }

    public synchronized void updateDouble(int columnIndex, double data) throws SQLException {
        this.updateObject(columnIndex, (Object)new Double(data));
    }

    public synchronized void updateBigDecimal(int columnIndex, BigDecimal data) throws SQLException {
        this.updateObject(columnIndex, (Object)data);
    }

    public synchronized void updateString(int columnIndex, String data) throws SQLException {
        this.updateObject(columnIndex, (Object)data);
    }

    public synchronized void updateBytes(int columnIndex, byte[] data) throws SQLException {
        this.updateObject(columnIndex, (Object)data);
    }

    public synchronized void updateDate(int columnIndex, Date data) throws SQLException {
        this.updateObject(columnIndex, (Object)data);
    }

    public synchronized void updateTime(int columnIndex, Time data) throws SQLException {
        this.updateObject(columnIndex, (Object)data);
    }

    public synchronized void updateTimestamp(int columnIndex, Timestamp data) throws SQLException {
        this.updateObject(columnIndex, (Object)data);
    }

    public synchronized void updateAsciiStream(int columnIndex, InputStream stream, int length) throws SQLException {
        this.updateBinaryStream(columnIndex, stream, length);
    }

    public synchronized void updateBinaryStream(int columnIndex, InputStream stream, int length) throws SQLException {
        this.checkUpdateCursorPosition();
        if (stream != null && length > 0) {
            RawData rawData = new RawData(length, stream);
            this.setBuffer(columnIndex, rawData);
        } else {
            this.updateObject(columnIndex, null);
        }
    }

    public synchronized void updateCharacterStream(int columnIndex, Reader reader, int length) throws SQLException {
        this.checkUpdateCursorPosition();
        if (reader != null && length > 0) {
            RawData rawData = new RawData(length, reader);
            this.setBuffer(columnIndex, rawData);
        } else {
            this.updateObject(columnIndex, null);
        }
    }

    public synchronized void updateObject(int columnIndex, Object data, int scale) throws SQLException {
        this.updateObject(columnIndex, data);
    }

    public synchronized void updateObject(int columnIndex, Object data) throws SQLException {
        this.checkUpdateCursorPosition();
        byte[] dataBytes = null;
        dataBytes = data == null ? new byte[]{} : this.rset.typeConverter.objectToServerTypeCast(data, this.rset.getColumnDataType(columnIndex));
        RawData rawData = new RawData(dataBytes.length, dataBytes);
        this.setBuffer(columnIndex, rawData);
    }

    public void updateClob(int columnIndex, Clob x) throws SQLException {
        this.checkUpdateCursorPosition();
        if (x == null) {
            this.updateObject(columnIndex, null);
        } else {
            if (!(x instanceof TbClob)) {
                throw new TbSQLException(-590702);
            }
            RawData rawData = new RawData(0, x);
            this.setBuffer(columnIndex, rawData);
        }
    }

    public void updateBlob(int columnIndex, Blob x) throws SQLException {
        this.checkUpdateCursorPosition();
        if (x == null) {
            this.updateObject(columnIndex, null);
        } else {
            if (!(x instanceof TbBlob)) {
                throw new TbSQLException(-590702);
            }
            RawData rawData = new RawData(0, x);
            this.setBuffer(columnIndex, rawData);
        }
    }

    public Row[] buildRowData(int rowCnt) {
        return this.rset.buildRowData(rowCnt);
    }

    public void checkColumnPos(int index) throws SQLException {
        if (this.colCnt < 0) {
            throw new TbSQLException(-90607);
        }
        if (index <= 0 || index >= this.colCnt) {
            throw new TbSQLException(-90609);
        }
    }

    protected int getColumnDataType(int columnIndex) throws SQLException {
        return this.rset.getColumnDataType(columnIndex);
    }

    protected boolean getColumnNullable(int columnIndex) throws SQLException {
        return this.rset.getColumnNullable(columnIndex);
    }

    protected int getColumnMaxLength(int columnIndex) throws SQLException {
        return this.rset.getColumnMaxLength(columnIndex);
    }

    protected String getColumnName(int columnIndex) throws SQLException {
        return this.rset.getColumnName(columnIndex);
    }

    protected int getColumnPrecision(int columnIndex) throws SQLException {
        return this.rset.getColumnPrecision(columnIndex);
    }

    protected int getColumnScale(int columnIndex) throws SQLException {
        return this.rset.getColumnScale(columnIndex);
    }

    protected int getColumnSqlType(int columnIndex) throws SQLException {
        return this.rset.getColumnSqlType(columnIndex);
    }
}

