/*
 * Decompiled with CFR 0.152.
 */
package com.tmax.tibero.jdbc.comm;

import com.tmax.tibero.jdbc.TbConnection;
import com.tmax.tibero.jdbc.TbPreparedStatement;
import com.tmax.tibero.jdbc.TbResultSet;
import com.tmax.tibero.jdbc.TbResultSetBase;
import com.tmax.tibero.jdbc.TbResultSetFactory;
import com.tmax.tibero.jdbc.TbSQLException;
import com.tmax.tibero.jdbc.TbSQLInfo;
import com.tmax.tibero.jdbc.TbSQLWarning;
import com.tmax.tibero.jdbc.TbSavepoint;
import com.tmax.tibero.jdbc.TbStatement;
import com.tmax.tibero.jdbc.comm.TbComm;
import com.tmax.tibero.jdbc.comm.TbStream;
import com.tmax.tibero.jdbc.data.BatchInfo;
import com.tmax.tibero.jdbc.data.Column;
import com.tmax.tibero.jdbc.data.Row;
import com.tmax.tibero.jdbc.data.RowChunkMgr;
import com.tmax.tibero.jdbc.data.ServerInfo;
import com.tmax.tibero.jdbc.data.StreamBuffer;
import com.tmax.tibero.jdbc.dpl.TbDirPathStream;
import com.tmax.tibero.jdbc.dpl.TbDirPathStreamDataWriter;
import com.tmax.tibero.jdbc.msg.common.TbMsg;
import java.sql.SQLException;
import java.util.Vector;

public class TbCommType2
implements TbComm {
    public TbConnection conn = null;
    public int authType = -1;
    public int commID = -1;
    public static int retInt1 = -1;
    public static int retInt2 = -1;
    public static int retInt3 = -1;
    public static long retLong1 = -1L;
    public static long retLong2 = -1L;

    private static native void initIDs();

    private native int doConnectionOpen(byte[] var1, int var2, int var3, ServerInfo var4);

    private native int doConnectionClose(int var1);

    private native int doLogon(int var1, byte[] var2, int var3, byte[] var4, int var5, byte[] var6, int var7, int var8);

    private native int doOpenSession(int var1);

    private native int doCloseSession(int var1);

    private native int doResetSession(int var1);

    private native int doCloseCursor(int var1, int var2);

    private native int doCommit(int var1, byte[] var2, int var3);

    private native int doRollback(int var1, byte[] var2, int var3);

    private native int doExecuteDirect(int var1, byte[] var2, int var3, int var4);

    private native int doPrepare(int var1, byte[] var2, int var3, byte[] var4);

    private native int buildColumnMetadata(int var1, Column[] var2, int var3, boolean var4);

    private native int doFetch(int var1, int var2, int var3);

    private native int copyRowData(int var1, byte[] var2);

    public String ToString() {
        StringBuffer buf = new StringBuffer(64);
        buf.append(this.toString());
        buf.append(" conn[").append(this.conn).append("]");
        buf.append(" authType[").append(this.authType).append("]");
        return buf.toString();
    }

    public TbStream getStream() {
        return null;
    }

    public void reset() {
        if (this.conn != null) {
            this.conn.reset();
            this.conn = null;
        }
    }

    public TbCommType2(TbConnection tbrConnection) {
        this.conn = tbrConnection;
        System.loadLibrary("tbnet");
        TbCommType2.initIDs();
    }

    protected TbConnection getTbConnection() {
        return this.conn;
    }

    public void setAuthType(int type) {
        this.authType = type;
    }

    public synchronized void logon() throws SQLException {
        int rc = 0;
        ServerInfo info = new ServerInfo(0, 0);
        byte[] svrName = this.conn.info.getServerName().getBytes();
        byte[] userName = this.conn.info.getUser().getBytes();
        byte[] dbName = this.conn.info.getDatabaseName().getBytes();
        byte[] pwd = this.conn.info.getPassword().getBytes();
        rc = this.doConnectionOpen(svrName, svrName.length, this.conn.info.getPortNumber(), info);
        if (rc < 0) {
            info = null;
            throw new TbSQLException(rc);
        }
        this.commID = retInt1;
        this.conn.setServerInfo(info);
        rc = this.doLogon(this.commID, userName, userName.length, dbName, dbName.length, pwd, pwd.length, this.authType);
        if (rc < 0) {
            throw new TbSQLException(rc);
        }
        this.setAuthType(retInt1);
        this.conn.setSessionId(retInt2);
    }

    public synchronized void close() {
        this.doConnectionClose(this.commID);
        this.reset();
    }

    public synchronized void openSession() throws SQLException {
        int rc = this.doOpenSession(this.commID);
        if (rc < 0) {
            throw new TbSQLException(-rc);
        }
        this.conn.setSessionId(retInt1);
    }

    public synchronized void closeSession() throws SQLException {
        int rc = this.doCloseSession(this.commID);
        if (rc < 0) {
            throw new TbSQLException(-rc);
        }
    }

    public synchronized void resetSession() throws SQLException {
        int rc = this.doResetSession(this.commID);
        if (rc < 0) {
            throw new TbSQLException(-rc);
        }
    }

    public synchronized void closeCursor(TbResultSet rs, int cursorId) throws SQLException {
        int rc = this.doCloseCursor(this.commID, cursorId);
        if (rc < 0) {
            throw new TbSQLException(-rc);
        }
    }

    public synchronized TbResultSet executeDirect(TbStatement stmt, String sql) throws SQLException {
        int rc = this.doExecuteDirect(this.commID, sql.getBytes(), sql.getBytes().length, stmt.getFetchSize());
        if (rc < 0) {
            throw new TbSQLException(rc);
        }
        int rcode = retInt1;
        switch (rcode) {
            case 4: {
                throw new TbSQLException(-90615);
            }
            case 2: {
                return TbResultSetFactory.buildUpdateResult(stmt, retLong1);
            }
            case 1: {
                return TbResultSetFactory.buildOKResult(stmt);
            }
            case 3: {
                int cursorId = retInt2;
                int columnCnt = retInt3;
                TbResultSet rs = TbResultSetFactory.buildRsetResult(stmt, cursorId, columnCnt, 0, false);
                this.buildColumnMetadata(this.commID, rs.getCols(), columnCnt, false);
                rs.setFetchCompleted(0);
                return rs;
            }
        }
        throw new TbSQLException(-90402, "unsupported protocol");
    }

    public synchronized Row[] fetch(TbStatement stmt, TbResultSetBase rs) throws SQLException {
        int rc = this.doFetch(this.commID, rs.getCursorId(), rs.getFetchSize());
        if (rc < 0) {
            throw new TbSQLException(rc);
        }
        int rowCnt = retInt1;
        int fetchResultMetadata = retInt2;
        int msgLen = retInt3;
        rs.setFetchCompleted(fetchResultMetadata);
        Row[] rows = rs.getRows(rowCnt);
        RowChunkMgr rowChunkMgr = stmt.getRowChunkMgr();
        rowChunkMgr.prepare(msgLen);
        StreamBuffer buf = rowChunkMgr.getChunkBuffer();
        rc = this.copyRowData(this.commID, buf.getRawBytes());
        if (rc < 0) {
            throw new TbSQLException(rc);
        }
        rowChunkMgr.makeRowData(rows, rowCnt, rs.getColumnCount(), rs.getRsetType().useRowId());
        return rows;
    }

    public synchronized void prepare(TbPreparedStatement pstmt, String escapedSql, Vector paramTypes) throws SQLException {
        byte[] ppid;
        byte[] sql = escapedSql.getBytes();
        int rc = this.doPrepare(this.commID, sql, sql.length, ppid = new byte[32]);
        if (rc < 0) {
            throw new TbSQLException(rc);
        }
        int paramCnt = retInt2;
        int flag = retInt3;
        if (flag == 1) {
            pstmt.setPPID(null);
            pstmt.setParameterCnt(0);
            pstmt.setPreparedDDLFlag(true);
        } else {
            pstmt.setPPID(ppid);
            pstmt.setParameterCnt(paramCnt);
            pstmt.setPreparedDDLFlag(false);
        }
    }

    public synchronized TbResultSet execute(TbPreparedStatement stmt, String sql) throws SQLException {
        return null;
    }

    public synchronized void batchUpdate(TbPreparedStatement stmt, int totBatchRowCnt, int batchRowCnt, int bindParamSum, int flag, int autoCommit, int offset, int paramInfoSize) throws SQLException {
    }

    public synchronized int[] batchUpdateLoop(TbPreparedStatement stmt, int flag, int autoCommit, int offset, BatchInfo[] batchInfos, int totBatchRowCnt) throws SQLException {
        return null;
    }

    public int[] batchUpdateReply(int batchRowCnt) throws SQLException {
        return null;
    }

    public synchronized void commit() throws SQLException {
        int rc = this.doCommit(this.commID, null, 0);
        if (rc < 0) {
            throw new TbSQLException(-rc);
        }
    }

    public synchronized void rollback() throws SQLException {
        int rc = this.doRollback(this.commID, null, 0);
        if (rc < 0) {
            throw new TbSQLException(-rc);
        }
    }

    public synchronized void setAutoCommit(boolean autoCommit) throws SQLException {
    }

    public synchronized void setIsolationLevel(int level) throws SQLException {
    }

    public TbSQLException getErrorMessage(int code, TbMsg msg) throws SQLException {
        throw new TbSQLException(code);
    }

    public TbSQLWarning getWarningMessage() throws SQLException {
        throw new TbSQLWarning(0);
    }

    public String readLong(byte[] locator) throws SQLException {
        return null;
    }

    public byte[] readLongBytes(byte[] locator) throws SQLException {
        return null;
    }

    public TbSQLInfo getLastExecutedSqlinfo() throws SQLException {
        return null;
    }

    public TbStream getTbStream() {
        return null;
    }

    public void dirPathPrepare(TbDirPathStream dirPathStream) throws SQLException {
    }

    public void dirPathDataSave(int action) throws SQLException {
    }

    public void dirPathFlushRow() throws SQLException {
    }

    public void dirPathAbort() throws SQLException {
    }

    public void dirPathFinish() throws SQLException {
    }

    public void dirPathLoadStream(TbDirPathStream dirPathStream, TbDirPathStreamDataWriter dplStreamDataWriter, int partialFlag) throws SQLException {
    }

    public TbResultSet prepareExecute(TbPreparedStatement stmt, String sql) throws SQLException {
        return null;
    }

    public void cancelStatement() throws SQLException {
    }

    public synchronized void rollback(TbSavepoint savepoint) throws SQLException {
    }

    public synchronized void setSavePoint(TbSavepoint savepoint) throws SQLException {
    }
}

