/*
 * Decompiled with CFR 0.152.
 */
package com.tmax.tibero.jdbc.data;

import com.tmax.tibero.jdbc.data.DataType;
import com.tmax.tibero.jdbc.msg.TbColumnDesc;
import com.tmax.tibero.jdbc.util.TbCommon;
import java.sql.SQLException;

public class Column {
    private TbColumnDesc colMeta = null;
    private int colIdx = 0;
    private int sqlType = 0;
    private boolean isNullable = false;

    public Column() {
    }

    public Column(String columnName, int dataType, int maxLength, int bitmap) throws SQLException {
        this.colMeta = new TbColumnDesc();
        this.colMeta.dataType = dataType;
        this.colMeta.etcMeta = bitmap;
        this.colMeta.maxSize = maxLength;
        this.colMeta.name = columnName;
        this.colMeta.precision = 0;
        this.colMeta.scale = 0;
    }

    public final int getDataType() {
        return this.colMeta.dataType;
    }

    public final int getMaxLength() {
        return this.colMeta.maxSize;
    }

    public final String getName() {
        if (this.colMeta.name == null || this.colMeta.name.length() == 0) {
            return "column" + this.colIdx;
        }
        return this.colMeta.name;
    }

    public final int getPrecision() {
        return this.colMeta.precision;
    }

    public static Column getRowIdColumnInstance() throws SQLException {
        return new Column("ROWID", 3, 65535, 0);
    }

    public final int getScale() {
        return this.colMeta.scale;
    }

    public final int getSqlType() {
        return this.sqlType;
    }

    public final boolean isNullable() {
        return this.isNullable;
    }

    public void reset() {
        this.colMeta = null;
    }

    public void set(int colIdx, TbColumnDesc colMeta) throws SQLException {
        this.colMeta = colMeta;
        this.colIdx = colIdx;
        this.sqlType = colMeta.dataType == 16 ? -1 : DataType.getSqlType(colMeta.dataType);
        this.isNullable = TbCommon.getBitmapAt(0, colMeta.etcMeta);
    }
}

