/*
 * Decompiled with CFR 0.152.
 */
package com.tmax.tibero.jdbc.data;

public class RsetType {
    private static final String[] _names = new String[]{"NULL", "FWRD", "FWUP", "SIRD", "SIUP", "SSRD", "SSUP"};
    public static final RsetType NULL = new RsetType(0, -1, -1);
    public static final RsetType FWRD = new RsetType(1, 1003, 1007);
    public static final RsetType FWUP = new RsetType(2, 1003, 1008);
    public static final RsetType SIRD = new RsetType(3, 1004, 1007);
    public static final RsetType SIUP = new RsetType(4, 1004, 1008);
    public static final RsetType SSRD = new RsetType(5, 1005, 1007);
    public static final RsetType SSUP = new RsetType(6, 1005, 1008);
    public static final RsetType DEFAULT_RSET = FWRD;
    public static final int DEFAULT_TYPE = 1003;
    public static final int DEFAULT_CONCURRENCY = 1007;
    private int _rank;
    private int _type;
    private int _concurrency;

    public static RsetType getRsetType(int type, int concurrency) {
        if (type == 1003 && concurrency == 1007) {
            return FWRD;
        }
        if (type == 1003 && concurrency == 1008) {
            return FWUP;
        }
        if (type == 1004 && concurrency == 1007) {
            return SIRD;
        }
        if (type == 1004 && concurrency == 1008) {
            return SIUP;
        }
        if (type == 1005 && concurrency == 1007) {
            return SSRD;
        }
        if (type == 1005 && concurrency == 1008) {
            return SSUP;
        }
        if (type < 1004) {
            return FWRD;
        }
        return SIRD;
    }

    public RsetType getCopy() {
        switch (this._rank) {
            case 0: {
                return NULL;
            }
            case 1: {
                return FWRD;
            }
            case 2: {
                return FWUP;
            }
            case 3: {
                return SIRD;
            }
            case 4: {
                return SIUP;
            }
            case 5: {
                return SSRD;
            }
            case 6: {
                return SSUP;
            }
        }
        return FWRD;
    }

    private RsetType(int rank, int type, int concurrency) {
        this._type = type;
        this._concurrency = concurrency;
        this._rank = rank;
    }

    public int getRank() {
        return this._rank;
    }

    public boolean isScrollable() {
        return this._rank > 2;
    }

    public boolean isUpdatable() {
        return this._rank == 2 || this._rank == 4 || this._rank == 6;
    }

    public boolean isSensitive() {
        return this._rank == 5 || this._rank == 6;
    }

    public boolean useRowId() {
        return this._rank != 0 && this._rank != 1 && this._rank != 3;
    }

    public int getType() {
        return this._type;
    }

    public int getConcurrency() {
        return this._concurrency;
    }

    public boolean equals(Object obj) {
        if (obj == null || !(obj instanceof RsetType)) {
            return false;
        }
        return ((RsetType)obj)._rank == this._rank && ((RsetType)obj)._type == this._type && ((RsetType)obj)._concurrency == this._concurrency;
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        buf.append(_names[this._rank]).append("(").append(this._rank).append(")");
        return buf.toString();
    }

    public static RsetType getDownGradedRsetType(int rank) {
        switch (rank) {
            case 0: {
                return NULL;
            }
            case 1: {
                return FWRD;
            }
            case 2: {
                return FWRD;
            }
            case 3: {
                return SIRD;
            }
            case 4: {
                return SIRD;
            }
            case 5: {
                return SIRD;
            }
            case 6: {
                return SIRD;
            }
        }
        return FWRD;
    }
}

