/*
 * Decompiled with CFR 0.152.
 */
package com.tmax.tibero.jdbc.dpl;

import com.tmax.tibero.DBConst;
import com.tmax.tibero.jdbc.TbConnection;
import com.tmax.tibero.jdbc.TbDatabaseMetaData;
import com.tmax.tibero.jdbc.TbSQLException;
import com.tmax.tibero.jdbc.comm.TbStream;
import com.tmax.tibero.jdbc.data.DataType;
import com.tmax.tibero.jdbc.dpl.TbDirBindData;
import com.tmax.tibero.jdbc.dpl.TbDirBindItem;
import com.tmax.tibero.jdbc.dpl.TbDirPathMetaData;
import com.tmax.tibero.jdbc.dpl.TbDirPathStreamDataWriter;
import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.sql.Date;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;

public class TbDirPathStream {
    public static final int DPL_BIND_STREAM = -1;
    public static final int DPL_LOAD_STREAM_SUCCESS = 0;
    public static final int DPL_LOAD_STREAM_NEED_DATA = 1;
    public static final int DPL_LOAD_STREAM_NO_DATA = 2;
    public static final int DPL_LOAD_STREAM_FAIL = 3;
    public static final int SQL_DPL_DATASAVE_SAVE_ONLY = 0;
    public static final int SQL_DPL_DATASAVE_FINISH = 1;
    private int returnCode;
    private int rowCnt;
    private TbConnection conn = null;
    private TbDirPathMetaData dirPathMetaData = null;
    protected TbDirBindData bindData = null;
    private TbDirPathStreamDataWriter dplStreamWriter = null;

    public TbDirPathStream(TbConnection conn, TbDirPathMetaData dirPathMetaData) throws SQLException {
        this.conn = conn;
        this.dirPathMetaData = dirPathMetaData;
        TbStream tbStream = this.conn.getTbComm().getTbStream();
        this.dplStreamWriter = tbStream.createDirPathWriter(dirPathMetaData.getBufferSize());
        this.dplStreamWriter.clearStreamBuf();
        this.initReturnInfo();
        this.prepare();
    }

    private void initReturnInfo() {
        this.returnCode = -1;
        this.rowCnt = 0;
    }

    private void reset() {
        this.conn = null;
        if (this.dirPathMetaData != null) {
            this.dirPathMetaData.reset();
            this.dirPathMetaData = null;
        }
        this.dplStreamWriter = null;
        this.bindData = null;
    }

    public TbDirPathMetaData getDPLMetaData() {
        return this.dirPathMetaData;
    }

    public TbDirPathStreamDataWriter getDPLStreamDataWriter() {
        return this.dplStreamWriter;
    }

    public int getBindDataSize() {
        return this.dplStreamWriter.getBufferedDataSize();
    }

    public int getReturnCode() {
        return this.returnCode;
    }

    public void setReturnCode(int returnCode) {
        this.returnCode = returnCode;
    }

    public int getRowCnt() {
        return this.rowCnt;
    }

    public void setRowCnt(int rowCnt) {
        this.rowCnt = rowCnt;
    }

    public void addRowCnt(int rowCnt) {
        this.rowCnt += rowCnt;
    }

    public boolean hasBindData() {
        return this.dplStreamWriter.hasBindData();
    }

    public void prepare() throws SQLException {
        this.dirPathMetaData.checkDirPathMetaData();
        this.createBindData(this.dirPathMetaData.getColumnCnt());
        this.conn.getTbComm().dirPathPrepare(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int loadStream() throws SQLException {
        this.initReturnInfo();
        try {
            this.copyStream();
            this.dirPathLoadStream(this.dplStreamWriter, 0);
            int n = this.returnCode;
            return n;
        }
        finally {
            this.clearBindData();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int loadStreamBatch(int flag) throws SQLException {
        this.initReturnInfo();
        try {
            if ((flag & 0x100) != 0) {
                this.copyStream();
            }
            if ((flag & 0x10) != 0) {
                if (this.dplStreamWriter.getRemainedBufferSize() == 0) {
                    this.dirPathLoadStream(this.dplStreamWriter, 0);
                }
            } else {
                this.dirPathLoadStream(this.dplStreamWriter, 0);
            }
            int n = this.returnCode;
            return n;
        }
        finally {
            this.clearBindData();
        }
    }

    protected void dirPathLoadStream(TbDirPathStreamDataWriter dplStreamWriter, int partialFlag) throws SQLException {
        this.conn.getTbComm().dirPathLoadStream(this, dplStreamWriter, partialFlag);
    }

    private void copyStream() throws SQLException {
        int columnCnt = this.bindData.getParameterCnt();
        try {
            for (int i = 0; i < columnCnt; ++i) {
                TbDirBindItem bindItem = this.bindData.getBindItem(i);
                if (bindItem.getRawDataStream() != null) {
                    int svrType = this.dirPathMetaData.getDataType(i + 1);
                    if (svrType == 10) {
                        String svrCharSet = ((TbDatabaseMetaData)this.conn.getMetaData()).getServerCharSet();
                        this.dplStreamWriter.writeLongBinaryStream(this, bindItem.getRawDataStream(), bindItem.getLength(), svrCharSet);
                        continue;
                    }
                    this.dplStreamWriter.writeBinaryStream(this, bindItem.getRawDataStream(), bindItem.getLength());
                    continue;
                }
                if (bindItem.getRawDataReader() != null) {
                    int svrType = this.dirPathMetaData.getDataType(i + 1);
                    this.dplStreamWriter.writeReader(this, svrType, this.conn.getTypeConverter(), bindItem.getRawDataReader(), bindItem.getLength());
                    continue;
                }
                byte[] bytes = bindItem.getRawData();
                this.dplStreamWriter.writeStream(bindItem.getLength(), bytes);
            }
        }
        catch (SQLException se) {
            this.dplStreamWriter.clearStreamBuf();
            throw se;
        }
    }

    public void dataSave(int action) throws SQLException {
        this.conn.getTbComm().dirPathDataSave(action);
    }

    public void flushRow() throws SQLException {
        this.conn.getTbComm().dirPathFlushRow();
    }

    public void abort() throws SQLException {
        this.conn.getTbComm().dirPathAbort();
    }

    public void finish() throws SQLException {
        this.conn.getTbComm().dirPathFinish();
    }

    public void close() {
        this.reset();
    }

    private void createBindData(int bindParamCnt) throws SQLException {
        this.bindData = new TbDirBindData(bindParamCnt);
    }

    public void clearBindData() {
        if (this.bindData != null) {
            this.bindData.reuse();
        }
    }

    public TbDirBindData getBindData() {
        return this.bindData;
    }

    public void setString(int index, String data) throws SQLException {
        if (data == null || data.equals("")) {
            this.setNull(index);
            return;
        }
        this.checkParameterIndex(index);
        int svrType = this.dirPathMetaData.getDataType(index);
        byte[] bytes = this.conn.getTypeConverter().varcharToServerTypeCast(data, svrType);
        this.bindData.setBindItem(index - 1, bytes.length, bytes);
    }

    public void setRowid(int index, String data) throws SQLException {
        if (data == null || data.equals("")) {
            this.setNull(index);
            return;
        }
        this.checkParameterIndex(index);
        int svrType = this.dirPathMetaData.getDataType(index);
        byte[] bytes = this.conn.getTypeConverter().varcharToRowidCast(data, svrType);
        this.bindData.setBindItem(index - 1, bytes.length, bytes);
    }

    public void setBoolean(int index, boolean data) throws SQLException {
        this.checkParameterIndex(index);
        int svrType = this.dirPathMetaData.getDataType(index);
        byte[] bytes = this.conn.getTypeConverter().booleanToServerTypeCast(data, svrType);
        this.bindData.setBindItem(index - 1, bytes.length, bytes);
    }

    public void setByte(int index, byte data) throws SQLException {
        this.checkParameterIndex(index);
        int svrType = this.dirPathMetaData.getDataType(index);
        byte[] bytes = this.conn.getTypeConverter().byteToServerTypeCast(data, svrType);
        this.bindData.setBindItem(index - 1, bytes.length, bytes);
    }

    public void setShort(int index, short data) throws SQLException {
        this.checkParameterIndex(index);
        int svrType = this.dirPathMetaData.getDataType(index);
        byte[] bytes = this.conn.getTypeConverter().shortToServerTypeCast(data, svrType);
        this.bindData.setBindItem(index - 1, bytes.length, bytes);
    }

    public void setInt(int index, int data) throws SQLException {
        this.checkParameterIndex(index);
        int svrType = this.dirPathMetaData.getDataType(index);
        byte[] bytes = this.conn.getTypeConverter().integerToServerTypeCast(data, svrType);
        this.bindData.setBindItem(index - 1, bytes.length, bytes);
    }

    public void setLong(int index, long data) throws SQLException {
        this.checkParameterIndex(index);
        int svrType = this.dirPathMetaData.getDataType(index);
        byte[] bytes = this.conn.getTypeConverter().longToServerTypeCast(data, svrType);
        this.bindData.setBindItem(index - 1, bytes.length, bytes);
    }

    public void setFloat(int index, float data) throws SQLException {
        this.checkParameterIndex(index);
        int svrType = this.dirPathMetaData.getDataType(index);
        byte[] bytes = this.conn.getTypeConverter().floatToServerTypeCast(data, svrType);
        this.bindData.setBindItem(index - 1, bytes.length, bytes);
    }

    public void setDouble(int index, double data) throws SQLException {
        this.checkParameterIndex(index);
        int svrType = this.dirPathMetaData.getDataType(index);
        byte[] bytes = this.conn.getTypeConverter().doubleToServerTypeCast(data, svrType);
        this.bindData.setBindItem(index - 1, bytes.length, bytes);
    }

    public void setBigDecimal(int index, BigDecimal data) throws SQLException {
        if (data == null) {
            this.setNull(index);
            return;
        }
        this.checkParameterIndex(index);
        int svrType = this.dirPathMetaData.getDataType(index);
        byte[] bytes = this.conn.getTypeConverter().bigDecimalToServerTypeCast(data, svrType);
        this.bindData.setBindItem(index - 1, bytes.length, bytes);
    }

    public void setBytes(int index, byte[] data) throws SQLException {
        if (data == null) {
            this.setNull(index);
            return;
        }
        this.checkParameterIndex(index);
        int svrType = this.dirPathMetaData.getDataType(index);
        if (svrType == 15) {
            svrType = 4;
        }
        byte[] bytes = this.conn.getTypeConverter().binaryToServerTypeCast(data, svrType);
        this.bindData.setBindItem(index - 1, bytes.length, bytes);
    }

    public void setBytes(int index, int tbDataType, byte[] bytes) throws SQLException {
        if (bytes == null) {
            this.setNull(index);
            return;
        }
        this.checkParameterIndex(index);
        this.bindData.setBindItem(index - 1, bytes.length, bytes);
    }

    public void setDate(int index, Date data) throws SQLException {
        if (data == null) {
            this.setNull(index);
            return;
        }
        this.checkParameterIndex(index);
        int svrType = this.dirPathMetaData.getDataType(index);
        byte[] bytes = this.conn.getTypeConverter().dateToServerTypeCast(data, svrType);
        this.bindData.setBindItem(index - 1, bytes.length, bytes);
    }

    public void setDate(int index, Date data, Calendar cal) throws SQLException {
        this.setDate(index, data);
    }

    public void setTime(int index, Time data) throws SQLException {
        if (data == null) {
            this.setNull(index);
            return;
        }
        this.checkParameterIndex(index);
        int svrType = this.dirPathMetaData.getDataType(index);
        byte[] bytes = this.conn.getTypeConverter().timeToServerTypeCast(data, svrType);
        this.bindData.setBindItem(index - 1, bytes.length, bytes);
    }

    public void setTime(int index, Time data, Calendar cal) throws SQLException {
        this.setTime(index, data);
    }

    public void setTimestamp(int index, Timestamp data) throws SQLException {
        if (data == null) {
            this.setNull(index);
            return;
        }
        this.checkParameterIndex(index);
        int svrType = this.dirPathMetaData.getDataType(index);
        byte[] bytes = this.conn.getTypeConverter().timestampToServerTypeCast(data, svrType);
        this.bindData.setBindItem(index - 1, bytes.length, bytes);
    }

    public void setTimestamp(int index, Timestamp data, Calendar cal) throws SQLException {
        this.setTimestamp(index, data);
    }

    public void setAsciiStream(int index, InputStream data, int length) throws SQLException {
        this.setBinaryStream(index, data, length);
    }

    public void setBinaryStream(int index, InputStream dataStream, int length) throws SQLException {
        if (dataStream == null || length < 0) {
            this.setNull(index);
            return;
        }
        this.checkParameterIndex(index);
        if (length >= DBConst.MIN_DEFERRED_BYTE_SIZE) {
            this.bindData.setBindItem(index - 1, length, dataStream);
        } else {
            byte[] bytes = this.conn.getTypeConverter().fromBinaryStreamToBytes(dataStream, length);
            this.bindData.setBindItem(index - 1, bytes.length, bytes);
        }
    }

    public void setLongBinaryStream(int index, InputStream dataStream, int length) throws SQLException {
        if (dataStream == null || length < 0) {
            this.setNull(index);
            return;
        }
        this.checkParameterIndex(index);
        int svrType = this.dirPathMetaData.getDataType(index);
        if (svrType != 10) {
            throw new TbSQLException(-590703);
        }
        this.bindData.setBindItem(index - 1, length, dataStream);
    }

    public void setCharacterStream(int index, Reader reader, int length) throws SQLException {
        if (reader == null || length < 0) {
            this.setNull(index);
            return;
        }
        this.checkParameterIndex(index);
        this.bind(index, length, reader);
    }

    public void setObject(int index, Object data, int targetSqlType, int scale) throws SQLException {
        switch (targetSqlType) {
            case -7: {
                this.setBoolean(index, new Boolean(data.toString()));
                break;
            }
            case -1: 
            case 1: 
            case 12: {
                if (data != null) {
                    this.setString(index, data.toString());
                    break;
                }
                this.setString(index, null);
                break;
            }
            case -4: 
            case -3: 
            case -2: {
                this.setBytes(index, (byte[])data);
                break;
            }
            case -6: 
            case 5: {
                this.setShort(index, new Short(data.toString()));
                break;
            }
            case 4: {
                this.setInt(index, new Integer(data.toString()));
                break;
            }
            case -5: {
                this.setLong(index, new Long(data.toString()));
                break;
            }
            case 3: {
                this.setBigDecimal(index, new BigDecimal(data.toString()));
                break;
            }
            case 6: {
                this.setFloat(index, new Float(data.toString()).floatValue());
                break;
            }
            case 7: {
                this.setFloat(index, new Float(data.toString()).floatValue());
                break;
            }
            case 8: {
                this.setDouble(index, new Double(data.toString()));
                break;
            }
            case 2: {
                if (data instanceof Short) {
                    this.setShort(index, (Short)data);
                    break;
                }
                if (data instanceof Integer) {
                    this.setInt(index, (Integer)data);
                    break;
                }
                if (data instanceof Long) {
                    this.setLong(index, (Long)data);
                    break;
                }
                if (data instanceof Float) {
                    this.setFloat(index, ((Float)data).floatValue());
                    break;
                }
                if (data instanceof Double) {
                    this.setDouble(index, (Double)data);
                    break;
                }
                if (data instanceof BigDecimal) {
                    this.setBigDecimal(index, (BigDecimal)data);
                    break;
                }
                if (data instanceof Boolean) {
                    this.setBoolean(index, (Boolean)data);
                    break;
                }
                throw new TbSQLException(-590704, "" + targetSqlType);
            }
            case 91: {
                this.setDate(index, (Date)data);
                break;
            }
            case 92: {
                this.setTime(index, (Time)data);
                break;
            }
            case 93: {
                this.setTimestamp(index, (Timestamp)data);
                break;
            }
            default: {
                throw new TbSQLException(-590704, "" + targetSqlType);
            }
        }
    }

    public void setObject(int index, Object data) throws SQLException {
        if (data == null) {
            this.setNull(index);
            return;
        }
        int sqlType = DataType.getSqlType(data);
        this.setObject(index, data, sqlType);
    }

    public void setObject(int index, Object data, int targetSqlType) throws SQLException {
        this.setObject(index, data, targetSqlType, 0);
    }

    public void setTbObject(int index, Object data, int dataType) throws SQLException {
        if (data == null) {
            this.setNull(index);
            return;
        }
        this.checkParameterIndex(index);
        byte[] bytes = this.conn.getTypeConverter().fromObject(data);
        this.bindData.setBindItem(index - 1, bytes.length, bytes);
    }

    public void setNull(int index) throws SQLException {
        this.checkParameterIndex(index);
        byte[] bytes = new byte[]{};
        this.bindData.setBindItem(index - 1, bytes.length, bytes);
    }

    public void setEmptyLob(int index) throws SQLException {
        this.checkParameterIndex(index);
        int svrType = this.dirPathMetaData.getDataType(index);
        if (svrType != 12 && svrType != 13 && svrType != 20) {
            throw new TbSQLException(-590703);
        }
        byte[] bytes = new byte[]{};
        this.bindData.setBindItem(index - 1, -1, bytes);
    }

    protected void bind(int index, int length, Reader reader) throws SQLException {
        this.bindData.setBindItem(index - 1, length, reader);
    }

    protected void checkParameterIndex(int index) throws SQLException {
        if (index < 1 || index > this.dirPathMetaData.getColumnCnt()) {
            throw new TbSQLException(-90609);
        }
    }
}

