/*
 * Decompiled with CFR 0.152.
 */
package com.tmax.tibero.jdbc.dpl;

import com.tmax.tibero.jdbc.TbSQLException;
import com.tmax.tibero.jdbc.comm.TbStreamDataWriter;
import com.tmax.tibero.jdbc.data.DataTypeConverter;
import com.tmax.tibero.jdbc.data.StreamBuffer;
import com.tmax.tibero.jdbc.dpl.TbDirPathStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.sql.SQLException;

public class TbDirPathStreamDataWriter
extends TbStreamDataWriter {
    private static final int DPL_PARAM_INFO_OFFSET = 32;
    private static final int EXTRA_SIZE = 65536;
    char[] charBuf = new char[4096];
    byte[] byteBuf = new byte[16384];

    public void set(int partialFlag) throws SQLException {
        this.reWriteInt(0, 57, 4);
        this.reWriteInt(4, this.getBufferedDataSize() - 24, 4);
        this.reWriteLong(8, 0L, 8);
        this.reWriteLong(16, 0L, 8);
        this.reWriteInt(24, partialFlag, 4);
        this.reWriteInt(28, this.buf.getCurDataSize() - 32, 4);
    }

    public TbDirPathStreamDataWriter(StreamBuffer buf) {
        super(buf);
    }

    public void clearStreamBuf() {
        this.buf.setCurDataSize(32);
    }

    public int getRemainedBufferSize() {
        int remainedSize = this.buf.getRemained() - 65536;
        if (remainedSize < 0) {
            return 0;
        }
        return remainedSize;
    }

    public boolean hasBindData() {
        return this.buf.getCurDataSize() > 32;
    }

    public int writePadding(int len) {
        int padLen = TbDirPathStreamDataWriter.getPadLength(len);
        this.putPadding(padLen);
        return padLen;
    }

    public static int getPadLength(int byteLength) {
        int result = (4 - byteLength % 4) % 4;
        return result;
    }

    public void writeStream(int length, byte[] bytes) throws SQLException {
        this.writeInt(length, 4);
        this.writePadBytes(bytes);
    }

    public void writeReader(TbDirPathStream dirPathStream, int svrType, DataTypeConverter dataTypeConverter, Reader reader, int totalReadChars) throws SQLException {
        int readChars = 0;
        int readBufferChars = 0;
        int convertedBytes = 0;
        int writeByteCnt = 0;
        try {
            this.writeInt(0, 4);
            while (totalReadChars >= 0) {
                readChars = totalReadChars > 4096 ? 4096 : totalReadChars;
                readBufferChars = reader.read(this.charBuf, 0, readChars);
                if (readBufferChars <= 0) {
                    if (writeByteCnt > 0) {
                        this.reWriteInt(this.buf.getCurDataSize() - writeByteCnt - 4, writeByteCnt, 4);
                        this.writePadding(writeByteCnt);
                    }
                    return;
                }
                convertedBytes = svrType == 13 || svrType == 20 ? dataTypeConverter.charsToFixedBytes(this.charBuf, 0, readBufferChars, this.byteBuf, 0, this.byteBuf.length) : dataTypeConverter.charsToBytes(this.charBuf, 0, readBufferChars, this.byteBuf, 0, this.byteBuf.length);
                int offset = 0;
                int availableBytes = 0;
                int unReadBytes = 0;
                while ((unReadBytes = convertedBytes - offset) > (availableBytes = this.buf.getRemained())) {
                    this.writeBytes(this.byteBuf, offset, availableBytes);
                    offset += availableBytes;
                    this.reWriteInt(this.buf.getCurDataSize() - (writeByteCnt += availableBytes) - 4, writeByteCnt, 4);
                    dirPathStream.dirPathLoadStream(this, 1);
                    writeByteCnt = 0;
                    this.writeInt(0, 4);
                }
                this.writeBytes(this.byteBuf, offset, unReadBytes);
                writeByteCnt += unReadBytes;
                offset += unReadBytes;
                totalReadChars -= readBufferChars;
            }
        }
        catch (IOException e) {
            throw new TbSQLException(-90202, "bind parameter reader failed");
        }
    }

    public void writeBinaryStream(TbDirPathStream dirPathStream, InputStream inputStream, int totalReadBytes) throws SQLException {
        int readBufferBytes = 0;
        int availableBytes = 0;
        int readBytes = 0;
        try {
            while (totalReadBytes >= 0) {
                this.writeInt(0, 4);
                availableBytes = this.buf.getRemained();
                readBytes = totalReadBytes > availableBytes ? availableBytes : totalReadBytes;
                readBufferBytes = inputStream.read(this.buf.getRawBytes(), this.buf.getCurDataSize(), readBytes);
                if (readBufferBytes == -1) {
                    readBufferBytes = 0;
                }
                this.setCurDataSize(this.buf.getCurDataSize() + readBufferBytes);
                this.reWriteInt(this.buf.getCurDataSize() - readBufferBytes - 4, readBufferBytes, 4);
                if (readBufferBytes != availableBytes) {
                    this.writePadding(readBufferBytes);
                    return;
                }
                dirPathStream.dirPathLoadStream(this, 1);
                totalReadBytes -= readBufferBytes;
            }
        }
        catch (IOException e) {
            throw new TbSQLException(-90202, "bind parameter stream failed: " + e.getMessage());
        }
    }

    public void writeLongBinaryStream(TbDirPathStream dirPathStream, InputStream inputStream, int totalReadBytes, String svrCharSet) throws SQLException {
        String clientCharSet = dirPathStream.getDPLMetaData().getClientCharSet();
        if (clientCharSet == null || clientCharSet.equals(svrCharSet)) {
            this.writeBinaryStream(dirPathStream, inputStream, totalReadBytes);
            return;
        }
        int readBufferBytes = 0;
        int readBytes = 0;
        int writeByteCnt = 0;
        int offset = 0;
        int availableBytes = 0;
        int unReadBytes = 0;
        try {
            this.writeInt(0, 4);
            while (totalReadBytes >= 0) {
                readBytes = totalReadBytes > 16384 ? 16384 : totalReadBytes;
                readBufferBytes = inputStream.read(this.byteBuf, 0, readBytes);
                if (readBufferBytes <= 0) {
                    if (writeByteCnt > 0) {
                        this.reWriteInt(this.buf.getCurDataSize() - writeByteCnt - 4, writeByteCnt, 4);
                        this.writePadding(writeByteCnt);
                    }
                    return;
                }
                String tempStr = new String(this.byteBuf, 0, readBufferBytes, clientCharSet);
                byte[] convBuf = tempStr.getBytes(svrCharSet);
                offset = 0;
                while ((unReadBytes = convBuf.length - offset) > (availableBytes = this.buf.getRemained())) {
                    this.writeBytes(convBuf, offset, availableBytes);
                    offset += availableBytes;
                    this.reWriteInt(this.buf.getCurDataSize() - (writeByteCnt += availableBytes) - 4, writeByteCnt, 4);
                    dirPathStream.dirPathLoadStream(this, 1);
                    writeByteCnt = 0;
                    this.writeInt(0, 4);
                }
                this.writeBytes(convBuf, offset, unReadBytes);
                writeByteCnt += unReadBytes;
                offset += unReadBytes;
                totalReadBytes -= readBufferBytes;
            }
        }
        catch (IOException e) {
            throw new TbSQLException(-90202, "bind parameter stream failed");
        }
    }
}

