/*
 * Decompiled with CFR 0.152.
 */
package com.tmax.tibero.jdbc.ext;

import com.tmax.tibero.jdbc.TbConnection;
import com.tmax.tibero.jdbc.ext.TbLogicalConnection;
import com.tmax.tibero.jdbc.ext.TbPooledConnection;
import com.tmax.tibero.jdbc.ext.TbXAException;
import java.sql.SQLException;
import javax.sql.XAConnection;
import javax.transaction.xa.XAException;
import javax.transaction.xa.XAResource;
import javax.transaction.xa.Xid;

public class TbXAConnection
extends TbPooledConnection
implements XAConnection,
XAResource {
    private boolean autoCommit = false;

    public TbXAConnection(TbConnection conn) throws SQLException {
        super(conn);
        this.getPhysicalConnection().setAutoCommit(false);
    }

    public void commit(Xid xid, boolean bool) throws XAException {
        if (xid == null) {
            throw new TbXAException(-5);
        }
        if (this.getPhysicalConnection().isClosed()) {
            throw new TbXAException(-7);
        }
        this.getPhysicalConnection().getTbXAComm().xaCommit(xid, bool);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void end(Xid xid, int flag) throws XAException {
        if (xid == null) {
            throw new TbXAException(-5);
        }
        if (this.getPhysicalConnection().isClosed()) {
            throw new TbXAException(-7);
        }
        try {
            this.getPhysicalConnection().setTxnMode(0);
            this.getPhysicalConnection().getTbXAComm().xaEnd(xid, flag);
        }
        finally {
            try {
                this.restoreAutoCommit();
            }
            catch (SQLException se) {
                throw new TbXAException(se.getMessage());
            }
        }
    }

    public void forget(Xid xid) throws XAException {
        if (xid == null) {
            throw new TbXAException(-5);
        }
    }

    protected TbLogicalConnection getNewLogicalConnection() throws SQLException {
        return new TbLogicalConnection(this, this.getPhysicalConnection(), true);
    }

    public int getTransactionTimeout() throws XAException {
        return -1;
    }

    public XAResource getXAResource() {
        return this;
    }

    public boolean isSameRM(XAResource aResource) throws XAException {
        if (!(aResource instanceof TbXAConnection)) {
            return false;
        }
        TbConnection conn = ((TbXAConnection)aResource).getPhysicalConnection();
        TbConnection myConn = this.getPhysicalConnection();
        String myUrl = myConn.info.getUrl();
        if (conn == null || conn.info == null) {
            return false;
        }
        return conn.equals(myConn) || conn.info.getUrl().equals(myUrl);
    }

    public int prepare(Xid xid) throws XAException {
        if (xid == null) {
            throw new TbXAException(-5);
        }
        if (this.getPhysicalConnection().isClosed()) {
            throw new TbXAException(-7);
        }
        return this.getPhysicalConnection().getTbXAComm().xaPrepare(xid);
    }

    public Xid[] recover(int flag) throws XAException {
        if (flag != 0 && flag != 0x1000000 && flag != 0x800000) {
            throw new TbXAException(-5);
        }
        if (this.getPhysicalConnection().isClosed()) {
            throw new TbXAException(-7);
        }
        return this.getPhysicalConnection().getTbXAComm().xaRecover(flag);
    }

    public final void restoreAutoCommit() throws SQLException {
        this.getPhysicalConnection().setAutoCommit(this.autoCommit);
    }

    public void rollback(Xid xid) throws XAException {
        if (xid == null) {
            throw new TbXAException(-5);
        }
        if (this.getPhysicalConnection().isClosed()) {
            throw new TbXAException(-7);
        }
        this.getPhysicalConnection().getTbXAComm().xaRollback(xid);
    }

    private final void saveAutoCommit() throws SQLException {
        this.autoCommit = this.getPhysicalConnection().getAutoCommit();
    }

    public boolean setTransactionTimeout(int i) throws XAException {
        return false;
    }

    public void start(Xid xid, int flag) throws XAException {
        if (xid == null) {
            throw new TbXAException(-5);
        }
        if (this.getPhysicalConnection().isClosed()) {
            throw new TbXAException(-7);
        }
        try {
            this.saveAutoCommit();
            this.getPhysicalConnection().setAutoCommit(false);
        }
        catch (SQLException se) {
            throw new TbXAException(se.getMessage());
        }
        try {
            this.getPhysicalConnection().getTbXAComm().xaStart(xid, flag);
            this.getPhysicalConnection().setTxnMode(2);
        }
        catch (XAException xe) {
            try {
                this.restoreAutoCommit();
            }
            catch (SQLException se) {
                throw new TbXAException(se.getMessage());
            }
            throw xe;
        }
    }
}

