/*
 * Decompiled with CFR 0.152.
 */
package com.tmax.tibero.jdbc.msg;

import com.tmax.tibero.jdbc.comm.TbStreamDataReader;
import com.tmax.tibero.jdbc.comm.TbStreamDataWriter;
import com.tmax.tibero.jdbc.msg.TbPivotInfo;
import com.tmax.tibero.jdbc.msg.common.TbMsg;
import java.sql.SQLException;

public class TbMsgExecutePivotReply
extends TbMsg {
    public int pivotInfoArrayCnt;
    public TbPivotInfo[] pivotInfo;
    public byte[] chunk;
    public int chunkLen;

    public TbMsgExecutePivotReply(int autoCommit) {
        this.msgType = 9;
        this.msgBodySize = 0;
        this.autoCommit = autoCommit;
    }

    public void set(int pivotInfoArrayCnt, TbPivotInfo[] pivotInfo, byte[] chunk, int chunkLen) {
        this.pivotInfoArrayCnt = pivotInfoArrayCnt;
        this.pivotInfo = pivotInfo;
        this.chunk = chunk;
        this.chunkLen = chunkLen;
    }

    public void serialize(TbStreamDataWriter writer) throws SQLException {
        writer.writeInt(this.msgType, 4);
        writer.writeInt(this.msgBodySize, 4);
        writer.writeInt(this.autoCommit, 8);
        writer.writeLong(this.tsn, 8);
        writer.writeInt(this.pivotInfoArrayCnt, 4);
        if (this.pivotInfo != null) {
            for (int i = 0; i < this.pivotInfoArrayCnt; ++i) {
                this.pivotInfo[i].serialize(writer);
            }
        }
        if (this.chunkLen != 0) {
            writer.writeInt(this.chunkLen, 4);
            writer.writePadBytes(this.chunk, 0, this.chunkLen);
        } else {
            writer.writeInt(0, 4);
            writer.writeInt(0, 4);
        }
        writer.reWriteInt(4, writer.getBufferedDataSize() - 24, 4);
    }

    public void deserialize(TbStreamDataReader reader) throws SQLException {
        int chunkLen;
        int pivotInfoLen = reader.readInt32();
        if (pivotInfoLen > 0) {
            this.pivotInfo = new TbPivotInfo[pivotInfoLen];
            for (int i = 0; i < pivotInfoLen; ++i) {
                this.pivotInfo[i] = new TbPivotInfo();
                this.pivotInfo[i].deserialize(reader);
            }
        } else {
            this.pivotInfo = null;
        }
        if ((chunkLen = reader.readInt32()) != 0) {
            this.chunk = new byte[chunkLen];
            reader.readPadBytes(this.chunk, 0, chunkLen);
        } else {
            reader.moveReadOffset(4);
            this.chunk = new byte[0];
        }
    }

    public boolean equals(Object obj) {
        int i;
        if (obj == null) {
            return false;
        }
        TbMsgExecutePivotReply msg = (TbMsgExecutePivotReply)obj;
        if (this.pivotInfo == null && msg.pivotInfo != null || this.pivotInfo != null && msg.pivotInfo == null) {
            return false;
        }
        if (this.pivotInfo != null && msg.pivotInfo != null) {
            if (this.pivotInfo.length != msg.pivotInfo.length) {
                return false;
            }
            for (i = 0; i < msg.pivotInfo.length; ++i) {
                if (this.pivotInfo[i].equals(msg.pivotInfo[i])) continue;
                return false;
            }
        }
        if (this.chunk == null && msg.chunk != null || this.chunk != null && msg.chunk == null) {
            return false;
        }
        if (this.chunk != null && msg.chunk != null) {
            if (this.chunk.length != msg.chunk.length) {
                return false;
            }
            for (i = 0; i < msg.chunk.length; ++i) {
                if (this.chunk[i] == msg.chunk[i]) continue;
                return false;
            }
        }
        return true;
    }

    public String toString() {
        int i;
        StringBuffer str = new StringBuffer("[TbMsgExecutePivotReply]/");
        str.append("pivotInfo={\n");
        if (this.pivotInfo != null) {
            for (i = 0; i < this.pivotInfo.length; ++i) {
                str.append("  pivotInfo[" + i + "]=" + this.pivotInfo[i]);
            }
        } else {
            str.append("=null");
        }
        str.append("}/");
        str.append("chunk=");
        if (this.chunk != null) {
            for (i = 0; i < this.chunk.length; ++i) {
                str.append(this.chunk[i] + "/");
            }
        } else {
            str.append("null/");
        }
        return str.append("\n").toString();
    }
}

