/*
 * Decompiled with CFR 0.152.
 */
package com.tmax.tibero.jdbc.msg;

import com.tmax.tibero.jdbc.comm.TbStreamDataReader;
import com.tmax.tibero.jdbc.comm.TbStreamDataWriter;
import com.tmax.tibero.jdbc.msg.common.TbMsg;
import java.sql.SQLException;

public class TbMsgLongReadReply
extends TbMsg {
    public int isLastData;
    public byte[] longLoc;
    public int longLocLen;
    public byte[] data;
    public int dataLen;

    public TbMsgLongReadReply(int autoCommit) {
        this.msgType = 53;
        this.msgBodySize = 0;
        this.autoCommit = autoCommit;
    }

    public void set(int isLastData, byte[] longLoc, int longLocLen, byte[] data, int dataLen) {
        this.isLastData = isLastData;
        this.longLoc = longLoc;
        this.longLocLen = longLocLen;
        this.data = data;
        this.dataLen = dataLen;
    }

    public void serialize(TbStreamDataWriter writer) throws SQLException {
        writer.writeInt(this.msgType, 4);
        writer.writeInt(this.msgBodySize, 4);
        writer.writeInt(this.autoCommit, 8);
        writer.writeLong(this.tsn, 8);
        writer.writeInt(this.isLastData, 4);
        if (this.longLocLen != 0) {
            writer.writeInt(this.longLocLen, 4);
            writer.writePadBytes(this.longLoc, 0, this.longLocLen);
        } else {
            writer.writeInt(0, 4);
            writer.writeInt(0, 4);
        }
        if (this.dataLen != 0) {
            writer.writeInt(this.dataLen, 4);
            writer.writePadBytes(this.data, 0, this.dataLen);
        } else {
            writer.writeInt(0, 4);
            writer.writeInt(0, 4);
        }
        writer.reWriteInt(4, writer.getBufferedDataSize() - 24, 4);
    }

    public void deserialize(TbStreamDataReader reader) throws SQLException {
        this.isLastData = reader.readInt32();
        int longLocLen = reader.readInt32();
        if (longLocLen != 0) {
            this.longLoc = new byte[longLocLen];
            reader.readPadBytes(this.longLoc, 0, longLocLen);
        } else {
            reader.moveReadOffset(4);
            this.longLoc = new byte[0];
        }
        int dataLen = reader.readInt32();
        if (dataLen != 0) {
            this.data = new byte[dataLen];
            reader.readPadBytes(this.data, 0, dataLen);
        } else {
            reader.moveReadOffset(4);
            this.data = new byte[0];
        }
    }

    public boolean equals(Object obj) {
        int i;
        if (obj == null) {
            return false;
        }
        TbMsgLongReadReply msg = (TbMsgLongReadReply)obj;
        if (this.isLastData != msg.isLastData) {
            return false;
        }
        if (this.longLoc == null && msg.longLoc != null || this.longLoc != null && msg.longLoc == null) {
            return false;
        }
        if (this.longLoc != null && msg.longLoc != null) {
            if (this.longLoc.length != msg.longLoc.length) {
                return false;
            }
            for (i = 0; i < msg.longLoc.length; ++i) {
                if (this.longLoc[i] == msg.longLoc[i]) continue;
                return false;
            }
        }
        if (this.data == null && msg.data != null || this.data != null && msg.data == null) {
            return false;
        }
        if (this.data != null && msg.data != null) {
            if (this.data.length != msg.data.length) {
                return false;
            }
            for (i = 0; i < msg.data.length; ++i) {
                if (this.data[i] == msg.data[i]) continue;
                return false;
            }
        }
        return true;
    }

    public String toString() {
        int i;
        StringBuffer str = new StringBuffer("[TbMsgLongReadReply]/");
        str.append("isLastData=");
        str.append(this.isLastData);
        str.append("/");
        str.append("longLoc=");
        if (this.longLoc != null) {
            for (i = 0; i < this.longLoc.length; ++i) {
                str.append(this.longLoc[i] + "/");
            }
        } else {
            str.append("null/");
        }
        str.append("data=");
        if (this.data != null) {
            for (i = 0; i < this.data.length; ++i) {
                str.append(this.data[i] + "/");
            }
        } else {
            str.append("null/");
        }
        return str.append("\n").toString();
    }
}

