/*
 * Decompiled with CFR 0.152.
 */
package com.tmax.tibero.jdbc.msg;

import com.tmax.tibero.jdbc.comm.TbStreamDataReader;
import com.tmax.tibero.jdbc.comm.TbStreamDataWriter;
import com.tmax.tibero.jdbc.msg.TbTbcmNode;
import com.tmax.tibero.jdbc.msg.common.TbMsg;
import java.sql.SQLException;

public class TbMsgTbcmMember
extends TbMsg {
    public int type;
    public int incarNo;
    public int clusterPort;
    public int memberArrayCnt;
    public TbTbcmNode[] member;

    public TbMsgTbcmMember(int autoCommit) {
        this.msgType = 125;
        this.msgBodySize = 0;
        this.autoCommit = autoCommit;
    }

    public void set(int type, int incarNo, int clusterPort, int memberArrayCnt, TbTbcmNode[] member) {
        this.type = type;
        this.incarNo = incarNo;
        this.clusterPort = clusterPort;
        this.memberArrayCnt = memberArrayCnt;
        this.member = member;
    }

    public void serialize(TbStreamDataWriter writer) throws SQLException {
        writer.writeInt(this.msgType, 4);
        writer.writeInt(this.msgBodySize, 4);
        writer.writeInt(this.autoCommit, 8);
        writer.writeLong(this.tsn, 8);
        writer.writeInt(this.type, 4);
        writer.writeInt(this.incarNo, 4);
        writer.writeInt(this.clusterPort, 4);
        writer.writeInt(this.memberArrayCnt, 4);
        if (this.member != null) {
            for (int i = 0; i < this.memberArrayCnt; ++i) {
                this.member[i].serialize(writer);
            }
        }
        writer.reWriteInt(4, writer.getBufferedDataSize() - 24, 4);
    }

    public void deserialize(TbStreamDataReader reader) throws SQLException {
        this.type = reader.readInt32();
        this.incarNo = reader.readInt32();
        this.clusterPort = reader.readInt32();
        int memberLen = reader.readInt32();
        if (memberLen > 0) {
            this.member = new TbTbcmNode[memberLen];
            for (int i = 0; i < memberLen; ++i) {
                this.member[i] = new TbTbcmNode();
                this.member[i].deserialize(reader);
            }
        } else {
            this.member = null;
        }
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        TbMsgTbcmMember msg = (TbMsgTbcmMember)obj;
        if (this.type != msg.type) {
            return false;
        }
        if (this.incarNo != msg.incarNo) {
            return false;
        }
        if (this.clusterPort != msg.clusterPort) {
            return false;
        }
        if (this.member == null && msg.member != null || this.member != null && msg.member == null) {
            return false;
        }
        if (this.member != null && msg.member != null) {
            if (this.member.length != msg.member.length) {
                return false;
            }
            for (int i = 0; i < msg.member.length; ++i) {
                if (this.member[i].equals(msg.member[i])) continue;
                return false;
            }
        }
        return true;
    }

    public String toString() {
        StringBuffer str = new StringBuffer("[TbMsgTbcmMember]/");
        str.append("type=");
        str.append(this.type);
        str.append("/");
        str.append("incarNo=");
        str.append(this.incarNo);
        str.append("/");
        str.append("clusterPort=");
        str.append(this.clusterPort);
        str.append("/");
        str.append("member={\n");
        if (this.member != null) {
            for (int i = 0; i < this.member.length; ++i) {
                str.append("  member[" + i + "]=" + this.member[i]);
            }
        } else {
            str.append("=null");
        }
        str.append("}/");
        return str.append("\n").toString();
    }
}

