/*
 * Decompiled with CFR 0.152.
 */
package com.tmax.tibero.rowset;

import java.io.Serializable;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import javax.sql.RowSetMetaData;

public class TbRowSetMetaData
implements RowSetMetaData,
Serializable {
    private int columnCount;
    private boolean[] autoIncrement;
    private boolean[] caseSensitive;
    private String[] catalogName;
    private int[] columnDIsplaySize;
    private String[] columnLabel;
    private String[] columnName;
    private int[] columnType;
    private String[] columnTypeName;
    private boolean[] currency;
    private int[] nullable;
    private int[] precision;
    private int[] scale;
    private String[] schemaName;
    private boolean[] searchable;
    private boolean[] signed;
    private String[] tableName;
    private boolean[] definatelyWritable;
    private boolean[] readOnly;
    private boolean[] writable;
    private String[] columnClassName;

    public TbRowSetMetaData(ResultSetMetaData data) throws SQLException {
        this.columnCount = data.getColumnCount();
        this.autoIncrement = new boolean[this.columnCount];
        this.caseSensitive = new boolean[this.columnCount];
        this.catalogName = new String[this.columnCount];
        this.columnDIsplaySize = new int[this.columnCount];
        this.columnLabel = new String[this.columnCount];
        this.columnName = new String[this.columnCount];
        this.columnType = new int[this.columnCount];
        this.columnTypeName = new String[this.columnCount];
        this.currency = new boolean[this.columnCount];
        this.nullable = new int[this.columnCount];
        this.precision = new int[this.columnCount];
        this.precision = new int[this.columnCount];
        this.scale = new int[this.columnCount];
        this.schemaName = new String[this.columnCount];
        this.searchable = new boolean[this.columnCount];
        this.signed = new boolean[this.columnCount];
        this.tableName = new String[this.columnCount];
        this.definatelyWritable = new boolean[this.columnCount];
        this.readOnly = new boolean[this.columnCount];
        this.writable = new boolean[this.columnCount];
        this.columnClassName = new String[this.columnCount];
        for (int k = 0; k < this.columnCount; ++k) {
            this.autoIncrement[k] = data.isAutoIncrement(k + 1);
            this.caseSensitive[k] = data.isCaseSensitive(k + 1);
            this.catalogName[k] = data.getCatalogName(k + 1);
            this.columnDIsplaySize[k] = data.getColumnDisplaySize(k + 1);
            this.columnLabel[k] = data.getColumnLabel(k + 1);
            this.columnName[k] = data.getColumnName(k + 1);
            this.columnType[k] = data.getColumnType(k + 1);
            this.columnTypeName[k] = data.getColumnTypeName(k + 1);
            this.currency[k] = data.isCurrency(k + 1);
            this.nullable[k] = data.isNullable(k + 1);
            this.precision[k] = data.getPrecision(k + 1);
            this.scale[k] = data.getScale(k + 1);
            this.schemaName[k] = data.getSchemaName(k + 1);
            this.searchable[k] = data.isSearchable(k + 1);
            this.signed[k] = data.isSearchable(k + 1);
            this.tableName[k] = data.getTableName(k + 1);
            this.definatelyWritable[k] = data.isDefinitelyWritable(k + 1);
            this.readOnly[k] = data.isReadOnly(k + 1);
            this.writable[k] = data.isWritable(k + 1);
            this.columnClassName[k] = data.getColumnClassName(k + 1);
        }
    }

    private void checkIndex(int colIndex) throws SQLException {
        if (colIndex < 1 || colIndex >= this.columnCount) {
            throw new SQLException("invalid column index");
        }
    }

    public void setAutoIncrement(int colIndex, boolean bool) throws SQLException {
        this.checkIndex(colIndex);
        this.autoIncrement[colIndex - 1] = bool;
    }

    public void setCaseSensitive(int colIndex, boolean bool) throws SQLException {
        this.checkIndex(colIndex);
        this.caseSensitive[colIndex - 1] = bool;
    }

    public void setCatalogName(int colIndex, String name) throws SQLException {
        this.checkIndex(colIndex);
        this.catalogName[colIndex - 1] = name;
    }

    public void setColumnCount(int columnCount) throws SQLException {
        this.columnCount = columnCount;
    }

    public void setColumnDisplaySize(int colIndex, int size) throws SQLException {
        this.checkIndex(colIndex);
        this.columnDIsplaySize[colIndex - 1] = size;
    }

    public void setColumnLabel(int colIndex, String label) throws SQLException {
        this.checkIndex(colIndex);
        this.columnLabel[colIndex - 1] = label;
    }

    public void setColumnName(int colIndex, String name) throws SQLException {
        this.checkIndex(colIndex);
        this.columnName[colIndex - 1] = name;
    }

    public void setColumnType(int colIndex, int type) throws SQLException {
        this.checkIndex(colIndex);
        this.columnType[colIndex - 1] = type;
    }

    public void setColumnTypeName(int colIndex, String name) throws SQLException {
        this.checkIndex(colIndex);
        this.columnTypeName[colIndex - 1] = name;
    }

    public void setCurrency(int colIndex, boolean bool) throws SQLException {
        this.checkIndex(colIndex);
        this.currency[colIndex - 1] = bool;
    }

    public void setNullable(int colIndex, int property) throws SQLException {
        this.checkIndex(colIndex);
        this.nullable[colIndex - 1] = property;
    }

    public void setPrecision(int colIndex, int precision) throws SQLException {
        this.checkIndex(colIndex);
        this.precision[colIndex - 1] = precision;
    }

    public void setScale(int colIndex, int scale) throws SQLException {
        this.checkIndex(colIndex);
        this.scale[colIndex - 1] = scale;
    }

    public void setSchemaName(int colIndex, String name) throws SQLException {
        this.checkIndex(colIndex);
        this.schemaName[colIndex - 1] = name;
    }

    public void setSearchable(int colIndex, boolean bool) throws SQLException {
        this.checkIndex(colIndex);
        this.searchable[colIndex - 1] = bool;
    }

    public void setSigned(int colIndex, boolean bool) throws SQLException {
        this.checkIndex(colIndex);
        this.signed[colIndex - 1] = bool;
    }

    public void setTableName(int colIndex, String name) throws SQLException {
        this.checkIndex(colIndex);
        this.tableName[colIndex - 1] = name;
    }

    public int getColumnCount() throws SQLException {
        return this.columnCount;
    }

    public boolean isAutoIncrement(int colIndex) throws SQLException {
        this.checkIndex(colIndex);
        return this.autoIncrement[colIndex - 1];
    }

    public boolean isCaseSensitive(int colIndex) throws SQLException {
        this.checkIndex(colIndex);
        return this.caseSensitive[colIndex - 1];
    }

    public boolean isSearchable(int colIndex) throws SQLException {
        this.checkIndex(colIndex);
        return this.searchable[colIndex - 1];
    }

    public boolean isCurrency(int colIndex) throws SQLException {
        this.checkIndex(colIndex);
        return this.currency[colIndex - 1];
    }

    public int isNullable(int colIndex) throws SQLException {
        this.checkIndex(colIndex);
        return this.nullable[colIndex - 1];
    }

    public boolean isSigned(int colIndex) throws SQLException {
        this.checkIndex(colIndex);
        return this.signed[colIndex - 1];
    }

    public int getColumnDisplaySize(int colIndex) throws SQLException {
        this.checkIndex(colIndex);
        return this.columnDIsplaySize[colIndex - 1];
    }

    public String getColumnLabel(int colIndex) throws SQLException {
        this.checkIndex(colIndex);
        return this.columnLabel[colIndex - 1];
    }

    public String getColumnName(int colIndex) throws SQLException {
        this.checkIndex(colIndex);
        return this.columnName[colIndex - 1];
    }

    public String getSchemaName(int colIndex) throws SQLException {
        this.checkIndex(colIndex);
        return this.schemaName[colIndex - 1];
    }

    public int getPrecision(int colIndex) throws SQLException {
        this.checkIndex(colIndex);
        return this.precision[colIndex - 1];
    }

    public int getScale(int colIndex) throws SQLException {
        this.checkIndex(colIndex);
        return this.scale[colIndex - 1];
    }

    public String getTableName(int colIndex) throws SQLException {
        this.checkIndex(colIndex);
        return this.tableName[colIndex - 1];
    }

    public String getCatalogName(int colIndex) throws SQLException {
        this.checkIndex(colIndex);
        return this.catalogName[colIndex - 1];
    }

    public int getColumnType(int colIndex) throws SQLException {
        this.checkIndex(colIndex);
        return this.columnType[colIndex - 1];
    }

    public String getColumnTypeName(int colIndex) throws SQLException {
        this.checkIndex(colIndex);
        return this.columnTypeName[colIndex - 1];
    }

    public boolean isReadOnly(int colIndex) throws SQLException {
        this.checkIndex(colIndex);
        return this.readOnly[colIndex - 1];
    }

    public boolean isWritable(int colIndex) throws SQLException {
        this.checkIndex(colIndex);
        return this.writable[colIndex - 1];
    }

    public boolean isDefinitelyWritable(int colIndex) throws SQLException {
        this.checkIndex(colIndex);
        return this.definatelyWritable[colIndex - 1];
    }

    public String getColumnClassName(int colIndex) throws SQLException {
        this.checkIndex(colIndex);
        return this.columnClassName[colIndex - 1];
    }
}

