/*
 * Decompiled with CFR 0.152.
 */
package org.apache.log4j.db;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Iterator;
import java.util.Set;
import org.apache.log4j.AppenderSkeleton;
import org.apache.log4j.db.ConnectionSource;
import org.apache.log4j.db.DBHelper;
import org.apache.log4j.db.dialect.SQLDialect;
import org.apache.log4j.db.dialect.Util;
import org.apache.log4j.spi.LocationInfo;
import org.apache.log4j.spi.LoggingEvent;

public class DBAppender
extends AppenderSkeleton {
    static final String insertPropertiesSQL = "INSERT INTO  logging_event_property (event_id, mapped_key, mapped_value) VALUES (?, ?, ?)";
    static final String insertExceptionSQL = "INSERT INTO  logging_event_exception (event_id, i, trace_line) VALUES (?, ?, ?)";
    static final String insertSQL;
    private static final Method GET_GENERATED_KEYS_METHOD;
    ConnectionSource connectionSource;
    boolean cnxSupportsGetGeneratedKeys = false;
    boolean cnxSupportsBatchUpdates = false;
    SQLDialect sqlDialect;
    boolean locationInfo = false;
    static /* synthetic */ Class class$java$sql$PreparedStatement;

    public DBAppender() {
        super(false);
    }

    public void activateOptions() {
        this.getLogger().debug("DBAppender.activateOptions called");
        if (this.connectionSource == null) {
            throw new IllegalStateException("DBAppender cannot function without a connection source");
        }
        this.sqlDialect = Util.getDialectFromCode(this.connectionSource.getSQLDialectCode());
        this.cnxSupportsGetGeneratedKeys = GET_GENERATED_KEYS_METHOD != null ? this.connectionSource.supportsGetGeneratedKeys() : false;
        this.cnxSupportsBatchUpdates = this.connectionSource.supportsBatchUpdates();
        if (!this.cnxSupportsGetGeneratedKeys && this.sqlDialect == null) {
            throw new IllegalStateException("DBAppender cannot function if the JDBC driver does not support getGeneratedKeys method *and* without a specific SQL dialect");
        }
        super.activateOptions();
    }

    public ConnectionSource getConnectionSource() {
        return this.connectionSource;
    }

    public void setConnectionSource(ConnectionSource connectionSource) {
        this.getLogger().debug("setConnectionSource called for DBAppender");
        this.connectionSource = connectionSource;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void append(LoggingEvent event) {
        Connection connection = null;
        try {
            try {
                String[] strRep;
                Set propertiesKeys;
                connection = this.connectionSource.getConnection();
                connection.setAutoCommit(false);
                PreparedStatement insertStatement = connection.prepareStatement(insertSQL);
                insertStatement.setLong(1, event.getSequenceNumber());
                insertStatement.setLong(2, event.getTimeStamp());
                insertStatement.setString(3, event.getRenderedMessage());
                insertStatement.setString(4, event.getLoggerName());
                insertStatement.setString(5, event.getLevel().toString());
                insertStatement.setString(6, event.getNDC());
                insertStatement.setString(7, event.getThreadName());
                insertStatement.setShort(8, DBHelper.computeReferenceMask(event));
                LocationInfo li = event.locationInformationExists() || this.locationInfo ? event.getLocationInformation() : LocationInfo.NA_LOCATION_INFO;
                insertStatement.setString(9, li.getFileName());
                insertStatement.setString(10, li.getClassName());
                insertStatement.setString(11, li.getMethodName());
                insertStatement.setString(12, li.getLineNumber());
                int updateCount = insertStatement.executeUpdate();
                if (updateCount != 1) {
                    this.getLogger().warn("Failed to insert loggingEvent");
                }
                ResultSet rs = null;
                Statement idStatement = null;
                boolean gotGeneratedKeys = false;
                if (this.cnxSupportsGetGeneratedKeys) {
                    try {
                        rs = (ResultSet)GET_GENERATED_KEYS_METHOD.invoke((Object)insertStatement, null);
                        gotGeneratedKeys = true;
                    }
                    catch (InvocationTargetException ex) {
                        Throwable target = ex.getTargetException();
                        if (!(target instanceof SQLException)) throw ex;
                        throw (SQLException)target;
                    }
                    catch (IllegalAccessException ex) {
                        this.getLogger().warn((Object)"IllegalAccessException invoking PreparedStatement.getGeneratedKeys", ex);
                    }
                }
                if (!gotGeneratedKeys) {
                    insertStatement.close();
                    insertStatement = null;
                    idStatement = connection.createStatement();
                    idStatement.setMaxRows(1);
                    rs = idStatement.executeQuery(this.sqlDialect.getSelectInsertId());
                }
                rs.next();
                int eventId = rs.getInt(1);
                rs.close();
                if (insertStatement != null) {
                    insertStatement.close();
                    insertStatement = null;
                }
                if (idStatement != null) {
                    idStatement.close();
                    idStatement = null;
                }
                if ((propertiesKeys = event.getPropertyKeySet()).size() > 0) {
                    PreparedStatement insertPropertiesStatement = connection.prepareStatement(insertPropertiesSQL);
                    Iterator i = propertiesKeys.iterator();
                    while (true) {
                        if (!i.hasNext()) {
                            if (this.cnxSupportsBatchUpdates) {
                                insertPropertiesStatement.executeBatch();
                            }
                            insertPropertiesStatement.close();
                            insertPropertiesStatement = null;
                            break;
                        }
                        String key = (String)i.next();
                        String value = event.getProperty(key);
                        insertPropertiesStatement.setInt(1, eventId);
                        insertPropertiesStatement.setString(2, key);
                        insertPropertiesStatement.setString(3, value);
                        if (this.cnxSupportsBatchUpdates) {
                            insertPropertiesStatement.addBatch();
                            continue;
                        }
                        insertPropertiesStatement.execute();
                    }
                }
                if ((strRep = event.getThrowableStrRep()) != null) {
                    this.getLogger().debug("Logging an exception");
                    PreparedStatement insertExceptionStatement = connection.prepareStatement(insertExceptionSQL);
                    short i = 0;
                    while (true) {
                        if (i >= strRep.length) {
                            if (this.cnxSupportsBatchUpdates) {
                                insertExceptionStatement.executeBatch();
                            }
                            insertExceptionStatement.close();
                            insertExceptionStatement = null;
                            break;
                        }
                        insertExceptionStatement.setInt(1, eventId);
                        insertExceptionStatement.setShort(2, i);
                        insertExceptionStatement.setString(3, strRep[i]);
                        if (this.cnxSupportsBatchUpdates) {
                            insertExceptionStatement.addBatch();
                        } else {
                            insertExceptionStatement.execute();
                        }
                        i = (short)(i + 1);
                    }
                }
                connection.commit();
            }
            catch (Throwable sqle) {
                this.getLogger().error((Object)"problem appending event", sqle);
                Object var16_21 = null;
                DBHelper.closeConnection(connection);
                return;
            }
            Object var16_20 = null;
        }
        catch (Throwable throwable) {
            Object var16_22 = null;
            DBHelper.closeConnection(connection);
            throw throwable;
        }
        DBHelper.closeConnection(connection);
    }

    public void close() {
        this.closed = true;
    }

    public boolean getLocationInfo() {
        return this.locationInfo;
    }

    public void setLocationInfo(boolean locationInfo) {
        this.locationInfo = locationInfo;
    }

    public boolean requiresLayout() {
        return false;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        Method getGeneratedKeysMethod;
        StringBuffer sql = new StringBuffer();
        sql.append("INSERT INTO logging_event (");
        sql.append("sequence_number, ");
        sql.append("timestamp, ");
        sql.append("rendered_message, ");
        sql.append("logger_name, ");
        sql.append("level_string, ");
        sql.append("ndc, ");
        sql.append("thread_name, ");
        sql.append("reference_flag, ");
        sql.append("caller_filename, ");
        sql.append("caller_class, ");
        sql.append("caller_method, ");
        sql.append("caller_line) ");
        sql.append(" VALUES (?, ?, ? ,?, ?, ?, ?, ?, ?, ?, ?, ?)");
        insertSQL = sql.toString();
        try {
            getGeneratedKeysMethod = (class$java$sql$PreparedStatement == null ? (class$java$sql$PreparedStatement = DBAppender.class$("java.sql.PreparedStatement")) : class$java$sql$PreparedStatement).getMethod("getGeneratedKeys", null);
        }
        catch (Exception ex) {
            getGeneratedKeysMethod = null;
        }
        GET_GENERATED_KEYS_METHOD = getGeneratedKeysMethod;
    }
}

