/*
 * Decompiled with CFR 0.152.
 */
package org.apache.log4j.lbel.comparator;

import org.apache.log4j.lbel.Operator;
import org.apache.log4j.lbel.ScanError;
import org.apache.log4j.lbel.comparator.Comparator;
import org.apache.log4j.spi.LoggingEvent;
import org.apache.oro.text.regex.MalformedPatternException;
import org.apache.oro.text.regex.Pattern;
import org.apache.oro.text.regex.Perl5Compiler;
import org.apache.oro.text.regex.Perl5Matcher;

public abstract class StringComparator
implements Comparator {
    Operator operator;
    String rightSide;
    String rightSideWithDotSuffix;
    Pattern rightSidePattern;
    Perl5Matcher matcher;

    public StringComparator(Operator operator, String rightSide) throws ScanError {
        this.operator = operator;
        this.rightSide = rightSide;
        if (operator.isRegex()) {
            Perl5Compiler compiler = new Perl5Compiler();
            this.matcher = new Perl5Matcher();
            try {
                this.rightSidePattern = compiler.compile(rightSide);
            }
            catch (MalformedPatternException mfpe) {
                throw new ScanError("Malformed pattern [" + rightSide + "]", mfpe);
            }
        }
        if (operator.getCode() == 40 && !rightSide.endsWith(".")) {
            this.rightSideWithDotSuffix = rightSide + ".";
        }
    }

    protected abstract String getLeftSide(LoggingEvent var1);

    public boolean compare(LoggingEvent event) throws NullPointerException {
        String leftSide = this.getLeftSide(event);
        if (leftSide == null) {
            switch (this.operator.getCode()) {
                case 1: {
                    return leftSide == this.rightSide;
                }
                case 2: {
                    return leftSide != this.rightSide;
                }
            }
            throw new NullPointerException("null leftside can only be used with == or != operators");
        }
        if (this.operator.isRegex()) {
            boolean match = this.matcher.contains(leftSide, this.rightSidePattern);
            if (this.operator.getCode() == 30) {
                return match;
            }
            return !match;
        }
        if (this.operator.getCode() == 40) {
            if (leftSide.equals(this.rightSide)) {
                return true;
            }
            return leftSide.startsWith(this.rightSideWithDotSuffix);
        }
        if (this.rightSide == null) {
            switch (this.operator.getCode()) {
                case 1: {
                    return leftSide == this.rightSide;
                }
                case 2: {
                    return leftSide != this.rightSide;
                }
            }
            throw new NullPointerException("null rightside can only be used with == or != operators");
        }
        int compResult = leftSide.compareTo(this.rightSide);
        switch (this.operator.getCode()) {
            case 1: {
                return compResult == 0;
            }
            case 2: {
                return compResult != 0;
            }
            case 10: {
                return compResult > 0;
            }
            case 11: {
                return compResult >= 0;
            }
            case 20: {
                return compResult < 0;
            }
            case 21: {
                return compResult <= 0;
            }
        }
        throw new IllegalStateException("Unreachable state reached, operator " + this.operator);
    }

    public String toString() {
        String full = this.getClass().getName();
        int i = full.lastIndexOf(".");
        return full.substring(i) + "(" + this.operator + ", " + this.rightSide + ")";
    }
}

