/*
 * Decompiled with CFR 0.152.
 */
package org.apache.log4j.spi.location;

import java.io.PrintWriter;
import java.io.StringWriter;
import org.apache.log4j.Layout;
import org.apache.log4j.helpers.PlatformInfo;
import org.apache.log4j.spi.LocationInfo;

public class LegacyExtractor {
    private static StringWriter sw = new StringWriter();
    private static PrintWriter pw = new PrintWriter(sw);

    private LegacyExtractor() {
    }

    public static void extract(LocationInfo li, Throwable t, String fqnOfInvokingClass) {
        String s;
        if (PlatformInfo.isOnAS400()) {
            fqnOfInvokingClass = fqnOfInvokingClass.replace('.', '/');
        }
        StringWriter stringWriter = sw;
        synchronized (stringWriter) {
            t.printStackTrace(pw);
            s = sw.toString();
            sw.getBuffer().setLength(0);
        }
        int ibegin = s.lastIndexOf(fqnOfInvokingClass);
        if (ibegin == -1) {
            return;
        }
        if ((ibegin = s.indexOf(Layout.LINE_SEP, ibegin)) == -1) {
            return;
        }
        int iend = s.indexOf(Layout.LINE_SEP, ibegin += Layout.LINE_SEP_LEN);
        if (iend == -1) {
            return;
        }
        if (!PlatformInfo.isInVisualAge() && !PlatformInfo.isOnAS400()) {
            ibegin = s.lastIndexOf("at ", iend);
            if (ibegin == -1) {
                return;
            }
            ibegin += 3;
        }
        li.fullInfo = s.substring(ibegin, iend);
        LegacyExtractor.setFileName(li, li.fullInfo);
        LegacyExtractor.setClassName(li, li.fullInfo);
        LegacyExtractor.setMethodName(li, li.fullInfo);
        LegacyExtractor.setLineNumber(li, li.fullInfo);
    }

    static void setFileName(LocationInfo li, String fullInfo) {
        if (fullInfo == null) {
            li.fileName = "?";
        } else {
            int iend = fullInfo.lastIndexOf(58);
            if (iend == -1) {
                li.fileName = "?";
            } else {
                int ibegin = fullInfo.lastIndexOf(40, iend - 1);
                li.fileName = fullInfo.substring(ibegin + 1, iend);
            }
        }
    }

    static void setClassName(LocationInfo li, String fullInfo) {
        if (fullInfo == null) {
            li.className = "?";
            return;
        }
        int iend = fullInfo.lastIndexOf(40);
        if (iend == -1) {
            li.className = "?";
        } else {
            iend = fullInfo.lastIndexOf(46, iend);
            int ibegin = 0;
            if (PlatformInfo.isInVisualAge()) {
                ibegin = fullInfo.lastIndexOf(32, iend) + 1;
            }
            li.className = iend == -1 ? "?" : fullInfo.substring(ibegin, iend);
        }
    }

    static void setLineNumber(LocationInfo li, String fullInfo) {
        int iend;
        int ibegin;
        li.lineNumber = fullInfo == null ? "?" : ((ibegin = fullInfo.lastIndexOf(58, (iend = fullInfo.lastIndexOf(41)) - 1)) == -1 ? "?" : fullInfo.substring(ibegin + 1, iend));
    }

    static void setMethodName(LocationInfo li, String fullInfo) {
        int iend;
        int ibegin;
        li.methodName = fullInfo == null ? "?" : ((ibegin = fullInfo.lastIndexOf(46, iend = fullInfo.lastIndexOf(40))) == -1 ? "?" : fullInfo.substring(ibegin + 1, iend));
    }
}

