/*
 * Decompiled with CFR 0.152.
 */
package Altibase.jdbc.driver;

import Altibase.jdbc.driver.ABConnection;
import Altibase.jdbc.driver.ABRConnection;
import Altibase.jdbc.driver.DriverPropertyInfo;
import Altibase.jdbc.driver.SQLStates;
import Altibase.jdbc.driver.aTokenizer;
import java.io.PrintWriter;
import java.sql.Connection;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.Enumeration;
import java.util.Properties;

public class AltibaseDriver
implements Driver {
    static PrintWriter logger;

    public boolean acceptsURL(String url) throws SQLException {
        if (url.length() < 10) {
            return false;
        }
        return url.substring(5, 13).equals("Altibase");
    }

    public synchronized Connection connect(String url, Properties p) throws SQLException {
        String orig = url;
        if (p == null) {
            p = new Properties();
        }
        if (url.startsWith("jdbc:")) {
            if (url.length() < 6) {
                return null;
            }
            url = url.substring(5);
        }
        if (!url.startsWith("Altibase://")) {
            return null;
        }
        if (url.length() < 12) {
            return null;
        }
        int i = (url = url.substring(11)).indexOf(58);
        if (i == -1) {
            p.put("portNumber", "20300");
            i = url.indexOf(47);
            if (i == -1) {
                throw new SQLException(SQLStates.mFixmsg[29] + orig, "01S00");
            }
            if (url.length() < i + 1) {
                throw new SQLException(SQLStates.mFixmsg[29] + orig, "01S00");
            }
            p.put("serverName", url.substring(0, i));
        } else {
            p.put("serverName", url.substring(0, i));
            if (url.length() < ++i) {
                throw new SQLException(SQLStates.mFixmsg[29] + orig, "01S00");
            }
            if ((i = (url = url.substring(i)).indexOf(47)) == -1 || url.length() < i + 1) {
                throw new SQLException(SQLStates.mFixmsg[29] + orig, "01S00");
            }
            p.put("portNumber", url.substring(0, i));
        }
        url = url.substring(++i);
        i = url.indexOf(63);
        if (i == -1) {
            p.put("databaseName", url.substring(0));
        } else {
            p.put("databaseName", url.substring(0, i++));
            url = url.substring(i);
            aTokenizer.setProperties(url, p);
        }
        if (p.getProperty("SLAVE_URL") == null) {
            return new ABConnection(p);
        }
        return new ABRConnection(p);
    }

    public int getMajorVersion() {
        return 5;
    }

    public int getMinorVersion() {
        return 4;
    }

    public java.sql.DriverPropertyInfo[] getPropertyInfo(String url, Properties info) throws SQLException {
        info.setProperty("user", info.getProperty("user", "SYS    "));
        info.setProperty("password", info.getProperty("password", "MANAGER"));
        if (info.containsKey("encoding")) {
            info.setProperty("encoding", info.getProperty("encoding"));
        } else {
            String[] encoding = new String[]{"KSC5601", "US7ASCII", "KOI8-R", "CP1251", "GB2312", "BIG5", "UTF-8"};
            info.put("encoding", encoding);
        }
        info.setProperty("AUTO_COMMIT", info.getProperty("AUTO_COMMIT", "1"));
        info.setProperty("CONNTYPE", info.getProperty("CONNTYPE", "1"));
        info.setProperty("FETCH_ENOUGH", info.getProperty("FETCH_ENOUGH", "1024"));
        DriverPropertyInfo[] ret = new DriverPropertyInfo[info.size()];
        int i = 0;
        Enumeration<?> e = info.propertyNames();
        while (e.hasMoreElements()) {
            String key = (String)e.nextElement();
            Object val = info.get(key);
            ret[i] = val instanceof String ? new DriverPropertyInfo(key, (String)val) : new DriverPropertyInfo(key, (String[])val);
            ++i;
        }
        return ret;
    }

    public boolean jdbcCompliant() {
        return false;
    }

    static {
        try {
            DriverManager.registerDriver(new AltibaseDriver());
            logger = DriverManager.getLogWriter();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }
}

