/*
 * Decompiled with CFR 0.152.
 */
package Altibase.jdbc.driver;

import Altibase.jdbc.driver.ABEncoder;
import Altibase.jdbc.driver.LobUpdater;
import Altibase.jdbc.driver.cmp;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.sql.SQLException;

class Clob
implements java.sql.Clob,
LobUpdater {
    private long mLobLocator = 0L;
    private cmp mChannel;
    private Reader mInputSource;
    private int mInputLength;

    Clob(long aLobLocator, cmp aChannel) {
        this.setLocator(aLobLocator, aChannel);
    }

    Clob(Reader aIn, int aLen) {
        this.mInputSource = aIn;
        this.mInputLength = aLen;
    }

    Clob() {
        this.setLocator(0L, null);
        this.mInputSource = null;
        this.mInputLength = -1;
    }

    public void doExecute() throws SQLException {
        if (this.mInputSource != null) {
            Writer sWriter = this.setCharacterStream(1L);
            char[] sBuf = new char[16000];
            int sRemainLen = this.mInputLength;
            try {
                int sLenToRead;
                int sReadLen;
                while ((sReadLen = this.mInputSource.read(sBuf, 0, sLenToRead = Math.min(sRemainLen, 16000))) > 0) {
                    sWriter.write(sBuf, 0, sReadLen);
                    sRemainLen -= sReadLen;
                }
                sWriter.flush();
            }
            catch (IOException e) {
                throw new SQLException(e.getMessage());
            }
        }
    }

    void setLocator(long aLobLocator, cmp aChannel) {
        this.mLobLocator = aLobLocator;
        this.mChannel = aChannel;
    }

    void setAsciiStream(InputStream aIn, int aLen) {
    }

    void setCharacterStream(Reader aReader, int aLen) {
        this.mInputSource = aReader;
        this.mInputLength = aLen;
    }

    public InputStream getAsciiStream() throws SQLException {
        return null;
    }

    public Reader getCharacterStream() throws SQLException {
        return new ClobReader(this.mLobLocator, this.mChannel);
    }

    public String getSubString(long aPos, int aLength) throws SQLException {
        int sReadBytes;
        if (aPos == 0L) {
            throw new SQLException("invalid position");
        }
        ABEncoder sEncoder = this.mChannel.getEncoder();
        byte[] sByteArr = new byte[aLength * sEncoder.maxBytesPerChar()];
        char[] sCharArr = new char[aLength];
        int[] sReadCharLength = new int[1];
        try {
            sReadBytes = this.mChannel.lobGet3(this.mLobLocator, aPos - 1L, sByteArr, 0, aLength, sReadCharLength);
        }
        catch (SQLException e) {
            return null;
        }
        ByteBuffer sByteBuf = ByteBuffer.wrap(sByteArr, 0, sReadBytes);
        CharBuffer sCharBuf = CharBuffer.wrap(sCharArr, 0, sReadCharLength[0]);
        sEncoder.decode(sByteBuf, sCharBuf);
        return new String(sCharArr, 0, sReadCharLength[0]);
    }

    public long position(java.sql.Clob aSearchstr, long aStart) throws SQLException {
        throw new SQLException("position() not supported");
    }

    public long position(String aSearchstr, long aStart) throws SQLException {
        throw new SQLException("position() not supported");
    }

    public OutputStream setAsciiStream(long aPos) throws SQLException {
        return null;
    }

    public Writer setCharacterStream(long aPos) throws SQLException {
        long sBytePos = this.mChannel.lobBytePos(this.mLobLocator, aPos - 1L);
        return new ClobWriter(this.mLobLocator, sBytePos, this.mChannel);
    }

    public int setString(long aPos, String aStr) throws SQLException {
        if (aStr == null) {
            throw new SQLException("String is null");
        }
        return this.setString(aPos, aStr, 0, aStr.length());
    }

    public int setString(long aPos, String aStr, int aOffset, int aLen) throws SQLException {
        if (aStr == null) {
            throw new SQLException("String is null");
        }
        long sBytePos = this.mChannel.lobBytePos(this.mLobLocator, aPos - 1L);
        long sLobSize = this.mChannel.lobSize(this.mLobLocator);
        ABEncoder sEncoder = this.mChannel.getEncoder();
        ByteBuffer sByteBuf = ByteBuffer.allocate(aLen * sEncoder.maxBytesPerChar());
        char[] sCharArr = aStr.toCharArray();
        CharBuffer sCharBuf = CharBuffer.wrap(sCharArr, aOffset, aLen);
        sEncoder.encode(sCharBuf, sByteBuf);
        sByteBuf.flip();
        this.mChannel.lobPut(this.mLobLocator, sBytePos, sLobSize, sByteBuf);
        return aLen;
    }

    public void truncate(long aLen) throws SQLException {
        long sLobSize = this.mChannel.lobSize(this.mLobLocator);
        this.mChannel.lobTruncate(this.mLobLocator, sLobSize, aLen);
    }

    final boolean isNull() {
        boolean sLobSize = false;
        try {
            this.mChannel.lobSize(this.mLobLocator);
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        return !sLobSize;
    }

    void setNull() throws SQLException {
        if (this.mLobLocator != 0L) {
            this.mChannel.lobFree(this.mLobLocator);
            this.mLobLocator = 0L;
        }
    }

    long locator() {
        return this.mLobLocator;
    }

    public long length() throws SQLException {
        return this.mChannel.lobCharLength(this.mLobLocator);
    }

    public String toString() {
        try {
            return this.getSubString(1L, (int)this.length());
        }
        catch (SQLException e) {
            return super.toString();
        }
    }

    class ClobWriter
    extends Writer {
        private long mLocator;
        private cmp mChannel;
        private long mPosition;
        private boolean mClosed;
        private ABEncoder mEncoder;
        private CharBuffer mCharBuf;
        private ByteBuffer mByteBuf;

        ClobWriter(long aLobLocator, long aPosition, cmp aChannel) throws SQLException {
            this.mLocator = aLobLocator;
            this.mChannel = aChannel;
            this.mPosition = aPosition;
            this.mClosed = false;
            this.mEncoder = aChannel.getEncoder();
            this.mByteBuf = ByteBuffer.allocate(32000);
            this.mCharBuf = CharBuffer.allocate(32000 / this.mEncoder.maxBytesPerChar());
        }

        public void close() throws IOException {
            this.mClosed = true;
        }

        public void flush() throws IOException {
            if (this.mClosed) {
                throw new IOException("Stream closed");
            }
            if (this.mCharBuf.position() > 0) {
                this.mCharBuf.flip();
                this.mByteBuf.clear();
                try {
                    this.mEncoder.encode(this.mCharBuf, this.mByteBuf);
                    this.mByteBuf.flip();
                    long sLobSize = this.mChannel.lobSize(this.mLocator);
                    this.mPosition += this.mChannel.lobPut(this.mLocator, this.mPosition, sLobSize, this.mByteBuf);
                }
                catch (SQLException e) {
                    throw new IOException(e.getMessage());
                }
                this.mCharBuf.clear();
            }
        }

        public void write(char[] aCbuf) throws IOException {
            if (this.mClosed) {
                throw new IOException("Stream closed");
            }
            this.write(aCbuf, 0, aCbuf.length);
        }

        public void write(char[] aCbuf, int aOff, int aLen) throws IOException {
            if (this.mClosed) {
                throw new IOException("Stream closed");
            }
            while (aLen > 0) {
                int sRemaining = this.mCharBuf.remaining();
                if (sRemaining < aLen) {
                    this.mCharBuf.put(aCbuf, aOff, sRemaining);
                    aOff += sRemaining;
                    aLen -= sRemaining;
                    this.flush();
                    continue;
                }
                this.mCharBuf.put(aCbuf, aOff, aLen);
                break;
            }
        }

        public void write(int aC) throws IOException {
            if (this.mClosed) {
                throw new IOException("Stream closed");
            }
            char[] sOneChar = new char[]{(char)aC};
            this.write(sOneChar, 0, 1);
        }

        public void write(String aStr) throws IOException {
            if (this.mClosed) {
                throw new IOException("Stream closed");
            }
            if (aStr == null) {
                throw new IOException("String is null");
            }
            this.write(aStr, 0, aStr.length());
        }

        public void write(String aStr, int aOff, int aLen) throws IOException {
            if (this.mClosed) {
                throw new IOException("Stream closed");
            }
            if (aStr == null) {
                throw new IOException("String is null");
            }
            char[] sCharArr = aStr.toCharArray();
            this.write(sCharArr, aOff, aLen);
        }
    }

    class ClobReader
    extends Reader {
        private long mLocator;
        private long mPosition;
        private cmp mChannel;
        private boolean mClosed;
        private ABEncoder mEncoder;
        private byte[] mByteArrForOneChar;
        private CharBuffer mCharBufForOneChar;

        ClobReader(long aLobLocator, cmp aChannel) throws SQLException {
            this.mLocator = aLobLocator;
            this.mChannel = aChannel;
            this.mPosition = 0L;
            this.mClosed = false;
            this.mEncoder = aChannel.getEncoder();
            this.mByteArrForOneChar = new byte[this.mEncoder.maxBytesPerChar()];
            this.mCharBufForOneChar = CharBuffer.allocate(1);
        }

        public void close() throws IOException {
            this.mClosed = true;
        }

        public void mark(int aReadAheadLimit) throws IOException {
            throw new IOException("mark() not supported");
        }

        public boolean markSupported() {
            return false;
        }

        private int read(byte[] aByteArr, char[] aCharArr, int aOff, int aCharLen) throws IOException {
            int sReadBytes;
            int[] sReadCharLength = new int[1];
            try {
                sReadBytes = this.mChannel.lobGet2(this.mLocator, this.mPosition, aByteArr, 0, aCharLen, sReadCharLength);
            }
            catch (SQLException e) {
                return -1;
            }
            this.mPosition += (long)sReadBytes;
            ByteBuffer sByteBuf = ByteBuffer.wrap(aByteArr, 0, sReadBytes);
            CharBuffer sCharBuf = CharBuffer.wrap(aCharArr, aOff, aCharLen);
            try {
                this.mEncoder.decode(sByteBuf, sCharBuf);
            }
            catch (SQLException e) {
                throw new IOException(e.getMessage());
            }
            return sReadCharLength[0];
        }

        public int read() throws IOException {
            if (this.mClosed) {
                throw new IOException("Stream closed");
            }
            this.mCharBufForOneChar.clear();
            int rc = this.read(this.mByteArrForOneChar, this.mCharBufForOneChar.array(), 0, 1);
            if (rc == -1) {
                return -1;
            }
            return this.mCharBufForOneChar.array()[0];
        }

        public int read(char[] aCbuf) throws IOException {
            if (this.mClosed) {
                throw new IOException("Stream closed");
            }
            return this.read(aCbuf, 0, aCbuf.length);
        }

        public int read(char[] aCbuf, int aOff, int aLen) throws IOException {
            if (this.mClosed) {
                throw new IOException("Stream closed");
            }
            byte[] sByteArr = new byte[aLen * this.mEncoder.maxBytesPerChar()];
            return this.read(sByteArr, aCbuf, aOff, aLen);
        }

        public boolean ready() throws IOException {
            return !this.mClosed;
        }

        public void reset() throws IOException {
            throw new IOException("reset() not supported");
        }

        public long skip(long aN) throws IOException {
            throw new IOException("skip() not supported");
        }
    }
}

