/*
 * Decompiled with CFR 0.152.
 */
package Altibase.jdbc.driver;

import Altibase.jdbc.driver.ABSerialize;
import Altibase.jdbc.driver.cmb;
import Altibase.jdbc.driver.cmp;
import java.io.Serializable;
import java.sql.SQLException;

public class mtdInterval
implements ABSerialize,
Serializable {
    static final long serialVersionUID = 111111112L;
    static final double SECOND_OF_DAY = 86400.0;
    long mSeconds;
    long mMicroSeconds;

    mtdInterval() {
        this.setNull();
    }

    public mtdInterval(long aInterval) {
        this.mSeconds = aInterval / 1000L;
        this.mMicroSeconds = aInterval % 1000L * 1000L;
    }

    public long addTimestamp(long aMiliSeconds) {
        return this.getMilliseconds() + aMiliSeconds;
    }

    public double getDays() {
        double val = 0.0;
        if (!this.isNull()) {
            val = (double)this.mSeconds / 86400.0;
            val += (double)this.mMicroSeconds * 1.0E-5 / 86400.0;
        }
        return val;
    }

    public long getMicroseconds() {
        return this.mMicroSeconds;
    }

    public long getMilliseconds() {
        long val = 0L;
        if (!this.isNull()) {
            val = this.mSeconds * 1000L + this.mMicroSeconds / 1000L;
        }
        return val;
    }

    public long getSeconds() {
        return this.mSeconds;
    }

    final boolean isNull() {
        return this.mSeconds == Long.MIN_VALUE && this.mMicroSeconds == Long.MIN_VALUE;
    }

    public void read(cmp chn) throws SQLException {
        cmb cbr = chn.remain();
        this.mSeconds = cbr.longValue();
        cbr = chn.remain();
        this.mMicroSeconds = cbr.longValue();
    }

    public void setMicroseconds(long aMicroSeconds) {
        if (this.isNull()) {
            this.mSeconds = 0L;
        }
        this.mMicroSeconds = aMicroSeconds;
    }

    final void setNull() {
        this.mSeconds = Long.MIN_VALUE;
        this.mMicroSeconds = Long.MIN_VALUE;
    }

    public void setSeconds(long sec) {
        if (this.isNull()) {
            this.mMicroSeconds = 0L;
        }
        this.mSeconds = sec;
    }

    public void write(cmp chn) throws SQLException {
        cmb cbw = chn.next();
        if (this.isNull()) {
            cbw.putByte((byte)1);
        } else {
            cbw.putByte((byte)12);
            cbw.putLong(this.mSeconds);
            cbw.putLong(this.mMicroSeconds);
        }
    }

    public String toString() {
        String val = null;
        if (!this.isNull()) {
            val = this.mSeconds + ":" + this.mMicroSeconds;
        }
        return val;
    }

    public boolean equals(Object obj) {
        return obj instanceof mtdInterval && ((mtdInterval)obj).getSeconds() == this.getSeconds() && ((mtdInterval)obj).getMicroseconds() == this.getMicroseconds();
    }

    public int hashCode() {
        long ht = this.getMilliseconds();
        return (int)ht ^ (int)(ht >> 32);
    }
}

