/*
 * Decompiled with CFR 0.152.
 */
package Altibase.jdbc.driver;

import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Properties;

public class aTokenizer
extends ArrayList {
    static final long serialVersionUID = 1L;

    public static String getUrl(Properties prop) {
        StringBuffer buf = new StringBuffer("jdbc:Altibase://");
        buf.append(prop.getProperty("serverName", "localhost"));
        buf.append(':');
        buf.append(prop.getProperty("portNumber", "20300"));
        buf.append('/');
        buf.append('?');
        Enumeration<?> e = prop.propertyNames();
        String key = (String)e.nextElement();
        while (e.hasMoreElements()) {
            String value = (String)prop.get(key);
            buf.append(key);
            buf.append('=');
            buf.append(value);
            key = (String)e.nextElement();
            if (!e.hasMoreElements()) continue;
            buf.append('&');
        }
        return buf.toString();
    }

    public static String remove(String s, String l, String t) {
        if (s.startsWith(l)) {
            s = s.substring(l.length());
        }
        if (s.endsWith(t)) {
            s = s.substring(0, s.length() - t.length());
        }
        return s;
    }

    public static String removeAngle(String s) {
        return aTokenizer.remove(s, "<", ">");
    }

    public static String removeBox(String s) {
        return aTokenizer.remove(s, "[", "]");
    }

    public static String removePara(String s) {
        return aTokenizer.remove(s, "(", ")");
    }

    public static void setProperties(String url, Properties p) {
        int i;
        do {
            String key;
            String val;
            if ((i = url.indexOf(38)) < 0) {
                val = url.substring(0);
            } else {
                val = url.substring(0, i);
                url = url.substring(i + 1);
            }
            int idel = val.indexOf(61);
            if (idel == -1) {
                key = val.trim();
                val = "";
            } else {
                key = val.substring(0, idel).trim();
                val = val.substring(1 + idel).trim();
            }
            p.setProperty(key, val);
        } while (i > 0);
    }

    public aTokenizer(String string, char delim) {
        this.tokenize(string, delim);
    }

    public String getToken(int n) {
        return (String)super.get(n);
    }

    public void remove(String l, String t) {
        for (int i = 0; i < super.size(); ++i) {
            super.set(i, aTokenizer.remove((String)super.get(i), l, t));
        }
    }

    public void removeAngle() {
        this.remove("<", ">");
    }

    public void removeBox() {
        this.remove("[", "]");
    }

    public void removePara() {
        this.remove("(", ")");
    }

    public int tokenize(String str, char delim) {
        int len = str.length();
        int nest = 0;
        int s = 0;
        block4: for (int p = 0; p < len; ++p) {
            char c = str.charAt(p);
            switch (c) {
                case '(': 
                case '<': 
                case '[': {
                    ++nest;
                    continue block4;
                }
                case ')': 
                case '>': 
                case ']': {
                    --nest;
                    continue block4;
                }
                default: {
                    if (nest != 0 || c != delim) continue block4;
                    super.add(str.substring(s, p));
                    s = p + 1;
                }
            }
        }
        if (s < len) {
            super.add(str.substring(s));
        }
        return this.size();
    }

    public aTokenizer tokenizeToken(int n, char delim) {
        return new aTokenizer((String)super.get(n), delim);
    }
}

