/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.wagon.providers.ssh.knownhost;

import com.jcraft.jsch.HostKey;
import com.jcraft.jsch.HostKeyRepository;
import com.jcraft.jsch.JSch;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import org.apache.maven.wagon.providers.ssh.knownhost.StreamKnownHostsProvider;
import org.codehaus.plexus.util.IOUtil;

public class FileKnownHostsProvider
extends StreamKnownHostsProvider {
    private final File file;

    public FileKnownHostsProvider(File file) throws IOException {
        super(file.exists() ? new FileInputStream(file) : new ByteArrayInputStream("".getBytes()));
        this.file = file;
    }

    public FileKnownHostsProvider() throws IOException {
        this(new File(System.getProperty("user.home"), ".ssh/known_hosts"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public void storeKnownHosts(JSch sch) {
        PrintWriter w = null;
        try {
            w = new PrintWriter(new FileWriter(this.file));
            HostKeyRepository hkr = sch.getHostKeyRepository();
            HostKey[] keys = hkr.getHostKey();
            for (int i = 0; i < keys.length; ++i) {
                HostKey key = keys[i];
                w.println(key.getHost() + " " + key.getType() + " " + key.getKey());
            }
        }
        catch (IOException iOException) {
            IOUtil.close(w);
            catch (Throwable throwable) {
                IOUtil.close(w);
                throw throwable;
            }
        }
        IOUtil.close((Writer)w);
        super.storeKnownHosts(sch);
    }

    public File getFile() {
        return this.file;
    }
}

