/*
 * Decompiled with CFR 0.152.
 */
package com.tmax.tibero.jdbc;

import com.tmax.tibero.jdbc.TbCallableStatement;
import com.tmax.tibero.jdbc.TbDatabaseMetaData;
import com.tmax.tibero.jdbc.TbPreparedStatement;
import com.tmax.tibero.jdbc.TbResultSet;
import com.tmax.tibero.jdbc.TbSQLException;
import com.tmax.tibero.jdbc.TbSQLInfo;
import com.tmax.tibero.jdbc.TbSavepoint;
import com.tmax.tibero.jdbc.TbStatement;
import com.tmax.tibero.jdbc.TbTimeout;
import com.tmax.tibero.jdbc.comm.TbBlobAccessor;
import com.tmax.tibero.jdbc.comm.TbClobAccessor;
import com.tmax.tibero.jdbc.comm.TbComm;
import com.tmax.tibero.jdbc.comm.TbCommType2;
import com.tmax.tibero.jdbc.comm.TbCommType4;
import com.tmax.tibero.jdbc.comm.TbXAComm;
import com.tmax.tibero.jdbc.comm.TbXACommType2;
import com.tmax.tibero.jdbc.comm.TbXACommType4;
import com.tmax.tibero.jdbc.data.ConnectionInfo;
import com.tmax.tibero.jdbc.data.DataTypeConverter;
import com.tmax.tibero.jdbc.data.ServerInfo;
import com.tmax.tibero.jdbc.dpl.TbDirPathMetaData;
import com.tmax.tibero.jdbc.dpl.TbDirPathStream;
import com.tmax.tibero.jdbc.ext.TbStatementCache;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Savepoint;
import java.sql.Statement;
import java.util.HashMap;
import java.util.Map;

public class TbConnection
implements Connection {
    public static final int NO_TXN = 0;
    public static final int LOCAL_TXN = 1;
    public static final int GLOBAL_TXN = 2;
    private TbComm dbComm;
    public ConnectionInfo info;
    protected boolean isPooledConnection;
    public ServerInfo serverInfo;
    protected DataTypeConverter typeConverter;
    protected SQLWarning warnings;
    protected boolean autoCommit;
    protected boolean connClosed;
    protected boolean sessionClosed;
    protected TbDatabaseMetaData dbMetaData = null;
    protected Map typeMap;
    private String nlsDate = null;
    private String nlsTimestamp = null;
    private int sessionId;
    private int serialNo;
    private int mthrPid;
    private int txnMode;
    protected int isolationLevel = 2;
    private TbTimeout timeout;
    private boolean isStmtCacheEnabled = false;
    private TbStatementCache stmtCache = null;
    private static final int MAX_CACHE_SIZE = 5;
    private int preFetchSize = 50;

    public String ToString() {
        StringBuffer buf = new StringBuffer(64);
        buf.append("==== TbConnection[").append(super.toString());
        buf.append("] ====");
        buf.append(" connInfo[").append(this.info).append("]");
        buf.append(" serverInfo[").append(this.serverInfo).append("]");
        buf.append(" autoCommit[").append(this.autoCommit).append("]");
        buf.append(" closed[").append(this.connClosed).append("]");
        buf.append(" typeMap[").append(this.typeMap).append("]");
        buf.append(" isolation[").append(this.isolationLevel).append("]");
        buf.append(" typeConverterverter[").append(this.typeConverter).append("]");
        buf.append(" sessionId[").append(this.sessionId).append("]");
        return buf.toString();
    }

    public void reset() {
        this.info = null;
        this.serverInfo = null;
        this.warnings = null;
        this.dbMetaData = null;
        this.typeMap = null;
        this.autoCommit = true;
        this.sessionClosed = true;
        this.txnMode = 0;
        this.preFetchSize = 50;
        if (this.typeConverter != null) {
            this.typeConverter.reset();
            this.typeConverter = null;
        }
        if (this.stmtCache != null) {
            this.stmtCache.clear();
            this.stmtCache = null;
        }
    }

    public void reuse() {
        this.warnings = null;
        this.isolationLevel = 2;
        this.autoCommit = true;
        this.txnMode = 0;
        this.preFetchSize = 50;
        if (this.typeMap != null) {
            this.typeMap.clear();
            this.typeMap = new HashMap();
        }
    }

    public TbComm getTbComm() {
        return this.dbComm;
    }

    public TbXAComm getTbXAComm() {
        return (TbXAComm)((Object)this.dbComm);
    }

    public int getSessionId() {
        return this.sessionId;
    }

    public void setSessionId(int sessionId) {
        this.sessionId = sessionId;
    }

    public int getSerialNo() {
        return this.serialNo;
    }

    public void setSerialNo(int serialNo) {
        this.serialNo = serialNo;
    }

    public void setServerInfo(ServerInfo info) {
        this.serverInfo = info;
    }

    public ServerInfo getServerInfo() {
        return this.serverInfo;
    }

    public int getServerCharSet() {
        return this.serverInfo.getServerCharSet();
    }

    public int getServerNCharSet() {
        return this.serverInfo.getServerNCharSet();
    }

    public DataTypeConverter getTypeConverter() {
        return this.typeConverter;
    }

    public TbClobAccessor getClobAccessor() {
        return (TbClobAccessor)((Object)this.dbComm);
    }

    public TbBlobAccessor getBlobAccessor() {
        return (TbBlobAccessor)((Object)this.dbComm);
    }

    public TbStatementCache getStmtCache() {
        return this.stmtCache;
    }

    public void enableStmtCache() {
        this.isStmtCacheEnabled = true;
    }

    public void disableStmtCache() {
        this.isStmtCacheEnabled = false;
    }

    public boolean isSessionClosed() {
        return this.sessionClosed;
    }

    public void openConnection(ConnectionInfo infos) throws SQLException {
        this.reuse();
        this.typeMap = new HashMap();
        this.info = (ConnectionInfo)infos.clone();
        this.typeConverter = new DataTypeConverter(this);
        if (this.isStmtCacheEnabled) {
            this.stmtCache = new TbStatementCache(5);
        }
        this.dbComm = this.info.getDriverType().equals("thin") ? (this.info.isXA() ? new TbXACommType4(this) : new TbCommType4(this)) : (this.info.isXA() ? new TbXACommType2(this) : new TbCommType2(this));
        this.dbComm.logon();
    }

    public String nativeSQL(String sql) throws SQLException {
        return null;
    }

    public synchronized void setAutoCommit(boolean autoCommit) throws SQLException {
        if (this.connClosed || this.dbComm.getStream() == null) {
            throw new TbSQLException(-90603);
        }
        if (this.autoCommit == autoCommit) {
            return;
        }
        this.autoCommit = autoCommit;
    }

    public boolean getAutoCommit() throws SQLException {
        return this.autoCommit;
    }

    public synchronized void commit() throws SQLException {
        if (this.connClosed || this.dbComm.getStream() == null) {
            throw new TbSQLException(-90603);
        }
        this.dbComm.commit();
    }

    public synchronized void rollback() throws SQLException {
        if (this.connClosed || this.dbComm.getStream() == null) {
            throw new TbSQLException(-90603);
        }
        this.dbComm.rollback();
    }

    public synchronized void closeCursor(TbResultSet rs, int cursorId) throws SQLException {
        this.dbComm.closeCursor(rs, cursorId);
    }

    public synchronized void close() {
        this.connClosed = true;
        if (this.dbComm != null) {
            this.dbComm.close();
            this.dbComm = null;
        }
        this.reset();
    }

    public boolean isClosed() {
        return this.connClosed;
    }

    public void setClosed(boolean closed) {
        this.connClosed = closed;
    }

    public DatabaseMetaData getMetaData() throws SQLException {
        if (this.connClosed || this.dbComm.getStream() == null) {
            throw new TbSQLException(-90603);
        }
        if (this.dbMetaData == null) {
            this.dbMetaData = new TbDatabaseMetaData(this);
        }
        return this.dbMetaData;
    }

    public void setReadOnly(boolean readonly) throws SQLException {
    }

    public boolean isReadOnly() throws SQLException {
        return false;
    }

    public void setCatalog(String catalog) throws SQLException {
    }

    public String getCatalog() throws SQLException {
        return this.info.getDatabaseName();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void setTransactionIsolation(int level) throws SQLException {
        if (level != 2 && level != 8) {
            throw new TbSQLException(-90201, "Only supports 'READ COMMITTED' and 'SERIALIZABLE'");
        }
        Statement stmt = null;
        try {
            stmt = this.createStatement();
            if (level == 8) {
                stmt.execute("alter session set isolation_level=serializable");
            } else {
                stmt.execute("alter session set isolation_level=read committed");
            }
        }
        finally {
            if (stmt != null) {
                stmt.close();
            }
        }
        this.isolationLevel = level;
    }

    public synchronized int getTransactionIsolation() throws SQLException {
        return this.isolationLevel;
    }

    public SQLWarning getWarnings() throws SQLException {
        return this.warnings;
    }

    public void clearWarnings() throws SQLException {
        this.warnings = null;
    }

    public void addWarning(SQLWarning warning) {
        if (this.warnings != null) {
            this.warnings.setNextWarning(warning);
        } else {
            this.warnings = warning;
        }
    }

    public Map getTypeMap() throws SQLException {
        return this.typeMap;
    }

    public synchronized void setTypeMap(Map typeMap) throws SQLException {
        this.typeMap = typeMap;
    }

    public synchronized Statement createStatement() throws SQLException {
        return this.createStatement(1003, 1007);
    }

    public synchronized Statement createStatement(int resultSetType, int resultSetConcurrency) throws SQLException {
        if (this.connClosed) {
            throw new TbSQLException(-90603);
        }
        return new TbStatement(this, resultSetType, resultSetConcurrency, this.preFetchSize);
    }

    public synchronized PreparedStatement prepareStatement(String sql) throws SQLException {
        return this.prepareStatement(sql, 1003, 1007, false);
    }

    public synchronized PreparedStatement prepareStatement(String sql, boolean forcePrepare) throws SQLException {
        return this.prepareStatement(sql, 1003, 1007, forcePrepare);
    }

    public synchronized PreparedStatement prepareStatement(String sql, int rsetType, int rsetConcurrency) throws SQLException {
        return this.prepareStatement(sql, rsetType, rsetConcurrency, false);
    }

    public synchronized PreparedStatement prepareStatement(String sql, int rsetType, int rsetCon, boolean forcePrepare) throws SQLException {
        TbPreparedStatement pstmt;
        if (this.connClosed) {
            throw new TbSQLException(-90603);
        }
        if (this.stmtCache != null && (pstmt = this.stmtCache.search(sql, rsetType, rsetCon)) != null) {
            return pstmt;
        }
        return new TbPreparedStatement(this, sql, rsetType, rsetCon, this.preFetchSize, forcePrepare);
    }

    public synchronized CallableStatement prepareCall(String sql) throws SQLException {
        return this.prepareCall(sql, 1003, 1007);
    }

    public synchronized CallableStatement prepareCall(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        if (this.connClosed) {
            throw new TbSQLException(-90603);
        }
        return new TbCallableStatement(this, sql, resultSetType, resultSetConcurrency, this.preFetchSize);
    }

    public TbDirPathStream createDirPathStream(TbDirPathMetaData dirPathMetaData) throws SQLException {
        return new TbDirPathStream(this, dirPathMetaData);
    }

    public void finalize() throws Throwable {
    }

    public void openSession() throws SQLException {
        this.dbComm.openSession();
    }

    public void closeSession() throws SQLException {
        this.dbComm.closeSession();
        this.sessionClosed = true;
    }

    public void resetSession() throws SQLException {
        this.dbComm.resetSession();
    }

    public TbSQLInfo getLastExecutedSqlinfo() throws SQLException {
        return this.dbComm.getLastExecutedSqlinfo();
    }

    public void switchTxnMode(int fromMode, int toMode) {
        if (this.txnMode == fromMode) {
            this.txnMode = toMode;
        }
    }

    void enterTxnMode(int txnMode) {
        this.txnMode = txnMode;
    }

    void disallowGlobalTxnMode(int errorCode) throws SQLException {
        if (this.txnMode == 2) {
            throw new SQLException();
        }
    }

    public void setTxnMode(int txnMode) {
        this.txnMode = txnMode;
    }

    public int getTxnMode() {
        return this.txnMode;
    }

    public void setDefaultRowPrefetch(int preFetchSize) {
        this.preFetchSize = preFetchSize;
    }

    public int getDefaultRowPrefetch() {
        return this.preFetchSize;
    }

    public void setHoldability(int holdability) throws SQLException {
        throw new TbSQLException(-90201);
    }

    public int getHoldability() throws SQLException {
        throw new TbSQLException(-90201);
    }

    public Statement createStatement(int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        throw new TbSQLException(-90201);
    }

    public PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        throw new TbSQLException(-90201);
    }

    public CallableStatement prepareCall(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        throw new TbSQLException(-90201);
    }

    public PreparedStatement prepareStatement(String sql, int autoGeneratedKeys) throws SQLException {
        throw new TbSQLException(-90201);
    }

    public PreparedStatement prepareStatement(String sql, int[] columnIndexes) throws SQLException {
        throw new TbSQLException(-90201);
    }

    public PreparedStatement prepareStatement(String sql, String[] columnNames) throws SQLException {
        throw new TbSQLException(-90201);
    }

    public void setPooledConnection(boolean isPooledConnection) {
        this.isPooledConnection = isPooledConnection;
    }

    public boolean isPooledConnection() {
        return this.isPooledConnection;
    }

    public int getMthrPid() {
        return this.mthrPid;
    }

    public void setMthrPid(int mthrPid) {
        this.mthrPid = mthrPid;
    }

    public TbTimeout getTimeout() throws SQLException {
        if (this.timeout == null) {
            this.timeout = TbTimeout.newTimeout();
        }
        return this.timeout;
    }

    public String getNlsDate() {
        return this.nlsDate;
    }

    public void setNlsDate(String nlsDate) {
        this.nlsDate = nlsDate;
    }

    public String getNlsTimestamp() {
        return this.nlsTimestamp;
    }

    public void setNlsTimestamp(String nlsTimestamp) {
        this.nlsTimestamp = nlsTimestamp;
    }

    public synchronized Savepoint setSavepoint() throws SQLException {
        TbSavepoint savepoint = new TbSavepoint();
        this.dbComm.setSavePoint(savepoint);
        return savepoint;
    }

    public synchronized Savepoint setSavepoint(String name) throws SQLException {
        TbSavepoint savepoint = new TbSavepoint(name);
        this.dbComm.setSavePoint(savepoint);
        return savepoint;
    }

    public synchronized void rollback(Savepoint savepoint) throws SQLException {
        if (this.connClosed || this.dbComm.getStream() == null) {
            throw new TbSQLException(-90603);
        }
        if (this.autoCommit) {
            throw new TbSQLException(-90601);
        }
        this.dbComm.rollback((TbSavepoint)savepoint);
    }

    public synchronized void releaseSavepoint(Savepoint savepoint) throws SQLException {
        throw new TbSQLException(-90201);
    }
}

