/*
 * Decompiled with CFR 0.152.
 */
package com.tmax.tibero.jdbc;

import com.tmax.tibero.jdbc.TbBlob;
import com.tmax.tibero.jdbc.TbClob;
import com.tmax.tibero.jdbc.TbLob;
import com.tmax.tibero.jdbc.TbSQLException;
import com.tmax.tibero.jdbc.util.TbError;
import java.io.IOException;
import java.io.InputStream;
import java.sql.SQLException;

public class TbLobInputStream
extends InputStream {
    private TbLob lob = null;
    private int bufOffset = 0;
    private long lobOffset = 0L;
    private int fetchedSize = 0;
    private boolean opened = false;
    private boolean isBlob = true;
    private char[] charBuf = null;
    private byte[] byteBuf = null;

    public TbLobInputStream(TbLob lob) throws SQLException {
        if (lob == null) {
            throw new TbSQLException(-590713);
        }
        this.lob = lob;
        this.bufOffset = 0;
        this.lobOffset = 0L;
        this.fetchedSize = 0;
        this.opened = true;
        if (lob instanceof TbClob) {
            this.charBuf = new char[TbLob.MAX_CHUNK_SIZE];
            this.isBlob = false;
        } else if (lob instanceof TbBlob) {
            this.byteBuf = new byte[TbLob.MAX_CHUNK_SIZE];
            this.isBlob = true;
        } else {
            throw new TbSQLException(-590713);
        }
    }

    private void assertOpen() throws IOException {
        if (!this.opened) {
            throw new IOException(TbError.getMsg(-90900));
        }
    }

    private int getRemainedInBuffer() {
        if (this.isBlob) {
            return this.fetchedSize - this.bufOffset;
        }
        return this.fetchedSize - this.bufOffset;
    }

    private void readNextBuffer() throws SQLException {
        long readCnt = 0L;
        readCnt = this.isBlob ? ((TbBlob)this.lob).getBytes(this.lobOffset + 1L, this.byteBuf) : ((TbClob)this.lob).getChars(this.lobOffset + 1L, this.charBuf);
        this.fetchedSize = (int)readCnt;
        this.lobOffset += readCnt;
        this.bufOffset = 0;
    }

    public int read() throws IOException {
        int c = 0;
        this.assertOpen();
        if (this.getRemainedInBuffer() == 0) {
            if (this.lob.isEndOfStream()) {
                return -1;
            }
            try {
                this.readNextBuffer();
                return this.read();
            }
            catch (SQLException e) {
                throw new IOException(TbError.getMsg(-90901));
            }
        }
        c = this.isBlob ? this.byteBuf[this.bufOffset++] : this.charBuf[this.bufOffset++];
        if (c < 0) {
            c += 256;
        }
        return c;
    }

    public void close() throws IOException {
        this.opened = false;
    }
}

