/*
 * Decompiled with CFR 0.152.
 */
package com.tmax.tibero.jdbc;

import com.tmax.tibero.jdbc.TbResultSetBase;
import com.tmax.tibero.jdbc.TbSQLException;
import com.tmax.tibero.jdbc.TbStatement;
import com.tmax.tibero.jdbc.data.Row;
import java.sql.SQLException;
import java.util.AbstractList;
import java.util.LinkedList;

public class TbRSScrollable
extends TbResultSetBase {
    protected AbstractList rows = new LinkedList();

    protected TbRSScrollable(TbStatement stmt, int cursorId, int colCnt, int hiddenColCnt) throws SQLException {
        super(stmt, cursorId, colCnt, hiddenColCnt);
        this.currentRowIndex = -1;
    }

    public synchronized boolean absolute(int rowIndex) throws SQLException {
        if (rowIndex == 0) {
            throw new TbSQLException(-90608, " row should not be 0 ");
        }
        if (this.isRSEmpty()) {
            return false;
        }
        if (rowIndex > 0) {
            this.currentRowIndex = rowIndex - 1;
        } else {
            if (!this.fetchComplete) {
                this.fetchRowsAll();
            }
            this.currentRowIndex = this.rowsFetchedCnt + rowIndex;
        }
        return this.isValidRowIndex(this.currentRowIndex);
    }

    public int addRows(Row[] rows) throws SQLException {
        if (rows == null) {
            throw new TbSQLException(-90608, " addRows ");
        }
        int rowCnt = rows.length;
        for (int i = 0; i < rowCnt; ++i) {
            this.rows.add(rows[i]);
        }
        this.rowsFetchedCnt += rowCnt;
        return rowCnt;
    }

    public synchronized void afterLast() throws SQLException {
        if (!this.isRSEmpty()) {
            if (!this.fetchComplete) {
                this.fetchRowsAll();
            }
            this.currentRowIndex = this.rowsFetchedCnt;
        }
    }

    public synchronized void beforeFirst() throws SQLException {
        if (!this.isRSEmpty()) {
            this.currentRowIndex = -1;
        }
    }

    protected void checkRowIndex(int rowIndex) throws SQLException {
        if (rowIndex < 0) {
            throw new TbSQLException(-90635);
        }
        if (rowIndex >= this.rowsFetchedCnt) {
            throw new TbSQLException(-90624);
        }
    }

    protected void fetchRowsAll() throws SQLException {
        while (!this.fetchComplete) {
            this.fetchRowsChunk();
        }
    }

    public synchronized boolean first() throws SQLException {
        if (this.isRSEmpty()) {
            return false;
        }
        this.currentRowIndex = 0;
        return this.isValidRowIndex(this.currentRowIndex);
    }

    protected Row getCurrentRow() throws SQLException {
        if (this.currentRowIndex < 0) {
            throw new TbSQLException(-90635);
        }
        if (this.currentRowIndex >= this.rowsFetchedCnt) {
            throw new TbSQLException(-90624);
        }
        return (Row)this.rows.get(this.currentRowIndex);
    }

    protected Row getRowAt(int rowIndex) throws SQLException {
        return (Row)this.rows.get(rowIndex);
    }

    public Row[] getRows(int rowCnt) throws SQLException {
        Row[] rows = new Row[rowCnt];
        for (int i = 0; i < rowCnt; ++i) {
            rows[i] = new Row(this.colCnt);
        }
        return rows;
    }

    public synchronized boolean isFirst() throws SQLException {
        return !this.hasNoResultReturned() && this.currentRowIndex == 0;
    }

    public synchronized boolean isLast() throws SQLException {
        return !this.hasNoResultReturned() && this.fetchComplete && this.currentRowIndex + 1 == this.rowsFetchedCnt;
    }

    protected boolean isRSEmpty() throws SQLException {
        if (this.rowsFetchedCnt != 0) {
            return false;
        }
        if (this.rowsFetchedCnt == 0 && this.fetchComplete) {
            return true;
        }
        return !this.isValidRowIndex(0);
    }

    protected boolean isValidRowIndex(int rowIndex) throws SQLException {
        if (rowIndex >= 0 && rowIndex < this.rowsFetchedCnt) {
            return true;
        }
        if (rowIndex < 0) {
            return false;
        }
        if (rowIndex >= this.rowsFetchedCnt) {
            if (this.fetchComplete) {
                return false;
            }
            while (rowIndex >= this.rowsFetchedCnt) {
                if (!this.fetchComplete) {
                    this.fetchRowsChunk();
                    continue;
                }
                return false;
            }
            return true;
        }
        return false;
    }

    public synchronized boolean last() throws SQLException {
        if (this.isRSEmpty()) {
            return false;
        }
        if (!this.fetchComplete) {
            this.fetchRowsAll();
        }
        this.currentRowIndex = this.rowsFetchedCnt - 1;
        return this.isValidRowIndex(this.currentRowIndex);
    }

    public synchronized boolean next() throws SQLException {
        this.currentRowIndex = this.currentRowIndex < 0 ? 0 : ++this.currentRowIndex;
        return this.isValidRowIndex(this.currentRowIndex);
    }

    public synchronized boolean previous() throws SQLException {
        if (this.isRSEmpty()) {
            return false;
        }
        this.currentRowIndex = this.currentRowIndex > 0 && !this.isValidRowIndex(this.currentRowIndex) ? this.rowsFetchedCnt - 1 : --this.currentRowIndex;
        return this.isValidRowIndex(this.currentRowIndex);
    }

    public synchronized boolean relative(int rowIndex) throws SQLException {
        if (this.isRSEmpty()) {
            return false;
        }
        if (this.isValidRowIndex(this.currentRowIndex)) {
            this.currentRowIndex += rowIndex;
            return this.isValidRowIndex(this.currentRowIndex);
        }
        throw new TbSQLException(-90624);
    }

    protected void removeCurrentRow() throws SQLException {
        this.checkRowIndex(this.currentRowIndex);
        this.rows.remove(this.currentRowIndex);
        --this.currentRowIndex;
        --this.rowsFetchedCnt;
    }

    public void reset() {
        super.reset();
        if (this.rows != null) {
            this.rows.clear();
            this.rows = null;
        }
    }

    protected void setRowAt(int rowIndex, Row row) throws SQLException {
        this.rows.set(rowIndex, row);
    }

    public String ToString() {
        StringBuffer buf = new StringBuffer(128);
        buf.append(this.toString());
        buf.append(super.ToString());
        return buf.toString();
    }
}

