/*
 * Decompiled with CFR 0.152.
 */
package com.tmax.tibero.jdbc;

import com.tmax.tibero.jdbc.TbSQLException;
import com.tmax.tibero.jdbc.data.Column;
import com.tmax.tibero.jdbc.data.Row;
import com.tmax.tibero.jdbc.data.RsetBuilder;
import com.tmax.tibero.jdbc.data.RsetType;
import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Statement;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Map;

public abstract class TbResultSet
implements ResultSet {
    protected SQLWarning warnings = null;
    protected RsetBuilder rsetBuilder = null;
    protected RsetType rsetType = RsetType.FWRD;
    protected long updateCount = -1L;

    protected void reset() {
        this.warnings = null;
        this.rsetBuilder = null;
        this.rsetType = null;
        this.updateCount = -1L;
    }

    public String ToString() {
        StringBuffer buf = new StringBuffer(128);
        buf.append(this.toString());
        buf.append(" rsetBuilder[").append(this.rsetBuilder).append("]");
        buf.append(" rsetType[").append(this.rsetType).append("]");
        buf.append(" updateCount[").append(this.updateCount).append("]");
        return buf.toString();
    }

    protected TbResultSet(RsetBuilder builder, RsetType rsetType, long updateCount) {
        this.rsetBuilder = builder.getCopy();
        this.rsetType = rsetType.getCopy();
        this.updateCount = updateCount;
    }

    public RsetBuilder getRsetBuilder() {
        return this.rsetBuilder;
    }

    public boolean isJUSTOK() {
        return RsetBuilder.JUSTOK.equals(this.rsetBuilder);
    }

    public boolean isCALL() {
        return RsetBuilder.CALL.equals(this.rsetBuilder);
    }

    public boolean isRSET() {
        return RsetBuilder.RSET.equals(this.rsetBuilder);
    }

    public boolean isCOUNT() {
        return RsetBuilder.COUNT.equals(this.rsetBuilder);
    }

    public void setRsetBuilder(RsetBuilder builder) {
        this.rsetBuilder = builder;
    }

    public RsetType getRsetType() {
        return this.rsetType;
    }

    public void setRsetType(RsetType rsetType) {
        this.rsetType = rsetType;
    }

    public long getUpdateCount() {
        return this.updateCount;
    }

    public abstract void setFetchCompleted(int var1) throws SQLException;

    public abstract Column[] getCols() throws SQLException;

    public abstract int getColumnCount() throws SQLException;

    public int getConcurrency() throws SQLException {
        return this.rsetType.getConcurrency();
    }

    public int getType() throws SQLException {
        return this.rsetType.getType();
    }

    public abstract ResultSetMetaData getMetaData() throws SQLException;

    public String getCursorName() throws SQLException {
        throw new TbSQLException(-90201);
    }

    public synchronized void setFetchDirection(int direction) throws SQLException {
        throw new TbSQLException(-90201);
    }

    public synchronized int getFetchDirection() throws SQLException {
        throw new TbSQLException(-90201);
    }

    public synchronized int getRow() throws SQLException {
        throw new TbSQLException(-90201);
    }

    public synchronized void setFetchSize(int rows) throws SQLException {
        throw new TbSQLException(-90201);
    }

    public int getFetchSize() throws SQLException {
        throw new TbSQLException(-90201);
    }

    public Statement getStatement() throws SQLException {
        throw new TbSQLException(-90201);
    }

    public synchronized boolean wasNull() throws SQLException {
        throw new TbSQLException(-90201);
    }

    public synchronized String getString(int columnIndex) throws SQLException {
        throw new TbSQLException(-90201);
    }

    public synchronized boolean getBoolean(int columnIndex) throws SQLException {
        throw new TbSQLException(-90201);
    }

    public synchronized byte getByte(int columnIndex) throws SQLException {
        throw new TbSQLException(-90201);
    }

    public synchronized short getShort(int columnIndex) throws SQLException {
        throw new TbSQLException(-90201);
    }

    public synchronized int getInt(int columnIndex) throws SQLException {
        throw new TbSQLException(-90201);
    }

    public synchronized long getLong(int columnIndex) throws SQLException {
        throw new TbSQLException(-90201);
    }

    public synchronized float getFloat(int columnIndex) throws SQLException {
        throw new TbSQLException(-90201);
    }

    public synchronized double getDouble(int columnIndex) throws SQLException {
        throw new TbSQLException(-90201);
    }

    public synchronized BigDecimal getBigDecimal(int columnIndex, int scale) throws SQLException {
        throw new TbSQLException(-90201);
    }

    public synchronized byte[] getBytes(int columnIndex) throws SQLException {
        throw new TbSQLException(-90201);
    }

    public synchronized Date getDate(int columnIndex) throws SQLException {
        throw new TbSQLException(-90201);
    }

    public synchronized Time getTime(int columnIndex) throws SQLException {
        throw new TbSQLException(-90201);
    }

    public synchronized Timestamp getTimestamp(int columnIndex) throws SQLException {
        throw new TbSQLException(-90201);
    }

    public synchronized InputStream getAsciiStream(int columnIndex) throws SQLException {
        throw new TbSQLException(-90201);
    }

    public synchronized InputStream getUnicodeStream(int columnIndex) throws SQLException {
        throw new TbSQLException(-90201);
    }

    public synchronized InputStream getBinaryStream(int columnIndex) throws SQLException {
        throw new TbSQLException(-90201);
    }

    public synchronized InputStream getLongByteStream(int columnIndex) throws SQLException {
        throw new TbSQLException(-90201);
    }

    public synchronized Object getObject(int columnIndex) throws SQLException {
        throw new TbSQLException(-90201);
    }

    public synchronized Reader getCharacterStream(int i) throws SQLException {
        throw new TbSQLException(-90201);
    }

    public BigDecimal getBigDecimal(int columnIndex) throws SQLException {
        throw new TbSQLException(-90201);
    }

    public synchronized int findColumn(String columnName) throws SQLException {
        throw new TbSQLException(-90201);
    }

    public Object getObject(int i, Map map) throws SQLException {
        throw new TbSQLException(-90201, "getObject");
    }

    public Ref getRef(int i) throws SQLException {
        throw new TbSQLException(-90201, "getRef");
    }

    public Blob getBlob(int i) throws SQLException {
        throw new TbSQLException(-90201, "getBlob");
    }

    public Clob getClob(int i) throws SQLException {
        throw new TbSQLException(-90201, "getClob");
    }

    public Array getArray(int i) throws SQLException {
        throw new TbSQLException(-90201, "getArray");
    }

    public String getString(String str) throws SQLException {
        return this.getString(this.findColumn(str));
    }

    public boolean getBoolean(String str) throws SQLException {
        return this.getBoolean(this.findColumn(str));
    }

    public byte getByte(String str) throws SQLException {
        return this.getByte(this.findColumn(str));
    }

    public short getShort(String str) throws SQLException {
        return this.getShort(this.findColumn(str));
    }

    public int getInt(String str) throws SQLException {
        return this.getInt(this.findColumn(str));
    }

    public long getLong(String str) throws SQLException {
        return this.getLong(this.findColumn(str));
    }

    public float getFloat(String str) throws SQLException {
        return this.getFloat(this.findColumn(str));
    }

    public double getDouble(String str) throws SQLException {
        return this.getDouble(this.findColumn(str));
    }

    public BigDecimal getBigDecimal(String str, int i) throws SQLException {
        return this.getBigDecimal(this.findColumn(str), i);
    }

    public byte[] getBytes(String str) throws SQLException {
        return this.getBytes(this.findColumn(str));
    }

    public Date getDate(String str) throws SQLException {
        return this.getDate(this.findColumn(str));
    }

    public Time getTime(String str) throws SQLException {
        return this.getTime(this.findColumn(str));
    }

    public Timestamp getTimestamp(String str) throws SQLException {
        return this.getTimestamp(this.findColumn(str));
    }

    public InputStream getAsciiStream(String str) throws SQLException {
        return this.getAsciiStream(this.findColumn(str));
    }

    public InputStream getUnicodeStream(String str) throws SQLException {
        return this.getUnicodeStream(this.findColumn(str));
    }

    public InputStream getBinaryStream(String str) throws SQLException {
        return this.getBinaryStream(this.findColumn(str));
    }

    public Object getObject(String str) throws SQLException {
        return this.getObject(this.findColumn(str));
    }

    public Reader getCharacterStream(String str) throws SQLException {
        return this.getCharacterStream(this.findColumn(str));
    }

    public BigDecimal getBigDecimal(String str) throws SQLException {
        return this.getBigDecimal(this.findColumn(str));
    }

    public Object getObject(String str, Map map) throws SQLException {
        return this.getObject(this.findColumn(str), map);
    }

    public Ref getRef(String str) throws SQLException {
        return this.getRef(this.findColumn(str));
    }

    public Blob getBlob(String str) throws SQLException {
        return this.getBlob(this.findColumn(str));
    }

    public Clob getClob(String str) throws SQLException {
        return this.getClob(this.findColumn(str));
    }

    public Array getArray(String str) throws SQLException {
        return this.getArray(this.findColumn(str));
    }

    public Date getDate(int i, Calendar calendar) throws SQLException {
        return this.getDate(i);
    }

    public Date getDate(String str, Calendar calendar) throws SQLException {
        return this.getDate(this.findColumn(str), calendar);
    }

    public Time getTime(int i, Calendar calendar) throws SQLException {
        return this.getTime(i);
    }

    public Time getTime(String str, Calendar calendar) throws SQLException {
        return this.getTime(this.findColumn(str), calendar);
    }

    public Timestamp getTimestamp(int i, Calendar calendar) throws SQLException {
        return this.getTimestamp(i);
    }

    public Timestamp getTimestamp(String str, Calendar calendar) throws SQLException {
        return this.getTimestamp(this.findColumn(str), calendar);
    }

    public synchronized void addWarning(SQLWarning warning) {
        if (this.warnings != null) {
            this.warnings.setNextWarning(warning);
        } else {
            this.warnings = warning;
        }
    }

    public synchronized SQLWarning getWarnings() throws SQLException {
        return this.warnings;
    }

    public synchronized void clearWarnings() throws SQLException {
        this.warnings = null;
    }

    public boolean next() throws SQLException {
        return false;
    }

    public boolean isBeforeFirst() throws SQLException {
        throw new TbSQLException(-90620, "isBeforeFirst");
    }

    public boolean isAfterLast() throws SQLException {
        throw new TbSQLException(-90620, "isAfterLast");
    }

    public boolean isFirst() throws SQLException {
        throw new TbSQLException(-90620, "isFirst");
    }

    public boolean isLast() throws SQLException {
        throw new TbSQLException(-90620, "isLast");
    }

    public void beforeFirst() throws SQLException {
        throw new TbSQLException(-90620, "beforeFirst");
    }

    public void afterLast() throws SQLException {
        throw new TbSQLException(-90620, "afterLast");
    }

    public boolean first() throws SQLException {
        throw new TbSQLException(-90620, "first");
    }

    public boolean last() throws SQLException {
        throw new TbSQLException(-90620, "last");
    }

    public boolean absolute(int i) throws SQLException {
        throw new TbSQLException(-90620, "absolute");
    }

    public boolean relative(int i) throws SQLException {
        throw new TbSQLException(-90620, "relative");
    }

    public boolean previous() throws SQLException {
        throw new TbSQLException(-90620, "previous");
    }

    public void insertRow() throws SQLException {
        throw new TbSQLException(-90621, "insertRow");
    }

    public void updateRow() throws SQLException {
        throw new TbSQLException(-90621, "updateRow");
    }

    public void deleteRow() throws SQLException {
        throw new TbSQLException(-90621, "deleteRow");
    }

    public void refreshRow() throws SQLException {
        throw new TbSQLException(-90621, "refreshRow");
    }

    public void cancelRowUpdates() throws SQLException {
        throw new TbSQLException(-90621, "cancelRowUpdates");
    }

    public void moveToInsertRow() throws SQLException {
        throw new TbSQLException(-90621, "moveToInsertRow");
    }

    public void moveToCurrentRow() throws SQLException {
        throw new TbSQLException(-90621, "moveToCurrentRow");
    }

    public boolean rowUpdated() throws SQLException {
        return false;
    }

    public boolean rowInserted() throws SQLException {
        return false;
    }

    public boolean rowDeleted() throws SQLException {
        return false;
    }

    public void updateNull(int i) throws SQLException {
        throw new TbSQLException(-90621, "updateNull");
    }

    public void updateBoolean(int i, boolean bool) throws SQLException {
        throw new TbSQLException(-90621, "updateBoolean");
    }

    public void updateByte(int i, byte b) throws SQLException {
        throw new TbSQLException(-90621, "updateByte");
    }

    public void updateShort(int i, short si) throws SQLException {
        throw new TbSQLException(-90621, "updateShort");
    }

    public void updateInt(int i, int i1) throws SQLException {
        throw new TbSQLException(-90621, "updateInt");
    }

    public void updateLong(int i, long l) throws SQLException {
        throw new TbSQLException(-90621, "updateLong");
    }

    public void updateFloat(int i, float f) throws SQLException {
        throw new TbSQLException(-90621, "updateFloat");
    }

    public void updateDouble(int i, double d) throws SQLException {
        throw new TbSQLException(-90621, "updateDouble");
    }

    public void updateBigDecimal(int i, BigDecimal decimal) throws SQLException {
        throw new TbSQLException(-90621, "updateBigDecimal");
    }

    public void updateString(int i, String str) throws SQLException {
        throw new TbSQLException(-90621, "updateString");
    }

    public void updateBytes(int i, byte[] param) throws SQLException {
        throw new TbSQLException(-90621, "updateBytes");
    }

    public void updateDate(int i, Date date) throws SQLException {
        throw new TbSQLException(-90621, "updateDate");
    }

    public void updateTime(int i, Time time) throws SQLException {
        throw new TbSQLException(-90621, "updateTime");
    }

    public void updateTimestamp(int i, Timestamp timestamp) throws SQLException {
        throw new TbSQLException(-90621, "updateTimestamp");
    }

    public void updateAsciiStream(int i, InputStream stream, int i1) throws SQLException {
        throw new TbSQLException(-90621, "updateAsciiStream");
    }

    public void updateBinaryStream(int i, InputStream stream, int i1) throws SQLException {
        throw new TbSQLException(-90621, "updateBinaryStream");
    }

    public void updateCharacterStream(int i, Reader reader, int i1) throws SQLException {
        throw new TbSQLException(-90621, "updateCharacterStream");
    }

    public void updateObject(int i, Object obj, int scale) throws SQLException {
        throw new TbSQLException(-90621, "updateObject");
    }

    public void updateObject(int i, Object obj) throws SQLException {
        this.updateObject(i, obj, 0);
    }

    public void updateNull(String str) throws SQLException {
        this.updateNull(this.findColumn(str));
    }

    public void updateBoolean(String str, boolean bool) throws SQLException {
        this.updateBoolean(this.findColumn(str), bool);
    }

    public void updateByte(String str, byte b) throws SQLException {
        this.updateByte(this.findColumn(str), b);
    }

    public void updateShort(String str, short si) throws SQLException {
        this.updateShort(this.findColumn(str), si);
    }

    public void updateInt(String str, int i) throws SQLException {
        this.updateInt(this.findColumn(str), i);
    }

    public void updateLong(String str, long l) throws SQLException {
        this.updateLong(this.findColumn(str), l);
    }

    public void updateFloat(String str, float f) throws SQLException {
        this.updateFloat(this.findColumn(str), f);
    }

    public void updateDouble(String str, double d) throws SQLException {
        this.updateDouble(this.findColumn(str), d);
    }

    public void updateBigDecimal(String str, BigDecimal decimal) throws SQLException {
        this.updateBigDecimal(this.findColumn(str), decimal);
    }

    public void updateString(String str, String str1) throws SQLException {
        this.updateString(this.findColumn(str), str1);
    }

    public void updateBytes(String str, byte[] param) throws SQLException {
        this.updateBytes(this.findColumn(str), param);
    }

    public void updateDate(String str, Date date) throws SQLException {
        this.updateDate(this.findColumn(str), date);
    }

    public void updateTime(String str, Time time) throws SQLException {
        this.updateTime(this.findColumn(str), time);
    }

    public void updateTimestamp(String str, Timestamp timestamp) throws SQLException {
        this.updateTimestamp(this.findColumn(str), timestamp);
    }

    public void updateAsciiStream(String str, InputStream stream, int i) throws SQLException {
        this.updateAsciiStream(this.findColumn(str), stream, i);
    }

    public void updateBinaryStream(String str, InputStream stream, int i) throws SQLException {
        this.updateBinaryStream(this.findColumn(str), stream, i);
    }

    public void updateCharacterStream(String str, Reader reader, int i) throws SQLException {
        this.updateCharacterStream(this.findColumn(str), reader, i);
    }

    public void updateObject(String str, Object obj, int i) throws SQLException {
        this.updateObject(this.findColumn(str), obj, i);
    }

    public void updateObject(String str, Object obj) throws SQLException {
        this.updateObject(this.findColumn(str), obj);
    }

    public URL getURL(int columnIndex) throws SQLException {
        throw new TbSQLException(-90201);
    }

    public URL getURL(String columnName) throws SQLException {
        throw new TbSQLException(-90201);
    }

    public void updateRef(int columnIndex, Ref x) throws SQLException {
        throw new TbSQLException(-90201);
    }

    public void updateRef(String columnName, Ref x) throws SQLException {
        throw new TbSQLException(-90201);
    }

    public void updateBlob(int columnIndex, Blob x) throws SQLException {
        throw new TbSQLException(-90201);
    }

    public void updateBlob(String columnName, Blob x) throws SQLException {
        throw new TbSQLException(-90201);
    }

    public void updateClob(int columnIndex, Clob x) throws SQLException {
        throw new TbSQLException(-90201);
    }

    public void updateClob(String columnName, Clob x) throws SQLException {
        throw new TbSQLException(-90201);
    }

    public void updateArray(int columnIndex, Array x) throws SQLException {
        throw new TbSQLException(-90201);
    }

    public void updateArray(String columnName, Array x) throws SQLException {
        throw new TbSQLException(-90201);
    }

    public abstract Row[] buildRowData(int var1) throws SQLException;

    public abstract int addRows(Row[] var1) throws SQLException;

    public abstract void checkColumnPos(int var1) throws SQLException;

    protected abstract int getColumnDataType(int var1) throws SQLException;

    protected abstract boolean getColumnNullable(int var1) throws SQLException;

    protected abstract int getColumnMaxLength(int var1) throws SQLException;

    protected abstract String getColumnName(int var1) throws SQLException;

    protected abstract int getColumnPrecision(int var1) throws SQLException;

    protected abstract int getColumnScale(int var1) throws SQLException;

    protected abstract int getColumnSqlType(int var1) throws SQLException;
}

