/*
 * Decompiled with CFR 0.152.
 */
package com.tmax.tibero.jdbc;

import com.tmax.tibero.jdbc.TbRSEmpty;
import com.tmax.tibero.jdbc.TbRSFwOnly;
import com.tmax.tibero.jdbc.TbRSFwOnlyCsr;
import com.tmax.tibero.jdbc.TbRSScrollable;
import com.tmax.tibero.jdbc.TbRSSensitive;
import com.tmax.tibero.jdbc.TbRSUpdatable;
import com.tmax.tibero.jdbc.TbResultSet;
import com.tmax.tibero.jdbc.TbStatement;
import com.tmax.tibero.jdbc.data.RsetBuilder;
import com.tmax.tibero.jdbc.data.RsetType;
import java.sql.SQLException;

public class TbResultSetFactory {
    public static TbResultSet buildCallResult(TbStatement stmt) throws SQLException {
        return new TbRSEmpty(RsetBuilder.CALL, stmt.getRealRsetType(), 0L);
    }

    public static TbResultSet buildOKResult(TbStatement stmt) throws SQLException {
        return new TbRSEmpty(RsetBuilder.JUSTOK, stmt.getRealRsetType(), 0L);
    }

    public static TbResultSet buildRsetResult(TbStatement stmt, int cursorId, int colCnt, int hiddenColCnt, boolean forCursor) throws SQLException {
        RsetType rsetType = stmt.getRealRsetType();
        switch (rsetType.getRank()) {
            case 2: {
                if (forCursor) {
                    TbRSFwOnlyCsr rs2 = new TbRSFwOnlyCsr(stmt, cursorId, colCnt, hiddenColCnt);
                    return new TbRSUpdatable(rs2, RsetType.FWUP);
                }
                TbRSFwOnly rs2 = new TbRSFwOnly(stmt, cursorId, colCnt, hiddenColCnt);
                return new TbRSUpdatable(rs2, RsetType.FWUP);
            }
            case 3: {
                return new TbRSScrollable(stmt, cursorId, colCnt, hiddenColCnt);
            }
            case 4: {
                TbRSScrollable rs4 = new TbRSScrollable(stmt, cursorId, colCnt, hiddenColCnt);
                return new TbRSUpdatable(rs4, RsetType.SIUP);
            }
            case 5: {
                return new TbRSSensitive(stmt, cursorId, colCnt, hiddenColCnt);
            }
            case 6: {
                TbRSSensitive rs6 = new TbRSSensitive(stmt, cursorId, colCnt, hiddenColCnt);
                return new TbRSUpdatable(rs6, RsetType.SSUP);
            }
        }
        if (forCursor) {
            return new TbRSFwOnlyCsr(stmt, cursorId, colCnt, hiddenColCnt);
        }
        return new TbRSFwOnly(stmt, cursorId, colCnt, hiddenColCnt);
    }

    public static TbResultSet buildUpdateResult(TbStatement stmt, long updateCount) throws SQLException {
        return new TbRSEmpty(RsetBuilder.COUNT, stmt.getRealRsetType(), updateCount);
    }
}

