/*
 * Decompiled with CFR 0.152.
 */
package com.tmax.tibero.jdbc;

import com.tmax.tibero.jdbc.TbStatement;
import com.tmax.tibero.jdbc.TbTimeoutPollingThread;
import java.sql.SQLException;

public class TbTimeout {
    private static final long INFINITE_TIME = Long.MAX_VALUE;
    private static final TbTimeoutPollingThread pollingThread = new TbTimeoutPollingThread();
    private TbStatement statement;
    private long interruptAfter = Long.MAX_VALUE;

    TbTimeout() {
        pollingThread.add(this);
    }

    static TbTimeout newTimeout() throws SQLException {
        TbTimeout instance = new TbTimeout();
        return instance;
    }

    void close() {
        pollingThread.remove(this);
    }

    synchronized void setTimeout(long milliseconds, TbStatement stmt) throws SQLException {
        this.statement = stmt;
        this.interruptAfter = System.currentTimeMillis() + milliseconds;
    }

    synchronized void cancelTimeout() throws SQLException {
        this.statement = null;
        this.interruptAfter = Long.MAX_VALUE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void cancelStmtOfTimeover(long now) {
        if (now > this.interruptAfter) {
            TbTimeout tbTimeout = this;
            synchronized (tbTimeout) {
                if (now > this.interruptAfter) {
                    try {
                        this.statement.cancel();
                        this.statement = null;
                        this.interruptAfter = Long.MAX_VALUE;
                    }
                    catch (SQLException e) {
                        e.printStackTrace();
                    }
                }
            }
        }
    }
}

