/*
 * Decompiled with CFR 0.152.
 */
package com.tmax.tibero.jdbc.data;

import com.tmax.tibero.jdbc.util.TbCommon;
import java.util.Properties;

public class ConnectionInfo
implements Cloneable {
    public static final String DEFAULT_SERVER_NAME = "localhost";
    public static final String DEFAULT_NETWORK_PROTOCOL = "tcp";
    public static final String DATABASENAME = "databaseName";
    public static final String DATASOURCENAME = "dataSourceName";
    public static final String DESCRIPTION = "description";
    public static final String DRIVERTYPE = "driverType";
    public static final String NETWORKPROTOCOL = "networkProtocol";
    public static final String PASSWORD = "password";
    public static final String PORTNUMBER = "portNumber";
    public static final String ROLENAME = "roleName";
    public static final String SERVERNAME = "serverName";
    public static final String USER = "user";
    public static final String TDU = "tdu";
    public static final String URL = "url";
    public static final String FAILOVER = "failOver";
    public static final String BACKUP_SERVERNAME = "backupServerName";
    public static final String BACKUP_PORTNUMBER = "backupPortNumber";
    private String user = "";
    private String serverName = "localhost";
    private int portNumber = 5432;
    private String databaseName = "";
    private String backupServerName = "localhost";
    private int backupPortNumber = 5432;
    private boolean failOver = false;
    private String dataSourceName = "";
    private String description = "";
    private String driverType = "thin";
    private String networkProtocol = "tcp";
    private String password = "";
    private String url = "";
    private int tdu = 4096;
    private boolean isXA = false;

    public Object clone() {
        try {
            return super.clone();
        }
        catch (Exception e) {
            throw new RuntimeException("ConnectionInfo clone() failed:" + e.getMessage());
        }
    }

    public String toString() {
        StringBuffer buf = new StringBuffer(64);
        buf.append("ConnInfo[");
        buf.append("User=").append(this.user);
        buf.append("/Password=").append(this.password);
        buf.append("/URL=").append(this.url);
        buf.append("/DriverType=").append(this.driverType);
        buf.append("/NetworkProtocol=").append(this.networkProtocol);
        buf.append("/TDU=").append(this.tdu);
        buf.append("/ServerName=").append(this.serverName);
        buf.append("/Port=").append(this.portNumber);
        buf.append("/DatabaseName=").append(this.databaseName);
        buf.append("/DataSourceName=").append(this.dataSourceName);
        buf.append("/Description=").append(this.description);
        buf.append("]");
        return buf.toString();
    }

    public ConnectionInfo() {
    }

    public ConnectionInfo(Properties props) {
        this.set(props);
    }

    public ConnectionInfo(String url, String user, String host, int port, String database, Properties connInfos) {
        this.serverName = TbCommon.getEmptyString(host, DEFAULT_SERVER_NAME);
        if (port <= 0) {
            port = 5432;
        }
        this.portNumber = port;
        this.user = this.getUserName(TbCommon.getEmptyString(user));
        this.databaseName = TbCommon.getEmptyString(database);
        this.url = url;
        Properties props = connInfos != null ? connInfos : new Properties();
        this.dataSourceName = props.getProperty(DATASOURCENAME, "");
        this.description = props.getProperty(DESCRIPTION, "");
        this.driverType = props.getProperty(DRIVERTYPE, "thin");
        this.networkProtocol = props.getProperty(NETWORKPROTOCOL, DEFAULT_NETWORK_PROTOCOL);
        this.password = props.getProperty(PASSWORD, "");
        try {
            this.tdu = Integer.parseInt(props.getProperty(TDU, ""));
        }
        catch (NumberFormatException ne) {
            this.tdu = 4096;
        }
    }

    public void set(Properties props) {
        if (props == null) {
            return;
        }
        this.user = this.getUserName(props.getProperty(USER, ""));
        this.password = props.getProperty(PASSWORD, "");
        this.url = props.getProperty(URL, "");
        this.driverType = props.getProperty(DRIVERTYPE, "thin");
        this.networkProtocol = props.getProperty(NETWORKPROTOCOL, DEFAULT_NETWORK_PROTOCOL);
        String tmpTdu = props.getProperty(TDU, null);
        try {
            this.tdu = Integer.parseInt(tmpTdu);
        }
        catch (Exception ignore) {
            this.tdu = 4096;
        }
        this.serverName = props.getProperty(SERVERNAME, DEFAULT_SERVER_NAME);
        String tmpVal = props.getProperty(PORTNUMBER, null);
        try {
            this.portNumber = Integer.parseInt(tmpVal);
        }
        catch (Exception ignore) {
            this.portNumber = 5432;
        }
        this.databaseName = props.getProperty(DATABASENAME, "");
        this.dataSourceName = props.getProperty(DATASOURCENAME, "");
        this.description = props.getProperty(DESCRIPTION, "");
        this.backupServerName = props.getProperty(BACKUP_SERVERNAME, DEFAULT_SERVER_NAME);
        tmpVal = props.getProperty(BACKUP_PORTNUMBER, null);
        try {
            this.backupPortNumber = Integer.parseInt(tmpVal);
        }
        catch (Exception ignore) {
            this.backupPortNumber = 5432;
        }
        tmpVal = props.getProperty(FAILOVER, "OFF");
        this.failOver = tmpVal.equals("ON");
    }

    public String getUser() {
        return this.user;
    }

    public void setUser(String user) {
        this.user = this.getUserName(TbCommon.getEmptyString(user));
    }

    private String getUserName(String user) {
        if (user.length() >= 2 && user.startsWith("\"") && user.endsWith("\"")) {
            return user.substring(1, user.length() - 1);
        }
        return user.toUpperCase();
    }

    public String getServerName() {
        return this.serverName;
    }

    public void setServerName(String str) {
        this.serverName = TbCommon.getEmptyString(str, DEFAULT_SERVER_NAME);
    }

    public int getPortNumber() {
        return this.portNumber;
    }

    public void setPortNumber(int port) {
        this.portNumber = port <= 0 ? 5432 : port;
    }

    public String getDatabaseName() {
        return this.databaseName;
    }

    public void setDatabaseName(String str) {
        this.databaseName = TbCommon.getEmptyString(str);
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String str) {
        this.description = TbCommon.getEmptyString(str);
    }

    public String getDataSourceName() {
        return this.dataSourceName;
    }

    public void setDataSourceName(String str) {
        this.dataSourceName = TbCommon.getEmptyString(str);
    }

    public String getDriverType() {
        return this.driverType;
    }

    public void setDriverType(String str) {
        this.driverType = TbCommon.getEmptyString(str, "thin");
    }

    public String getNetworkProtocol() {
        return this.networkProtocol;
    }

    public void setNetworkProtocol(String str) {
        this.networkProtocol = TbCommon.getEmptyString(str, DEFAULT_NETWORK_PROTOCOL);
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String str) {
        this.password = TbCommon.getEmptyString(str);
    }

    public String getUrl() {
        return this.url;
    }

    public void setUrl(String str) {
        this.url = str;
    }

    public int getTdu() {
        return this.tdu;
    }

    public void setTdu(int i) {
        this.tdu = i <= 0 ? 4096 : i;
    }

    public void setBackupServerName(String backupServerName) {
        this.backupServerName = backupServerName;
    }

    public void setBackupPortNumber(int backupPortNumber) {
        this.backupPortNumber = backupPortNumber;
    }

    public void setFailOver(boolean failOver) {
        this.failOver = failOver;
    }

    public String getBackupServerName() {
        return this.backupServerName;
    }

    public int getBackupPortNumber() {
        return this.backupPortNumber;
    }

    public boolean getFailOver() {
        return this.failOver;
    }

    public boolean isXA() {
        return this.isXA;
    }

    public void setXA(boolean isXA) {
        this.isXA = isXA;
    }
}

