/*
 * Decompiled with CFR 0.152.
 */
package com.tmax.tibero.jdbc.data.charset;

import com.tmax.tibero.jdbc.TbSQLException;
import com.tmax.tibero.jdbc.data.charset.CharsetDecoder;
import com.tmax.tibero.jdbc.data.charset.SJISByteToCharConverter;
import java.io.UnsupportedEncodingException;
import java.sql.SQLException;

public class SJISDecoder
implements CharsetDecoder {
    private SJISByteToCharConverter conv = new SJISByteToCharConverter();

    public int bytesToChars(byte[] srcBytes, int srcStart, int srcLen, char[] destChars, int destStart, int destLen) throws TbSQLException {
        return this.conv.convert(srcBytes, srcStart, srcStart + srcLen, destChars, destStart, destStart + destLen);
    }

    public String bytesToString(byte[] srcBytes, int srcStart, int srcLen) throws SQLException {
        try {
            return new String(srcBytes, srcStart, srcLen, "Shift_JIS");
        }
        catch (UnsupportedEncodingException e) {
            throw new TbSQLException(-590714);
        }
    }

    public String bytesToString(byte[] srcBytes) throws SQLException {
        try {
            return new String(srcBytes, "EUC-KR");
        }
        catch (UnsupportedEncodingException e) {
            throw new TbSQLException(-590714);
        }
    }

    public int fixedBytesToChars(byte[] srcBytes, int srcStart, int srcLen, char[] destChars, int destStart, int destLen) throws TbSQLException {
        return 0;
    }

    public String fixedBytesToString(byte[] srcBytes, int srcStart, int srcLen) throws SQLException {
        return null;
    }

    public String fixedBytesToString(byte[] srcBytes) throws SQLException {
        return null;
    }
}

