/*
 * Decompiled with CFR 0.152.
 */
package com.tmax.tibero.jdbc.data.charset;

import com.tmax.tibero.jdbc.TbSQLException;
import com.tmax.tibero.jdbc.data.charset.CharsetEncoder;
import com.tmax.tibero.jdbc.data.charset.UTF8CharToByteConverter;
import java.sql.SQLException;

public class UTF8Encoder
implements CharsetEncoder {
    private UTF8CharToByteConverter conv = new UTF8CharToByteConverter();
    private int maxBytesPerChar = this.conv.getMaxBytesPerChar();

    public int charsToBytes(char[] srcChars, int srcStart, int srcLen, byte[] destBytes, int destStart, int destLen) throws TbSQLException {
        return this.conv.convert(srcChars, srcStart, srcStart + srcLen, destBytes, destStart, destStart + destLen);
    }

    public int charsToFixedBytes(char[] srcChars, int srcStart, int srcLen, byte[] destBytes, int destStart, int destLen) throws TbSQLException {
        throw new TbSQLException(-590714);
    }

    public int getEndingBytePos(byte[] byteArr, int offset) {
        if (byteArr[offset] >= 0) {
            return offset;
        }
        int clbOffset = this.getLeadingBytePos(byteArr, offset);
        if (byteArr[clbOffset] >= 224) {
            return clbOffset + 2;
        }
        return clbOffset + 1;
    }

    public int getLeadingBytePos(byte[] byteArr, int offset) {
        int i = offset;
        while ((byteArr[i] & 0x80) != 0 && (byteArr[i] & 0x40) == 0) {
            --i;
        }
        return i;
    }

    public int getMaxBytesPerChar() {
        return this.maxBytesPerChar;
    }

    public boolean isEndingByte(byte[] byteArr, int offset) {
        if (byteArr[offset] >= 0) {
            return true;
        }
        int clbOffset = this.getLeadingBytePos(byteArr, offset);
        if (byteArr[clbOffset] >= 224) {
            return offset == clbOffset + 2;
        }
        return offset == clbOffset + 1;
    }

    public boolean isLeadingByte(byte[] byteArr, int offset) {
        byte c = byteArr[offset];
        return (c & 0x80) == 0 || (c & 0x40) != 0;
    }

    public byte[] stringToBytes(String string) throws SQLException {
        char[] srcArr = string.toCharArray();
        byte[] temp = new byte[srcArr.length * this.getMaxBytesPerChar()];
        int byteLen = this.charsToBytes(srcArr, 0, srcArr.length, temp, 0, temp.length);
        byte[] dest = new byte[byteLen];
        System.arraycopy(temp, 0, dest, 0, byteLen);
        return dest;
    }

    public byte[] stringToFixedBytes(String string) throws SQLException {
        return new byte[0];
    }
}

