/*
 * Decompiled with CFR 0.152.
 */
package com.tmax.tibero.jdbc.msg;

import com.tmax.tibero.jdbc.comm.TbStreamDataReader;
import com.tmax.tibero.jdbc.comm.TbStreamDataWriter;
import com.tmax.tibero.jdbc.msg.common.TbMsg;
import java.sql.SQLException;

public class TbMsgFetchReply
extends TbMsg {
    public int rowCnt;
    public int isFetchCompleted;
    public int rowChunkSize;

    public TbMsgFetchReply(int autoCommit) {
        this.msgType = 19;
        this.msgBodySize = 0;
        this.autoCommit = autoCommit;
    }

    public void set(int rowCnt, int isFetchCompleted, int rowChunkSize) {
        this.rowCnt = rowCnt;
        this.isFetchCompleted = isFetchCompleted;
        this.rowChunkSize = rowChunkSize;
    }

    public void serialize(TbStreamDataWriter writer) throws SQLException {
        writer.writeInt(this.msgType, 4);
        writer.writeInt(this.msgBodySize, 4);
        writer.writeInt(this.autoCommit, 8);
        writer.writeLong(this.tsn, 8);
        writer.writeInt(this.rowCnt, 4);
        writer.writeInt(this.isFetchCompleted, 4);
        writer.writeInt(this.rowChunkSize, 4);
        writer.reWriteInt(4, writer.getBufferedDataSize() - 24, 4);
    }

    public void deserialize(TbStreamDataReader reader) throws SQLException {
        this.rowCnt = reader.readInt32();
        this.isFetchCompleted = reader.readInt32();
        this.rowChunkSize = reader.readInt32();
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        TbMsgFetchReply msg = (TbMsgFetchReply)obj;
        if (this.rowCnt != msg.rowCnt) {
            return false;
        }
        if (this.isFetchCompleted != msg.isFetchCompleted) {
            return false;
        }
        return this.rowChunkSize == msg.rowChunkSize;
    }

    public String toString() {
        StringBuffer str = new StringBuffer("[TbMsgFetchReply]/");
        str.append("rowCnt=");
        str.append(this.rowCnt);
        str.append("/");
        str.append("isFetchCompleted=");
        str.append(this.isFetchCompleted);
        str.append("/");
        str.append("rowChunkSize=");
        str.append(this.rowChunkSize);
        str.append("/");
        return str.append("\n").toString();
    }
}

