/*
 * Decompiled with CFR 0.152.
 */
package com.tmax.tibero.jdbc.msg;

import com.tmax.tibero.jdbc.comm.TbStreamDataReader;
import com.tmax.tibero.jdbc.comm.TbStreamDataWriter;
import com.tmax.tibero.jdbc.msg.common.TbMsg;
import java.sql.SQLException;

public class TbMsgTbcmHeartbeat
extends TbMsg {
    public int status;
    public int id;
    public int clusterPort;
    public String name;

    public TbMsgTbcmHeartbeat(int autoCommit) {
        this.msgType = 126;
        this.msgBodySize = 0;
        this.autoCommit = autoCommit;
    }

    public void set(int status, int id, int clusterPort, String name) {
        this.status = status;
        this.id = id;
        this.clusterPort = clusterPort;
        this.name = name;
    }

    public void serialize(TbStreamDataWriter writer) throws SQLException {
        writer.writeInt(this.msgType, 4);
        writer.writeInt(this.msgBodySize, 4);
        writer.writeInt(this.autoCommit, 8);
        writer.writeLong(this.tsn, 8);
        writer.writeInt(this.status, 4);
        writer.writeInt(this.id, 4);
        writer.writeInt(this.clusterPort, 4);
        if (this.name != null) {
            writer.writeLenAndDBEncodedPadString(this.name);
        } else {
            writer.writeInt(0, 4);
        }
        writer.reWriteInt(4, writer.getBufferedDataSize() - 24, 4);
    }

    public void deserialize(TbStreamDataReader reader) throws SQLException {
        this.status = reader.readInt32();
        this.id = reader.readInt32();
        this.clusterPort = reader.readInt32();
        int nameLen = reader.readInt32();
        this.name = reader.readDBDecodedPadString(nameLen);
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        TbMsgTbcmHeartbeat msg = (TbMsgTbcmHeartbeat)obj;
        if (this.status != msg.status) {
            return false;
        }
        if (this.id != msg.id) {
            return false;
        }
        if (this.clusterPort != msg.clusterPort) {
            return false;
        }
        if (this.name == null && msg.name != null || this.name != null && msg.name == null) {
            return false;
        }
        return this.name == null || msg.name == null || this.name.equals(msg.name);
    }

    public String toString() {
        StringBuffer str = new StringBuffer("[TbMsgTbcmHeartbeat]/");
        str.append("status=");
        str.append(this.status);
        str.append("/");
        str.append("id=");
        str.append(this.id);
        str.append("/");
        str.append("clusterPort=");
        str.append(this.clusterPort);
        str.append("/");
        str.append("name=");
        str.append(this.name);
        str.append("/");
        return str.append("\n").toString();
    }
}

