/*
 * Decompiled with CFR 0.152.
 */
package com.tmax.tibero.jdbc.util;

import com.tmax.tibero.jdbc.TbSQLException;
import com.tmax.tibero.jdbc.data.ConnectionInfo;
import java.sql.SQLException;
import java.util.Properties;
import java.util.StringTokenizer;

public class TbUrlParser {
    public static ConnectionInfo parseUrl(String url, Properties infos) throws SQLException {
        if (url == null) {
            throw new TbSQLException(-90605);
        }
        StringTokenizer token = new StringTokenizer(url, ":\n");
        int tokenCnt = token.countTokens();
        if (tokenCnt == 0) {
            ConnectionInfo info = new ConnectionInfo(infos);
            info.setUrl(TbUrlParser.makeURL(info));
            return info;
        }
        if (tokenCnt >= 4) {
            String host;
            Properties props = new Properties(infos);
            if (!"jdbc".equals(token.nextToken()) || !"tibero".equals(token.nextToken())) {
                throw new TbSQLException(-90605);
            }
            String driverType = token.nextToken();
            if (!"thin".equals(driverType) && !"tbcli".equals(driverType)) {
                throw new TbSQLException(-90605);
            }
            props.setProperty("driverType", driverType);
            String hostString = token.nextToken();
            if (hostString.trim().length() == 0) {
                throw new TbSQLException(-90605);
            }
            int indexSlash = hostString.indexOf(47);
            int indexAt = hostString.indexOf(64);
            if (hostString.trim().charAt(indexAt + 1) == '(') {
                return TbUrlParser.parseDescription(url, props, hostString);
            }
            if (indexAt != -1) {
                host = hostString.substring(indexAt + 1);
                if (host.trim().length() == 0) {
                    throw new TbSQLException(-90605);
                }
            } else {
                throw new TbSQLException(-90605);
            }
            props.setProperty("serverName", host);
            if (indexSlash != -1) {
                String user = hostString.substring(0, indexSlash);
                String password = hostString.substring(indexSlash + 1, indexAt);
                if (user.trim().length() == 0 && password.trim().length() != 0) {
                    throw new TbSQLException(-90605);
                }
                props.setProperty("user", user);
                props.setProperty("password", password);
            }
            if (tokenCnt == 5) {
                String portORdatabase = token.nextToken();
                if (portORdatabase.trim().length() == 0) {
                    throw new TbSQLException(-90605);
                }
                try {
                    Integer.parseInt(portORdatabase);
                    props.setProperty("portNumber", portORdatabase);
                }
                catch (NumberFormatException nfe) {
                    props.setProperty("databaseName", portORdatabase);
                }
            } else if (tokenCnt == 6) {
                String portString = token.nextToken();
                if (portString.trim().length() == 0) {
                    throw new TbSQLException(-90605);
                }
                try {
                    Integer.parseInt(portString);
                    props.setProperty("portNumber", portString);
                }
                catch (NumberFormatException nfe) {
                    throw new TbSQLException(-90605);
                }
                String databaseString = token.nextToken();
                if (databaseString.trim().length() == 0) {
                    throw new TbSQLException(-90605);
                }
                props.setProperty("databaseName", databaseString);
            }
            ConnectionInfo info = new ConnectionInfo(props);
            info.setUrl(url);
            return info;
        }
        return null;
    }

    public static ConnectionInfo parseDescription(String url, Properties props, String descStr) throws SQLException {
        String findValChars = ") \t\r\n\f";
        boolean START = false;
        boolean DESCRIPTION = true;
        int FAILOVER = 2;
        int ADDRESS_LIST = 3;
        int ADDRESS = 6;
        int HOST = 7;
        int PORT = 8;
        int ACCEPT = 9;
        int ERROR = -1;
        int state = 0;
        boolean NONE = false;
        boolean PRIMARY = true;
        int BACKUP = 2;
        int subState = 0;
        String description = "DESCRIPTION";
        String failover = "FAILOVER";
        String on = "ON";
        String off = "OFF";
        String address_list = "ADDRESS_LIST";
        String primary = "PRIMARY";
        String backup = "BACKUP";
        String address = "ADDRESS";
        String host = "HOST";
        String port = "PORT";
        int ofs = descStr.indexOf(40);
        String scanStr = null;
        int valOfs = 0;
        int len = 0;
        String valStr = null;
        while (state != 9) {
            switch (state) {
                case 0: {
                    scanStr = descStr.substring(ofs + 1).trim();
                    if (scanStr.startsWith("DESCRIPTION")) {
                        ofs = "DESCRIPTION".length();
                        if (!(scanStr = scanStr.substring(ofs).trim()).startsWith("=")) {
                            state = -1;
                            break;
                        }
                        ofs = 1;
                        scanStr = scanStr.substring(ofs).trim();
                        state = 1;
                        break;
                    }
                    state = -1;
                    break;
                }
                case 1: {
                    if (scanStr.startsWith(")")) {
                        state = 9;
                        break;
                    }
                    if (!scanStr.startsWith("(")) {
                        state = -1;
                        break;
                    }
                    ofs = 1;
                    if ((scanStr = scanStr.substring(ofs).trim()).startsWith("FAILOVER")) {
                        ofs = "FAILOVER".length();
                        scanStr = scanStr.substring(ofs).trim();
                        state = 2;
                        break;
                    }
                    if (scanStr.startsWith("ADDRESS_LIST")) {
                        ofs = "ADDRESS_LIST".length();
                        if (!(scanStr = scanStr.substring(ofs).trim()).startsWith("=")) {
                            state = -1;
                            break;
                        }
                        ofs = 1;
                        scanStr = scanStr.substring(ofs).trim();
                        state = 3;
                        break;
                    }
                    if (scanStr.startsWith("ADDRESS")) {
                        ofs = "ADDRESS".length();
                        scanStr = scanStr.substring(ofs).trim();
                        state = 6;
                        break;
                    }
                    state = -1;
                    break;
                }
                case 2: {
                    if (!scanStr.startsWith("=")) {
                        state = -1;
                        break;
                    }
                    ofs = 1;
                    if ((scanStr = scanStr.substring(ofs).trim()).startsWith("ON")) {
                        ofs = "ON".length();
                        if ((scanStr = scanStr.substring(ofs).trim()).startsWith(")")) {
                            ofs = 1;
                            scanStr = scanStr.substring(ofs).trim();
                            props.setProperty("failOver", "ON");
                            state = 1;
                            break;
                        }
                        state = -1;
                        break;
                    }
                    if (scanStr.startsWith("OFF")) {
                        ofs = "OFF".length();
                        if ((scanStr = scanStr.substring(ofs).trim()).startsWith(")")) {
                            ofs = 1;
                            scanStr = scanStr.substring(ofs).trim();
                            props.setProperty("failOver", "OFF");
                            state = 1;
                            break;
                        }
                        state = -1;
                        break;
                    }
                    state = -1;
                    break;
                }
                case 3: {
                    if (scanStr.startsWith(")")) {
                        ofs = 1;
                        scanStr = scanStr.substring(ofs).trim();
                        state = 1;
                        break;
                    }
                    if (!scanStr.startsWith("(")) {
                        state = -1;
                        break;
                    }
                    ofs = 1;
                    if ((scanStr = scanStr.substring(ofs).trim()).startsWith("PRIMARY")) {
                        ofs = "PRIMARY".length();
                        if (!(scanStr = scanStr.substring(ofs).trim()).startsWith("=")) {
                            state = -1;
                            break;
                        }
                        ofs = 1;
                        scanStr = scanStr.substring(ofs).trim();
                        subState = 1;
                        state = 6;
                        break;
                    }
                    if (scanStr.startsWith("BACKUP")) {
                        ofs = "BACKUP".length();
                        if (!(scanStr = scanStr.substring(ofs).trim()).startsWith("=")) {
                            state = -1;
                            break;
                        }
                        ofs = 1;
                        scanStr = scanStr.substring(ofs).trim();
                        subState = 2;
                        state = 6;
                        break;
                    }
                    state = -1;
                    break;
                }
                case 6: {
                    if (scanStr.startsWith(")")) {
                        ofs = 1;
                        scanStr = scanStr.substring(ofs).trim();
                        if (subState == 0) {
                            state = 1;
                            break;
                        }
                        subState = 0;
                        state = 3;
                        break;
                    }
                    if (!scanStr.startsWith("(")) {
                        state = -1;
                        break;
                    }
                    ofs = 1;
                    if ((scanStr = scanStr.substring(ofs).trim()).startsWith("HOST")) {
                        ofs = "HOST".length();
                        scanStr = scanStr.substring(ofs).trim();
                        state = 7;
                        break;
                    }
                    if (scanStr.startsWith("PORT")) {
                        ofs = "PORT".length();
                        scanStr = scanStr.substring(ofs).trim();
                        state = 8;
                        break;
                    }
                    state = -1;
                    break;
                }
                case 7: {
                    if (!scanStr.startsWith("=")) {
                        state = -1;
                        break;
                    }
                    ofs = 1;
                    scanStr = scanStr.substring(ofs).trim();
                    len = scanStr.length();
                    for (valOfs = 0; valOfs < len && ") \t\r\n\f".indexOf(scanStr.charAt(valOfs)) == -1; ++valOfs) {
                    }
                    valStr = scanStr.substring(0, valOfs);
                    ofs = valOfs;
                    if (!(scanStr = scanStr.substring(ofs).trim()).startsWith(")")) {
                        state = -1;
                        break;
                    }
                    ofs = 1;
                    scanStr = scanStr.substring(ofs).trim();
                    if (subState == 2) {
                        props.setProperty("backupServerName", valStr);
                    } else {
                        props.setProperty("serverName", valStr);
                    }
                    state = 6;
                    break;
                }
                case 8: {
                    if (!scanStr.startsWith("=")) {
                        state = -1;
                        break;
                    }
                    ofs = 1;
                    scanStr = scanStr.substring(ofs).trim();
                    len = scanStr.length();
                    for (valOfs = 0; valOfs < len && ") \t\r\n\f".indexOf(scanStr.charAt(valOfs)) == -1; ++valOfs) {
                    }
                    valStr = scanStr.substring(0, valOfs);
                    try {
                        Integer.parseInt(valStr);
                    }
                    catch (NumberFormatException e) {
                        state = -1;
                        break;
                    }
                    ofs = valOfs;
                    scanStr = scanStr.substring(ofs).trim();
                    if (!scanStr.startsWith(")")) {
                        state = -1;
                        break;
                    }
                    ofs = 1;
                    scanStr = scanStr.substring(ofs).trim();
                    if (subState == 2) {
                        props.setProperty("backupPortNumber", valStr);
                    } else {
                        props.setProperty("portNumber", valStr);
                    }
                    state = 6;
                    break;
                }
                case -1: {
                    throw new TbSQLException(-90605);
                }
            }
        }
        ConnectionInfo info = new ConnectionInfo(props);
        info.setUrl(url);
        return info;
    }

    public static String makeURL(ConnectionInfo info) throws SQLException {
        StringBuffer url = new StringBuffer("jdbc:tibero");
        String driverType = info.getDriverType();
        if (driverType == null || driverType.equals("")) {
            url.append(":").append("thin");
            info.setDriverType("thin");
        } else {
            if (!driverType.equals("thin")) {
                throw new TbSQLException(-90605);
            }
            url.append(":").append(driverType);
        }
        String serverName = info.getServerName();
        if (serverName == null || serverName.equals("")) {
            throw new TbSQLException(-90605);
        }
        url.append(":@").append(info.getServerName());
        url.append(":").append(info.getPortNumber());
        String databaseName = info.getDatabaseName();
        if (databaseName != null && !databaseName.equals("")) {
            url.append(":").append(info.getDatabaseName());
        }
        return url.substring(0, url.length());
    }
}

