/*
 * Decompiled with CFR 0.152.
 */
package com.tmax.tibero.rowset;

import com.tmax.tibero.jdbc.TbSQLException;
import com.tmax.tibero.rowset.TbRow;
import com.tmax.tibero.rowset.TbRowSet;
import com.tmax.tibero.rowset.TbRowSetMetaData;
import com.tmax.tibero.rowset.TbRowSetReader;
import com.tmax.tibero.rowset.TbRowSetWriter;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Reader;
import java.io.Serializable;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.Date;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;
import java.util.Vector;
import javax.sql.RowSet;
import javax.sql.RowSetInternal;
import javax.sql.RowSetMetaData;
import javax.sql.RowSetReader;
import javax.sql.RowSetWriter;

public class TbCachedRowSet
extends TbRowSet
implements RowSetInternal,
Serializable,
Cloneable {
    protected transient Connection conn;
    protected RowSetMetaData rowsetMD;
    protected int currentRowIndex;
    protected RowSetReader reader;
    protected RowSetWriter writer;
    protected Vector rows;
    protected TbRow insertBuffer;
    protected boolean onInserting;
    protected int columnCount;
    protected int rowsCount;

    protected void reset() {
        super.reset();
        this.conn = null;
        this.rowsetMD = null;
        this.reader = null;
        this.writer = null;
        this.rows = null;
        this.insertBuffer = null;
    }

    protected void reuse() {
        this.reset();
        super.reuse();
        this.reader = new TbRowSetReader();
        this.writer = new TbRowSetWriter();
        this.rows = new Vector();
        this.insertBuffer = new TbRow(0);
        this.currentRowIndex = -1;
        this.onInserting = false;
        this.columnCount = 0;
        this.rowsCount = 0;
    }

    public Connection getConnection() throws SQLException {
        return this.conn;
    }

    protected void setConnection(Connection conn) throws SQLException {
        this.conn = conn;
    }

    public ResultSet getOriginal() throws SQLException {
        TbCachedRowSet rset = new TbCachedRowSet();
        rset.reuse();
        rset.rowsetMD = this.rowsetMD;
        rset.columnCount = this.columnCount;
        rset.rowsCount = this.rowsCount;
        TbRow row = null;
        TbRow originalRow = null;
        Iterator itr = this.rows.iterator();
        while (itr.hasNext()) {
            originalRow = (TbRow)itr.next();
            if (originalRow.isInserted()) continue;
            row = new TbRow(this.rowsetMD.getColumnCount(), ((TbRow)itr.next()).getOriginalColumns());
            rset.rows.add(row);
        }
        return rset;
    }

    public void setOriginal() throws SQLException {
        Vector<TbRow> newRows = new Vector<TbRow>(this.size());
        TbRow row = null;
        Iterator itr = this.rows.iterator();
        while (itr.hasNext()) {
            row = (TbRow)itr.next();
            if (row.isUpdated() || row.isInserted()) {
                row.commitChangedColumns();
            } else if (row.isDeleted()) {
                itr.remove();
                continue;
            }
            newRows.add(row);
        }
        this.rows = null;
        this.rows = newRows;
        this.rowsCount = newRows.size();
        this.notifyRowSetChanged();
    }

    public ResultSet getOriginalRow() throws SQLException {
        TbCachedRowSet rset = new TbCachedRowSet();
        rset.reuse();
        rset.rowsetMD = this.rowsetMD;
        rset.columnCount = this.columnCount;
        rset.rowsCount = 1;
        rset.setReader(null);
        rset.setWriter(null);
        TbRow row = new TbRow(this.rowsetMD.getColumnCount(), this.getCurrentRow().getOriginalColumns());
        rset.rows.add(row);
        return rset;
    }

    protected TbRow getCurrentRow() {
        if (this.onInserting) {
            return this.insertBuffer;
        }
        return (TbRow)this.rows.elementAt(this.currentRowIndex);
    }

    public void setMetaData(RowSetMetaData rowsetMetaData) throws SQLException {
        this.rowsetMD = rowsetMetaData;
    }

    public void setReader(RowSetReader reader) throws SQLException {
        this.reader = reader;
    }

    public RowSetReader getReader() throws SQLException {
        return this.reader;
    }

    public void setWriter(RowSetWriter writer) throws SQLException {
        this.writer = writer;
    }

    public RowSetWriter getWriter() throws SQLException {
        return this.writer;
    }

    public void populate(ResultSet rs) throws SQLException {
        this.rows = new Vector(100, 10);
        this.rowsetMD = new TbRowSetMetaData(rs.getMetaData());
        this.columnCount = this.rowsetMD.getColumnCount();
        Statement stmt = rs.getStatement();
        this.conn = stmt.getConnection();
        this.isolation = this.conn.getTransactionIsolation();
        this.readOnly = this.conn.isReadOnly();
        this.maxFieldSize = stmt.getMaxFieldSize();
        this.maxRows = stmt.getMaxRows();
        this.queryTimeout = stmt.getQueryTimeout();
        this.rowSetType = stmt.getResultSetType();
        this.concurrency = stmt.getResultSetConcurrency();
        this.typeMap = this.conn.getTypeMap();
        DatabaseMetaData dbMD = this.conn.getMetaData();
        this.url = dbMD.getURL();
        while (rs.next()) {
            TbRow row = new TbRow(this.columnCount);
            Object obj = null;
            for (int k = 1; k <= this.columnCount; ++k) {
                obj = rs.getObject(k);
                row.setColumn(k, obj);
            }
            this.rows.add(row);
        }
        this.rowsCount = this.rows.size();
        this.notifyRowSetChanged();
    }

    public void release() throws SQLException {
        this.reuse();
        this.notifyRowSetChanged();
    }

    public void restoreOriginal() throws SQLException {
        TbRow row = null;
        for (int k = 0; k < this.rowsCount; ++k) {
            row = (TbRow)this.rows.elementAt(k);
            if (row.isUpdated()) {
                row.cancelUpdated();
                continue;
            }
            if (row.isInserted()) {
                this.rows.remove(k);
                --this.rowsCount;
                --k;
                continue;
            }
            if (!row.isDeleted()) continue;
            row.cancelDeleted();
        }
        this.notifyRowSetChanged();
    }

    public int size() {
        return this.rowsCount;
    }

    public Collection toCollection() throws SQLException {
        int key = 0;
        TreeMap<Integer, Collection> map = new TreeMap<Integer, Collection>();
        TbRow row = null;
        Iterator itr = this.rows.iterator();
        while (itr.hasNext()) {
            row = (TbRow)itr.next();
            map.put(new Integer(key++), row.toCollection());
        }
        return (Collection)((Object)map);
    }

    public Collection toCollection(int column) throws SQLException {
        Vector<Object> colRows = new Vector<Object>(this.size());
        Iterator iterator = this.rows.iterator();
        while (iterator.hasNext()) {
            TbRow row = (TbRow)iterator.next();
            colRows.add(row.getColumn(column));
        }
        return colRows;
    }

    public void acceptChanges() throws SQLException {
        if (this.onInserting) {
            throw new SQLException(" invalid operation on inserting row");
        }
        if (!this.writer.writeData(this)) {
            throw new SQLException("failed to reflect changes to data source");
        }
        this.setOriginal();
    }

    public void acceptChanges(Connection conn) throws SQLException {
        this.setConnection(conn);
        this.acceptChanges();
    }

    public void cancelRowDelete() throws SQLException {
        if (this.onInserting) {
            throw new SQLException(" invalid operation on inserting row");
        }
        this.checkRowIndex();
        TbRow row = this.getCurrentRow();
        if (!row.isDeleted()) {
            throw new SQLException(" invalid action on not deleted row");
        }
        row.cancelDeleted();
        this.notifyRowChanged();
    }

    public void cancelRowInsert() throws SQLException {
        if (this.onInserting) {
            throw new SQLException(" invalid operation on inserting row");
        }
        this.checkRowIndex();
        TbRow row = this.getCurrentRow();
        if (row.isInserted()) {
            row.cancelInserted();
            this.rows.remove(this.currentRowIndex);
            --this.rowsCount;
        } else {
            throw new SQLException(" invalid action on not inserted row");
        }
        this.notifyRowChanged();
    }

    public void cancelRowUpdates() throws SQLException {
        if (this.onInserting) {
            throw new SQLException(" invalid operation on inserting row");
        }
        this.checkRowIndex();
        TbRow row = this.getCurrentRow();
        if (!row.isUpdated()) {
            throw new SQLException(" invalid action on not updated row");
        }
        row.cancelUpdated();
        this.notifyRowChanged();
    }

    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }

    public RowSet createCopy() throws SQLException {
        try {
            ByteArrayOutputStream _out = new ByteArrayOutputStream();
            ObjectOutputStream out = new ObjectOutputStream(new ByteArrayOutputStream());
            out.writeObject(this);
            ByteArrayInputStream _in = new ByteArrayInputStream(_out.toByteArray());
            ObjectInputStream in = new ObjectInputStream(_in);
            return (RowSet)in.readObject();
        }
        catch (IOException ie) {
            throw new SQLException("createCopy() failed:" + ie.getMessage());
        }
        catch (ClassNotFoundException cnfe) {
            throw new SQLException("createCopy() failed:" + cnfe.getMessage());
        }
    }

    public RowSet createShared() throws SQLException {
        try {
            return (RowSet)this.clone();
        }
        catch (CloneNotSupportedException cnse) {
            throw new SQLException(cnse.getMessage());
        }
    }

    public void execute() throws SQLException {
        this.reader.readData(this);
    }

    public boolean next() throws SQLException {
        return false;
    }

    public void close() throws SQLException {
        this.release();
    }

    public boolean wasNull() throws SQLException {
        return false;
    }

    public String getCursorName() throws SQLException {
        return null;
    }

    public ResultSetMetaData getMetaData() throws SQLException {
        return null;
    }

    public int findColumn(String columnName) throws SQLException {
        return -1;
    }

    public boolean isBeforeFirst() throws SQLException {
        return false;
    }

    public boolean isAfterLast() throws SQLException {
        return false;
    }

    public boolean isFirst() throws SQLException {
        return false;
    }

    public boolean isLast() throws SQLException {
        return false;
    }

    public void beforeFirst() throws SQLException {
    }

    public void afterLast() throws SQLException {
    }

    public boolean first() throws SQLException {
        return false;
    }

    public boolean last() throws SQLException {
        return false;
    }

    public int getRow() throws SQLException {
        return -1;
    }

    public boolean absolute(int row) throws SQLException {
        return false;
    }

    public boolean relative(int offset) throws SQLException {
        return false;
    }

    public boolean previous() throws SQLException {
        return false;
    }

    public int getType() throws SQLException {
        return -1;
    }

    public int getConcurrency() throws SQLException {
        return -1;
    }

    public boolean rowUpdated() throws SQLException {
        return false;
    }

    public boolean rowInserted() throws SQLException {
        return false;
    }

    public boolean rowDeleted() throws SQLException {
        return false;
    }

    public void insertRow() throws SQLException {
    }

    public void updateRow() throws SQLException {
    }

    public void deleteRow() throws SQLException {
    }

    public void refreshRow() throws SQLException {
    }

    public void moveToInsertRow() throws SQLException {
    }

    public void moveToCurrentRow() throws SQLException {
    }

    public Statement getStatement() throws SQLException {
        return null;
    }

    public String getString(int columnIndex) throws SQLException {
        return null;
    }

    public boolean getBoolean(int columnIndex) throws SQLException {
        return false;
    }

    public byte getByte(int columnIndex) throws SQLException {
        return 0;
    }

    public short getShort(int columnIndex) throws SQLException {
        return 0;
    }

    public int getInt(int columnIndex) throws SQLException {
        return 0;
    }

    public long getLong(int columnIndex) throws SQLException {
        return 0L;
    }

    public float getFloat(int columnIndex) throws SQLException {
        return 0.0f;
    }

    public double getDouble(int columnIndex) throws SQLException {
        return 0.0;
    }

    public BigDecimal getBigDecimal(int columnIndex, int scale) throws SQLException {
        return this.getBigDecimal(columnIndex);
    }

    public byte[] getBytes(int columnIndex) throws SQLException {
        return null;
    }

    public Date getDate(int columnIndex) throws SQLException {
        return null;
    }

    public Time getTime(int columnIndex) throws SQLException {
        return null;
    }

    public Timestamp getTimestamp(int columnIndex) throws SQLException {
        return null;
    }

    public InputStream getAsciiStream(int columnIndex) throws SQLException {
        return null;
    }

    public InputStream getUnicodeStream(int columnIndex) throws SQLException {
        return null;
    }

    public InputStream getBinaryStream(int columnIndex) throws SQLException {
        return null;
    }

    public String getString(String columnName) throws SQLException {
        return this.getString(this.findColumn(columnName));
    }

    public boolean getBoolean(String columnName) throws SQLException {
        return this.getBoolean(this.findColumn(columnName));
    }

    public byte getByte(String columnName) throws SQLException {
        return this.getByte(this.findColumn(columnName));
    }

    public short getShort(String columnName) throws SQLException {
        return this.getShort(this.findColumn(columnName));
    }

    public int getInt(String columnName) throws SQLException {
        return this.getInt(this.findColumn(columnName));
    }

    public long getLong(String columnName) throws SQLException {
        return this.getLong(this.findColumn(columnName));
    }

    public float getFloat(String columnName) throws SQLException {
        return this.getFloat(this.findColumn(columnName));
    }

    public double getDouble(String columnName) throws SQLException {
        return this.getDouble(this.findColumn(columnName));
    }

    public BigDecimal getBigDecimal(String columnName, int scale) throws SQLException {
        return this.getBigDecimal(this.findColumn(columnName));
    }

    public byte[] getBytes(String columnName) throws SQLException {
        return this.getBytes(this.findColumn(columnName));
    }

    public Date getDate(String columnName) throws SQLException {
        return this.getDate(this.findColumn(columnName));
    }

    public Time getTime(String columnName) throws SQLException {
        return this.getTime(this.findColumn(columnName));
    }

    public Timestamp getTimestamp(String columnName) throws SQLException {
        return this.getTimestamp(this.findColumn(columnName));
    }

    public InputStream getAsciiStream(String columnName) throws SQLException {
        return this.getAsciiStream(this.findColumn(columnName));
    }

    public InputStream getUnicodeStream(String columnName) throws SQLException {
        return this.getUnicodeStream(this.findColumn(columnName));
    }

    public InputStream getBinaryStream(String columnName) throws SQLException {
        return this.getBinaryStream(this.findColumn(columnName));
    }

    public Object getObject(int columnIndex) throws SQLException {
        return null;
    }

    public Object getObject(String columnName) throws SQLException {
        return this.getObject(this.findColumn(columnName));
    }

    public Reader getCharacterStream(int columnIndex) throws SQLException {
        return null;
    }

    public Reader getCharacterStream(String columnName) throws SQLException {
        return this.getCharacterStream(this.findColumn(columnName));
    }

    public BigDecimal getBigDecimal(int columnIndex) throws SQLException {
        return null;
    }

    public BigDecimal getBigDecimal(String columnName) throws SQLException {
        return this.getBigDecimal(this.findColumn(columnName));
    }

    public void updateNull(int columnIndex) throws SQLException {
    }

    public void updateBoolean(int columnIndex, boolean bool) throws SQLException {
    }

    public void updateByte(int columnIndex, byte b) throws SQLException {
    }

    public void updateShort(int columnIndex, short si) throws SQLException {
    }

    public void updateInt(int columnIndex, int i1) throws SQLException {
    }

    public void updateLong(int columnIndex, long l) throws SQLException {
    }

    public void updateFloat(int columnIndex, float f) throws SQLException {
    }

    public void updateDouble(int columnIndex, double d) throws SQLException {
    }

    public void updateBigDecimal(int columnIndex, BigDecimal decimal) throws SQLException {
    }

    public void updateString(int columnIndex, String columnName) throws SQLException {
    }

    public void updateBytes(int columnIndex, byte[] param) throws SQLException {
    }

    public void updateDate(int columnIndex, Date date) throws SQLException {
    }

    public void updateTime(int columnIndex, Time time) throws SQLException {
    }

    public void updateTimestamp(int columnIndex, Timestamp timestamp) throws SQLException {
    }

    public void updateAsciiStream(int columnIndex, InputStream columnNameeam, int i1) throws SQLException {
    }

    public void updateBinaryStream(int columnIndex, InputStream columnNameeam, int i1) throws SQLException {
    }

    public void updateCharacterStream(int columnIndex, Reader reader, int i1) throws SQLException {
    }

    public void updateObject(int columnIndex, Object obj, int i1) throws SQLException {
    }

    public void updateObject(int columnIndex, Object obj) throws SQLException {
    }

    public void updateNull(String columnName) throws SQLException {
        this.updateNull(this.findColumn(columnName));
    }

    public void updateBoolean(String columnName, boolean bool) throws SQLException {
        this.updateBoolean(this.findColumn(columnName), bool);
    }

    public void updateByte(String columnName, byte b) throws SQLException {
        this.updateByte(this.findColumn(columnName), b);
    }

    public void updateShort(String columnName, short si) throws SQLException {
        this.updateShort(this.findColumn(columnName), si);
    }

    public void updateInt(String columnName, int i) throws SQLException {
        this.updateInt(this.findColumn(columnName), i);
    }

    public void updateLong(String columnName, long l) throws SQLException {
        this.updateLong(this.findColumn(columnName), l);
    }

    public void updateFloat(String columnName, float f) throws SQLException {
        this.updateFloat(this.findColumn(columnName), f);
    }

    public void updateDouble(String columnName, double d) throws SQLException {
        this.updateDouble(this.findColumn(columnName), d);
    }

    public void updateBigDecimal(String columnName, BigDecimal x) throws SQLException {
        this.updateBigDecimal(this.findColumn(columnName), x);
    }

    public void updateString(String columnName, String x) throws SQLException {
        this.updateString(this.findColumn(columnName), x);
    }

    public void updateBytes(String columnName, byte[] x) throws SQLException {
        this.updateBytes(this.findColumn(columnName), x);
    }

    public void updateDate(String columnName, Date x) throws SQLException {
        this.updateDate(this.findColumn(columnName), x);
    }

    public void updateTime(String columnName, Time x) throws SQLException {
        this.updateTime(this.findColumn(columnName), x);
    }

    public void updateTimestamp(String columnName, Timestamp x) throws SQLException {
        this.updateTimestamp(this.findColumn(columnName), x);
    }

    public void updateAsciiStream(String columnName, InputStream x, int length) throws SQLException {
        this.updateAsciiStream(this.findColumn(columnName), x, length);
    }

    public void updateBinaryStream(String columnName, InputStream x, int length) throws SQLException {
        this.updateBinaryStream(this.findColumn(columnName), x, length);
    }

    public void updateCharacterStream(String columnName, Reader x, int length) throws SQLException {
        this.updateCharacterStream(this.findColumn(columnName), x, length);
    }

    public void updateObject(String columnName, Object x, int scale) throws SQLException {
        this.updateObject(this.findColumn(columnName), x);
    }

    public void updateObject(String columnName, Object x) throws SQLException {
        this.updateObject(this.findColumn(columnName), x);
    }

    public Object getObject(int columnIndex, Map map) throws SQLException {
        return null;
    }

    public Ref getRef(int columnIndex) throws SQLException {
        return null;
    }

    public Blob getBlob(int columnIndex) throws SQLException {
        return null;
    }

    public Clob getClob(int columnIndex) throws SQLException {
        return null;
    }

    public Array getArray(int columnIndex) throws SQLException {
        return null;
    }

    public Object getObject(String columnName, Map map) throws SQLException {
        return this.getObject(this.findColumn(columnName), map);
    }

    public Ref getRef(String columnName) throws SQLException {
        return this.getRef(this.findColumn(columnName));
    }

    public Blob getBlob(String columnName) throws SQLException {
        return this.getBlob(this.findColumn(columnName));
    }

    public Clob getClob(String columnName) throws SQLException {
        return this.getClob(this.findColumn(columnName));
    }

    public Array getArray(String columnName) throws SQLException {
        return this.getArray(this.findColumn(columnName));
    }

    public Date getDate(int columnIndex, Calendar cal) throws SQLException {
        return null;
    }

    public Date getDate(String columnName, Calendar cal) throws SQLException {
        return this.getDate(this.findColumn(columnName), cal);
    }

    public Time getTime(int columnIndex, Calendar cal) throws SQLException {
        return null;
    }

    public Time getTime(String columnName, Calendar cal) throws SQLException {
        return this.getTime(this.findColumn(columnName), cal);
    }

    public Timestamp getTimestamp(int columnIndex, Calendar cal) throws SQLException {
        return null;
    }

    public Timestamp getTimestamp(String columnName, Calendar cal) throws SQLException {
        return this.getTimestamp(this.findColumn(columnName), cal);
    }

    void checkColumnIndex(int colIndex) throws SQLException {
        if (colIndex < 1 || colIndex >= this.columnCount) {
            throw new SQLException("invalid column index");
        }
    }

    void checkRowIndex() throws SQLException {
        if (this.currentRowIndex < 0 || this.currentRowIndex >= this.rows.size()) {
            throw new SQLException("invalid row cursor position");
        }
    }

    public URL getURL(String columnName) throws SQLException {
        throw new TbSQLException(-90201);
    }

    public URL getURL(int columnIndex) throws SQLException {
        throw new TbSQLException(-90201);
    }

    public void updateRef(int columnIndex, Ref x) throws SQLException {
        throw new TbSQLException(-90201);
    }

    public void updateRef(String columnName, Ref x) throws SQLException {
        throw new TbSQLException(-90201);
    }

    public void updateBlob(int columnIndex, Blob x) throws SQLException {
        throw new TbSQLException(-90201);
    }

    public void updateBlob(String columnName, Blob x) throws SQLException {
        throw new TbSQLException(-90201);
    }

    public void updateClob(int columnIndex, Clob x) throws SQLException {
        throw new TbSQLException(-90201);
    }

    public void updateClob(String columnName, Clob x) throws SQLException {
        throw new TbSQLException(-90201);
    }

    public void updateArray(int columnIndex, Array x) throws SQLException {
        throw new TbSQLException(-90201);
    }

    public void updateArray(String columnName, Array x) throws SQLException {
        throw new TbSQLException(-90201);
    }
}

