/*
 * Decompiled with CFR 0.152.
 */
package com.tmax.tibero.rowset;

import java.io.InputStream;
import java.io.Reader;
import java.io.Serializable;
import java.math.BigDecimal;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.Ref;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Vector;
import javax.sql.RowSet;
import javax.sql.RowSetEvent;
import javax.sql.RowSetListener;

public abstract class TbRowSet
implements RowSet,
Serializable,
Cloneable {
    protected String url;
    protected String dataSourceName;
    protected transient String username;
    protected transient String password;
    protected int isolation;
    protected String command;
    protected boolean readOnly;
    protected boolean showDeleted;
    protected int maxFieldSize;
    protected int maxRows;
    protected boolean escapeProcessing;
    protected int queryTimeout;
    protected int rowSetType;
    protected int concurrency;
    protected int fetchDirection;
    protected int fetchSize;
    protected Vector listeners;
    protected Vector params;
    protected Map typeMap;
    protected SQLWarning warnings;
    protected static final int STREAM_ASCII = 9090;
    protected static final int STREAM_BINARY = 9091;
    protected static final int STREAM_CHARACTER = 9092;

    protected void reset() {
        this.url = null;
        this.dataSourceName = null;
        this.username = null;
        this.password = null;
        this.command = null;
        this.listeners = null;
        this.params = null;
        this.typeMap = null;
        this.warnings = null;
    }

    protected void reuse() {
        this.reset();
        this.readOnly = true;
        this.showDeleted = false;
        this.maxFieldSize = 0;
        this.maxRows = 0;
        this.escapeProcessing = true;
        this.queryTimeout = 0;
        this.rowSetType = 1003;
        this.concurrency = 1007;
        this.isolation = 2;
        this.listeners = new Vector();
        this.params = new Vector();
        this.typeMap = new HashMap();
    }

    public String ToString() {
        StringBuffer buf = new StringBuffer();
        buf.append(this.toString()).append("{");
        buf.append("url[").append(this.url).append("]");
        buf.append("dataSourceName[").append(this.dataSourceName).append("]");
        buf.append("username[").append(this.username).append("]");
        buf.append("password[").append(this.password).append("]");
        buf.append("isolation[").append(this.isolation).append("]");
        buf.append("command[").append(this.command).append("]");
        buf.append("readOnly[").append(this.readOnly).append("]");
        buf.append("maxFieldSize[").append(this.maxFieldSize).append("]");
        buf.append("maxRows[").append(this.maxRows).append("]");
        buf.append("escapeProcessing[").append(this.escapeProcessing).append("]");
        buf.append("queryTimeout[").append(this.queryTimeout).append("]");
        buf.append("rowSetType[").append(this.rowSetType).append("]");
        buf.append("concurrency[").append(this.concurrency).append("]");
        buf.append("listeners[").append(this.listeners).append("]");
        buf.append("params[").append(this.params).append("]");
        buf.append("}");
        return buf.toString();
    }

    public TbRowSet() {
        this.reuse();
    }

    public boolean isShowDeleted() {
        return this.showDeleted;
    }

    public void setShowDeleted(boolean b) {
        this.showDeleted = b;
    }

    public int getFetchDirection() {
        return this.fetchDirection;
    }

    public int getFetchSize() {
        return this.fetchSize;
    }

    public void setFetchDirection(int direction) {
        this.fetchDirection = direction;
    }

    public void setFetchSize(int size) {
        this.fetchSize = size;
    }

    public void addWarning(SQLWarning warning) {
        if (this.warnings != null) {
            this.warnings.setNextWarning(warning);
        } else {
            this.warnings = warning;
        }
    }

    public synchronized SQLWarning getWarnings() throws SQLException {
        return this.warnings;
    }

    public synchronized void clearWarnings() throws SQLException {
        this.warnings = null;
    }

    public String getUrl() throws SQLException {
        return this.url;
    }

    public void setUrl(String url) throws SQLException {
        this.url = url;
    }

    public String getDataSourceName() {
        return this.dataSourceName;
    }

    public void setDataSourceName(String name) throws SQLException {
        this.dataSourceName = name;
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String name) throws SQLException {
        this.username = name;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) throws SQLException {
        this.password = password;
    }

    public int getTransactionIsolation() {
        return this.isolation;
    }

    public void setTransactionIsolation(int level) throws SQLException {
        switch (level) {
            case 2: 
            case 8: {
                this.isolation = level;
                return;
            }
        }
        throw new SQLException("Unsupported transation isolation level");
    }

    public Map getTypeMap() throws SQLException {
        return this.typeMap;
    }

    public void setTypeMap(Map map) throws SQLException {
        this.typeMap = map;
    }

    public String getCommand() {
        return this.command;
    }

    public void setCommand(String cmd) throws SQLException {
        this.command = cmd;
    }

    public boolean isReadOnly() {
        return this.readOnly;
    }

    public void setReadOnly(boolean value) throws SQLException {
        this.readOnly = value;
    }

    public int getMaxFieldSize() throws SQLException {
        return this.maxFieldSize;
    }

    public void setMaxFieldSize(int max) throws SQLException {
        this.maxFieldSize = max;
    }

    public int getMaxRows() throws SQLException {
        return this.maxRows;
    }

    public void setMaxRows(int max) throws SQLException {
        this.maxRows = max;
    }

    public boolean getEscapeProcessing() throws SQLException {
        return this.escapeProcessing;
    }

    public void setEscapeProcessing(boolean enable) throws SQLException {
        this.escapeProcessing = enable;
    }

    public int getQueryTimeout() throws SQLException {
        return this.queryTimeout;
    }

    public void setQueryTimeout(int seconds) throws SQLException {
        this.queryTimeout = seconds;
    }

    public void setType(int type) throws SQLException {
        switch (type) {
            case 1003: 
            case 1004: 
            case 1005: {
                this.rowSetType = type;
                return;
            }
        }
        throw new SQLException("Unsupported RowSet rowSetType");
    }

    public void setConcurrency(int concurrency) throws SQLException {
        switch (concurrency) {
            case 1007: 
            case 1008: {
                this.concurrency = concurrency;
                return;
            }
        }
        throw new SQLException("Unsupported RowSet concurrency");
    }

    void checkParameterIndex(int parameterIndex) throws SQLException {
        if (parameterIndex < 1) {
            throw new SQLException("Invalid parameter index");
        }
    }

    public Object[] getParams() throws SQLException {
        return this.params.toArray();
    }

    public void setNull(int parameterIndex, int sqlType) throws SQLException {
        this.setNull(parameterIndex, sqlType);
    }

    public void setNull(int paramIndex, int sqlType, String typeName) throws SQLException {
        this.checkParameterIndex(paramIndex);
        Object[] obj = new Object[]{null, new Integer(sqlType), typeName};
        this.params.add(paramIndex - 1, obj);
    }

    public void setBoolean(int parameterIndex, boolean x) throws SQLException {
        this.checkParameterIndex(parameterIndex);
        this.params.add(parameterIndex - 1, x ? Boolean.TRUE : Boolean.FALSE);
    }

    public void setByte(int parameterIndex, byte x) throws SQLException {
        this.checkParameterIndex(parameterIndex);
        this.params.add(parameterIndex - 1, new Byte(x));
    }

    public void setShort(int parameterIndex, short x) throws SQLException {
        this.checkParameterIndex(parameterIndex);
        this.params.add(parameterIndex - 1, new Short(x));
    }

    public void setInt(int parameterIndex, int x) throws SQLException {
        this.checkParameterIndex(parameterIndex);
        this.params.add(parameterIndex - 1, new Integer(x));
    }

    public void setLong(int parameterIndex, long x) throws SQLException {
        this.checkParameterIndex(parameterIndex);
        this.params.add(parameterIndex - 1, new Long(x));
    }

    public void setFloat(int parameterIndex, float x) throws SQLException {
        this.checkParameterIndex(parameterIndex);
        this.params.add(parameterIndex - 1, new Float(x));
    }

    public void setDouble(int parameterIndex, double x) throws SQLException {
        this.checkParameterIndex(parameterIndex);
        this.params.add(parameterIndex - 1, new Double(x));
    }

    public void setBigDecimal(int parameterIndex, BigDecimal x) throws SQLException {
        this.checkParameterIndex(parameterIndex);
        this.params.add(parameterIndex - 1, x);
    }

    public void setString(int parameterIndex, String x) throws SQLException {
        this.checkParameterIndex(parameterIndex);
        this.params.add(parameterIndex - 1, x);
    }

    public void setBytes(int parameterIndex, byte[] x) throws SQLException {
        this.checkParameterIndex(parameterIndex);
        this.params.add(parameterIndex - 1, x);
    }

    public void setDate(int parameterIndex, Date x) throws SQLException {
        this.checkParameterIndex(parameterIndex);
        this.params.add(parameterIndex - 1, x);
    }

    public void setTime(int parameterIndex, Time x) throws SQLException {
        this.checkParameterIndex(parameterIndex);
        this.params.add(parameterIndex - 1, x);
    }

    public void setTimestamp(int parameterIndex, Timestamp x) throws SQLException {
        this.checkParameterIndex(parameterIndex);
        this.params.add(parameterIndex - 1, x);
    }

    public void setAsciiStream(int parameterIndex, InputStream x, int length) throws SQLException {
        this.checkParameterIndex(parameterIndex);
        Object[] obj = new Object[]{x, new Integer(length), new Integer(9090)};
        this.params.add(parameterIndex - 1, obj);
    }

    public void setBinaryStream(int parameterIndex, InputStream x, int length) throws SQLException {
        this.checkParameterIndex(parameterIndex);
        Object[] obj = new Object[]{x, new Integer(length), new Integer(9091)};
        this.params.add(parameterIndex - 1, obj);
    }

    public void setCharacterStream(int parameterIndex, Reader reader, int length) throws SQLException {
        this.checkParameterIndex(parameterIndex);
        Object[] obj = new Object[]{reader, new Integer(length), new Integer(9092)};
        this.params.add(parameterIndex - 1, obj);
    }

    public void setObject(int parameterIndex, Object x, int targetSqlType, int scale) throws SQLException {
        this.checkParameterIndex(parameterIndex);
        Object[] obj = new Object[]{x, new Integer(targetSqlType), new Integer(scale)};
        this.params.add(parameterIndex - 1, obj);
    }

    public void setObject(int parameterIndex, Object x, int targetSqlType) throws SQLException {
        this.checkParameterIndex(parameterIndex);
        Object[] obj = new Object[]{x, new Integer(targetSqlType)};
        this.params.add(parameterIndex - 1, obj);
    }

    public void setObject(int parameterIndex, Object x) throws SQLException {
        this.checkParameterIndex(parameterIndex);
        this.params.add(parameterIndex - 1, x);
    }

    public void setRef(int parameterIndex, Ref x) throws SQLException {
        this.checkParameterIndex(parameterIndex);
        this.params.add(parameterIndex - 1, x);
    }

    public void setBlob(int parameterIndex, Blob x) throws SQLException {
        this.checkParameterIndex(parameterIndex);
        this.params.add(parameterIndex - 1, x);
    }

    public void setClob(int parameterIndex, Clob x) throws SQLException {
        this.checkParameterIndex(parameterIndex);
        this.params.add(parameterIndex - 1, x);
    }

    public void setArray(int parameterIndex, Array x) throws SQLException {
        this.checkParameterIndex(parameterIndex);
        this.params.add(parameterIndex - 1, x);
    }

    public void setDate(int parameterIndex, Date x, Calendar cal) throws SQLException {
        this.checkParameterIndex(parameterIndex);
        Object[] obj = new Object[]{x, cal};
        this.params.add(parameterIndex - 1, obj);
    }

    public void setTime(int parameterIndex, Time x, Calendar cal) throws SQLException {
        this.checkParameterIndex(parameterIndex);
        Object[] obj = new Object[]{x, cal};
        this.params.add(parameterIndex - 1, obj);
    }

    public void setTimestamp(int parameterIndex, Timestamp x, Calendar cal) throws SQLException {
        this.checkParameterIndex(parameterIndex);
        Object[] obj = new Object[]{x, cal};
        this.params.add(parameterIndex - 1, obj);
    }

    public void clearParameters() throws SQLException {
        this.params.clear();
    }

    public abstract void execute() throws SQLException;

    public void addRowSetListener(RowSetListener listener) {
        this.listeners.add(listener);
    }

    public void removeRowSetListener(RowSetListener listener) {
        this.listeners.remove(listener);
    }

    public void notifyCursorMoved() {
        RowSetEvent event = new RowSetEvent(this);
        Iterator iterator = this.listeners.iterator();
        while (iterator.hasNext()) {
            ((RowSetListener)iterator.next()).cursorMoved(event);
        }
    }

    public void notifyRowSetChanged() {
        RowSetEvent event = new RowSetEvent(this);
        Iterator iterator = this.listeners.iterator();
        while (iterator.hasNext()) {
            ((RowSetListener)iterator.next()).rowSetChanged(event);
        }
    }

    public void notifyRowChanged() {
        RowSetEvent event = new RowSetEvent(this);
        Iterator iterator = this.listeners.iterator();
        while (iterator.hasNext()) {
            ((RowSetListener)iterator.next()).rowChanged(event);
        }
    }
}

