/*
 * Decompiled with CFR 0.152.
 */
package org.apache.log4j.rule;

import java.util.Stack;
import org.apache.log4j.rule.AbstractRule;
import org.apache.log4j.rule.Rule;
import org.apache.log4j.spi.LoggingEvent;

public class AndRule
extends AbstractRule {
    private final Rule firstRule;
    private final Rule secondRule;
    static final long serialVersionUID = -8233444426923854651L;

    private AndRule(Rule firstRule, Rule secondRule) {
        this.firstRule = firstRule;
        this.secondRule = secondRule;
    }

    public static Rule getRule(Stack stack) {
        if (stack.size() < 2) {
            throw new IllegalArgumentException("Invalid AND rule - expected two rules but received " + stack.size());
        }
        Object o2 = stack.pop();
        Object o1 = stack.pop();
        if (o2 instanceof Rule && o1 instanceof Rule) {
            Rule p2 = (Rule)o2;
            Rule p1 = (Rule)o1;
            return new AndRule(p1, p2);
        }
        throw new IllegalArgumentException("Invalid AND rule: " + o2 + "..." + o1);
    }

    public static Rule getRule(Rule firstParam, Rule secondParam) {
        return new AndRule(firstParam, secondParam);
    }

    public boolean evaluate(LoggingEvent event) {
        return this.firstRule.evaluate(event) && this.secondRule.evaluate(event);
    }
}

