/*
 * Decompiled with CFR 0.152.
 */
package org.apache.log4j.watchdog;

import org.apache.log4j.scheduler.Job;
import org.apache.log4j.spi.LoggerRepository;
import org.apache.log4j.spi.LoggerRepositoryEx;
import org.apache.log4j.watchdog.WatchdogSkeleton;

public abstract class TimedLocationWatchdog
extends WatchdogSkeleton
implements Job {
    public static long DEFAULT_INTERVAL = 60000L;
    protected long interval = DEFAULT_INTERVAL;
    private long lastModTime = -1L;

    public void setInterval(long interval) {
        this.interval = interval;
    }

    public long getInterval() {
        return this.interval;
    }

    public abstract long getModificationTime();

    public void execute() {
        long newModTime = this.getModificationTime();
        if (this.lastModTime != newModTime) {
            this.reconfigure();
            this.lastModTime = newModTime;
        }
    }

    public void activateOptions() {
        this.lastModTime = this.getModificationTime();
        LoggerRepository repo = this.getLoggerRepository();
        if (repo instanceof LoggerRepositoryEx) {
            ((LoggerRepositoryEx)repo).getScheduler().schedule(this, System.currentTimeMillis() + this.interval, this.interval);
        } else {
            this.getLogger().error((Object)"{} watchdog requires repository that supports LoggerRepositoryEx", this.getName());
        }
    }

    public void shutdown() {
        LoggerRepository repo = this.getLoggerRepository();
        if (repo instanceof LoggerRepositoryEx) {
            ((LoggerRepositoryEx)repo).getScheduler().delete(this);
        }
    }
}

