/*
 * Decompiled with CFR 0.152.
 */
package Altibase.jdbc.driver;

import Altibase.jdbc.driver.ABConnection;
import Altibase.jdbc.driver.ABXAConsts;
import Altibase.jdbc.driver.ABXAException;
import java.sql.SQLException;
import javax.transaction.xa.XAException;
import javax.transaction.xa.XAResource;
import javax.transaction.xa.Xid;

public class ABXAResource
implements XAResource,
ABXAConsts {
    static final long serialVersionUID = 11242352364797L;
    private ABConnection con;
    private static final int rmid = 1105;
    private int timeout_ignored;

    ABXAResource(ABConnection aConnection) throws SQLException {
        this.con = aConnection;
    }

    public void commit(Xid xid, boolean onePhase) throws XAException {
        int ret;
        int flags = 0;
        if (onePhase) {
            flags |= 0x40000000;
        }
        if ((ret = this.xa_trans(xid, (byte)6, 1105, flags)) != 0) {
            throw new ABXAException(ret);
        }
    }

    public void end(Xid xid, int flags) throws XAException {
        if (xid == null) {
            throw new ABXAException(-5);
        }
        this.xa_trans(xid, (byte)4, 1105, flags);
    }

    public void forget(Xid xid) throws XAException {
        if (xid == null) {
            throw new ABXAException(-5);
        }
        this.xa_trans(xid, (byte)8, 1105, 0L);
    }

    public int getTransactionTimeout() throws XAException {
        return this.timeout_ignored;
    }

    public int hashCode() {
        return 1105;
    }

    public boolean isSameRM(XAResource res) throws XAException {
        return res == this;
    }

    public int prepare(Xid xid) throws XAException {
        if (xid == null) {
            throw new ABXAException(-5);
        }
        return this.xa_trans(xid, (byte)5, 1105, 0L);
    }

    public Xid[] recover(int flag) throws XAException {
        Xid[] rv = new Xid[]{};
        try {
            int ret = this.con.xa_exec_conn(null, (byte)9, 1105, flag, 1024L);
            if (ret < 0) {
                throw new ABXAException(ret);
            }
            if (ret > 0) {
                rv = new Xid[ret];
                for (int i = 0; i < ret; ++i) {
                    rv[i] = this.con.readXid();
                }
            }
        }
        catch (SQLException se) {
            throw new ABXAException(se.toString(), -6);
        }
        return rv;
    }

    public void rollback(Xid xid) throws XAException {
        if (xid == null) {
            throw new ABXAException(-5);
        }
        if (this.con.getAutoCommit()) {
            throw new XAException(7);
        }
        this.xa_trans(xid, (byte)7, 1105, 0L);
    }

    public boolean setTransactionTimeout(int timeout) throws XAException {
        this.timeout_ignored = timeout;
        return false;
    }

    public void start(Xid xid, int flags) throws XAException {
        if (xid == null) {
            throw new ABXAException(-5);
        }
        this.xa_trans(xid, (byte)3, 1105, flags);
    }

    private final int xa_trans(Xid id, byte funcId, int rmid, long flags) throws XAException {
        int rc;
        try {
            rc = this.con.xa_trans(id, funcId, rmid, flags, 0L);
            if (rc < 0) {
                throw new ABXAException(rc);
            }
        }
        catch (SQLException e) {
            throw new ABXAException(-6);
        }
        return rc;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void finalize() throws Throwable {
        if (this.con != null) {
            try {
                this.con.xa_close(this.rmid());
            }
            catch (SQLException sQLException) {
            }
            finally {
                this.con = null;
            }
        }
        super.finalize();
    }

    final int rmid() {
        return 1105;
    }

    static final String flagsToStrng(long flag) {
        switch ((int)flag) {
            case 0: {
                return " TMNOFLAGS";
            }
            case 1: {
                return " TMREGISTER";
            }
            case 2: {
                return " TMNOMIGRATE";
            }
            case 4: {
                return " TMUSEASYNC";
            }
            case -2147483648: {
                return " TMASYNC";
            }
            case 0x40000000: {
                return " TMONEPHASE";
            }
            case 0x20000000: {
                return " TMFAIL";
            }
            case 0x10000000: {
                return " TMNOWAIT";
            }
            case 0x8000000: {
                return " TMRESUME";
            }
            case 0x4000000: {
                return " TMSUCCESS";
            }
            case 0x2000000: {
                return " TMSUSPEND";
            }
            case 0x1000000: {
                return " TMSTARTRSCAN";
            }
            case 0x800000: {
                return " TMENDRSCAN";
            }
            case 0x400000: {
                return " TMMULTIPLE";
            }
            case 0x200000: {
                return " TMJOIN";
            }
            case 0x100000: {
                return " TMMIGRATE";
            }
        }
        return "UNKNOWN";
    }

    static final String getFunToString(int funcId) {
        switch (funcId) {
            case 1: {
                return " MMD_FID_XA_OPEN";
            }
            case 2: {
                return " MMD_FID_XA_RECOVER";
            }
            case 3: {
                return " MMD_FID_XA_START";
            }
            case 4: {
                return " MMD_FID_XA_END";
            }
            case 5: {
                return " MMD_FID_XA_PREPARE";
            }
            case 6: {
                return " MMD_FID_XA_COMMIT";
            }
            case 7: {
                return " MMD_FID_XA_ROLLBACK";
            }
            case 8: {
                return " MMD_FID_XA_FORGET";
            }
            case 9: {
                return " MMD_FID_XA_CLOSE";
            }
        }
        return "";
    }
}

